/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands;

import java.util.ArrayList;
import java.util.Arrays;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.text.TextAlignment;
import org.controlsfx.control.CheckListView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.interfaces.ROI;

public class CreateChannelTrainingImagesCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CreateChannelTrainingImagesCommand.class);
    private String title = "Create training images";
    private QuPathGUI qupath;

    public CreateChannelTrainingImagesCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        ProjectImageEntry entry;
        Project project = this.qupath.getProject();
        ImageData imageData = this.qupath.getImageData();
        ProjectImageEntry projectImageEntry = entry = project != null && imageData != null ? project.getEntry(imageData) : null;
        if (entry == null) {
            Dialogs.showErrorMessage((String)this.title, (String)"This command requires an open image within a project!");
            return;
        }
        ArrayList channels = new ArrayList(imageData.getServerMetadata().getChannels());
        CheckListView list = new CheckListView();
        list.getItems().setAll(channels);
        list.getCheckModel().checkAll();
        list.setCellFactory(v -> new CheckBoxListCell<ImageChannel>(this, item -> list.getItemBooleanProperty(item)){

            public void updateItem(ImageChannel item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    return;
                }
                this.setText(item.getName());
            }
        });
        Label label = new Label("Create duplicate images for each of the following channels?");
        if (channels.size() == 1) {
            label.setText("Create a duplicate image for the one and only channel?");
        }
        Label labelName = new Label("Root name");
        TextField tfName = new TextField(entry.getImageName().trim());
        labelName.setLabelFor((Node)tfName);
        String namePrompt = "Enter root image name for duplicate images";
        tfName.setPromptText(namePrompt);
        tfName.setTooltip(new Tooltip(namePrompt));
        CheckBox cbInitializePoints = new CheckBox("Initialize Points annotations");
        GridPane pane = new GridPane();
        int row = 0;
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{label, label});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)namePrompt, (Node[])new Node[]{labelName, tfName});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Channels to duplicate", (Node[])new Node[]{list, list});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Create Points annotations for the corresponding channel", (Node[])new Node[]{cbInitializePoints, cbInitializePoints});
        if (imageData.isChanged()) {
            Label labelWarning = new Label("Image contains unsaved changes!\nThese will not be transferred to the new images.");
            labelWarning.setTextAlignment(TextAlignment.CENTER);
            labelWarning.setStyle("-fx-text-fill: -qp-script-error-color;");
            BorderPane paneWarning = new BorderPane((Node)labelWarning);
            pane.add((Node)paneWarning, 0, row++, Integer.MAX_VALUE, 1);
            GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{paneWarning});
        }
        GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{label, tfName, list, cbInitializePoints});
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{label, tfName, list, cbInitializePoints});
        GridPaneUtils.setVGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{list});
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{label, tfName, list, cbInitializePoints});
        list.setPrefHeight(240.0);
        list.setPrefWidth(400.0);
        pane.setHgap(5.0);
        pane.setVgap(5.0);
        if (!Dialogs.showMessageDialog((String)this.title, (Node)pane)) {
            return;
        }
        String name = tfName.getText().trim();
        boolean initializePoints = cbInitializePoints.isSelected();
        try {
            for (ImageChannel channel : list.getCheckModel().getCheckedItems()) {
                ProjectImageEntry entry2 = project.addDuplicate(entry, true);
                String channelName = channel.getName();
                entry2.setImageName(name.trim() + " - " + channelName);
                if (!initializePoints) continue;
                ImageData imageData2 = entry2.readImageData();
                imageData2.getHierarchy().addObjects(Arrays.asList(PathObjects.createAnnotationObject((ROI)ROIs.createPointsROI((ImagePlane)ImagePlane.getDefaultPlane()), (PathClass)PathClass.getInstance((String)channelName, (Integer)channel.getColor())), PathObjects.createAnnotationObject((ROI)ROIs.createPointsROI((ImagePlane)ImagePlane.getDefaultPlane()), (PathClass)PathClass.StandardPathClasses.IGNORE)));
                entry2.saveImageData(imageData2);
            }
            project.syncChanges();
        }
        catch (Exception e) {
            Dialogs.showErrorMessage((String)this.title, (Throwable)e);
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.qupath.refreshProject();
    }
}

