/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.Window;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.analysis.stats.Histogram;
import qupath.lib.common.ColorTools;
import qupath.lib.common.ThreadTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.charts.ChartThresholdPane;
import qupath.lib.gui.charts.HistogramChart;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.scripting.QP;
import qupath.process.gui.commands.SingleMeasurementClassificationCommand;

public class CellIntensityClassificationCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CellIntensityClassificationCommand.class);
    private static String title = "Cell intensity classification";
    private QuPathGUI qupath;
    private IntensityClassificationRequest nextRequest;
    private ExecutorService pool;

    public CellIntensityClassificationCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        Collection detections;
        ImageData imageData = this.qupath.getImageData();
        if (imageData == null) {
            GuiTools.showNoImageError((String)title);
            return;
        }
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        Collection cells = imageData.getHierarchy().getCellObjects();
        boolean allDetections = cells.isEmpty();
        if (allDetections) {
            logger.debug("No cells found - will try using all detections");
        }
        Collection collection = detections = allDetections ? imageData.getHierarchy().getDetectionObjects() : cells;
        if (detections.isEmpty()) {
            Dialogs.showErrorMessage((String)title, (String)"No cells found in the current image!");
            return;
        }
        Set measurements = PathObjectTools.getAvailableFeatures((Collection)detections);
        if (measurements.isEmpty()) {
            Dialogs.showErrorMessage((String)title, (String)"No cell measurements found in the current image!");
            return;
        }
        Map currentClassifications = PathObjectTools.createClassificationMap((Collection)detections);
        ComboBox comboMeasurements = new ComboBox();
        comboMeasurements.getItems().setAll((Collection)measurements);
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{comboMeasurements});
        ReadOnlyObjectProperty selectedMeasurement = comboMeasurements.getSelectionModel().selectedItemProperty();
        CheckBox cbSingleThreshold = new CheckBox("Single threshold");
        cbSingleThreshold.setSelected(true);
        BooleanProperty singleThreshold = cbSingleThreshold.selectedProperty();
        ArrayList<Slider> sliders = new ArrayList<Slider>();
        ArrayList<TextField> textFields = new ArrayList<TextField>();
        for (int i = 0; i < 3; ++i) {
            Slider slider = new Slider();
            TextField tf = new TextField();
            tf.setPrefColumnCount(6);
            textFields.add(tf);
            FXUtils.bindSliderAndTextField((Slider)slider, (TextField)tf, (boolean)true);
            GuiTools.installRangePrompt((Slider)slider);
            slider.valueProperty().addListener((v, o, n) -> this.updateClassifications(hierarchy, allDetections, (String)selectedMeasurement.get(), this.parseValues(sliders, singleThreshold.get())));
            GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{slider});
            sliders.add(slider);
        }
        HashMap map = new HashMap();
        HistogramChart histogramPanel = new HistogramChart();
        ChartThresholdPane chartPane = new ChartThresholdPane((XYChart)histogramPanel);
        chartPane.setIsInteractive(true);
        singleThreshold.addListener((v, o, n) -> {
            chartPane.clearThresholds();
            if (!n.booleanValue()) {
                for (int i = 0; i < sliders.size(); ++i) {
                    chartPane.addThreshold((ObservableNumberValue)((Slider)sliders.get(i)).valueProperty());
                }
            } else {
                chartPane.addThreshold((ObservableNumberValue)((Slider)sliders.get(0)).valueProperty());
            }
        });
        selectedMeasurement.addListener((v, o, n) -> {
            if (o != null) {
                map.put(o, this.parseValues(sliders));
            }
            double[] measurementValues = detections.stream().mapToDouble(p -> p.getMeasurementList().get(n)).filter(d -> Double.isFinite(d)).toArray();
            DescriptiveStatistics stats = new DescriptiveStatistics(measurementValues);
            Histogram histogram = new Histogram(measurementValues, 100, stats.getMin(), stats.getMax());
            histogramPanel.getHistogramData().setAll((Object[])new HistogramChart.HistogramData[]{HistogramChart.createHistogramData((Histogram)histogram, (Integer)ColorTools.packARGB((int)100, (int)200, (int)20, (int)20))});
            double[] values = (double[])map.get(n);
            for (int i = 0; i < sliders.size(); ++i) {
                Slider slider = (Slider)sliders.get(i);
                slider.setMin(stats.getMin());
                slider.setMax(stats.getMax());
                double val = values == null ? stats.getMean() + stats.getStandardDeviation() * (double)i : values[i];
                slider.setValue(val);
                if (i != 0) continue;
                chartPane.addThreshold((ObservableNumberValue)((Slider)sliders.get(i)).valueProperty());
            }
        });
        selectedMeasurement.addListener((v, o, n) -> this.updateClassifications(hierarchy, allDetections, (String)n, this.parseValues(sliders, singleThreshold.get())));
        singleThreshold.addListener((v, o, n) -> this.updateClassifications(hierarchy, allDetections, (String)selectedMeasurement.get(), this.parseValues(sliders, singleThreshold.get())));
        GridPane pane = new GridPane();
        int row = 0;
        Label labelMeasurements = new Label("Measurement");
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Select measurement to threshold", (Node[])new Node[]{labelMeasurements, comboMeasurements, comboMeasurements});
        for (int i = 0; i < sliders.size(); ++i) {
            Label labelThreshold = new Label("Threshold " + (i + 1) + "+");
            Slider slider = (Slider)sliders.get(i);
            TextField tf = (TextField)textFields.get(i);
            if (i > 0) {
                slider.disableProperty().bind((ObservableValue)singleThreshold);
                tf.disableProperty().bind((ObservableValue)singleThreshold);
            }
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Select threshold value", (Node[])new Node[]{labelThreshold, slider, tf});
        }
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Toggle between using a single threshold (Negative/Positive) or three threshold Negative/1+/2+/3+)", (Node[])new Node[]{cbSingleThreshold, cbSingleThreshold, cbSingleThreshold});
        pane.setHgap(5.0);
        pane.setVgap(5.0);
        GridPaneUtils.setToExpandGridPaneHeight((Node[])new Node[]{chartPane});
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{chartPane});
        histogramPanel.getYAxis().setTickLabelsVisible(false);
        histogramPanel.setAnimated(false);
        chartPane.setPrefSize(200.0, 80.0);
        pane.add((Node)SingleMeasurementClassificationCommand.SingleMeasurementPane.addLogHistogramCheckbox(chartPane, histogramPanel), pane.getColumnCount(), 0, 1, pane.getRowCount());
        Dialog dialog = new Dialog();
        dialog.initOwner((Window)this.qupath.getStage());
        dialog.setTitle(title);
        dialog.getDialogPane().setContent((Node)pane);
        dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
        ButtonType response = dialog.showAndWait().orElse(ButtonType.CANCEL);
        if (this.pool != null) {
            this.pool.shutdown();
            try {
                this.pool.awaitTermination(5000L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.debug("Exception waiting for classification to complete: " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (this.nextRequest == null) {
            return;
        }
        if (ButtonType.APPLY.equals(response)) {
            if (!this.nextRequest.isComplete()) {
                this.nextRequest.doClassification();
            }
            imageData.getHistoryWorkflow().addStep(this.nextRequest.toWorkflowStep());
        } else {
            Collection changed = PathObjectTools.restoreClassificationsFromMap((Map)currentClassifications);
            if (!changed.isEmpty()) {
                hierarchy.fireObjectClassificationsChangedEvent((Object)this, changed);
            }
        }
    }

    double[] parseValues(List<Slider> sliders) {
        return sliders.stream().mapToDouble(s -> s.getValue()).toArray();
    }

    double[] parseValues(List<Slider> sliders, boolean singleThreshold) {
        if (singleThreshold) {
            return new double[]{sliders.get(0).getValue()};
        }
        return sliders.stream().mapToDouble(s -> s.getValue()).toArray();
    }

    void setValues(List<Slider> sliders, double[] values) {
        for (int i = 0; i < sliders.size(); ++i) {
            sliders.get(i).setValue(values[i]);
        }
    }

    void updateClassifications(PathObjectHierarchy hierarchy, boolean allDetections, String measurement, double ... thresholds) {
        ImageData imageData = this.qupath.getImageData();
        if (thresholds.length == 0 || imageData == null || measurement == null || Arrays.stream(thresholds).anyMatch(d -> Double.isNaN(d))) {
            return;
        }
        this.nextRequest = new IntensityClassificationRequest(hierarchy, allDetections, measurement, thresholds);
        if (this.pool == null || this.pool.isShutdown()) {
            this.pool = Executors.newSingleThreadExecutor(ThreadTools.createThreadFactory((String)"intensity-classifier", (boolean)true));
        }
        this.pool.execute(() -> this.processRequest());
    }

    synchronized void processRequest() {
        if (this.nextRequest == null || this.nextRequest.isComplete()) {
            return;
        }
        this.nextRequest.doClassification();
    }

    static class IntensityClassificationRequest {
        private PathObjectHierarchy hierarchy;
        private String measurement;
        private double[] thresholds;
        private boolean allDetections;
        private boolean isComplete = false;

        IntensityClassificationRequest(PathObjectHierarchy hierarchy, boolean allDetections, String measurement, double[] thresholds) {
            this.hierarchy = hierarchy;
            this.measurement = measurement;
            this.thresholds = thresholds;
            this.allDetections = allDetections;
        }

        public void doClassification() {
            Collection pathObjects = this.allDetections ? this.hierarchy.getDetectionObjects() : this.hierarchy.getCellObjects();
            QP.setIntensityClassifications((Collection)pathObjects, (String)this.measurement, (double[])this.thresholds);
            this.hierarchy.fireObjectClassificationsChangedEvent((Object)this, pathObjects);
            this.isComplete = true;
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        public WorkflowStep toWorkflowStep() {
            DecimalFormat formatter = new DecimalFormat("#.#####");
            String thresholdString = Arrays.stream(this.thresholds).mapToObj(d -> formatter.format(d)).collect(Collectors.joining(", "));
            if (this.allDetections) {
                return new DefaultScriptableWorkflowStep("Set detection intensity classifications", String.format("setDetectionIntensityClassifications(\"%s\", %s)", this.measurement, thresholdString));
            }
            return new DefaultScriptableWorkflowStep("Set cell intensity classifications", String.format("setCellIntensityClassifications(\"%s\", %s)", this.measurement, thresholdString));
        }
    }
}

