/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.input.MouseEvent;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.MatVector;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.Size;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.geom.util.GeometryCombiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.fx.prefs.annotations.BooleanPref;
import qupath.fx.prefs.annotations.DoublePref;
import qupath.fx.prefs.annotations.Pref;
import qupath.fx.prefs.annotations.PrefCategory;
import qupath.fx.prefs.controlsfx.PropertySheetUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.images.stores.DefaultImageRegionStore;
import qupath.lib.gui.images.stores.ImageRenderer;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.overlays.HierarchyOverlay;
import qupath.lib.gui.viewer.overlays.PathOverlay;
import qupath.lib.gui.viewer.tools.QuPathPenManager;
import qupath.lib.gui.viewer.tools.handlers.BrushToolEventHandler;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.GeometryTools;

public class WandToolEventHandler
extends BrushToolEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(WandToolEventHandler.class);
    private Point2D pLast = null;
    private static int w = 149;
    private BufferedImage imgBGR = new BufferedImage(w, w, 5);
    private BufferedImage imgGray = new BufferedImage(w, w, 10);
    private Mat mat = null;
    private Mat matMask = new Mat(w + 2, w + 2, opencv_core.CV_8UC1);
    private Mat matFloat = new Mat(w, w, opencv_core.CV_32FC3);
    private Scalar threshold = Scalar.all((double)1.0);
    private Point seed = new Point(w / 2, w / 2);
    private Mat strel = null;
    private Mat contourHierarchy = null;
    private Mat mean = new Mat();
    private Mat stddev = new Mat();
    private Rectangle2D bounds = new Rectangle2D.Double();
    private Size blurSize = new Size(31, 31);
    private static ObjectProperty<WandType> wandType = PathPrefs.createPersistentPreference((String)"wandType", (Enum)WandType.RGB, WandType.class);
    private static BooleanProperty wandUseOverlays = PathPrefs.createPersistentPreference((String)"wandUseOverlays", (boolean)true);
    private static DoubleProperty wandSigmaPixels = PathPrefs.createPersistentPreference((String)"wandSigmaPixels", (double)4.0);
    private static DoubleProperty wandSensitivityProperty = PathPrefs.createPersistentPreference((String)"wandSensitivityPixels", (double)2.0);

    public static ObjectProperty<WandType> wandTypeProperty() {
        return wandType;
    }

    public static BooleanProperty wandUseOverlaysProperty() {
        return wandUseOverlays;
    }

    public static boolean getWandUseOverlays() {
        return wandUseOverlays.get();
    }

    public static void setWandUseOverlays(boolean useOverlays) {
        wandUseOverlays.set(useOverlays);
    }

    public static DoubleProperty wandSigmaPixelsProperty() {
        return wandSigmaPixels;
    }

    public static double getWandSigmaPixels() {
        return wandSigmaPixels.get();
    }

    public static void setWandSigmaPixels(double sigma) {
        wandSigmaPixels.set(sigma);
    }

    public static DoubleProperty wandSensitivityProperty() {
        return wandSensitivityProperty;
    }

    public static double getWandSensitivity() {
        return wandSensitivityProperty.get();
    }

    public static void setWandSensitivity(double sensitivity) {
        wandSensitivityProperty.set(sensitivity);
    }

    public WandToolEventHandler(QuPathGUI qupath) {
        WandToolEventHandler.installPreferences(qupath);
    }

    static void installPreferences(QuPathGUI qupath) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> WandToolEventHandler.installPreferences(qupath));
            return;
        }
        qupath.getPreferencePane().getPropertySheet().getItems().addAll((Collection)PropertySheetUtils.parseAnnotatedItemsWithResources((LocalizedResourceManager)QuPathResources.getLocalizedResourceManager(), (Object)new WandPreferences()));
    }

    protected Geometry createShape(MouseEvent e, double x, double y, boolean useTiles, Geometry addToShape) {
        boolean doSimpleSelection;
        GeometryFactory factory = this.getGeometryFactory();
        if (addToShape != null && this.pLast != null && this.pLast.distanceSq(x, y) < 2.0) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        QuPathViewer viewer = this.getViewer();
        if (viewer == null) {
            return null;
        }
        double downsample = (double)Math.max(1L, Math.round(viewer.getDownsampleFactor() * 4.0)) / 4.0;
        DefaultImageRegionStore regionStore = viewer.getImageRegionStore();
        WandType type = (WandType)((Object)wandType.get());
        boolean doGray = type == WandType.GRAY;
        BufferedImage imgTemp = doGray ? this.imgGray : this.imgBGR;
        int nChannels = doGray ? 1 : 3;
        Graphics2D g2d = imgTemp.createGraphics();
        g2d.setColor(Color.BLACK);
        g2d.setClip(0, 0, w, w);
        g2d.fillRect(0, 0, w, w);
        double xStart = Math.round(x - (double)w * downsample * 0.5);
        double yStart = Math.round(y - (double)w * downsample * 0.5);
        this.bounds.setFrame(xStart, yStart, (double)w * downsample, (double)w * downsample);
        g2d.scale(1.0 / downsample, 1.0 / downsample);
        g2d.translate(-xStart, -yStart);
        regionStore.paintRegion(viewer.getServer(), (Graphics)g2d, (Shape)this.bounds, viewer.getZPosition(), viewer.getTPosition(), downsample, null, null, (ImageRenderer)viewer.getImageDisplay());
        float opacity = viewer.getOverlayOptions().getOpacity();
        if (opacity > 0.0f && WandToolEventHandler.getWandUseOverlays()) {
            ImageRegion region = ImageRegion.createInstance((int)((int)this.bounds.getX() - 1), (int)((int)this.bounds.getY() - 1), (int)((int)this.bounds.getWidth() + 2), (int)((int)this.bounds.getHeight() + 2), (int)viewer.getZPosition(), (int)viewer.getTPosition());
            if (opacity < 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, opacity));
            }
            for (PathOverlay overlay : (PathOverlay[])viewer.getOverlayLayers().toArray(PathOverlay[]::new)) {
                if (overlay instanceof HierarchyOverlay) continue;
                overlay.paintOverlay(g2d, region, downsample, viewer.getImageData(), true);
            }
        }
        if (this.mat != null && (this.mat.channels() != nChannels || this.mat.depth() != 0)) {
            this.mat.close();
            this.mat = null;
        }
        if (this.mat == null || this.mat.isNull() || this.mat.empty()) {
            this.mat = new Mat(w, w, opencv_core.CV_8UC((int)nChannels));
        }
        byte[] buffer = ((DataBufferByte)imgTemp.getRaster().getDataBuffer()).getData();
        ByteBuffer matBuffer = (ByteBuffer)this.mat.createBuffer();
        matBuffer.put(buffer);
        boolean bl = doSimpleSelection = e.isShortcutDown() && !e.isShiftDown();
        if (doSimpleSelection) {
            this.matMask.put(Scalar.ZERO);
            opencv_imgproc.floodFill((Mat)this.mat, (Mat)this.matMask, (Point)this.seed, (Scalar)Scalar.ONE, null, (Scalar)Scalar.ZERO, (Scalar)Scalar.ZERO, (int)197124);
            opencv_core.subtractPut((Mat)this.matMask, (Scalar)Scalar.ONE);
        } else {
            double blurSigma = Math.max(0.5, WandToolEventHandler.getWandSigmaPixels());
            int size = (int)Math.ceil(blurSigma * 2.0) * 2 + 1;
            this.blurSize.width(size);
            this.blurSize.height(size);
            opencv_imgproc.GaussianBlur((Mat)this.mat, (Mat)this.mat, (Size)this.blurSize, (double)blurSigma);
            Mat matThreshold = this.mat;
            if (type == WandType.LAB_DISTANCE) {
                this.mat.convertTo(this.matFloat, 5, 0.00392156862745098, 0.0);
                opencv_imgproc.cvtColor((Mat)this.matFloat, (Mat)this.matFloat, (int)44);
                double max = 0.0;
                double mean = 0.0;
                try (FloatIndexer idx = (FloatIndexer)this.matFloat.createIndexer();){
                    int k = w / 2;
                    double v1 = idx.get((long)k, (long)k, 0L);
                    double v2 = idx.get((long)k, (long)k, 1L);
                    double v3 = idx.get((long)k, (long)k, 2L);
                    double meanScale = 1.0 / (double)(w * w);
                    for (int row = 0; row < w; ++row) {
                        for (int col = 0; col < w; ++col) {
                            double B;
                            double A;
                            double L = (double)idx.get((long)row, (long)col, 0L) - v1;
                            double dist = Math.sqrt(L * L + (A = (double)idx.get((long)row, (long)col, 1L) - v2) * A + (B = (double)idx.get((long)row, (long)col, 2L) - v3) * B);
                            if (dist > max) {
                                max = dist;
                            }
                            mean += dist * meanScale;
                            idx.put((long)row, (long)col, 0L, (float)dist);
                        }
                    }
                }
                if (matThreshold == null) {
                    matThreshold = new Mat();
                }
                opencv_core.extractChannel((Mat)this.matFloat, (Mat)matThreshold, (int)0);
                matThreshold.convertTo(matThreshold, 0, 255.0 / max, 0.0);
                this.threshold.put(mean * WandToolEventHandler.getWandSensitivity());
                nChannels = 1;
            } else {
                opencv_core.meanStdDev((Mat)matThreshold, (Mat)this.mean, (Mat)this.stddev);
                DoubleBuffer stddevBuffer = (DoubleBuffer)this.stddev.createBuffer();
                double[] stddev2 = new double[nChannels];
                stddevBuffer.get(stddev2);
                double scale = 1.0 / WandToolEventHandler.getWandSensitivity();
                if (scale < 0.0) {
                    scale = 0.01;
                }
                for (int i = 0; i < stddev2.length; ++i) {
                    stddev2[i] = stddev2[i] * scale;
                }
                this.threshold.put(stddev2);
            }
            int radius = (int)Math.round((double)w / 2.0 * QuPathPenManager.getPenManager().getPressure());
            if (radius == 0) {
                return null;
            }
            this.matMask.put(Scalar.ZERO);
            opencv_imgproc.circle((Mat)this.matMask, (Point)this.seed, (int)radius, (Scalar)Scalar.ONE);
            opencv_imgproc.floodFill((Mat)matThreshold, (Mat)this.matMask, (Point)this.seed, (Scalar)Scalar.ONE, null, (Scalar)this.threshold, (Scalar)this.threshold, (int)197124);
            opencv_core.subtractPut((Mat)this.matMask, (Scalar)Scalar.ONE);
            if (this.strel == null) {
                this.strel = opencv_imgproc.getStructuringElement((int)2, (Size)new Size(5, 5));
            }
            opencv_imgproc.morphologyEx((Mat)this.matMask, (Mat)this.matMask, (int)3, (Mat)this.strel);
        }
        MatVector contours = new MatVector();
        if (this.contourHierarchy == null) {
            this.contourHierarchy = new Mat();
        }
        opencv_imgproc.findContours((Mat)this.matMask, (MatVector)contours, (Mat)this.contourHierarchy, (int)0, (int)2);
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        ArrayList<Polygon> geometries = new ArrayList<Polygon>();
        for (Mat contour : contours.get()) {
            if (contour.size().height() <= 2) continue;
            try (IntIndexer idxrContours = (IntIndexer)contour.createIndexer();){
                for (long r = 0L; r < idxrContours.size(0); ++r) {
                    int px = idxrContours.get(r, 0L, 0L);
                    int py = idxrContours.get(r, 0L, 1L);
                    double xx = (double)px - (double)w / 2.0 - 1.0;
                    double yy = (double)py - (double)w / 2.0 - 1.0;
                    coords.add(new Coordinate(xx, yy));
                }
            }
            if (coords.size() <= 1) continue;
            if (!((Coordinate)coords.getLast()).equals(coords.getFirst())) {
                coords.add((Coordinate)coords.getFirst());
            }
            Polygon polygon = factory.createPolygon((Coordinate[])coords.toArray(Coordinate[]::new));
            if (coords.size() <= 5 && !(polygon.getArea() > 1.0)) continue;
            geometries.add(polygon);
        }
        contours.close();
        if (geometries.isEmpty()) {
            return null;
        }
        Geometry geometry = geometries.size() == 1 ? (Geometry)geometries.getFirst() : GeometryCombiner.combine(geometries);
        geometry = geometry.buffer(0.5);
        AffineTransformation transform = new AffineTransformation().scale(downsample, downsample).translate(x, y);
        geometry = transform.transform(geometry);
        geometry = GeometryTools.roundCoordinates((Geometry)geometry);
        if ((geometry = GeometryTools.constrainToBounds((Geometry)geometry, (double)0.0, (double)0.0, (double)viewer.getServerWidth(), (double)viewer.getServerHeight())).getArea() <= 1.0) {
            return null;
        }
        long endTime = System.currentTimeMillis();
        logger.trace("{} time: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)(endTime - startTime));
        if (this.pLast == null) {
            this.pLast = new Point2D.Double(x, y);
        } else {
            this.pLast.setLocation(x, y);
        }
        return geometry;
    }

    protected double getBrushDiameter() {
        QuPathViewer viewer = this.getViewer();
        if (viewer == null) {
            return (double)w / 8.0;
        }
        return (double)w * this.getViewer().getDownsampleFactor() / 8.0;
    }

    @PrefCategory(value="Prefs.Drawing")
    public static class WandPreferences {
        @Pref(value="Prefs.Drawing.wandType", type=WandType.class)
        public final ObjectProperty<WandType> wandType = WandToolEventHandler.wandTypeProperty();
        @DoublePref(value="Prefs.Drawing.wandSigma")
        public final DoubleProperty wandSigma = WandToolEventHandler.wandSigmaPixelsProperty();
        @DoublePref(value="Prefs.Drawing.wandSensivity")
        public final DoubleProperty wandSensitivity = WandToolEventHandler.wandSensitivityProperty();
        @BooleanPref(value="Prefs.Drawing.wandUseOverlays")
        public final BooleanProperty useOverlays = WandToolEventHandler.wandUseOverlaysProperty();
    }

    public static enum WandType {
        GRAY,
        RGB,
        LAB_DISTANCE;

    }
}

