/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui;

import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.openblas.global.openblas;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_dnn;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.global.opencv_ml;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.heatmaps.DensityMaps;
import qupath.lib.classifiers.pixel.PixelClassifier;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.Version;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.annotations.ActionAccelerator;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.extensions.QuPathExtension;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.viewer.tools.PathTool;
import qupath.lib.gui.viewer.tools.PathTools;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.scripting.QP;
import qupath.opencv.CellCountsCV;
import qupath.opencv.features.DelaunayClusteringPlugin;
import qupath.opencv.ops.ImageOps;
import qupath.process.gui.WandToolEventHandler;
import qupath.process.gui.commands.CellIntensityClassificationCommand;
import qupath.process.gui.commands.CreateChannelTrainingImagesCommand;
import qupath.process.gui.commands.CreateCompositeClassifierCommand;
import qupath.process.gui.commands.CreateRegionAnnotationsCommand;
import qupath.process.gui.commands.CreateTrainingImageCommand;
import qupath.process.gui.commands.DensityMapCommand;
import qupath.process.gui.commands.ObjectClassifierCommand;
import qupath.process.gui.commands.ObjectClassifierLoadCommand;
import qupath.process.gui.commands.PixelClassifierCommand;
import qupath.process.gui.commands.SimpleThresholdCommand;
import qupath.process.gui.commands.SingleMeasurementClassificationCommand;
import qupath.process.gui.commands.SplitProjectTrainingCommand;
import qupath.process.gui.commands.ui.LoadResourceCommand;

public class ProcessingExtension
implements QuPathExtension {
    private static final Logger logger = LoggerFactory.getLogger(ProcessingExtension.class);

    private static void promptToCreateSparseServer(QuPathGUI qupath) {
        Project project = qupath.getProject();
        ProjectImageEntry<BufferedImage> entry = CreateTrainingImageCommand.promptToCreateTrainingImage((Project<BufferedImage>)project, (List<PathClass>)qupath.getAvailablePathClasses());
        qupath.refreshProject();
        if (entry != null) {
            qupath.openImageEntry(entry);
        }
    }

    public void installExtension(QuPathGUI qupath) {
        logger.debug("Installing extension");
        qupath.installActions((Collection)ActionTools.getAnnotatedActions((Object)new OpenCVCommands(qupath)));
        qupath.installActions((Collection)ActionTools.getAnnotatedActions((Object)new PixelClassificationCommands(this, qupath)));
        qupath.installActions((Collection)ActionTools.getAnnotatedActions((Object)new ObjectClassificationCommands(this, qupath)));
        qupath.installActions((Collection)ActionTools.getAnnotatedActions((Object)new OtherCommands(this, qupath)));
        this.installWand(qupath);
        new ImageOps();
    }

    private void installWand(QuPathGUI qupath) {
        Thread t = new Thread(() -> {
            if (!GeneralTools.isWindows()) {
                openblas.blas_set_num_threads((int)1);
            }
            this.loadCoreClasses();
            PathTool wandTool = PathTools.createTool((EventHandler)new WandToolEventHandler(qupath), (String)"Wand", (Node)IconFactory.createNode((int)16, (int)16, (IconFactory.PathIcons)IconFactory.PathIcons.WAND_TOOL));
            logger.debug("Installing wand tool");
            Platform.runLater(() -> {
                KeyCodeCombination keyCodeCombination = new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[0]);
                qupath.getToolManager().installTool(wandTool, keyCodeCombination);
                qupath.getToolManager().getToolAction(wandTool).setLongText(String.format("(%s) Click and drag to draw with a wand tool.\nAdjust brightness/contrast or wand preferences to customize the sensitivity and behavior.\n", keyCodeCombination.getDisplayText()));
            });
            logger.debug("Loading OpenCV classes");
        });
        t.start();
    }

    private void loadCoreClasses() {
        try {
            logger.debug("Attempting to load core OpenCV classes");
            Loader.load(opencv_core.class);
            Loader.load(opencv_imgproc.class);
            Loader.load(opencv_ml.class);
            Loader.load(opencv_dnn.class);
        }
        catch (Throwable t) {
            logger.error("Error loading OpenCV classes: " + t.getLocalizedMessage(), t);
        }
    }

    public String getName() {
        return QuPathResources.getString((String)"Extension.Processing");
    }

    public String getDescription() {
        return QuPathResources.getString((String)"Extension.Processing.description");
    }

    public Version getVersion() {
        return Version.parse((String)GeneralTools.getPackageVersion(ProcessingExtension.class));
    }

    public Version getQuPathVersion() {
        return this.getVersion();
    }

    static {
        QP qP = new QP();
    }

    @ActionMenu(value={"Menu.Analyze"})
    public static class OpenCVCommands {
        @ActionMenu(value={"Deprecated"})
        @ActionConfig(value="Action.Processing.Spatial.delaunay")
        @Deprecated
        public final Action actionDelaunay;
        @ActionMenu(value={"Menu.Analyze.CellDetection"})
        @ActionConfig(value="Action.Processing.CellDetection.fastCellCounts")
        @Deprecated
        public final Action actionFastCellCounts;
        @ActionMenu(value={"Menu.Analyze.DensityMaps"})
        @ActionConfig(value="Action.Processing.DensityMaps.create")
        public final Action actionDensityMap;
        @ActionMenu(value={"Menu.Analyze.DensityMaps"})
        @ActionConfig(value="Action.Processing.DensityMaps.load")
        public final Action actionDensityMapLoad;

        private OpenCVCommands(QuPathGUI qupath) {
            this.actionDelaunay = qupath.createPluginAction("Delaunay cluster features 2D (deprecated)", DelaunayClusteringPlugin.class, null);
            this.actionFastCellCounts = qupath.createPluginAction("Fast cell counts (brightfield)", CellCountsCV.class, null);
            DensityMapCommand densityMapCommand = new DensityMapCommand(qupath);
            this.actionDensityMap = qupath.createImageDataAction(imageData -> densityMapCommand.run());
            LoadResourceCommand<DensityMaps.DensityMapBuilder> commandLoad = LoadResourceCommand.createLoadDensityMapCommand(qupath);
            this.actionDensityMapLoad = qupath.createImageDataAction(imageData -> commandLoad.run());
        }
    }

    @ActionMenu(value={"Menu.Classify", "Menu.Classify.PixelClassification"})
    public class PixelClassificationCommands {
        @ActionConfig(value="Action.Processing.Classify.loadPixelClassifier")
        public final Action actionLoadPixelClassifier;
        public final Action SEP = ActionTools.createSeparator();
        @ActionAccelerator(value="shortcut+shift+p")
        @ActionConfig(value="Action.Processing.Classify.trainPixelClassifier")
        public final Action actionPixelClassifier;
        @ActionConfig(value="Action.Processing.Classify.createThresholder")
        public final Action actionSimpleThreshold;

        private PixelClassificationCommands(ProcessingExtension this$0, QuPathGUI qupath) {
            PixelClassifierCommand commandPixel = new PixelClassifierCommand();
            this.actionPixelClassifier = qupath.createImageDataAction(imageData -> commandPixel.run());
            LoadResourceCommand<PixelClassifier> commandLoad = LoadResourceCommand.createLoadPixelClassifierCommand(qupath);
            this.actionLoadPixelClassifier = qupath.createImageDataAction(imageData -> commandLoad.run());
            SimpleThresholdCommand commandThreshold = new SimpleThresholdCommand(qupath);
            this.actionSimpleThreshold = qupath.createImageDataAction(imageData -> commandThreshold.run());
        }
    }

    @ActionMenu(value={"Menu.Classify", "Menu.Classify.ObjectClassification"})
    public class ObjectClassificationCommands {
        @ActionConfig(value="Action.Processing.Classify.loadObjectClassifier")
        public final Action actionLoadObjectClassifier;
        public final Action SEP = ActionTools.createSeparator();
        @ActionAccelerator(value="shortcut+shift+d")
        @ActionConfig(value="Action.Processing.Classify.trainObjectClassifier")
        public final Action actionObjectClassifier;
        @ActionConfig(value="Action.Processing.Classify.createSingleMeasurementClassifier")
        public final Action actionMeasurement;
        @ActionConfig(value="Action.Processing.Classify.createCompositeClassifier")
        public final Action actionComposite;
        @ActionConfig(value="Action.Processing.Classify.setCellIntensityClassifications")
        public final Action actionIntensity;

        private ObjectClassificationCommands(ProcessingExtension this$0, QuPathGUI qupath) {
            ObjectClassifierLoadCommand commandLoad = new ObjectClassifierLoadCommand(qupath);
            this.actionLoadObjectClassifier = qupath.createImageDataAction(imageData -> commandLoad.run());
            CreateCompositeClassifierCommand commandComposite = new CreateCompositeClassifierCommand(qupath);
            this.actionComposite = ActionTools.createAction((Runnable)commandComposite);
            SingleMeasurementClassificationCommand commandSingle = new SingleMeasurementClassificationCommand(qupath);
            this.actionMeasurement = qupath.createImageDataAction(imageData -> commandSingle.run());
            CellIntensityClassificationCommand commandIntensity = new CellIntensityClassificationCommand(qupath);
            this.actionIntensity = qupath.createImageDataAction(imageData -> commandIntensity.run());
            ObjectClassifierCommand commandCreate = new ObjectClassifierCommand(qupath);
            this.actionObjectClassifier = qupath.createImageDataAction(imageData -> commandCreate.run());
        }
    }

    @ActionMenu(value={"Menu.Classify", "Menu.Classify.TrainingImages"})
    public class OtherCommands {
        @ActionConfig(value="Action.Processing.Classify.createRegionAnnotations")
        public final Action actionCreateRegions;
        @ActionConfig(value="Action.Processing.Classify.createTrainingImage")
        public final Action actionTrainingImage;
        @ActionConfig(value="Action.Processing.Classify.createChannelTrainingImages")
        public final Action actionChannelTraining;
        @ActionConfig(value="Action.Processing.Classify.splitTrainValidationTest")
        public final Action actionSplitProject;

        private OtherCommands(ProcessingExtension this$0, QuPathGUI qupath) {
            this.actionTrainingImage = qupath.createProjectAction(project -> ProcessingExtension.promptToCreateSparseServer(qupath));
            CreateChannelTrainingImagesCommand channelTraining = new CreateChannelTrainingImagesCommand(qupath);
            this.actionChannelTraining = qupath.createImageDataAction(imageData -> channelTraining.run());
            SplitProjectTrainingCommand splitProject = new SplitProjectTrainingCommand(qupath);
            this.actionSplitProject = qupath.createProjectAction(project -> splitProject.run());
            CreateRegionAnnotationsCommand createRegions = new CreateRegionAnnotationsCommand(qupath);
            this.actionCreateRegions = qupath.createImageDataAction(imageData -> createRegions.run());
        }
    }
}

