/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.gui.scripts;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.util.StringConverter;

class MappedStringConverter<T>
extends StringConverter<T> {
    private final Map<T, String> map;

    private MappedStringConverter(Map<T, String> map) {
        this.map = Map.copyOf(map);
    }

    public static <T> StringConverter<T> createFromFunction(Function<T, String> fun, T ... values) {
        Map<Object, String> map = Arrays.stream(values).collect(Collectors.toMap(t -> t, fun));
        return MappedStringConverter.create(map);
    }

    public static <T> StringConverter<T> create(Map<T, String> map) {
        return new MappedStringConverter<T>(map);
    }

    public String toString(T object) {
        return object == null ? null : (String)this.map.getOrDefault(object, null);
    }

    public T fromString(String string) {
        for (Map.Entry<T, String> entry : this.map.entrySet()) {
            if (!Objects.equals(string, entry.getValue())) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("No mapping for " + string);
    }
}

