/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.gui.scripts;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Duration;
import org.controlsfx.control.CheckComboBox;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.imagej.gui.scripts.ImageJScriptRunner;
import qupath.imagej.gui.scripts.MappedStringConverter;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.TaskRunnerFX;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.prefs.SystemMenuBar;
import qupath.lib.gui.scripting.ScriptEditorControl;
import qupath.lib.gui.scripting.TextAreaControl;
import qupath.lib.gui.scripting.languages.GroovyLanguage;
import qupath.lib.gui.scripting.languages.ImageJMacroLanguage;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ColorTransforms;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.downsamples.DownsampleCalculator;
import qupath.lib.images.servers.downsamples.DownsampleCalculators;
import qupath.lib.plugins.TaskRunner;
import qupath.lib.scripting.languages.ScriptLanguage;

public class ImageJScriptRunnerController
extends BorderPane {
    private static final Logger logger = LoggerFactory.getLogger(ImageJScriptRunnerController.class);
    private final QuPathGUI qupath;
    private static final ResourceBundle resources = ResourceBundle.getBundle("qupath.imagej.gui.scripts.strings");
    private static final String title = resources.getString("title");
    private static final String PREFS_KEY = "ij.scripts.";
    private final Map<ResolutionOption, StringProperty> resolutionOptionStringMap = Map.of(ResolutionOption.FIXED_DOWNSAMPLE, PathPrefs.createPersistentPreference((String)"ij.scripts.resolution.fixed", (String)"10"), ResolutionOption.PIXEL_SIZE, PathPrefs.createPersistentPreference((String)"ij.scripts.resolution.pixelSize", (String)"1"), ResolutionOption.LARGEST_DIMENSION, PathPrefs.createPersistentPreference((String)"ij.scripts.resolution.maxDim", (String)"1024"));
    private final ObjectProperty<LanguageOption> languageProperty = PathPrefs.createPersistentPreference((String)"ij.scripts.language", (Enum)LanguageOption.MACRO, LanguageOption.class);
    private final BooleanProperty setImageJRoi = PathPrefs.createPersistentPreference((String)"ij.scripts.setImageJRoi", (boolean)true);
    private final BooleanProperty setImageJOverlay = PathPrefs.createPersistentPreference((String)"ij.scripts.setImageJOverlay", (boolean)false);
    private final BooleanProperty deleteChildObjects = PathPrefs.createPersistentPreference((String)"ij.scripts.deleteChildObjects", (boolean)true);
    private final BooleanProperty addToCommandHistory = PathPrefs.createPersistentPreference((String)"ij.scripts.addToCommandHistory", (boolean)false);
    private final IntegerProperty nThreadsProperty = PathPrefs.createPersistentPreference((String)"ij.scripts.nThreads", (int)1);
    private final ObjectProperty<ResolutionOption> resolutionProperty = PathPrefs.createPersistentPreference((String)"ij.scripts.resolutionProperty", (Enum)ResolutionOption.LARGEST_DIMENSION, ResolutionOption.class);
    private final IntegerProperty paddingProperty = PathPrefs.createPersistentPreference((String)"ij.scripts.padding", (int)0);
    private final ObjectProperty<ImageJScriptRunner.PathObjectType> returnRoiType = PathPrefs.createPersistentPreference((String)"ij.scripts.returnRoiType", (Enum)ImageJScriptRunner.PathObjectType.NONE, ImageJScriptRunner.PathObjectType.class);
    private final ObjectProperty<ImageJScriptRunner.PathObjectType> returnOverlayType = PathPrefs.createPersistentPreference((String)"ij.scripts.returnOverlayType", (Enum)ImageJScriptRunner.PathObjectType.NONE, ImageJScriptRunner.PathObjectType.class);
    private final ObjectProperty<ImageJScriptRunner.ApplyToObjects> applyToObjects = PathPrefs.createPersistentPreference((String)"ij.scripts.applyToObjects", (Enum)ImageJScriptRunner.ApplyToObjects.SELECTED, ImageJScriptRunner.ApplyToObjects.class);
    private final BooleanBinding noReturnObjects = this.returnRoiType.isNull().or((ObservableBooleanValue)this.returnRoiType.isEqualTo((Object)ImageJScriptRunner.PathObjectType.NONE)).and((ObservableBooleanValue)this.returnOverlayType.isNull().or((ObservableBooleanValue)this.returnOverlayType.isEqualTo((Object)ImageJScriptRunner.PathObjectType.NONE)));
    private final ObjectProperty<ImageData<BufferedImage>> imageDataProperty = new SimpleObjectProperty();
    private final ObjectProperty<Future<?>> runningTask = new SimpleObjectProperty();
    private final ObservableList<URI> recentUris = PathPrefs.createPersistentUriList((String)"ij.scripts.recentUris", (int)8, (String[])new String[0]);
    @FXML
    private BorderPane paneScript;
    @FXML
    private CheckComboBox<ColorTransforms.ColorTransform> comboChannels;
    @FXML
    private Button btnRunMacro;
    @FXML
    private Button btnTest;
    @FXML
    private Spinner<Integer> spinnerThreads;
    @FXML
    private Label labelThreadsWarning;
    @FXML
    private CheckBox cbAddToHistory;
    @FXML
    private CheckBox cbDeleteExistingObjects;
    @FXML
    private CheckBox cbSetImageJOverlay;
    @FXML
    private CheckBox cbSetImageJRoi;
    @FXML
    private ChoiceBox<ResolutionOption> choiceResolution;
    @FXML
    private ChoiceBox<ImageJScriptRunner.PathObjectType> choiceReturnOverlay;
    @FXML
    private ChoiceBox<ImageJScriptRunner.PathObjectType> choiceReturnRoi;
    @FXML
    private ChoiceBox<ImageJScriptRunner.ApplyToObjects> choiceApplyTo;
    @FXML
    private Label labelResolution;
    @FXML
    private TextArea textAreaMacro;
    @FXML
    private TextField tfResolution;
    @FXML
    private Spinner<Integer> spinnerPadding;
    @FXML
    private TitledPane titledScript;
    @FXML
    private TitledPane titledOptions;
    @FXML
    private MenuBar menuBar;
    @FXML
    private Menu menuRecent;
    @FXML
    private Menu menuExamples;
    @FXML
    private MenuItem miUndo;
    @FXML
    private MenuItem miRedo;
    @FXML
    private MenuItem miRun;
    @FXML
    private RadioMenuItem rmiMacro;
    @FXML
    private RadioMenuItem rmiGroovy;
    @FXML
    private ToggleGroup toggleLanguages;
    private final ObjectProperty<DownsampleCalculator> downsampleCalculatorProperty = new SimpleObjectProperty();
    private ScriptEditorControl<?> scriptEditorControl;
    private final StringProperty macroText = new SimpleStringProperty("");
    private final StringProperty lastSavedText = new SimpleStringProperty("");
    private final ObjectProperty<Path> lastSavedPath = new SimpleObjectProperty(null);
    private final BooleanBinding unsavedChanges = this.lastSavedText.isNotEqualTo((ObservableStringValue)this.macroText).and((ObservableBooleanValue)this.lastSavedText.isNotEmpty());
    private final PropertyChangeListener imageDataPropertyListener = this::imageDataPropertyChange;

    public static ImageJScriptRunnerController createInstance(QuPathGUI qupath) throws IOException {
        return new ImageJScriptRunnerController(qupath);
    }

    private ImageJScriptRunnerController(QuPathGUI qupath) throws IOException {
        this.qupath = qupath;
        URL url = ImageJScriptRunnerController.class.getResource("ij-script-runner.fxml");
        FXMLLoader loader = new FXMLLoader(url, resources);
        loader.setRoot((Object)this);
        if (loader.getController() == null) {
            loader.setController((Object)this);
        }
        loader.load();
        this.init();
    }

    private void init() {
        this.imageDataProperty.bind((ObservableValue)this.qupath.imageDataProperty());
        this.imageDataProperty.addListener(this::handleImageDataChange);
        this.initEditor();
        this.initLanguages();
        this.initThreads();
        this.initTitle();
        this.initResolutionChoices();
        this.initPadding();
        this.initReturnObjectTypeChoices();
        this.initApplyToObjectTypes();
        this.bindPreferences();
        this.initMenus();
        this.initRunButton();
        this.initDragDrop();
        this.handleImageDataChange((ObservableValue<? extends ImageData<BufferedImage>>)this.imageDataProperty, null, (ImageData<BufferedImage>)((ImageData)this.imageDataProperty.get()));
    }

    private void initEditor() {
        try {
            this.scriptEditorControl = ImageJScriptRunnerController.createScriptEditorControl();
            this.titledScript.setContent((Node)this.scriptEditorControl.getRegion());
        }
        catch (Exception e) {
            this.scriptEditorControl = null;
            logger.warn("Unable to create editor from the default script editor: {}", (Object)e.getMessage(), (Object)e);
        }
        if (this.scriptEditorControl == null) {
            this.scriptEditorControl = new TextAreaControl(this.textAreaMacro, true);
        }
        this.macroText.bind((ObservableValue)this.scriptEditorControl.textProperty());
    }

    private void initLanguages() {
        this.rmiMacro.setUserData((Object)LanguageOption.MACRO);
        this.rmiGroovy.setUserData((Object)LanguageOption.GROOVY);
        if (this.languageProperty.get() == LanguageOption.GROOVY) {
            this.toggleLanguages.selectToggle((Toggle)this.rmiGroovy);
        } else {
            this.toggleLanguages.selectToggle((Toggle)this.rmiMacro);
        }
        this.languageProperty.bind(this.toggleLanguages.selectedToggleProperty().map(t -> (LanguageOption)((Object)((Object)t.getUserData()))));
        this.languageProperty.addListener((v, o, n) -> this.updateLanguage());
        this.updateLanguage();
    }

    private void updateLanguage() {
        if (this.languageProperty.get() == LanguageOption.GROOVY) {
            this.scriptEditorControl.setLanguage((ScriptLanguage)GroovyLanguage.getInstanceWithCompletions(Collections.emptyList()));
        } else {
            this.scriptEditorControl.setLanguage((ScriptLanguage)ImageJMacroLanguage.getInstance());
        }
    }

    private void initTitle() {
        this.titledScript.textProperty().bind((ObservableValue)Bindings.createStringBinding(this::getMacroPaneTitle, (Observable[])new Observable[]{this.unsavedChanges, this.languageProperty, this.lastSavedPath}));
    }

    private static ScriptEditorControl<?> createScriptEditorControl() {
        try {
            Class<?> cls = Class.forName("qupath.lib.gui.scripting.richtextfx.CodeAreaControl");
            Method method = cls.getMethod("createCodeEditor", new Class[0]);
            Object editor = method.invoke(null, new Object[0]);
            Method methodLanguage = cls.getMethod("setLanguage", ScriptLanguage.class);
            methodLanguage.invoke(editor, ImageJMacroLanguage.getInstance());
            return (ScriptEditorControl)editor;
        }
        catch (Error | Exception e) {
            logger.warn("Unable to find rich text code editor - will default to basic editor");
            return new TextAreaControl(true);
        }
    }

    private String getMacroPaneTitle() {
        String name;
        Path path = (Path)this.lastSavedPath.get();
        String string = name = path == null || path.getFileName() == null ? "" : path.getFileName().toString();
        if (!name.isBlank()) {
            return name;
        }
        String title = switch (((LanguageOption)((Object)this.languageProperty.get())).ordinal()) {
            case 1 -> resources.getString("ui.title.script.groovy");
            case 0 -> resources.getString("ui.title.script.macro");
            default -> resources.getString("ui.title.script");
        };
        return this.unsavedChanges.get() ? title + "*" : title;
    }

    private void handleImageDataChange(ObservableValue<? extends ImageData<BufferedImage>> values, ImageData<BufferedImage> oldValue, ImageData<BufferedImage> newValue) {
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.imageDataPropertyListener);
        }
        if (newValue != null) {
            newValue.addPropertyChangeListener(this.imageDataPropertyListener);
        }
        this.updateChannels(newValue);
    }

    private void imageDataPropertyChange(PropertyChangeEvent evt) {
        if ("imageType".equals(evt.getPropertyName()) || "stains".equals(evt.getPropertyName()) || "serverMetadata".equals(evt.getPropertyName())) {
            this.updateChannels((ImageData)this.imageDataProperty.getValue());
        }
    }

    private void initChannels() {
        this.updateChannels((ImageData)this.imageDataProperty.get());
        FXUtils.installSelectAllOrNoneMenu(this.comboChannels);
    }

    private void updateChannels(ImageData<?> imageData) {
        if (imageData == null) {
            return;
        }
        ArrayList<ColorTransforms.ColorTransform> availableChannels = new ArrayList<ColorTransforms.ColorTransform>();
        int nChannels = imageData.getServer().nChannels();
        for (ImageChannel channel : imageData.getServer().getMetadata().getChannels()) {
            availableChannels.add(ColorTransforms.createChannelExtractor((String)channel.getName()));
        }
        ColorDeconvolutionStains stains = imageData.getColorDeconvolutionStains();
        if (stains != null) {
            for (int i = 0; i < 3; ++i) {
                availableChannels.add(ColorTransforms.createColorDeconvolvedChannel((ColorDeconvolutionStains)stains, (int)(i + 1)));
            }
        }
        if (!Objects.equals(availableChannels, this.comboChannels.getItems())) {
            int[] toCheck = availableChannels.size() == this.comboChannels.getItems().size() ? this.comboChannels.getCheckModel().getCheckedIndices().stream().mapToInt(Integer::intValue).toArray() : IntStream.range(0, nChannels).toArray();
            this.comboChannels.getCheckModel().clearChecks();
            this.comboChannels.getItems().setAll(availableChannels);
            this.comboChannels.getCheckModel().checkIndices(toCheck);
        }
    }

    private void initPadding() {
        int min = 0;
        int value = Math.max(min, this.paddingProperty.getValue());
        int max = 1024;
        int step = 1;
        this.spinnerPadding.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max, value, step));
        this.paddingProperty.bind((ObservableValue)this.spinnerPadding.valueProperty());
    }

    private void initThreads() {
        int min = 1;
        int value = Math.max(min, this.nThreadsProperty.getValue());
        int max = Math.max(value, Runtime.getRuntime().availableProcessors());
        int step = 1;
        this.spinnerThreads.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max, value, step));
        this.nThreadsProperty.bind((ObservableValue)this.spinnerThreads.valueProperty());
        this.labelThreadsWarning.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.nThreadsProperty.get() > 1 && this.languageProperty.get() == LanguageOption.MACRO, (Observable[])new Observable[]{this.nThreadsProperty, this.languageProperty}));
        Glyph icon = new Glyph("FontAwesome", (Object)FontAwesome.Glyph.EXCLAMATION_CIRCLE);
        icon.getStyleClass().add((Object)"warning");
        this.labelThreadsWarning.setGraphic((Node)icon);
        this.labelThreadsWarning.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.labelThreadsWarning.getTooltip().setShowDelay(Duration.ZERO);
        this.labelThreadsWarning.getTooltip().setHideDelay(Duration.ZERO);
    }

    private void bindPreferences() {
        this.cbSetImageJRoi.selectedProperty().bindBidirectional((Property)this.setImageJRoi);
        this.cbSetImageJOverlay.selectedProperty().bindBidirectional((Property)this.setImageJOverlay);
        this.cbDeleteExistingObjects.selectedProperty().bindBidirectional((Property)this.deleteChildObjects);
        this.cbAddToHistory.selectedProperty().bindBidirectional((Property)this.addToCommandHistory);
        this.cbDeleteExistingObjects.disableProperty().bind((ObservableValue)this.noReturnObjects);
    }

    private void initResolutionChoices() {
        this.choiceResolution.getItems().setAll((Object[])ResolutionOption.values());
        this.resolutionProperty.addListener(this::resolutionChoiceChanged);
        this.tfResolution.textProperty().addListener(o -> this.refreshDownsampleCalculator());
        this.choiceResolution.valueProperty().bindBidirectional(this.resolutionProperty);
        this.resolutionChoiceChanged((ObservableValue<? extends ResolutionOption>)this.resolutionProperty, null, (ResolutionOption)((Object)this.resolutionProperty.getValue()));
    }

    private void resolutionChoiceChanged(ObservableValue<? extends ResolutionOption> value, ResolutionOption oldValue, ResolutionOption newValue) {
        StringProperty prop;
        if (oldValue != null) {
            prop = this.resolutionOptionStringMap.get((Object)oldValue);
            prop.unbind();
        }
        if (newValue != null) {
            prop = this.resolutionOptionStringMap.get((Object)newValue);
            String val = prop.getValue();
            prop.bind((ObservableValue)this.tfResolution.textProperty());
            this.tfResolution.setText(val);
            this.labelResolution.setText(resources.getString(newValue.getResourceKey() + ".label"));
            this.labelResolution.getTooltip().setText(resources.getString(newValue.getResourceKey() + ".tooltip"));
        }
    }

    private void initReturnObjectTypeChoices() {
        List<ImageJScriptRunner.PathObjectType> availableTypes = List.of(ImageJScriptRunner.PathObjectType.NONE, ImageJScriptRunner.PathObjectType.ANNOTATION, ImageJScriptRunner.PathObjectType.DETECTION, ImageJScriptRunner.PathObjectType.TILE, ImageJScriptRunner.PathObjectType.CELL);
        this.choiceReturnRoi.getItems().setAll(availableTypes);
        this.choiceReturnRoi.setConverter(MappedStringConverter.createFromFunction(ImageJScriptRunnerController::typeToName, ImageJScriptRunner.PathObjectType.values()));
        this.choiceReturnRoi.valueProperty().bindBidirectional(this.returnRoiType);
        this.choiceReturnOverlay.getItems().setAll(availableTypes);
        this.choiceReturnOverlay.setConverter(MappedStringConverter.createFromFunction(ImageJScriptRunnerController::typeToPluralName, ImageJScriptRunner.PathObjectType.values()));
        this.choiceReturnOverlay.valueProperty().bindBidirectional(this.returnOverlayType);
    }

    private static String typeToName(ImageJScriptRunner.PathObjectType type) {
        if (type == ImageJScriptRunner.PathObjectType.NONE) {
            return "-";
        }
        String name = type.name();
        return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
    }

    private static String typeToPluralName(ImageJScriptRunner.PathObjectType type) {
        if (type == ImageJScriptRunner.PathObjectType.NONE) {
            return "-";
        }
        return ImageJScriptRunnerController.typeToName(type) + "s";
    }

    private void initApplyToObjectTypes() {
        List<ImageJScriptRunner.ApplyToObjects> availableTypes = List.of(ImageJScriptRunner.ApplyToObjects.values());
        this.choiceApplyTo.getItems().setAll(availableTypes);
        this.choiceApplyTo.setConverter(MappedStringConverter.createFromFunction(ImageJScriptRunner.ApplyToObjects::toString, ImageJScriptRunner.ApplyToObjects.values()));
        this.choiceApplyTo.valueProperty().bindBidirectional(this.applyToObjects);
        if (this.choiceApplyTo.valueProperty().get() == null) {
            this.choiceApplyTo.setValue((Object)ImageJScriptRunner.ApplyToObjects.SELECTED);
        }
    }

    private void initRunButton() {
        this.btnRunMacro.disableProperty().bind((ObservableValue)this.imageDataProperty.isNull().or((ObservableBooleanValue)this.macroText.isEmpty()).or((ObservableBooleanValue)this.downsampleCalculatorProperty.isNull()).or((ObservableBooleanValue)this.runningTask.isNotNull()).or((ObservableBooleanValue)this.applyToObjects.isNull()));
        this.miRun.disableProperty().bind((ObservableValue)this.btnRunMacro.disableProperty());
        this.btnTest.disableProperty().bind((ObservableValue)this.btnRunMacro.disableProperty());
        StringBinding runText = Bindings.createStringBinding(() -> switch (((LanguageOption)((Object)((Object)this.languageProperty.get()))).ordinal()) {
            case 1 -> resources.getString("ui.button.run.groovy");
            case 0 -> resources.getString("ui.button.run.macro");
            default -> resources.getString("ui.button.run");
        }, (Observable[])new Observable[]{this.languageProperty});
        this.miRun.textProperty().bind((ObservableValue)runText);
        this.btnRunMacro.textProperty().bind((ObservableValue)runText);
    }

    private void initMenus() {
        Region region = this.scriptEditorControl.getRegion();
        if (region instanceof TextArea) {
            TextArea textArea = (TextArea)region;
            this.miUndo.disableProperty().bind((ObservableValue)textArea.undoableProperty().not());
            this.miRedo.disableProperty().bind((ObservableValue)textArea.redoableProperty().not());
        }
        SystemMenuBar.manageChildMenuBar((MenuBar)this.menuBar);
        this.menuExamples.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.menuExamples.getItems()));
        try {
            List<MenuItem> examples = this.loadExampleMacros();
            this.menuExamples.getItems().setAll(examples);
        }
        catch (Exception e) {
            logger.error("Error loading default examples: {}", (Object)e.getMessage(), (Object)e);
        }
        this.initRecentScripts();
    }

    private void initRecentScripts() {
        GuiTools.configureRecentItemsMenu((Menu)this.menuRecent, this.recentUris, this::tryToOpenUri);
    }

    private void tryToOpenUri(URI uri) {
        Path path = GeneralTools.toPath((URI)uri);
        if (path != null && Files.exists(path, new LinkOption[0])) {
            this.openMacro(path);
        } else {
            logger.error("Unable to open URI {}", (Object)uri);
        }
    }

    private void initDragDrop() {
        this.setOnDragOver(this::handleDragOver);
        this.setOnDragDropped(this::handleDragDropped);
    }

    private void handleDragOver(DragEvent event) {
        event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
        event.consume();
    }

    private void handleDragDropped(DragEvent event) {
        Path file;
        Dragboard dragboard = event.getDragboard();
        if (dragboard.hasFiles() && (file = (Path)dragboard.getFiles().stream().filter(f -> f.length() < 0x100000L).map(File::toPath).findFirst().orElse(null)) != null) {
            this.openMacro(file);
            event.consume();
        }
    }

    private void refreshDownsampleCalculator() {
        ResolutionOption resolution = (ResolutionOption)((Object)this.resolutionProperty.get());
        String text = this.tfResolution.getText();
        if (resolution == null || text == null || text.isBlank()) {
            logger.trace("Downsample calculator cannot be set");
            this.downsampleCalculatorProperty.set(null);
            return;
        }
        try {
            Number number = NumberFormat.getNumberInstance().parse(text);
            this.downsampleCalculatorProperty.set((Object)resolution.createCalculator(number.doubleValue()));
        }
        catch (Exception e) {
            logger.debug("Error creating downsample calculator: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private File getLastSavedFile() {
        Path path = (Path)this.lastSavedPath.get();
        if (path != null && Objects.equals(path.getFileSystem(), FileSystems.getDefault())) {
            return path.toFile();
        }
        String name = "Untitled";
        if (path != null && path.getFileName() != null) {
            name = GeneralTools.stripExtension((String)path.getFileName().toString());
        }
        return new File(name);
    }

    private List<MenuItem> loadExampleMacros() throws URISyntaxException, IOException {
        Path dirExamples;
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        URL url = ImageJScriptRunnerController.class.getResource("examples");
        if (url == null) {
            return items;
        }
        URI uri = url.toURI();
        if (uri.getScheme().equals("jar")) {
            FileSystem fileSystem = FileSystems.newFileSystem(uri, Map.of());
            dirExamples = fileSystem.getPath(uri.toString().substring(uri.toString().indexOf("!") + 1), new String[0]);
        } else {
            dirExamples = Paths.get(uri);
        }
        try (Stream<Path> stream = Files.walk(dirExamples, 2, new FileVisitOption[0]);){
            Map<String, List<Path>> map = stream.sorted(Comparator.comparing(p -> p.getFileName().toString())).filter(p -> ImageJScriptRunnerController.getFileExtension(p) != null).collect(Collectors.groupingBy(ImageJScriptRunnerController::getFileExtension));
            ArrayList<String> keys = new ArrayList<String>(map.keySet());
            if (keys.contains(".ijm")) {
                keys.remove(".ijm");
                keys.addFirst(".ijm");
            }
            for (String key : keys) {
                if (!items.isEmpty()) {
                    items.add((MenuItem)new SeparatorMenuItem());
                }
                for (Path path : map.get(key)) {
                    MenuItem item = this.createMenuItemForExample(path);
                    items.add(item);
                }
            }
        }
        return items;
    }

    private MenuItem createMenuItemForExample(Path path) {
        String name = path.getFileName().toString();
        MenuItem item = new MenuItem(name.replaceAll("_", " "));
        item.setOnAction(e -> this.openMacro(path));
        return item;
    }

    private static String getFileExtension(Path p) {
        return GeneralTools.getExtension((String)p.getFileName().toString()).orElse(null);
    }

    @FXML
    void promptToOpenMacro() {
        File file = FileChoosers.promptForFile((Window)FXUtils.getWindow((Node)this), (String)title, (FileChooser.ExtensionFilter[])this.getAllValidExtensionFilters());
        if (file != null) {
            this.openMacro(file.toPath());
        }
    }

    @FXML
    void handleSave() {
        File lastSavedFile = this.getLastSavedFile();
        if (lastSavedFile == null || !lastSavedFile.exists()) {
            this.handleSaveAs();
            return;
        }
        if (!this.unsavedChanges.get() || Dialogs.showYesNoDialog((String)title, (String)String.format(resources.getString("dialogs.overwrite"), lastSavedFile.getName()))) {
            this.tryToSave(lastSavedFile);
        }
    }

    @FXML
    void handleSaveAs() {
        File file = FileChoosers.promptToSaveFile((Window)FXUtils.getWindow((Node)this), (String)title, (File)this.getLastSavedFile(), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{this.getExtensionFilter()});
        if (file != null) {
            this.tryToSave(file);
        }
    }

    @FXML
    void handleClose() {
        Window window = FXUtils.getWindow((Node)this);
        if (window != null) {
            window.hide();
        }
    }

    private void tryToSave(File file) {
        try {
            String text = this.macroText.getValueSafe();
            Path path = file.toPath();
            Files.writeString(path, (CharSequence)text, new OpenOption[0]);
            logger.info("Script saved to {}", (Object)path);
            this.lastSavedText.set((Object)text);
            this.lastSavedPath.set((Object)path);
            URI uri = path.toUri();
            this.recentUris.remove((Object)uri);
            this.recentUris.addFirst((Object)uri);
        }
        catch (IOException e) {
            Dialogs.showErrorNotification((String)title, (String)String.format(resources.getString("dialogs.error.writing"), file.getName()));
        }
    }

    private FileChooser.ExtensionFilter getExtensionFilter() {
        if (this.languageProperty.get() == LanguageOption.GROOVY) {
            return FileChoosers.createExtensionFilter((String)"Groovy", (String[])new String[]{"*.groovy"});
        }
        return FileChoosers.createExtensionFilter((String)"ImageJ macro", (String[])new String[]{"*.ijm"});
    }

    private FileChooser.ExtensionFilter[] getAllValidExtensionFilters() {
        return new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)resources.getString("chooser.validFiles"), (String[])new String[]{"*.ijm", "*.txt", "*.groovy"}), FileChoosers.FILTER_ALL_FILES};
    }

    @FXML
    public void promptToCreateNewMacro() {
        if (!this.macroText.getValueSafe().isBlank() && this.unsavedChanges.get() && !Dialogs.showYesNoDialog((String)title, (String)resources.getString("dialogs.discardUnsaved"))) {
            return;
        }
        this.scriptEditorControl.setText("");
        this.lastSavedText.set((Object)"");
        this.lastSavedPath.set(null);
    }

    @FXML
    public void doCopy(ActionEvent event) {
        this.scriptEditorControl.copy();
        event.consume();
    }

    @FXML
    public void doPaste(ActionEvent event) {
        this.scriptEditorControl.paste();
        event.consume();
    }

    @FXML
    public void doCut(ActionEvent event) {
        this.scriptEditorControl.cut();
        event.consume();
    }

    @FXML
    public void doUndo(ActionEvent event) {
        this.scriptEditorControl.undo();
        event.consume();
    }

    @FXML
    public void doRedo(ActionEvent event) {
        this.scriptEditorControl.redo();
        event.consume();
    }

    public void openMacro(Path path) {
        try {
            String text = Files.readString(path);
            String currentText = (String)this.macroText.get();
            if (currentText == null) {
                currentText = "";
            }
            if (Objects.equals(currentText, text)) {
                return;
            }
            if (!currentText.isBlank() && this.unsavedChanges.get() && !Dialogs.showYesNoDialog((String)title, (String)resources.getString("dialogs.replaceCurrent"))) {
                return;
            }
            this.scriptEditorControl.setText(text);
            this.lastSavedText.set((Object)text);
            this.lastSavedPath.set((Object)path);
            String ext = GeneralTools.getExtension((String)path.toString()).orElse("");
            switch (ext.toLowerCase()) {
                case ".groovy": {
                    this.toggleLanguages.selectToggle((Toggle)this.rmiGroovy);
                    break;
                }
                case ".ijm": 
                case ".txt": {
                    this.toggleLanguages.selectToggle((Toggle)this.rmiMacro);
                    break;
                }
            }
        }
        catch (IOException e) {
            Dialogs.showErrorNotification((String)title, (String)String.format(resources.getString("dialogs.error.reading"), path.getFileName()));
        }
    }

    public static String getTitle() {
        return resources.getString("title");
    }

    @FXML
    void handleRunTest(ActionEvent event) {
        this.handleRun(true);
    }

    @FXML
    void handleRun(ActionEvent event) {
        this.handleRun(false);
    }

    private void handleRun(boolean isTest) {
        ImageJScriptRunner.ApplyToObjects applyToType;
        ImageData imageData = (ImageData)this.imageDataProperty.get();
        if (!ImageJScriptRunnerController.checkForCompatibleObjects(imageData, applyToType = (ImageJScriptRunner.ApplyToObjects)((Object)this.applyToObjects.get()))) {
            return;
        }
        String macroText = (String)this.macroText.get();
        DownsampleCalculator downsampleCalculator = (DownsampleCalculator)this.downsampleCalculatorProperty.get();
        int padding = this.paddingProperty.get();
        boolean setImageJRoi = this.setImageJRoi.get();
        boolean setImageJOverlay = this.setImageJOverlay.get();
        ImageJScriptRunner.PathObjectType roiObjectType = (ImageJScriptRunner.PathObjectType)((Object)this.returnRoiType.get());
        ImageJScriptRunner.PathObjectType overlayObjectType = (ImageJScriptRunner.PathObjectType)((Object)this.returnOverlayType.get());
        boolean clearChildObjects = this.deleteChildObjects.get() && !this.noReturnObjects.get();
        boolean addToWorkflow = !isTest && this.cbAddToHistory.isSelected();
        int nThreads = this.nThreadsProperty.get();
        ObservableList channels = this.comboChannels.getCheckModel().getCheckedItems();
        if (imageData.getServer().isRGB() && channels.size() == 3) {
            channels = null;
        }
        ImageJScriptRunner runner = ImageJScriptRunner.builder().setImageJRoi(setImageJRoi).setImageJOverlay(setImageJOverlay).downsample(downsampleCalculator).padding(padding).overlayToObjects(overlayObjectType).roiToObject(roiObjectType).text(macroText).scriptEngine(this.estimateScriptEngine()).addToWorkflow(addToWorkflow).channels((Collection<? extends ColorTransforms.ColorTransform>)channels).nThreads(nThreads).taskRunner((TaskRunner)new TaskRunnerFX(this.qupath, nThreads)).applyToObjects(applyToType).clearChildObjects(clearChildObjects).build();
        this.runningTask.setValue(this.qupath.getThreadPoolManager().getSingleThreadExecutor((Object)this).submit(() -> {
            try {
                if (isTest) {
                    runner.test((ImageData<BufferedImage>)imageData);
                } else {
                    runner.run((ImageData<BufferedImage>)imageData);
                }
            }
            finally {
                if (Platform.isFxApplicationThread()) {
                    this.runningTask.set(null);
                } else {
                    Platform.runLater(() -> this.runningTask.set(null));
                }
            }
        }));
    }

    private static boolean checkForCompatibleObjects(ImageData<?> imageData, ImageJScriptRunner.ApplyToObjects applyType) {
        if (imageData == null) {
            return false;
        }
        if (ImageJScriptRunner.getObjectsToProcess(imageData.getHierarchy(), applyType).isEmpty()) {
            Dialogs.showWarningNotification((String)title, (String)("No compatible objects found for the option '" + String.valueOf((Object)applyType) + "'"));
            return false;
        }
        return true;
    }

    private String estimateScriptEngine() {
        if (this.languageProperty.get() == LanguageOption.GROOVY) {
            return "groovy";
        }
        return null;
    }

    public static enum ResolutionOption {
        FIXED_DOWNSAMPLE,
        PIXEL_SIZE,
        LARGEST_DIMENSION;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> "Pixel size (\u00b5m)";
                case 0 -> "Fixed downsample";
                case 2 -> "Largest dimensions";
            };
        }

        private String getResourceKey() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> "ui.resolution.pixelSize";
                case 0 -> "ui.resolution.fixed";
                case 2 -> "ui.resolution.maxDim";
            };
        }

        private DownsampleCalculator createCalculator(double value) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> DownsampleCalculators.pixelSizeMicrons((double)value);
                case 0 -> DownsampleCalculators.fixedDownsample((double)value);
                case 2 -> DownsampleCalculators.maxDimension((int)((int)Math.round(value)));
            };
        }
    }

    public static enum LanguageOption {
        MACRO,
        GROOVY;

    }
}

