/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.gui.scripts;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.imagej.tools.IJProperties;
import qupath.imagej.tools.IJTools;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ColorTransforms;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.servers.TransformedServerBuilder;
import qupath.lib.images.servers.WrappedBufferedImageServer;
import qupath.lib.images.servers.downsamples.DownsampleCalculator;
import qupath.lib.images.servers.downsamples.DownsampleCalculators;
import qupath.lib.io.GsonTools;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.TaskRunner;
import qupath.lib.plugins.TaskRunnerUtils;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;
import qupath.lib.scripting.LoggingTools;
import qupath.lib.scripting.QP;

public class ImageJScriptRunner {
    private static final Logger logger = LoggerFactory.getLogger(ImageJScriptRunner.class);
    private static final String ENGINE_NAME_MACRO = "macro";
    private static final String ENGINE_NAME_GROOVY = "groovy";
    private final ImageJScriptParameters params;
    private transient ScriptEngineManager scriptEngineManager;
    private static final Writer writer = LoggingTools.createLogWriter((Logger)logger, (Level)Level.INFO);
    private static final Writer errorWriter = LoggingTools.createLogWriter((Logger)logger, (Level)Level.ERROR);
    private final Map<Thread, ScriptEngine> engineMap = new WeakHashMap<Thread, ScriptEngine>();

    public ImageJScriptRunner(ImageJScriptParameters params) {
        this.params = params;
    }

    public static ImageJScriptRunner fromParams(ImageJScriptParameters params) {
        if (params == null) {
            throw new IllegalArgumentException("Macro parameters cannot be null");
        }
        if (params.getText() == null) {
            throw new IllegalArgumentException("Macro text cannot be null");
        }
        return new ImageJScriptRunner(params);
    }

    public static ImageJScriptRunner fromJson(String json) {
        return ImageJScriptRunner.fromParams((ImageJScriptParameters)GsonTools.getInstance().fromJson(json, ImageJScriptParameters.class));
    }

    public static ImageJScriptRunner fromMap(Map<String, ?> paramMap) {
        return ImageJScriptRunner.fromJson(GsonTools.getInstance().toJson(paramMap));
    }

    public void run() {
        this.run((ImageData<BufferedImage>)QP.getCurrentImageData());
    }

    public void run(ImageData<BufferedImage> imageData) {
        if (imageData == null) {
            throw new IllegalArgumentException("No image data available");
        }
        this.run(imageData, this.getObjectsToProcess(imageData.getHierarchy()));
    }

    public void test() {
        this.test((ImageData<BufferedImage>)QP.getCurrentImageData());
    }

    public void test(ImageData<BufferedImage> imageData) {
        if (imageData == null) {
            throw new IllegalArgumentException("No image data available");
        }
        List<PathObject> toProcess = this.getObjectsToProcess(imageData.getHierarchy());
        if (toProcess.isEmpty()) {
            return;
        }
        PathObject selected = imageData.getHierarchy().getSelectionModel().getSelectedObject();
        if (!toProcess.contains(selected)) {
            selected = toProcess.getFirst();
        }
        this.run(imageData, selected, true);
    }

    private void run(ImageData<BufferedImage> imageData, Collection<? extends PathObject> pathObjects) {
        int nAfter;
        if (pathObjects.isEmpty()) {
            logger.warn("No objects found for script (requested {})", (Object)this.params.applyToObjects);
            return;
        }
        TaskRunner taskRunner = this.params.getTaskRunner();
        int[] idsBefore = WindowManager.getIDList();
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        AtomicInteger successCount = new AtomicInteger();
        AtomicInteger failCount = new AtomicInteger();
        for (PathObject pathObject : pathObjects) {
            tasks.add(() -> {
                if (this.run(imageData, parent, false)) {
                    successCount.incrementAndGet();
                } else {
                    failCount.incrementAndGet();
                }
            });
        }
        taskRunner.runTasks("ImageJ scripts", tasks);
        if (this.params.doAddToWorkflow() && successCount.get() > 0) {
            this.addScriptToWorkflow(imageData, pathObjects);
        }
        int[] idsAfter = WindowManager.getIDList();
        int n = idsBefore == null ? 0 : idsBefore.length;
        int n2 = nAfter = idsAfter == null ? 0 : idsAfter.length;
        if (n != nAfter) {
            int nClosed;
            logger.warn("Number of ImageJ images open before: {}, images open after: {}", (Object)n, (Object)nAfter);
            if (this.params.doCloseOpenImages() && (nClosed = ImageJScriptRunner.closeNewImages(idsBefore, idsAfter)) > 0) {
                logger.debug("Closed {} ImageJ images", (Object)nClosed);
            }
        }
        FXUtils.runOnApplicationThread(() -> imageData.getHierarchy().fireHierarchyChangedEvent((Object)this));
        this.engineMap.clear();
        if (failCount.get() > 0) {
            Dialogs.showErrorMessage((String)"ImageJ script runner", (String)(failCount.get() + "/" + tasks.size() + " tasks failed - see log for details"));
        }
    }

    private static int closeNewImages(int[] idsBefore, int[] idsAfter) {
        int count = 0;
        if (idsAfter == null) {
            return count;
        }
        for (int id : idsAfter) {
            ImagePlus impExtra;
            if (idsBefore != null && !Arrays.stream(idsBefore).noneMatch(i -> i == id) || (impExtra = WindowManager.getImage((int)id)) == null) continue;
            impExtra.changes = false;
            impExtra.close();
            ++count;
        }
        return count;
    }

    private List<PathObject> getObjectsToProcess(PathObjectHierarchy hierarchy) {
        return ImageJScriptRunner.getObjectsToProcess(hierarchy, this.params.getApplyToObjects());
    }

    public static List<PathObject> getObjectsToProcess(PathObjectHierarchy hierarchy, ApplyToObjects applyTo) {
        if (applyTo == null || hierarchy == null) {
            return Collections.emptyList();
        }
        return switch (applyTo.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> List.of(hierarchy.getRootObject());
            case 2 -> List.copyOf(hierarchy.getAnnotationObjects());
            case 3 -> List.copyOf(hierarchy.getDetectionObjects());
            case 5 -> List.copyOf(hierarchy.getCellObjects());
            case 4 -> List.copyOf(hierarchy.getTileObjects());
            case 6 -> {
                if (hierarchy.getTMAGrid() == null) {
                    yield List.of();
                }
                yield List.copyOf(hierarchy.getTMAGrid().getTMACoreList());
            }
            case 0 -> {
                ArrayList<PathObject> selected = new ArrayList<PathObject>(hierarchy.getSelectionModel().getSelectedObjects());
                PathObject mainSelected = hierarchy.getSelectionModel().getSelectedObject();
                if (mainSelected != null && (selected.isEmpty() || selected.getFirst() != mainSelected)) {
                    selected.remove(mainSelected);
                    selected.addFirst(mainSelected);
                }
                yield selected;
            }
        };
    }

    /*
     * Exception decompiling
     */
    private boolean run(ImageData<BufferedImage> imageData, PathObject pathObject, boolean isTest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 16[CATCHBLOCK], 15[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RegionRequest createRequest(ImageServer<?> server, PathObject parent) {
        ROI pathROI = parent.getROI();
        RegionRequest fullImage = RegionRequest.createInstance(server);
        RegionRequest region = pathROI == null ? fullImage : ImageRegion.createInstance((ROI)pathROI);
        double downsampleFactor = this.params.getDownsample().getDownsample(server, (ImageRegion)region);
        RegionRequest request = RegionRequest.createInstance((String)server.getPath(), (double)downsampleFactor, (ImageRegion)region);
        if (!region.equals((Object)fullImage) && this.params.getPadding() > 0) {
            int expand = (int)Math.round((double)this.params.getPadding() * downsampleFactor);
            request = request.pad2D(expand, expand);
        }
        return request.intersect2D((ImageRegion)fullImage);
    }

    private static ImagePlus extractImage(ImageServer<BufferedImage> server, RegionRequest request, boolean requestHyperstack) throws IOException {
        if (requestHyperstack) {
            return IJTools.extractHyperstack(server, (RegionRequest)request);
        }
        return (ImagePlus)IJTools.convertToImagePlus(server, (RegionRequest)request).getImage();
    }

    private static List<Roi> createRois(PathObject pathObject, RegionRequest request, int count) {
        Roi roi = IJTools.convertToIJRoi((ROI)pathObject.getROI(), (RegionRequest)request);
        Object defaultName = PathObjectTools.getSuitableName(pathObject.getClass(), (boolean)false);
        if (count > 0) {
            defaultName = (String)defaultName + " (" + count + ")";
        }
        roi.setName((String)defaultName);
        IJTools.calibrateRoi((Roi)roi, (PathObject)pathObject);
        if (pathObject instanceof PathCellObject) {
            PathCellObject cell = (PathCellObject)pathObject;
            ROI nucleusRoi = cell.getNucleusROI();
            String key = "qupath.object.type";
            roi.setProperty(key, "cell");
            if (nucleusRoi != null) {
                Roi roi2 = IJTools.convertToIJRoi((ROI)nucleusRoi, (RegionRequest)request);
                roi2.setName((String)defaultName);
                IJTools.calibrateRoi((Roi)roi2, (PathObject)pathObject);
                roi2.setName(roi2.getName() + "-nucleus");
                roi2.setProperty(key, "cell.nucleus");
                return List.of(roi, roi2);
            }
        }
        return Collections.singletonList(roi);
    }

    private ScriptEngine getScriptEngine() {
        if (this.params.scriptEngine == null || this.params.scriptEngine.equalsIgnoreCase(ENGINE_NAME_MACRO) || this.params.scriptEngine.equalsIgnoreCase("imagej")) {
            return null;
        }
        ScriptEngine engine = this.engineMap.computeIfAbsent(Thread.currentThread(), t -> this.getScriptEngineManager().getEngineByName(this.params.scriptEngine));
        if (engine != null) {
            SimpleScriptContext context = new SimpleScriptContext();
            context.setWriter(writer);
            context.setErrorWriter(errorWriter);
            engine.setContext(context);
        }
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptEngineManager getScriptEngineManager() {
        if (this.scriptEngineManager != null) {
            return this.scriptEngineManager;
        }
        ImageJScriptRunner imageJScriptRunner = this;
        synchronized (imageJScriptRunner) {
            if (this.scriptEngineManager == null) {
                this.scriptEngineManager = new ScriptEngineManager();
            }
            return this.scriptEngineManager;
        }
    }

    private void addScriptToWorkflow(ImageData<?> imageData, Collection<? extends PathObject> parents) {
        StringBuilder sb = new StringBuilder();
        if (!parents.isEmpty()) {
            if (parents.stream().allMatch(PathObject::isAnnotation)) {
                sb.append("// selectAnnotations()\n");
            } else if (parents.stream().allMatch(PathObject::isTile)) {
                sb.append("// selectTiles()\n");
            } else if (parents.stream().allMatch(PathObject::isTMACore)) {
                sb.append("// selectTMACores()\n");
            } else if (parents.stream().allMatch(PathObject::isCell)) {
                sb.append("// selectCells()\n");
            } else if (parents.stream().allMatch(PathObject::isDetection)) {
                sb.append("// selectDetections()\n");
            }
        }
        Gson gson = GsonTools.getInstance();
        String json = gson.toJson((Object)this.params);
        JsonObject obj = (JsonObject)gson.fromJson(json, JsonObject.class);
        Map map = (Map)gson.fromJson(json, Map.class);
        sb.append(ImageJScriptRunner.class.getName()).append(".fromMap(\n");
        String groovyMap = ImageJScriptRunner.toGroovy((JsonElement)obj);
        if (groovyMap.startsWith("[") && groovyMap.endsWith("]")) {
            groovyMap = groovyMap.substring(1, groovyMap.length() - 1).strip();
        }
        if (!groovyMap.isEmpty()) {
            sb.append("  ");
            sb.append(groovyMap);
            sb.append("\n");
        }
        sb.append(").run()");
        String workflowScript = sb.toString();
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("ImageJ script", map, workflowScript));
        logger.debug(sb.toString());
    }

    private static String toGroovy(JsonElement element) {
        StringBuilder sb = new StringBuilder();
        ImageJScriptRunner.appendValue(sb, element, 1);
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            WrappedBufferedImageServer server = new WrappedBufferedImageServer("Anything", new BufferedImage(128, 128, 1));
            ImageData imageData = new ImageData((ImageServer)server);
            imageData.setImageType(ImageData.ImageType.BRIGHTFIELD_H_E);
            new Builder().text("print(\"Hello?\");\nprint(\"Are you here?);\n").channels(ColorTransforms.createChannelExtractor((int)0), ColorTransforms.createChannelExtractor((String)"Green"), ColorTransforms.createColorDeconvolvedChannel((ColorDeconvolutionStains)imageData.getColorDeconvolutionStains(), (int)1)).build().addScriptToWorkflow(imageData, List.of());
            WorkflowStep workflowStep = imageData.getHistoryWorkflow().getLastStep();
            if (workflowStep instanceof DefaultScriptableWorkflowStep) {
                DefaultScriptableWorkflowStep step = (DefaultScriptableWorkflowStep)workflowStep;
                logger.info(step.getScript());
            }
        }
        catch (Exception e) {
            logger.error("Error running ImageJScriptRunner", (Throwable)e);
        }
    }

    private static String appendValue(StringBuilder sb, JsonElement val, int indent) {
        JsonElement jsonElement = val;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonPrimitive.class, JsonArray.class, JsonObject.class}, (Object)jsonElement, n)) {
            case 0: {
                JsonPrimitive primitive = (JsonPrimitive)jsonElement;
                if (primitive.isString()) {
                    String quote;
                    Object str = primitive.getAsString();
                    if (((String)str).contains(quote = "\"")) {
                        if (((String)str).contains("\"\"\"")) {
                            logger.warn("Triple-quotes found in script text - this will not be properly handled");
                        }
                        int sinceLastNewline = Math.max(1, sb.length() - 1 - Math.max(sb.lastIndexOf("\n"), 0));
                        quote = "\"\"\"";
                        if (((String)str).contains("\n")) {
                            if (!((String)str).startsWith("\n")) {
                                str = "\n" + (String)str;
                            }
                            if (!((String)str).endsWith("\n")) {
                                str = (String)str + "\n";
                            }
                            str = ((String)str).replace("\n", "\n" + " ".repeat(sinceLastNewline));
                        }
                    }
                    sb.append(quote).append((String)str).append(quote);
                    break;
                }
                sb.append(primitive.getAsString());
                break;
            }
            case 1: {
                JsonArray array = (JsonArray)jsonElement;
                sb.append("[");
                boolean isFirst = true;
                boolean isIndented = array.size() > 1 && indent > 0;
                for (int i = 0; i < array.size(); ++i) {
                    if (!isFirst) {
                        sb.append(", ");
                    }
                    if (isIndented) {
                        sb.append("\n");
                        sb.append(" ".repeat(indent * 2));
                    }
                    ImageJScriptRunner.appendValue(sb, array.get(i), indent + 1);
                    isFirst = false;
                }
                if (isIndented) {
                    sb.append("\n");
                    sb.append(" ".repeat(indent * 2));
                }
                sb.append("]");
                break;
            }
            case 2: {
                JsonObject obj = (JsonObject)jsonElement;
                sb.append("[");
                String newlineAndIndent = indent <= 0 || obj.size() <= 1 ? "" : System.lineSeparator() + " ".repeat(indent * 2);
                sb.append(newlineAndIndent);
                boolean isFirst = true;
                for (Map.Entry entry : obj.asMap().entrySet()) {
                    if (!isFirst) {
                        sb.append(", ");
                        sb.append(newlineAndIndent);
                    }
                    sb.append((String)entry.getKey()).append(": ");
                    ImageJScriptRunner.appendValue(sb, (JsonElement)entry.getValue(), indent + 1);
                    isFirst = false;
                }
                sb.append(newlineAndIndent);
                sb.append("]");
                break;
            }
            default: {
                sb.append("null");
            }
        }
        return sb.toString();
    }

    private ImageServer<BufferedImage> getServer(ImageData<BufferedImage> imageData) {
        ImageServer server = imageData.getServer();
        List<ColorTransforms.ColorTransform> channels = this.params.getChannels();
        if (channels.isEmpty()) {
            return server;
        }
        return new TransformedServerBuilder(server).applyColorTransforms((ColorTransforms.ColorTransform[])channels.toArray(ColorTransforms.ColorTransform[]::new)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PathObject createOrUpdateObject(Function<ROI, PathObject> creator, Roi roi, RegionRequest request, ROI clipROI, Map<UUID, PathObject> existingObjects) {
        PathObject existing;
        UUID id = IJProperties.getObjectId((Roi)roi);
        PathObject pathObject = existing = id == null ? null : (PathObject)existingObjects.getOrDefault(id, null);
        if (existing == null) {
            return ImageJScriptRunner.createNewObject(creator, roi, request, clipROI);
        }
        PathObject pathObject2 = existing;
        synchronized (pathObject2) {
            IJTools.calibrateObject((PathObject)existing, (Roi)roi);
            return null;
        }
    }

    private static PathObject createNewObject(Function<ROI, PathObject> creator, Roi roi, RegionRequest request, ROI clipROI) {
        ROI newROI = IJTools.convertToROI((Roi)roi, (RegionRequest)request);
        if (RoiTools.isShapeROI((ROI)clipROI) && RoiTools.isShapeROI((ROI)newROI)) {
            newROI = RoiTools.combineROIs((ROI)clipROI, (ROI)newROI, (RoiTools.CombineOp)RoiTools.CombineOp.INTERSECT);
        } else if (RoiTools.isShapeROI((ROI)clipROI) && newROI != null && newROI.isPoint()) {
            newROI = ROIs.createPointsROI(newROI.getAllPoints().stream().filter(p -> clipROI.contains(p.getX(), p.getY())).toList(), (ImagePlane)newROI.getImagePlane());
        }
        if (newROI == null || newROI.isEmpty()) {
            return null;
        }
        PathObject pathObjectNew = creator.apply(newROI);
        if (pathObjectNew != null) {
            IJTools.calibrateObject((PathObject)pathObjectNew, (Roi)roi);
            pathObjectNew.setLocked(true);
            return pathObjectNew;
        }
        return null;
    }

    public static PathObject createDetectionOrPointAnnotation(ROI roi) {
        if (roi.isPoint()) {
            return PathObjects.createAnnotationObject((ROI)roi);
        }
        return PathObjects.createDetectionObject((ROI)roi);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ImageJScriptParameters params) {
        return new Builder(params);
    }

    private static /* synthetic */ PathObject lambda$run$3(Function overlayRoiToObject, RegionRequest request, ROI maskROI, Map sentObjects, Roi r) {
        return ImageJScriptRunner.createOrUpdateObject(overlayRoiToObject, r, request, maskROI, sentObjects);
    }

    public static class ImageJScriptParameters {
        private String text;
        private List<ColorTransforms.ColorTransform> channels;
        private DownsampleCalculator downsample = DownsampleCalculators.maxDimension((int)1024);
        private int padding = 0;
        private boolean setRoi = true;
        private boolean setOverlay = false;
        private boolean closeOpenImages = false;
        private boolean clearChildObjects = false;
        private PathObjectType activeRoiObjectType = null;
        private PathObjectType overlayRoiObjectType = null;
        private ApplyToObjects applyToObjects = ApplyToObjects.SELECTED;
        private String scriptEngine;
        private boolean addToWorkflow = false;
        private int nThreads = -1;
        private transient TaskRunner taskRunner;

        private ImageJScriptParameters() {
        }

        private ImageJScriptParameters(ImageJScriptParameters params) {
            this.channels = params.channels == null || params.channels.isEmpty() ? null : List.copyOf(params.channels);
            this.text = params.text;
            this.downsample = params.downsample;
            this.padding = params.padding;
            this.setRoi = params.setRoi;
            this.setOverlay = params.setOverlay;
            this.closeOpenImages = params.closeOpenImages;
            this.clearChildObjects = params.clearChildObjects;
            this.activeRoiObjectType = params.activeRoiObjectType;
            this.overlayRoiObjectType = params.overlayRoiObjectType;
            this.applyToObjects = params.applyToObjects;
            this.scriptEngine = params.scriptEngine;
            this.addToWorkflow = params.addToWorkflow;
            this.nThreads = params.nThreads;
        }

        public List<ColorTransforms.ColorTransform> getChannels() {
            return this.channels == null ? Collections.emptyList() : this.channels;
        }

        public String getText() {
            return this.text;
        }

        public DownsampleCalculator getDownsample() {
            return this.downsample;
        }

        public int getPadding() {
            return this.padding;
        }

        public boolean doSetRoi() {
            return this.setRoi;
        }

        public boolean doSetOverlay() {
            return this.setOverlay;
        }

        public boolean doRemoveChildObjects() {
            return this.clearChildObjects;
        }

        public boolean doAddToWorkflow() {
            return this.addToWorkflow;
        }

        public boolean doCloseOpenImages() {
            return this.closeOpenImages;
        }

        public String getScriptEngineName() {
            return this.scriptEngine;
        }

        public ApplyToObjects getApplyToObjects() {
            return this.applyToObjects;
        }

        public TaskRunner getTaskRunner() {
            if (this.taskRunner == null) {
                return TaskRunnerUtils.getDefaultInstance().createTaskRunner(this.nThreads);
            }
            return this.taskRunner;
        }

        public Function<ROI, PathObject> getActiveRoiToObjectFunction() {
            return this.getObjectFunction(this.activeRoiObjectType);
        }

        public Function<ROI, PathObject> getOverlayRoiToObjectFunction() {
            return this.getObjectFunction(this.overlayRoiObjectType);
        }

        private Function<ROI, PathObject> getObjectFunction(PathObjectType type) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> PathObjects::createAnnotationObject;
                case 2 -> PathObjects::createDetectionObject;
                case 3 -> PathObjects::createTileObject;
                case 4 -> r -> PathObjects.createCellObject((ROI)r, null);
                case 0 -> null;
                case 5 -> throw new IllegalArgumentException("TMA core is not a valid object type!");
            };
        }
    }

    public static enum ApplyToObjects {
        SELECTED,
        IMAGE,
        ANNOTATIONS,
        DETECTIONS,
        TILES,
        CELLS,
        TMA_CORES;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> "Whole image";
                case 0 -> "Selected objects";
                case 2 -> "All annotations";
                case 3 -> "All detections";
                case 4 -> "All tiles";
                case 5 -> "All cells";
                case 6 -> "All TMA cores";
            };
        }
    }

    public static enum PathObjectType {
        NONE,
        ANNOTATION,
        DETECTION,
        TILE,
        CELL,
        TMA_CORE;

    }

    public static class Builder {
        private static final Map<String, String> scriptEngineNameCache = new HashMap<String, String>();
        private ImageJScriptParameters params = new ImageJScriptParameters();

        private Builder() {
        }

        private Builder(ImageJScriptParameters params) {
            this.params = new ImageJScriptParameters(params);
        }

        public Builder macroText(String macroText) {
            this.text(macroText);
            return this.scriptEngine(ImageJScriptRunner.ENGINE_NAME_MACRO);
        }

        public Builder groovyText(String groovy) {
            this.text(groovy);
            return this.scriptEngine(ImageJScriptRunner.ENGINE_NAME_GROOVY);
        }

        public Builder text(String script) {
            this.params.text = script;
            return this;
        }

        public Builder file(String path) throws IOException {
            return this.scriptFile(Paths.get(path, new String[0]));
        }

        public Builder scriptFile(File file) throws IOException {
            return this.scriptFile(file.toPath());
        }

        public Builder scriptFile(Path path) throws IOException {
            String text = Files.readString(path, StandardCharsets.UTF_8);
            this.updateScriptEngineFromFilename(path.getFileName().toString());
            return this.text(text);
        }

        private void updateScriptEngineFromFilename(String name) {
            String engineName;
            if (this.params.scriptEngine != null) {
                return;
            }
            String ext = GeneralTools.getExtension((String)name).orElse(null);
            if (ext != null && (engineName = scriptEngineNameCache.computeIfAbsent(ext.toLowerCase(), this::scriptEngineForExtension)) != null) {
                this.params.scriptEngine = engineName;
            }
        }

        private String scriptEngineForExtension(String ext) {
            ScriptEngine engine = new ScriptEngineManager().getEngineByExtension(ext);
            if (engine != null) {
                return engine.getFactory().getEngineName();
            }
            return null;
        }

        public Builder scriptEngine(String scriptEngine) {
            this.params.scriptEngine = scriptEngine;
            return this;
        }

        public Builder setImageJRoi() {
            return this.setImageJRoi(true);
        }

        public Builder setImageJRoi(boolean doSet) {
            this.params.setRoi = doSet;
            return this;
        }

        public Builder setImageJOverlay() {
            return this.setImageJOverlay(true);
        }

        public Builder setImageJOverlay(boolean doSet) {
            this.params.setOverlay = doSet;
            return this;
        }

        public Builder closeOpenImages(boolean doClose) {
            this.params.closeOpenImages = doClose;
            return this;
        }

        public Builder roiToDetection() {
            return this.roiToObject(PathObjectType.DETECTION);
        }

        public Builder roiToAnnotation() {
            return this.roiToObject(PathObjectType.ANNOTATION);
        }

        public Builder roiToTile() {
            return this.roiToObject(PathObjectType.TILE);
        }

        public Builder roiToObject(PathObjectType type) {
            this.params.activeRoiObjectType = type;
            return this;
        }

        public Builder overlayToAnnotations() {
            return this.overlayToObjects(PathObjectType.TILE);
        }

        public Builder overlayToDetections() {
            return this.overlayToObjects(PathObjectType.DETECTION);
        }

        public Builder overlayToTiles() {
            return this.overlayToObjects(PathObjectType.TILE);
        }

        public Builder overlayToObjects(PathObjectType type) {
            this.params.overlayRoiObjectType = type;
            return this;
        }

        public Builder clearChildObjects() {
            return this.clearChildObjects(true);
        }

        public Builder clearChildObjects(boolean doClear) {
            this.params.clearChildObjects = doClear;
            return this;
        }

        public Builder addToWorkflow() {
            return this.addToWorkflow(true);
        }

        public Builder addToWorkflow(boolean doAdd) {
            this.params.addToWorkflow = doAdd;
            return this;
        }

        public Builder applyToObjects(ApplyToObjects objectType) {
            this.params.applyToObjects = objectType;
            return this;
        }

        public Builder fixedDownsample(double downsample) {
            return this.downsample(DownsampleCalculators.fixedDownsample((double)downsample));
        }

        public Builder maxDimension(int maxDim) {
            return this.downsample(DownsampleCalculators.maxDimension((int)maxDim));
        }

        public Builder pixelSizeMicrons(double pixelSizeMicrons) {
            return this.downsample(DownsampleCalculators.pixelSizeMicrons((double)pixelSizeMicrons));
        }

        public Builder pixelSize(PixelCalibration targetCalibration) {
            return this.downsample(DownsampleCalculators.pixelSize((PixelCalibration)targetCalibration));
        }

        public Builder downsample(DownsampleCalculator downsample) {
            this.params.downsample = downsample;
            return this;
        }

        public Builder padding(int padding) {
            this.params.padding = padding;
            return this;
        }

        public Builder nThreads(int nThreads) {
            this.params.nThreads = nThreads;
            return this;
        }

        public Builder taskRunner(TaskRunner taskRunner) {
            this.params.taskRunner = taskRunner;
            return this;
        }

        public Builder channelIndices(int ... inds) {
            return this.channels(IntStream.of(inds).mapToObj(ColorTransforms::createChannelExtractor).toList());
        }

        public Builder channelNames(String ... names) {
            return this.channels(Arrays.stream(names).map(ColorTransforms::createChannelExtractor).toList());
        }

        public Builder channels(ColorTransforms.ColorTransform channel, ColorTransforms.ColorTransform ... channels) {
            ArrayList<ColorTransforms.ColorTransform> list = new ArrayList<ColorTransforms.ColorTransform>();
            list.add(channel);
            Collections.addAll(list, channels);
            return this.channels(list);
        }

        public Builder channels(Collection<? extends ColorTransforms.ColorTransform> channels) {
            this.params.channels = channels == null ? null : List.copyOf(channels);
            return this;
        }

        public ImageJScriptRunner build() {
            return ImageJScriptRunner.fromParams(this.params);
        }

        static {
            scriptEngineNameCache.put(null, ImageJScriptRunner.ENGINE_NAME_MACRO);
            scriptEngineNameCache.put(".ijm", ImageJScriptRunner.ENGINE_NAME_MACRO);
            scriptEngineNameCache.put(".txt", ImageJScriptRunner.ENGINE_NAME_MACRO);
            scriptEngineNameCache.put(".groovy", ImageJScriptRunner.ENGINE_NAME_GROOVY);
        }
    }
}

