/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.gui;

import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import qupath.imagej.gui.IJExtension;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ServerTools;

class ScreenshotCommand
implements Runnable {
    private QuPathGUI qupath;

    public ScreenshotCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        double pixelHeight;
        QuPathViewer viewer = this.qupath.getViewer();
        if (viewer == null) {
            return;
        }
        BufferedImage img = GuiTools.makeSnapshot((QuPathGUI)this.qupath, (GuiTools.SnapshotType)GuiTools.SnapshotType.VIEWER);
        ImageJ ij = IJExtension.getImageJInstance();
        if (ij != null) {
            ij.setVisible(true);
        }
        String name = "QuPath screenshot";
        if (viewer.getServer() != null) {
            name = WindowManager.getUniqueName((String)("Screenshot - " + ServerTools.getDisplayableImageName((ImageServer)viewer.getServer())));
        }
        img = BufferedImageTools.ensureBufferedImageType((BufferedImage)img, (int)1);
        ImagePlus imp = new ImagePlus(name, (Image)img);
        double pixelWidth = this.getDisplayedPixelWidthMicrons(viewer);
        if (!Double.isNaN(pixelWidth + (pixelHeight = this.getDisplayedPixelHeightMicrons(viewer)))) {
            Calibration cal = imp.getCalibration();
            cal.pixelWidth = pixelWidth;
            cal.pixelHeight = pixelHeight;
            cal.setUnit("um");
        }
        Interpreter.batchMode = false;
        SwingUtilities.invokeLater(() -> imp.show());
    }

    private double getDisplayedPixelWidthMicrons(QuPathViewer viewer) {
        ImageServer server = viewer.getServer();
        if (server == null) {
            return Double.NaN;
        }
        return server.getPixelCalibration().getPixelWidthMicrons() * viewer.getDownsampleFactor();
    }

    private double getDisplayedPixelHeightMicrons(QuPathViewer viewer) {
        ImageServer server = viewer.getServer();
        if (server == null) {
            return Double.NaN;
        }
        return server.getPixelCalibration().getPixelHeightMicrons() * viewer.getDownsampleFactor();
    }
}

