/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.gui;

import ij.gui.Roi;
import java.io.File;
import java.util.List;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.imagej.tools.IJTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;

class ImportRoisCommand
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(ImportRoisCommand.class);
    private QuPathGUI qupath;

    public ImportRoisCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    public String getName() {
        return "Import ImageJ ROIs";
    }

    @Override
    public void run() {
        ImageData imageData;
        QuPathViewer viewer = this.qupath.getViewer();
        ImageData imageData2 = imageData = viewer == null ? null : viewer.getImageData();
        if (imageData == null) {
            GuiTools.showNoImageError((String)this.getName());
            return;
        }
        List files = FileChoosers.promptForMultipleFiles((String)"ImageJ ROIs", (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"ImageJ ROI files", (String[])new String[]{"*.roi", "*.zip"})});
        if (files == null) {
            logger.info("No ImageJ ROI files selected for import");
            return;
        }
        List rois = files.stream().filter(f -> IJTools.containsImageJRois((File)f)).flatMap(f -> IJTools.readImageJRois((File)f).stream()).toList();
        if (rois.isEmpty()) {
            Dialogs.showInfoNotification((String)this.getName(), (String)"No ROIs found in selected files");
            return;
        }
        double downsample = 1.0;
        double xOrigin = 0.0;
        double yOrigin = 0.0;
        List<PathObject> pathObjects = rois.stream().map(r -> IJTools.convertToAnnotation((Roi)r, (double)xOrigin, (double)yOrigin, (double)downsample, null)).toList();
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        hierarchy.addObjects(pathObjects);
        hierarchy.getSelectionModel().selectObjects(pathObjects);
    }
}

