/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.gui;

import ij.CommandListener;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.plugin.frame.Editor;
import java.awt.Frame;
import java.util.Set;
import javafx.application.Platform;
import qupath.lib.gui.prefs.SystemMenuBar;

class ImageJQuitCommandListener
implements CommandListener {
    private final boolean blockQuit;

    ImageJQuitCommandListener(boolean blockQuit) {
        this.blockQuit = blockQuit;
    }

    public String commandExecuting(String command) {
        if ("quit".equalsIgnoreCase(command)) {
            if (this.hasUnsavedChanges() && !IJ.showMessageWithCancel((String)"Close ImageJ", (String)"Close all ImageJ windows without saving changes?")) {
                return null;
            }
            this.closeWindowsQuietly();
            if (this.blockQuit) {
                return null;
            }
        }
        return command;
    }

    private boolean hasUnsavedChanges() {
        for (Frame frame : Frame.getFrames()) {
            Editor editor;
            ImageWindow win;
            ImagePlus imp;
            if (!frame.isShowing() || !(frame instanceof ImageWindow ? (imp = (win = (ImageWindow)frame).getImagePlus()) != null && imp.changes : frame instanceof Editor && (editor = (Editor)frame).fileChanged())) continue;
            return true;
        }
        return false;
    }

    private void closeWindowsQuietly() {
        ImageJ ij = IJ.getInstance();
        if (ij == null) {
            return;
        }
        ij.requestFocus();
        Set<Frame> nonImageFrames = Set.of(WindowManager.getNonImageWindows());
        for (Frame frame : Frame.getFrames()) {
            if (frame instanceof ImageWindow) {
                ImageWindow win = (ImageWindow)frame;
                ImagePlus imp = win.getImagePlus();
                if (imp == null) continue;
                imp.setIJMenuBar(false);
                imp.changes = false;
                imp.close();
                continue;
            }
            if (!nonImageFrames.contains(frame)) continue;
            frame.setVisible(false);
            frame.dispose();
            WindowManager.removeWindow((Frame)frame);
        }
        ij.setMenuBar(null);
        ij.setVisible(false);
        Platform.runLater(() -> SystemMenuBar.setOverrideSystemMenuBar((boolean)false));
    }
}

