/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.imagej.gui.IJExtension;
import qupath.imagej.tools.IJTools;
import qupath.lib.display.ImageDisplay;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.dialogs.ParameterPanelFX;
import qupath.lib.gui.images.servers.ChannelDisplayTransformServer;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.PathImage;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.AbstractPlugin;
import qupath.lib.plugins.TaskRunner;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.LineROI;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;
import qupathj.QuPath_Send_Overlay_to_QuPath;

@Deprecated
public class ImageJMacroRunner
extends AbstractPlugin<BufferedImage> {
    private static Logger logger = LoggerFactory.getLogger(ImageJMacroRunner.class);
    private QuPathGUI qupath;
    private ParameterList params;
    private String macroText = null;
    private transient Stage dialog;

    public ImageJMacroRunner(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    public String getName() {
        return "ImageJ macro runner";
    }

    public String getDescription() {
        return "Apply ImageJ macros to selected regions of interest";
    }

    public boolean runPlugin(TaskRunner runner, ImageData<BufferedImage> imageData, String arg) {
        if (!this.parseArgument(imageData, arg)) {
            return false;
        }
        if (this.dialog == null) {
            this.dialog = new Stage();
            this.dialog.initOwner((Window)this.qupath.getStage());
            this.dialog.setTitle("ImageJ macro runner");
            FXUtils.addCloseWindowShortcuts((Stage)this.dialog);
            BorderPane pane = new BorderPane();
            if (arg != null) {
                this.macroText = arg;
            }
            TextArea textArea = new TextArea();
            textArea.setPrefRowCount(12);
            textArea.setPrefSize(400.0, 400.0);
            textArea.setWrapText(true);
            textArea.setFont(Font.font((String)"Courier"));
            if (this.macroText != null) {
                textArea.setText(this.macroText);
            }
            BorderPane panelMacro = new BorderPane();
            panelMacro.setCenter((Node)textArea);
            ParameterPanelFX parameterPanel = new ParameterPanelFX(this.getParameterList(imageData));
            panelMacro.setBottom((Node)parameterPanel.getPane());
            Button btnRun = new Button("Run");
            btnRun.setOnAction(e -> {
                PathObject pathObject;
                this.macroText = textArea.getText().trim();
                if (this.macroText.isEmpty()) {
                    return;
                }
                QuPathViewer viewer = this.qupath.getViewer();
                ImageData imageDataLocal = viewer.getImageData();
                PathObjectHierarchy hierarchy = imageDataLocal.getHierarchy();
                PathObject pathObject2 = pathObject = hierarchy.getSelectionModel().singleSelection() ? hierarchy.getSelectionModel().getSelectedObject() : null;
                if (pathObject instanceof PathAnnotationObject || pathObject instanceof TMACoreObject) {
                    SwingUtilities.invokeLater(() -> ImageJMacroRunner.runMacro(this.params, (ImageData<BufferedImage>)imageDataLocal, viewer.getImageDisplay(), pathObject, this.macroText));
                } else {
                    Collection<? extends PathObject> parents = this.getParentObjects((ImageData<BufferedImage>)imageDataLocal);
                    if (parents.isEmpty()) {
                        Dialogs.showErrorNotification((String)"ImageJ macro runner", (String)"No annotation or TMA core objects selected!");
                        return;
                    }
                    ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                    for (PathObject pathObject3 : parents) {
                        this.addRunnableTasks((ImageData<BufferedImage>)imageDataLocal, pathObject3, tasks);
                    }
                    this.qupath.getThreadPoolManager().submitShortTask(() -> {
                        runner.runTasks((Collection)tasks);
                        imageDataLocal.getHierarchy().fireHierarchyChangedEvent((Object)this);
                    });
                }
            });
            Button btnClose = new Button("Close");
            btnClose.setOnAction(e -> this.dialog.hide());
            GridPane panelButtons = GridPaneUtils.createRowGridControls((Node[])new Node[]{btnRun, btnClose});
            pane.setCenter((Node)panelMacro);
            pane.setBottom((Node)panelButtons);
            panelButtons.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
            pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.dialog.setScene(new Scene((Parent)pane));
        }
        this.dialog.show();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runMacro(ParameterList params, ImageData<BufferedImage> imageData, ImageDisplay imageDisplay, PathObject pathObject, String macroText) {
        PathImage<ImagePlus> pathImage;
        if (Thread.currentThread().isInterrupted()) {
            logger.warn("Skipping macro for {} - thread interrupted", (Object)pathObject);
            return;
        }
        double downsampleFactor = params.getDoubleParameterValue("downsampleFactor");
        boolean sendROI = params.getBooleanParameterValue("sendROI");
        boolean sendOverlay = params.getBooleanParameterValue("sendOverlay");
        ROI pathROI = pathObject.getROI();
        ImageDisplay imageDisplay2 = params.containsKey((Object)"useTransform") && Boolean.TRUE.equals(params.getBooleanParameterValue("useTransform")) ? imageDisplay : null;
        ImageServer server = imageDisplay2 == null || imageDisplay2.availableChannels().isEmpty() ? imageData.getServer() : ChannelDisplayTransformServer.createColorTransformServer((ImageServer)imageData.getServer(), (List)imageDisplay.availableChannels());
        RegionRequest region = RegionRequest.createInstance((String)imageData.getServer().getPath(), (double)downsampleFactor, (ROI)pathROI);
        try {
            IJTools.isMemorySufficient((RegionRequest)region, imageData);
        }
        catch (Exception e1) {
            Dialogs.showErrorMessage((String)"ImageJ macro error", (String)e1.getMessage());
            return;
        }
        try {
            pathImage = sendOverlay ? IJExtension.extractROIWithOverlay((ImageServer<BufferedImage>)server, pathObject, imageData.getHierarchy(), region, sendROI, null) : IJExtension.extractROI((ImageServer<BufferedImage>)server, pathObject, region, sendROI);
        }
        catch (IOException e) {
            logger.error("Unable to extract image region {}", (Object)region, (Object)e);
            return;
        }
        String argument = pathObject instanceof TMACoreObject || !pathObject.hasROI() ? pathObject.getDisplayedName() : String.format("Region (%d, %d, %d, %d)", region.getX(), region.getY(), region.getWidth(), region.getHeight());
        ImagePlus imp = (ImagePlus)pathImage.getImage();
        imp.setProperty("QuPath region", (Object)argument);
        WindowManager.setTempCurrentImage((ImagePlus)imp);
        IJExtension.getImageJInstance();
        try {
            Overlay overlay;
            List<PathObject> childObjects;
            boolean cancelled = false;
            ImagePlus impResult = null;
            try {
                IJ.redirectErrorMessages();
                Interpreter interpreter = new Interpreter();
                impResult = interpreter.runBatchMacro(macroText, imp);
                if (interpreter.wasError()) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (impResult == null) {
                    impResult = WindowManager.getCurrentImage();
                }
            }
            catch (RuntimeException e) {
                logger.error(e.getLocalizedMessage());
                Thread.currentThread().interrupt();
                cancelled = true;
            }
            finally {
                WindowManager.setTempCurrentImage(null);
            }
            if (cancelled) {
                return;
            }
            if (impResult == null) {
                impResult = imp;
            }
            boolean changes = false;
            if (params.getBooleanParameterValue("clearObjects").booleanValue() && pathObject.hasChildObjects()) {
                pathObject.clearChildObjects();
                changes = true;
            }
            if (params.getBooleanParameterValue("getROI").booleanValue() && impResult.getRoi() != null) {
                PathObject pathObjectNew;
                Roi roi = impResult.getRoi();
                Calibration cal = impResult.getCalibration();
                PathObject pathObject2 = pathObjectNew = roi == null ? null : IJTools.convertToAnnotation((Roi)roi, (double)cal.xOrigin, (double)cal.yOrigin, (double)downsampleFactor, (ImagePlane)region.getImagePlane());
                if (pathObjectNew != null) {
                    if (pathROI != null && !(pathROI instanceof RectangleROI) && pathObjectNew.isAnnotation() && RoiTools.isShapeROI((ROI)pathROI) && RoiTools.isShapeROI((ROI)pathObjectNew.getROI())) {
                        ROI roiNew = RoiTools.combineROIs((ROI)pathROI, (ROI)pathObjectNew.getROI(), (RoiTools.CombineOp)RoiTools.CombineOp.INTERSECT);
                        ((PathAnnotationObject)pathObjectNew).setROI(roiNew);
                    }
                    if (pathObjectNew.getROI() instanceof LineROI || !pathObjectNew.getROI().isEmpty()) {
                        pathObject.addChildObject(pathObjectNew);
                        changes = true;
                    }
                }
            }
            boolean exportAsDetection = Objects.equals(params.getChoiceParameterValue("getOverlayAs"), "Detections");
            if (params.getBooleanParameterValue("getOverlay").booleanValue() && impResult.getOverlay() != null && !(childObjects = QuPath_Send_Overlay_to_QuPath.createObjectsFromROIs(imp, Arrays.asList((overlay = impResult.getOverlay()).toArray()), downsampleFactor, exportAsDetection, true, region.getImagePlane())).isEmpty()) {
                pathObject.addChildObjects(childObjects);
                changes = true;
            }
            if (changes) {
                Platform.runLater(() -> imageData.getHierarchy().fireHierarchyChangedEvent(null));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean parseArgument(ImageData<BufferedImage> imageData, String arg) {
        if (imageData == null) {
            return false;
        }
        if (arg != null && arg.length() > 0) {
            this.macroText = arg;
        }
        return true;
    }

    public String getLastResultsDescription() {
        return null;
    }

    ParameterList getParameterList(ImageData<BufferedImage> imageData) {
        if (this.params == null) {
            this.params = new ParameterList().addTitleParameter("Setup").addDoubleParameter("downsampleFactor", "Downsample factor", 1.0).addBooleanParameter("sendROI", "Send ROI to ImageJ", true).addBooleanParameter("sendOverlay", "Send overlay to ImageJ", true).addBooleanParameter("doParallel", "Do parallel processing (experimental)", false).addTitleParameter("Results").addBooleanParameter("clearObjects", "Clear current child objects", false).addBooleanParameter("getROI", "Create annotation from ImageJ ROI", false).addBooleanParameter("getOverlay", "Get objects from ImageJ overlay", false).addChoiceParameter("getOverlayAs", "Get objects as", (Object)"Detections", Arrays.asList("Detections", "Annotations"), "Return ROIs from the ImageJ overlay as QuPath detections or annotations");
        }
        return this.params;
    }

    protected Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        ArrayList<Class<? extends PathObject>> list = new ArrayList<Class<? extends PathObject>>();
        list.add(TMACoreObject.class);
        list.add(PathAnnotationObject.class);
        return list;
    }

    protected void addRunnableTasks(final ImageData<BufferedImage> imageData, final PathObject parentObject, List<Runnable> tasks) {
        final ParameterList params = this.getParameterList(imageData);
        final boolean doParallel = Boolean.TRUE.equals(params.getBooleanParameterValue("doParallel"));
        tasks.add(new Runnable(){

            @Override
            public void run() {
                if (Thread.currentThread().isInterrupted()) {
                    logger.warn("Execution interrupted - skipping {}", (Object)parentObject);
                    return;
                }
                if (SwingUtilities.isEventDispatchThread() || doParallel) {
                    ImageJMacroRunner.runMacro(params, (ImageData<BufferedImage>)imageData, null, parentObject, ImageJMacroRunner.this.macroText);
                } else {
                    try {
                        SwingUtilities.invokeAndWait(() -> ImageJMacroRunner.runMacro(params, (ImageData<BufferedImage>)imageData, null, parentObject, ImageJMacroRunner.this.macroText));
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
    }

    protected Collection<? extends PathObject> getParentObjects(ImageData<BufferedImage> imageData) {
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        List<PathObject> pathObjects = hierarchy.getSelectionModel().getSelectedObjects().stream().filter(p -> p.isAnnotation() || p.isTMACore()).toList();
        if (pathObjects.isEmpty() && GuiTools.promptForParentObjects((String)this.getName(), imageData, (boolean)false, this.getSupportedParentObjectClasses())) {
            pathObjects = new ArrayList<PathObject>(hierarchy.getSelectionModel().getSelectedObjects());
        }
        return pathObjects;
    }
}

