/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.gui;

import ij.CommandListener;
import ij.Executer;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.gui.Overlay;
import ij.gui.Roi;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.prefs.controlsfx.PropertyItemBuilder;
import qupath.imagej.detect.cells.PositiveCellDetection;
import qupath.imagej.detect.cells.SubcellularDetection;
import qupath.imagej.detect.cells.WatershedCellDetection;
import qupath.imagej.detect.cells.WatershedCellMembraneDetection;
import qupath.imagej.detect.dearray.TMADearrayerPluginIJ;
import qupath.imagej.detect.tissue.PositivePixelCounterIJ;
import qupath.imagej.detect.tissue.SimpleTissueDetection2;
import qupath.imagej.gui.AwtMenuBarBlocker;
import qupath.imagej.gui.ExtractRegionCommand;
import qupath.imagej.gui.ImageJMacroRunner;
import qupath.imagej.gui.ImageJQuitCommandListener;
import qupath.imagej.gui.ImportRoisCommand;
import qupath.imagej.gui.ScreenshotCommand;
import qupath.imagej.gui.scripts.ImageJScriptRunnerController;
import qupath.imagej.superpixels.DoGSuperpixelsPlugin;
import qupath.imagej.superpixels.SLICSuperpixelsPlugin;
import qupath.imagej.tools.IJTools;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.Version;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionIcon;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.extensions.QuPathExtension;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.prefs.SystemMenuBar;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.tools.MenuTools;
import qupath.lib.gui.viewer.DragDropImportListener;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.PathImage;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.PathPlugin;
import qupath.lib.plugins.objects.TileClassificationsToAnnotationsPlugin;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.interfaces.ROI;
import qupathj.QuPath_Send_Overlay_to_QuPath;
import qupathj.QuPath_Send_ROI_to_QuPath;

public class IJExtension
implements QuPathExtension {
    private static final Logger logger = LoggerFactory.getLogger(IJExtension.class);
    private static StringProperty imageJPath = null;
    private static final ImageJQuitCommandListener quitCommandListener = new ImageJQuitCommandListener(IJ.getInstance() != null);
    private static final BooleanProperty alwaysOnTop = new SimpleBooleanProperty(false);
    private static final boolean blockAwtMenuBars = "true".equals(System.getProperty("qupath.block.awt.menubars", GeneralTools.isMac() ? "true" : "false"));
    private static final AwtMenuBarBlocker menuBarBlocker = new AwtMenuBarBlocker();
    private static final Set<ImageJ> installedPlugins;
    private boolean extensionInstalled = false;

    public static void setImageJPath(String path) {
        imageJPath.set((Object)path);
    }

    public static String getImageJPath() {
        return (String)imageJPath.get();
    }

    public static StringProperty imageJPathProperty() {
        return imageJPath;
    }

    public static synchronized ImageJ getImageJInstance() {
        if (SwingUtilities.isEventDispatchThread()) {
            return IJExtension.getImageJInstanceOnEDT();
        }
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            IJExtension.ensurePluginsInstalled(ij);
            IJExtension.ensureImageJInitialized(ij);
            return ij;
        }
        return IJExtension.getImageJInstanceOnEDT();
    }

    private static synchronized void ensurePluginsInstalled(ImageJ imageJ) {
        if (installedPlugins.contains(imageJ)) {
            return;
        }
        if (!Platform.isFxApplicationThread() && !SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> IJExtension.ensurePluginsInstalled(imageJ));
            return;
        }
        logger.info("Installing QuPath plugins for ImageJ");
        Menus.installPlugin((String)QuPath_Send_ROI_to_QuPath.class.getName(), (char)'p', (String)"Send ROI to QuPath", (String)"", (ImageJ)imageJ);
        Menus.installPlugin((String)QuPath_Send_Overlay_to_QuPath.class.getName(), (char)'p', (String)"Send Overlay to QuPath", (String)"", (ImageJ)imageJ);
        Menus.installPlugin((String)(QuPath_Send_Overlay_to_QuPath.class.getName() + "(\"manager\")"), (char)'p', (String)"Send RoiManager ROIs to QuPath", (String)"", (ImageJ)imageJ);
        installedPlugins.add(imageJ);
    }

    private static synchronized ImageJ getImageJInstanceOnEDT() {
        ImageJ ijTemp = IJ.getInstance();
        Prefs.setThreads((int)1);
        if (ijTemp == null) {
            logger.info("Creating a new standalone ImageJ instance...");
            try {
                String ijPath = IJExtension.getImageJPath();
                if (ijPath != null) {
                    System.getProperties().setProperty("plugins.dir", ijPath);
                }
                ijTemp = new ImageJ(0);
            }
            catch (Exception e) {
                logger.warn(e.getLocalizedMessage());
                ijTemp = IJ.getInstance();
            }
            if (ijTemp == null) {
                logger.error("Unable to start ImageJ");
                return null;
            }
            ImageJ ij = ijTemp;
            IJExtension.ensureImageJInitialized(ij);
            logger.debug("Created ImageJ instance: {}", (Object)ijTemp);
        }
        IJExtension.ensurePluginsInstalled(ijTemp);
        return ijTemp;
    }

    private static void ensureImageJInitialized(ImageJ ij) {
        ij.exitWhenQuitting(false);
        Executer.removeCommandListener((CommandListener)quitCommandListener);
        Executer.addCommandListener((CommandListener)quitCommandListener);
        ij.setAlwaysOnTop(alwaysOnTop.get());
        if (blockAwtMenuBars) {
            menuBarBlocker.startBlocking();
        }
        if (ij.isShowing()) {
            Platform.runLater(() -> SystemMenuBar.setOverrideSystemMenuBar((boolean)true));
        }
        ij.resize();
    }

    public static PathImage<ImagePlus> extractROI(ImageServer<BufferedImage> server, ROI pathROI, RegionRequest request, boolean setROI) throws IOException {
        boolean bl = setROI = setROI && pathROI != null;
        if (!request.intersects(0.0, 0.0, (double)server.getWidth(), (double)server.getHeight())) {
            return null;
        }
        PathImage pathImage = IJTools.convertToImagePlus(server, (RegionRequest)request);
        if (pathImage == null || pathImage.getImage() == null) {
            return null;
        }
        if (setROI) {
            ImagePlus imp = (ImagePlus)pathImage.getImage();
            Roi roi = IJTools.convertToIJRoi((ROI)pathROI, (PathImage)pathImage);
            imp.setRoi(roi);
        }
        return pathImage;
    }

    public static PathImage<ImagePlus> extractROI(ImageServer<BufferedImage> server, PathObject pathObject, RegionRequest request, boolean setROI) throws IOException {
        PathImage<ImagePlus> pathImage = IJExtension.extractROI(server, pathObject.getROI(), request, setROI);
        IJTools.setTitleFromObject(pathImage, (PathObject)pathObject);
        return pathImage;
    }

    public static PathImage<ImagePlus> extractROIWithOverlay(ImageServer<BufferedImage> server, PathObject pathObject, PathObjectHierarchy hierarchy, RegionRequest request, boolean setROI, OverlayOptions options) throws IOException {
        ROI pathROI = pathObject == null || !pathObject.hasROI() ? ROIs.createRectangleROI((double)0.0, (double)0.0, (double)server.getWidth(), (double)server.getHeight(), (ImagePlane)ImagePlane.getDefaultPlane()) : pathObject.getROI();
        PathImage<ImagePlus> pathImage = IJExtension.extractROI(server, pathROI, request, setROI);
        if (pathImage == null) {
            return pathImage;
        }
        if (hierarchy != null) {
            ImagePlus imp = (ImagePlus)pathImage.getImage();
            Predicate regionPredicate = PathObjectTools.createImageRegionPredicate((ImageRegion)request);
            Overlay overlay = IJExtension.extractOverlay(hierarchy, request, options, p -> p != pathObject && regionPredicate.test(p));
            if (overlay.size() > 0) {
                imp.setOverlay(overlay);
            }
        }
        IJTools.setTitleFromObject(pathImage, (PathObject)pathObject);
        return pathImage;
    }

    public static Overlay extractOverlay(PathObjectHierarchy hierarchy, RegionRequest request, OverlayOptions options, Predicate<PathObject> filter) {
        Overlay overlay = new Overlay();
        double downsample = request.getDownsample();
        double xOrigin = (double)(-request.getX()) / downsample;
        double yOrigin = (double)(-request.getY()) / downsample;
        for (PathObject child : hierarchy.getAllObjectsForRegion((ImageRegion)request, null)) {
            PathCellObject cell;
            ROI nucleus;
            if (filter != null && !filter.test(child) || !child.hasROI() || options != null && (child instanceof PathDetectionObject && !options.getShowDetections() || child instanceof PathAnnotationObject && !options.getShowAnnotations() || child instanceof TMACoreObject && !options.getShowTMAGrid())) continue;
            boolean isCell = child instanceof PathCellObject;
            Color color = ColorToolsAwt.getCachedColor((Integer)ColorToolsFX.getDisplayedColorARGB((PathObject)child));
            if (!isCell || options != null && options.getShowCellBoundaries()) {
                Roi roi = IJTools.convertToIJRoi((ROI)child.getROI(), (double)xOrigin, (double)yOrigin, (double)downsample);
                roi.setStrokeColor(color);
                roi.setName(child.getDisplayedName());
                overlay.add(roi);
            }
            if (!isCell || options != null && !options.getShowCellNuclei() || (nucleus = (cell = (PathCellObject)child).getNucleusROI()) == null) continue;
            Roi roi = IJTools.convertToIJRoi((ROI)nucleus, (double)xOrigin, (double)yOrigin, (double)downsample);
            roi.setStrokeColor(color);
            roi.setName(child.getDisplayedName() + " - nucleus");
            overlay.add(roi);
        }
        return overlay;
    }

    private static void promptToSetImageJDirectory() {
        File dir;
        Path likelyPath;
        String ijPath = IJExtension.getImageJPath();
        if (ijPath == null && (likelyPath = IJExtension.searchForDefaultImageJPath()) != null) {
            ijPath = likelyPath.toString();
        }
        if ((dir = FileChoosers.promptForDirectory((String)"Set ImageJ directory", (File)(ijPath == null ? null : new File(ijPath)))) != null && dir.isDirectory()) {
            IJExtension.setImageJPath(dir.getAbsolutePath());
        }
    }

    private static Path searchForDefaultImageJPath() {
        List<String> appNames = List.of("ImageJ.app", "ImageJ", "Fiji", "Fiji.app");
        ArrayList<Path> possiblePaths = new ArrayList<Path>();
        for (String appName : appNames) {
            String home;
            if (GeneralTools.isMac()) {
                possiblePaths.add(Paths.get("Applications", appName));
            }
            if ((home = System.getProperty("user.home")) == null || home.isBlank()) continue;
            possiblePaths.add(Paths.get(home, appName));
            possiblePaths.add(Paths.get(home, "Documents", appName));
            possiblePaths.add(Paths.get(home, "Desktop", appName));
        }
        return IJExtension.findPotentialImageJDirectory(possiblePaths);
    }

    private static Path findPotentialImageJDirectory(Collection<Path> paths) {
        return paths.stream().filter(IJExtension::isImageJDirectory).findFirst().orElse(null);
    }

    private static boolean isImageJDirectory(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        return Files.isDirectory(path.resolve("plugins"), new LinkOption[0]) && Files.isDirectory(path.resolve("luts"), new LinkOption[0]);
    }

    private void addQuPathCommands(QuPathGUI qupath) {
        PropertySheet.Item item = new PropertyItemBuilder((Property)imageJPath, String.class).propertyType(PropertyItemBuilder.PropertyType.DIRECTORY).name("ImageJ plugins directory").category("ImageJ").description("Set the path to the 'plugins' directory of an existing ImageJ installation").build();
        qupath.getPreferencePane().getPropertySheet().getItems().add((Object)item);
        PropertySheet.Item itemOnTop = new PropertyItemBuilder((Property)alwaysOnTop, Boolean.class).name("ImageJ always on top").category("ImageJ").description("Request that the ImageJ window is always on top of all other windows").build();
        qupath.getPreferencePane().getPropertySheet().getItems().add((Object)itemOnTop);
        IJExtensionCommands commands = new IJExtensionCommands(qupath);
        qupath.installActions((Collection)ActionTools.getAnnotatedActions((Object)commands));
        ToolBar toolbar = qupath.getToolBar();
        toolbar.getItems().add((Object)new Separator(Orientation.VERTICAL));
        try {
            ImageView imageView = new ImageView(IJExtension.getImageJIcon(16, 16));
            MenuButton btnImageJ = new MenuButton();
            btnImageJ.setGraphic((Node)imageView);
            btnImageJ.setTooltip(new Tooltip("ImageJ commands"));
            MenuTools.addMenuItems((List)btnImageJ.getItems(), (Object[])new Object[]{commands.actionShowImageJ, commands.actionExtractRegion, commands.actionSnapshot, null, commands.actionImageJDirectory, null, commands.actionScriptRunner});
            toolbar.getItems().add((Object)btnImageJ);
        }
        catch (Exception e) {
            logger.error("Error adding toolbar buttons", (Throwable)e);
        }
        Menu menuTMA = qupath.getMenu("TMA", true);
        Action actionTMADearray = qupath.createPluginAction(QuPathResources.getString((String)"Action.ImageJ.tmaDearrayer"), TMADearrayerPluginIJ.class, null);
        actionTMADearray.setLongText(QuPathResources.getString((String)"Action.ImageJ.tmaDearrayer.description"));
        menuTMA.getItems().addFirst((Object)ActionTools.createMenuItem((Action)actionTMADearray));
        qupath.getDefaultDragDropListener().addFileDropHandler((DragDropImportListener.DropHandler)new ImageJDropHandler(qupath, commands));
    }

    public static Image getImageJIcon(int width, int height) {
        try {
            URL url = ImageJ.class.getClassLoader().getResource("microscope.gif");
            return url == null ? null : new Image(url.toString(), (double)width, (double)height, true, true);
        }
        catch (Exception e) {
            logger.error("Unable to load ImageJ icon!", (Throwable)e);
            return null;
        }
    }

    public void installExtension(QuPathGUI qupath) {
        if (this.extensionInstalled) {
            return;
        }
        this.extensionInstalled = true;
        alwaysOnTop.addListener(this::alwaysOnTopChanged);
        Prefs.setThreads((int)1);
        this.addQuPathCommands(qupath);
    }

    private void alwaysOnTopChanged(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            ij.setAlwaysOnTop(newValue.booleanValue());
        }
    }

    public String getName() {
        return QuPathResources.getString((String)"Extension.ImageJ");
    }

    public String getDescription() {
        return QuPathResources.getString((String)"Extension.ImageJ.description");
    }

    public Version getQuPathVersion() {
        return this.getVersion();
    }

    static {
        imageJPath = PathPrefs.createPersistentPreference((String)"ijPath", null);
        installedPlugins = Collections.newSetFromMap(new WeakHashMap());
    }

    public static class IJExtensionCommands {
        private QuPathGUI qupath;
        @ActionMenu(value={"Menu.Analyze", "Menu.Analyze.Tiles"})
        public final Action SEP_0 = ActionTools.createSeparator();
        @ActionMenu(value={"Menu.Analyze", "Menu.Analyze.Tiles"})
        @ActionConfig(value="Action.ImageJ.superpixelsSLIC")
        public final Action actionSLIC;
        @ActionMenu(value={"Menu.Analyze", "Menu.Analyze.Tiles"})
        @ActionConfig(value="Action.ImageJ.superpixelsDoG")
        public final Action actionDoG;
        @ActionMenu(value={"Menu.Analyze", "Menu.Analyze.Tiles"})
        public final Action SEP_1 = ActionTools.createSeparator();
        @ActionMenu(value={"Menu.Analyze", "Menu.Analyze.Tiles"})
        @ActionConfig(value="Action.ImageJ.tilesToAnnotations")
        public final Action actionTiles;
        @ActionMenu(value={"Menu.Analyze", "Menu.Analyze.CellDetection"})
        @ActionConfig(value="Action.ImageJ.cellDetection")
        public final Action actionCellDetection;
        @ActionMenu(value={"Menu.Analyze", "Menu.Analyze.CellDetection"})
        @ActionConfig(value="Action.ImageJ.positiveCellDetection")
        public final Action actionPositiveCellDetection;
        @ActionMenu(value={"Menu.Analyze", "Menu.Analyze.CellDetection"})
        public final Action SEP_2 = ActionTools.createSeparator();
        @ActionMenu(value={"Menu.Analyze", "Menu.Analyze.CellDetection"})
        @ActionConfig(value="Action.ImageJ.subcellularDetection")
        @Deprecated
        public final Action actionSubcellularDetection;
        @ActionMenu(value={"Menu.Analyze"})
        public final Action SEP_2B = ActionTools.createSeparator();
        @ActionMenu(value={"Menu.Analyze", "Menu.deprecated"})
        @ActionConfig(value="Action.ImageJ.pixelCount")
        @Deprecated
        public final Action actionPixelCount;
        @ActionMenu(value={"Menu.Analyze", "Menu.deprecated"})
        @ActionConfig(value="Action.ImageJ.simpleTissueDetection")
        @Deprecated
        public final Action actionSimpleTissueDetection;
        @ActionMenu(value={"Menu.Analyze", "Menu.deprecated"})
        @ActionConfig(value="Action.ImageJ.cellAndMembraneDetection")
        @Deprecated
        public final Action actionCellMembraneDetection;
        @ActionMenu(value={"Menu.Extensions", "ImageJ>"})
        @ActionConfig(value="Action.ImageJ.showImageJ")
        public final Action actionShowImageJ = this.createShowImageJAction();
        @ActionIcon(value=IconFactory.PathIcons.EXTRACT_REGION)
        @ActionMenu(value={"Menu.Extensions", "ImageJ>"})
        @ActionConfig(value="Action.ImageJ.extractRegion")
        public final Action actionExtractRegion;
        @ActionIcon(value=IconFactory.PathIcons.SCREENSHOT)
        @ActionMenu(value={"Menu.Extensions", "ImageJ>"})
        @ActionConfig(value="Action.ImageJ.extractRegionSnapshot")
        public final Action actionSnapshot;
        @ActionMenu(value={"Menu.Extensions", "ImageJ>"})
        @ActionConfig(value="Action.ImageJ.importRois")
        public final Action actionImportROIs;
        @ActionMenu(value={"Menu.Extensions", "ImageJ>"})
        public final Action SEP_3 = ActionTools.createSeparator();
        @ActionMenu(value={"Menu.Extensions", "ImageJ>"})
        @ActionConfig(value="Action.ImageJ.setImageJDirectory")
        public final Action actionImageJDirectory = ActionTools.createAction(IJExtension::promptToSetImageJDirectory);
        @ActionMenu(value={"Menu.Extensions", "ImageJ>"})
        public final Action SEP_4 = ActionTools.createSeparator();
        @ActionMenu(value={"Menu.Extensions", "ImageJ>"})
        @ActionConfig(value="Action.ImageJ.legacyMacroRunner")
        @Deprecated
        public final Action actionLegacyMacroRunner;
        private final ScriptRunnerWrapper scriptRunner;
        @ActionMenu(value={"Menu.Extensions", "ImageJ>"})
        @ActionConfig(value="Action.ImageJ.scriptRunner")
        public final Action actionScriptRunner;

        IJExtensionCommands(QuPathGUI qupath) {
            this.qupath = qupath;
            ExtractRegionCommand commandExtractRegionCustom = new ExtractRegionCommand(qupath);
            this.actionExtractRegion = qupath.createImageDataAction(imageData -> commandExtractRegionCustom.run());
            ScreenshotCommand screenshotCommand = new ScreenshotCommand(qupath);
            this.actionSnapshot = ActionTools.createAction((Runnable)screenshotCommand);
            this.actionLegacyMacroRunner = this.createPluginAction((PathPlugin<BufferedImage>)new ImageJMacroRunner(qupath));
            this.scriptRunner = new ScriptRunnerWrapper(qupath);
            this.actionScriptRunner = this.scriptRunner.createAction();
            this.actionSLIC = this.createPluginAction(SLICSuperpixelsPlugin.class);
            this.actionDoG = this.createPluginAction(DoGSuperpixelsPlugin.class);
            this.actionTiles = this.createPluginAction(TileClassificationsToAnnotationsPlugin.class);
            this.actionPixelCount = this.createPluginAction(PositivePixelCounterIJ.class);
            this.actionSimpleTissueDetection = this.createPluginAction(SimpleTissueDetection2.class);
            this.actionCellDetection = this.createPluginAction(WatershedCellDetection.class);
            this.actionPositiveCellDetection = this.createPluginAction(PositiveCellDetection.class);
            this.actionCellMembraneDetection = this.createPluginAction(WatershedCellMembraneDetection.class);
            this.actionSubcellularDetection = this.createPluginAction(SubcellularDetection.class);
            ImportRoisCommand importRoisCommand = new ImportRoisCommand(qupath);
            this.actionImportROIs = qupath.createImageDataAction(imageData -> importRoisCommand.run());
        }

        private Action createShowImageJAction() {
            return new Action(this::showImageJ);
        }

        private void showImageJ(ActionEvent event) {
            ImageJ ij = IJExtension.getImageJInstance();
            if (ij != null) {
                ij.setVisible(true);
            }
        }

        private Action createPluginAction(Class<? extends PathPlugin> pluginClass) {
            return this.qupath.createPluginAction(null, pluginClass, null);
        }

        private Action createPluginAction(PathPlugin<BufferedImage> plugin) {
            return this.qupath.createPluginAction(null, plugin, null);
        }
    }

    static class ImageJDropHandler
    implements DragDropImportListener.DropHandler<File> {
        private final QuPathGUI qupath;
        private final IJExtensionCommands commands;

        private ImageJDropHandler(QuPathGUI qupath, IJExtensionCommands commands) {
            this.qupath = qupath;
            this.commands = commands;
        }

        public boolean handleDrop(QuPathViewer viewer, List<File> list) {
            if (list.size() == 1 && this.handleMacro(list.getFirst())) {
                return true;
            }
            return this.handleRois(viewer, list);
        }

        private boolean handleRois(QuPathViewer viewer, List<File> files) {
            ImageData imageData;
            ImageData imageData2 = imageData = viewer == null ? null : viewer.getImageData();
            if (imageData == null) {
                return false;
            }
            List<File> roiFiles = files.stream().filter(IJTools::containsImageJRois).toList();
            if (roiFiles.isEmpty()) {
                return false;
            }
            List<PathObject> pathObjects = files.stream().flatMap(f -> IJTools.readImageJRois((File)f).stream()).map(r -> IJTools.convertToAnnotation((Roi)r, (double)1.0, null)).toList();
            imageData.getHierarchy().addObjects(pathObjects);
            imageData.getHierarchy().getSelectionModel().selectObjects(pathObjects);
            return true;
        }

        private boolean handleMacro(File file) {
            if (file.getName().toLowerCase().endsWith(".ijm")) {
                this.commands.scriptRunner.openMacro(file);
                return true;
            }
            return false;
        }
    }

    private static class ScriptRunnerWrapper {
        private final QuPathGUI qupath;
        private final String title = ImageJScriptRunnerController.getTitle();
        private Stage stage;
        private ImageJScriptRunnerController controller;

        private ScriptRunnerWrapper(QuPathGUI qupath) {
            this.qupath = qupath;
        }

        Action createAction() {
            return new Action(e -> this.showStage());
        }

        void openMacro(File file) {
            this.showStage();
            if (file != null) {
                this.controller.openMacro(file.toPath());
            }
        }

        private void showStage() {
            if (this.stage == null) {
                try {
                    this.stage = new Stage();
                    this.controller = ImageJScriptRunnerController.createInstance(this.qupath);
                    Scene scene = new Scene((Parent)new BorderPane((Node)this.controller));
                    this.stage.setScene(scene);
                    this.stage.initOwner((Window)QuPathGUI.getInstance().getStage());
                    this.stage.setTitle(this.title);
                    this.stage.setResizable(true);
                    this.stage.setMinWidth(400.0);
                    this.stage.setMinHeight(400.0);
                }
                catch (IOException e) {
                    Dialogs.showErrorMessage((String)this.title, (String)"GUI loading failed");
                    logger.error("Unable to load InstanSeg FXML", (Throwable)e);
                }
            }
            this.stage.show();
        }
    }
}

