/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.gui;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.process.LUT;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.imagej.gui.IJExtension;
import qupath.imagej.tools.IJTools;
import qupath.lib.awt.common.AwtTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.ImageDisplay;
import qupath.lib.display.SingleChannelDisplayInfo;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.images.servers.ChannelDisplayTransformServer;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.interfaces.ROI;

class ExtractRegionCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ExtractRegionCommand.class);
    private static final String title = "Send region to ImageJ";
    private QuPathGUI qupath;
    private static final String PIXELS_UNIT = "Pixels (downsample)";
    private DoubleProperty resolution = PathPrefs.createPersistentPreference((String)"ext.ij.extract.resolution", (double)1.0);
    private StringProperty resolutionUnit = PathPrefs.createPersistentPreference((String)"ext.ij.extract.resolutionUnit", (String)"Pixels (downsample)");
    private ObjectProperty<RoiInclude> includeROI = PathPrefs.createPersistentPreference((String)"ext.ij.extract.includeROI", (Enum)RoiInclude.YES, RoiInclude.class);
    private BooleanProperty includeOverlay = PathPrefs.createPersistentPreference((String)"ext.ij.extract.includeOverlay", (boolean)true);
    private BooleanProperty doTransforms = PathPrefs.createPersistentPreference((String)"ext.ij.extract.doTransforms", (boolean)false);
    private BooleanProperty doZ = PathPrefs.createPersistentPreference((String)"ext.ij.extract.doZ", (boolean)false);
    private BooleanProperty doT = PathPrefs.createPersistentPreference((String)"ext.ij.extract.doT", (boolean)false);

    public ExtractRegionCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    public String getName() {
        return "Extract region (custom)";
    }

    @Override
    public void run() {
        Collection<Object> pathObjects;
        LookupOp gamma;
        ObservableList channels;
        String resolutionUnit;
        QuPathViewer viewer = this.qupath.getViewer();
        ImageServer server = null;
        if (viewer != null) {
            server = viewer.getServer();
        }
        if (server == null) {
            return;
        }
        ArrayList<String> unitOptions = new ArrayList<String>();
        unitOptions.add(PIXELS_UNIT);
        String unit = server.getPixelCalibration().getPixelWidthUnit();
        if (unit.equals(server.getPixelCalibration().getPixelHeightUnit()) && !unit.equals("px")) {
            unitOptions.add(unit);
        }
        if (!unitOptions.contains(resolutionUnit = (String)this.resolutionUnit.get())) {
            resolutionUnit = PIXELS_UNIT;
        }
        ParameterList params = new ParameterList().addDoubleParameter("resolution", "Resolution", this.resolution.get(), null, "Resolution at which the image will be exported, defined as the 'pixel size' in Resolution units").addChoiceParameter("resolutionUnit", "Resolution unit", (Object)resolutionUnit, unitOptions, "Units defining the export resolution; if 'pixels' then the resolution is the same as a downsample value").addChoiceParameter("includeROI", "Include ROI", (Object)((RoiInclude)((Object)this.includeROI.get())), Arrays.asList(RoiInclude.values()), "Include the primary object defining the exported region as an active ROI in ImageJ").addBooleanParameter("includeOverlay", "Include overlay", this.includeOverlay.get(), "Include any objects overlapping the exported region as ROIs on an ImageJ overlay").addBooleanParameter("doTransforms", "Apply color transforms", this.doTransforms.get(), "Optionally apply any color transforms when sending the pixels to ImageJ").addBooleanParameter("doZ", "All z-slices", this.doZ.get(), "Optionally include all slices of a z-stack").addBooleanParameter("doT", "All timepoints", this.doT.get(), "Optionally include all timepoints of a time series");
        params.setHiddenParameters(server.nZSlices() == 1, new String[]{"doZ"});
        params.setHiddenParameters(server.nTimepoints() == 1, new String[]{"doT"});
        if (!GuiTools.showParameterDialog((String)title, (ParameterList)params)) {
            return;
        }
        double resolution = params.getDoubleParameterValue("resolution");
        resolutionUnit = (String)params.getChoiceParameterValue("resolutionUnit");
        RoiInclude includeROI = (RoiInclude)((Object)params.getChoiceParameterValue("includeROI"));
        boolean includeOverlay = params.getBooleanParameterValue("includeOverlay");
        boolean doTransforms = params.getBooleanParameterValue("doTransforms");
        boolean doZ = params.getBooleanParameterValue("doZ");
        boolean doT = params.getBooleanParameterValue("doT");
        this.resolution.set(resolution);
        this.resolutionUnit.set((Object)resolutionUnit);
        this.includeROI.set((Object)includeROI);
        this.includeOverlay.set(includeOverlay);
        this.doTransforms.set(doTransforms);
        this.doZ.set(doZ);
        this.doT.set(doT);
        double downsample = resolution;
        if (!resolutionUnit.equals(PIXELS_UNIT)) {
            downsample = resolution / server.getPixelCalibration().getAveragedPixelSize().doubleValue();
        }
        if (downsample <= 0.0) {
            Dialogs.showErrorMessage((String)title, (String)"Invalid resolution - calculated downsample must be greater than zero");
            return;
        }
        ImageDisplay imageDisplay = viewer.getImageDisplay();
        ObservableList selectedChannels = new ArrayList(imageDisplay.selectedChannels());
        ObservableList observableList = channels = doTransforms && !selectedChannels.isEmpty() ? selectedChannels : null;
        if (channels != null) {
            server = ChannelDisplayTransformServer.createColorTransformServer((ImageServer)server, channels);
        }
        if (doTransforms && (gamma = viewer.getGammaOp()) != null) {
            logger.warn("Gamma transform not supported when sending image to ImageJ");
        }
        if ((pathObjects = viewer.getHierarchy().getSelectionModel().getSelectedObjects()).isEmpty()) {
            pathObjects = Collections.singletonList(viewer.getHierarchy().getRootObject());
        }
        ArrayList<ImagePlus> imps = new ArrayList<ImagePlus>();
        for (PathObject pathObject : pathObjects) {
            int height;
            int width;
            if (Thread.currentThread().isInterrupted() || IJ.escapePressed()) {
                logger.warn("Escape pressed! I will stop showing images.");
                IJ.resetEscape();
                return;
            }
            if (pathObject == null || !pathObject.hasROI()) {
                width = server.getWidth();
                height = server.getHeight();
            } else {
                Rectangle bounds = AwtTools.getBounds((ROI)pathObject.getROI());
                width = bounds.width;
                height = bounds.height;
            }
            ROI roi = pathObject == null ? null : pathObject.getROI();
            RegionRequest region = roi == null || PathObjectTools.hasPointROI((PathObject)pathObject) ? RegionRequest.createInstance((String)server.getPath(), (double)downsample, (int)0, (int)0, (int)server.getWidth(), (int)server.getHeight(), (int)viewer.getZPosition(), (int)viewer.getTPosition()) : RegionRequest.createInstance((String)server.getPath(), (double)downsample, (ROI)roi);
            int zStart = doZ ? 0 : region.getZ();
            int zEnd = doZ ? server.nZSlices() : region.getZ() + 1;
            int tStart = doT ? 0 : region.getT();
            int tEnd = doT ? server.nTimepoints() : region.getT() + 1;
            long nZ = zEnd - zStart;
            long nT = tEnd - tStart;
            int bytesPerPixel = server.isRGB() ? 4 : server.getPixelType().getBytesPerPixel() * server.nChannels();
            double memory = (double)((long)width * (long)height * nZ * nT * (long)bytesPerPixel) / (downsample * downsample);
            long availableMemory = GeneralTools.estimateAvailableMemory();
            if (memory >= (double)availableMemory * 0.95) {
                logger.error("Cannot extract region {} - estimated size is too large (approx. {} MB)", (Object)pathObject, (Object)GeneralTools.formatNumber((double)(memory / 1048576.0), (int)2));
                Dialogs.showErrorMessage((String)title, (String)"Selected region is too large to extract - please selected a smaller region or use a higher downsample factor");
                continue;
            }
            if (memory / 1024.0 / 1024.0 > 100.0 && pathObjects.size() == 1 && !Dialogs.showYesNoDialog((String)title, (String)String.format("Attempting to extract this region is likely to require > %.2f MB - are you sure you want to continue?", memory / 1024.0 / 1024.0))) {
                return;
            }
            boolean doIncludeRoi = switch (includeROI.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> {
                    if (roi != null && !(roi instanceof RectangleROI)) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> true;
                case 1 -> false;
            };
            try {
                ImagePlus imp;
                PathObjectHierarchy hierarchy = viewer.getHierarchy();
                OverlayOptions options = viewer.getOverlayOptions();
                if (zEnd - zStart > 1 || tEnd - tStart > 1) {
                    imp = IJTools.extractHyperstack((ImageServer)server, (RegionRequest)region, (int)zStart, (int)zEnd, (int)tStart, (int)tEnd);
                    if (doIncludeRoi && roi != null) {
                        Roi roiIJ = IJTools.convertToIJRoi((ROI)roi, (Calibration)imp.getCalibration(), (double)region.getDownsample());
                        imp.setRoi(roiIJ);
                    }
                    if (includeOverlay) {
                        Overlay overlay = new Overlay();
                        for (int t = tStart; t < tEnd; ++t) {
                            for (int z = zStart; z < zEnd; ++z) {
                                RegionRequest request2 = RegionRequest.createInstance((String)region.getPath(), (double)region.getDownsample(), (int)region.getX(), (int)region.getY(), (int)region.getWidth(), (int)region.getHeight(), (int)z, (int)t);
                                Predicate regionPredicate = PathObjectTools.createImageRegionPredicate((ImageRegion)request2);
                                Overlay temp = IJExtension.extractOverlay(hierarchy, request2, options, p -> p != pathObject && regionPredicate.test(p));
                                for (int i = 0; i < temp.size(); ++i) {
                                    Roi roiIJ = temp.get(i);
                                    roiIJ.setPosition(-1, z + 1, t + 1);
                                    overlay.add(roiIJ);
                                }
                            }
                        }
                        if (overlay.size() > 0) {
                            imp.setOverlay(overlay);
                        }
                    }
                } else {
                    imp = includeOverlay ? (ImagePlus)IJExtension.extractROIWithOverlay((ImageServer<BufferedImage>)server, pathObject, hierarchy, region, doIncludeRoi, options).getImage() : (ImagePlus)IJExtension.extractROIWithOverlay((ImageServer<BufferedImage>)server, pathObject, null, region, doIncludeRoi, options).getImage();
                }
                boolean invertLUTs = imageDisplay.useInvertedBackground();
                if (imp instanceof CompositeImage) {
                    CompositeImage impComp = (CompositeImage)imp;
                    ObservableList tempChannels = channels == null ? imageDisplay.availableChannels() : channels;
                    List<SingleChannelDisplayInfo> availableSingleChannels = tempChannels.stream().filter(c -> c instanceof SingleChannelDisplayInfo).map(c -> (SingleChannelDisplayInfo)c).toList();
                    if (invertLUTs) {
                        impComp.setProp("CompositeProjection", "invert");
                    }
                    if (availableSingleChannels.size() == impComp.getNChannels()) {
                        for (int c2 = 0; c2 < availableSingleChannels.size(); ++c2) {
                            SingleChannelDisplayInfo channel = availableSingleChannels.get(c2);
                            impComp.setPosition(c2 + 1, 1, 1);
                            if (invertLUTs) {
                                LUT lut = impComp.getChannelLut();
                                int n = lut.getMapSize();
                                int r = lut.getRed(n - 1);
                                int g = lut.getGreen(n - 1);
                                int b = lut.getBlue(n - 1);
                                byte[] reds = new byte[n];
                                byte[] greens = new byte[n];
                                byte[] blues = new byte[n];
                                for (int i = 0; i < n; ++i) {
                                    reds[i] = (byte)(255 - (int)((double)(255 - r) * ((double)i / 255.0)));
                                    greens[i] = (byte)(255 - (int)((double)(255 - g) * ((double)i / 255.0)));
                                    blues[i] = (byte)(255 - (int)((double)(255 - b) * ((double)i / 255.0)));
                                }
                                lut = new LUT(reds, greens, blues);
                                impComp.setChannelLut(lut);
                            }
                            impComp.setDisplayRange((double)channel.getMinDisplay(), (double)channel.getMaxDisplay());
                        }
                        impComp.setPosition(1, 1, 1);
                    }
                } else if (selectedChannels.size() == 1 && imp.getType() != 4) {
                    ChannelDisplayInfo channel = (ChannelDisplayInfo)selectedChannels.getFirst();
                    imp.setDisplayRange((double)channel.getMinDisplay(), (double)channel.getMaxDisplay());
                }
                imps.add(imp);
            }
            catch (IOException e) {
                Dialogs.showErrorMessage((String)title, (Throwable)e);
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
        }
        if (!imps.isEmpty()) {
            SwingUtilities.invokeLater(() -> {
                boolean batchMode = Interpreter.batchMode;
                try {
                    ImageJ ij = IJExtension.getImageJInstance();
                    if (ij == null) {
                        return;
                    }
                    ij.setVisible(true);
                    Interpreter.batchMode = false;
                    for (ImagePlus imp : imps) {
                        if (IJ.escapePressed()) {
                            logger.warn("Escape pressed - I'll stop showing images");
                            IJ.resetEscape();
                            return;
                        }
                        imp.show();
                    }
                }
                finally {
                    Interpreter.batchMode = batchMode;
                }
            });
        }
    }

    public static enum RoiInclude {
        YES,
        NO,
        NON_RECTANGLE;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Yes";
                case 1 -> "No";
                case 2 -> "Non-rectangles only";
            };
        }
    }
}

