/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.gui;

import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.MenuBar;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AwtMenuBarBlocker
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(AwtMenuBarBlocker.class);
    private WeakReference<MenuBar> blockedMenuBarRef = null;
    private boolean isBlocking = false;

    AwtMenuBarBlocker() {
    }

    synchronized void startBlocking() {
        if (this.isBlocking) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("activeWindow", this);
        this.isBlocking = true;
    }

    synchronized void stopBlocking() {
        MenuBar blockedMenuBar;
        if (!this.isBlocking) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("activeWindow", this);
        MenuBar menuBar = blockedMenuBar = this.blockedMenuBarRef == null ? null : (MenuBar)this.blockedMenuBarRef.get();
        if (blockedMenuBar != null) {
            this.restoreMenuBar(blockedMenuBar);
        }
        this.blockedMenuBarRef = null;
        this.isBlocking = false;
    }

    public synchronized boolean isBlocking() {
        return this.isBlocking;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        MenuBar blockedMenuBar;
        Object activeWindow = evt.getNewValue();
        MenuBar menuBar = blockedMenuBar = this.blockedMenuBarRef == null ? null : (MenuBar)this.blockedMenuBarRef.get();
        if (activeWindow != null) {
            if (blockedMenuBar != null) {
                this.restoreMenuBar(blockedMenuBar);
                this.blockedMenuBarRef = null;
            }
        } else {
            MenuBar currentMenuBar = AwtMenuBarBlocker.getMenuBar(evt.getOldValue());
            if (currentMenuBar != null && blockedMenuBar != currentMenuBar) {
                this.blockMenuBar(currentMenuBar);
                this.restoreMenuBar(blockedMenuBar);
                this.blockedMenuBarRef = new WeakReference<MenuBar>(currentMenuBar);
            }
        }
    }

    private void blockMenuBar(MenuBar menuBar) {
        if (menuBar == null) {
            return;
        }
        logger.debug("Removing menubar notifications {}", (Object)menuBar);
        menuBar.removeNotify();
    }

    private void restoreMenuBar(MenuBar menuBar) {
        if (menuBar == null) {
            return;
        }
        logger.debug("Adding menubar notifications {}", (Object)menuBar);
        menuBar.addNotify();
    }

    private static MenuBar getMenuBar(Object o) {
        if (o instanceof Frame) {
            Frame frame = (Frame)o;
            return frame.getMenuBar();
        }
        return null;
    }
}

