/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.opencv.opencv_core.Mat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;

public class Thinning {
    private static final Logger logger = LoggerFactory.getLogger(Thinning.class);
    private static final AdjacencyTree adjacencyTree = new AdjacencyTree();
    private static final int nBits = 0x4000000;
    private static BitSet bitLUTSet = new BitSet(0x4000000);
    private static BitSet bitLUT = new BitSet(0x4000000);

    public static void thin(Mat mat) {
        if (mat.depth() != 0) {
            mat.convertTo(mat, 0);
        }
        UByteIndexer idx = (UByteIndexer)mat.createIndexer();
        Thinning.thin(idx);
        idx.release();
    }

    static void thin(UByteIndexer idx) {
        byte[] neighbors = new byte[26];
        long iMax = idx.size(0);
        long jMax = idx.size(1);
        long kMax = idx.size(2);
        ArrayList<Direction> directions = new ArrayList<Direction>();
        if (iMax > 1L) {
            directions.add(Direction.NORTH);
            directions.add(Direction.SOUTH);
        }
        if (jMax > 1L) {
            directions.add(Direction.EAST);
            directions.add(Direction.WEST);
        }
        if (kMax > 1L) {
            directions.add(Direction.UP);
            directions.add(Direction.DOWN);
        }
        long nChanges = Long.MAX_VALUE;
        long iter = 0L;
        ArrayList<long[]> simplePoints = new ArrayList<long[]>();
        while (nChanges != 0L) {
            nChanges = 0L;
            for (Direction direction : directions) {
                long j;
                long i;
                for (long k = 0L; k < kMax; ++k) {
                    for (i = 0L; i < iMax; ++i) {
                        block12: for (j = 0L; j < jMax; ++j) {
                            boolean checkBounds;
                            int bitMask;
                            if (idx.get(i, j, k) == 0) continue;
                            switch (direction.ordinal()) {
                                case 5: {
                                    if (k <= 0L || idx.get(i, j, k - 1L) == 0) break;
                                    continue block12;
                                }
                                case 2: {
                                    if (j >= jMax - 1L || idx.get(i, j + 1L, k) == 0) break;
                                    continue block12;
                                }
                                case 0: {
                                    if (i <= 0L || idx.get(i - 1L, j, k) == 0) break;
                                    continue block12;
                                }
                                case 1: {
                                    if (i >= iMax - 1L || idx.get(i + 1L, j, k) == 0) break;
                                    continue block12;
                                }
                                case 4: {
                                    if (k >= kMax - 1L || idx.get(i, j, k + 1L) == 0) break;
                                    continue block12;
                                }
                                case 3: {
                                    if (j <= 0L || idx.get(i, j - 1L, k) == 0) break;
                                    continue block12;
                                }
                                default: {
                                    logger.debug("Unknown boundary direction: {}", (Object)direction);
                                    continue block12;
                                }
                            }
                            if (!Thinning.isSimpleBorderPoint(neighbors, bitMask = (checkBounds = i == 0L || j == 0L || k == 0L || i == iMax - 1L || j == jMax - 1L || k == kMax - 1L) ? Thinning.getNeighborsWithBoundsCheck(idx, i, j, k, iMax, jMax, kMax, neighbors) : Thinning.getNeighbors(idx, i, j, k, neighbors))) continue;
                            simplePoints.add(new long[]{i, j, k});
                        }
                    }
                }
                for (long[] point : simplePoints) {
                    boolean simplePoint;
                    i = point[0];
                    j = point[1];
                    long k = point[2];
                    Thinning.getNeighborsWithBoundsCheck(idx, i, j, k, iMax, jMax, kMax, neighbors);
                    boolean bl = simplePoint = Thinning.countConnectedObjects(neighbors) <= 1;
                    if (!simplePoint) continue;
                    idx.put(i, j, k, 0);
                    ++nChanges;
                }
                simplePoints.clear();
            }
            logger.debug("Changes at iteration {}: {}", (Object)(++iter), (Object)nChanges);
        }
        logger.info("Cached bitset values: {} ({} %)", (Object)Thinning.adjacencyTree.cachedCount, (Object)GeneralTools.formatNumber((double)((double)Thinning.adjacencyTree.cachedCount / (double)Thinning.adjacencyTree.requestCount * 100.0), (int)1));
    }

    static void countNeighbors(UByteIndexer idx) {
        long iMax = idx.size(0);
        long jMax = idx.size(1);
        long kMax = idx.size(2);
        byte[] neighbors = new byte[26];
        for (long k = 0L; k < kMax; ++k) {
            for (long i = 0L; i < iMax; ++i) {
                for (long j = 0L; j < jMax; ++j) {
                    if (idx.get(i, j, k) == 0) continue;
                    boolean checkBounds = i == 0L || j == 0L || k == 0L || i == iMax - 1L || j == jMax - 1L || k == kMax - 1L;
                    int bitMask = checkBounds ? Thinning.getNeighborsWithBoundsCheck(idx, i, j, k, iMax, jMax, kMax, neighbors) : Thinning.getNeighbors(idx, i, j, k, neighbors);
                    int n = Integer.bitCount(bitMask) + 1;
                    idx.put(i, j, k, n);
                }
            }
        }
    }

    static boolean isSimpleBorderPoint(byte[] neighborhood, int bitMask) {
        int count = Integer.bitCount(bitMask);
        if (count <= 1) {
            return false;
        }
        assert (bitMask >= 0 && bitMask <= 0x4000000);
        ++Thinning.adjacencyTree.requestCount;
        if (!bitLUTSet.get(bitMask)) {
            boolean isSimpleBorderPoint = Thinning.isSimpleBorderPoint(neighborhood);
            bitLUT.set(bitMask, isSimpleBorderPoint);
            bitLUTSet.set(bitMask, true);
            return isSimpleBorderPoint;
        }
        ++Thinning.adjacencyTree.cachedCount;
        return bitLUT.get(bitMask);
    }

    private static boolean isSimpleBorderPoint(byte[] neighborhood) {
        if (!adjacencyTree.isEulerInvariant(neighborhood)) {
            return false;
        }
        return Thinning.countConnectedObjects(neighborhood) <= 1;
    }

    private static int countConnectedObjects(byte[] neighbours) {
        byte label = 2;
        for (int ind = 0; ind < 26; ++ind) {
            byte val = neighbours[ind];
            if (val != 1) continue;
            adjacencyTree.labelNeighbors(ind, neighbours, label);
            label = (byte)(label + 1);
        }
        return label - 2;
    }

    private static int getNeighbors(UByteIndexer idx, long i, long j, long k, byte[] cube) {
        int count = 0;
        int ind = 0;
        for (int di = -1; di <= 1; ++di) {
            for (int dj = -1; dj <= 1; ++dj) {
                for (int dk = -1; dk <= 1; ++dk) {
                    if (di == 0 && dj == 0 && dk == 0) continue;
                    int val = idx.get(i + (long)di, j + (long)dj, k + (long)dk);
                    if (val != 0) {
                        cube[ind] = 1;
                        count |= 1 << ind;
                    } else {
                        cube[ind] = 0;
                    }
                    ++ind;
                }
            }
        }
        return count;
    }

    private static int getNeighborsWithBoundsCheck(UByteIndexer idx, long i, long j, long k, long sizeI, long sizeJ, long sizeK, byte[] cube) {
        int count = 0;
        int ind = 0;
        for (int di = -1; di <= 1; ++di) {
            long ii = i + (long)di;
            for (int dj = -1; dj <= 1; ++dj) {
                long jj = j + (long)dj;
                for (int dk = -1; dk <= 1; ++dk) {
                    if (di == 0 && dj == 0 && dk == 0) continue;
                    long kk = k + (long)dk;
                    int val = ii < 0L || jj < 0L || kk < 0L || ii >= sizeI || jj >= sizeJ || kk >= sizeK ? 0 : idx.get(ii, jj, kk);
                    if (val != 0) {
                        cube[ind] = 1;
                        count |= 1 << ind;
                    } else {
                        cube[ind] = 0;
                    }
                    ++ind;
                }
            }
        }
        return count;
    }

    private static int[] createDeltaG_26() {
        int[] lut = new int[256];
        lut[1] = 1;
        lut[3] = -1;
        lut[5] = -1;
        lut[7] = 1;
        lut[9] = -3;
        lut[11] = -1;
        lut[13] = -1;
        lut[15] = 1;
        lut[17] = -1;
        lut[19] = 1;
        lut[21] = 1;
        lut[23] = -1;
        lut[25] = 3;
        lut[27] = 1;
        lut[29] = 1;
        lut[31] = -1;
        lut[33] = -3;
        lut[35] = -1;
        lut[37] = 3;
        lut[39] = 1;
        lut[41] = 1;
        lut[43] = -1;
        lut[45] = 3;
        lut[47] = 1;
        lut[49] = -1;
        lut[51] = 1;
        lut[53] = 1;
        lut[55] = -1;
        lut[57] = 3;
        lut[59] = 1;
        lut[61] = 1;
        lut[63] = -1;
        lut[65] = -3;
        lut[67] = 3;
        lut[69] = -1;
        lut[71] = 1;
        lut[73] = 1;
        lut[75] = 3;
        lut[77] = -1;
        lut[79] = 1;
        lut[81] = -1;
        lut[83] = 1;
        lut[85] = 1;
        lut[87] = -1;
        lut[89] = 3;
        lut[91] = 1;
        lut[93] = 1;
        lut[95] = -1;
        lut[97] = 1;
        lut[99] = 3;
        lut[101] = 3;
        lut[103] = 1;
        lut[105] = 5;
        lut[107] = 3;
        lut[109] = 3;
        lut[111] = 1;
        lut[113] = -1;
        lut[115] = 1;
        lut[117] = 1;
        lut[119] = -1;
        lut[121] = 3;
        lut[123] = 1;
        lut[125] = 1;
        lut[127] = -1;
        lut[129] = -7;
        lut[131] = -1;
        lut[133] = -1;
        lut[135] = 1;
        lut[137] = -3;
        lut[139] = -1;
        lut[141] = -1;
        lut[143] = 1;
        lut[145] = -1;
        lut[147] = 1;
        lut[149] = 1;
        lut[151] = -1;
        lut[153] = 3;
        lut[155] = 1;
        lut[157] = 1;
        lut[159] = -1;
        lut[161] = -3;
        lut[163] = -1;
        lut[165] = 3;
        lut[167] = 1;
        lut[169] = 1;
        lut[171] = -1;
        lut[173] = 3;
        lut[175] = 1;
        lut[177] = -1;
        lut[179] = 1;
        lut[181] = 1;
        lut[183] = -1;
        lut[185] = 3;
        lut[187] = 1;
        lut[189] = 1;
        lut[191] = -1;
        lut[193] = -3;
        lut[195] = 3;
        lut[197] = -1;
        lut[199] = 1;
        lut[201] = 1;
        lut[203] = 3;
        lut[205] = -1;
        lut[207] = 1;
        lut[209] = -1;
        lut[211] = 1;
        lut[213] = 1;
        lut[215] = -1;
        lut[217] = 3;
        lut[219] = 1;
        lut[221] = 1;
        lut[223] = -1;
        lut[225] = 1;
        lut[227] = 3;
        lut[229] = 3;
        lut[231] = 1;
        lut[233] = 5;
        lut[235] = 3;
        lut[237] = 3;
        lut[239] = 1;
        lut[241] = -1;
        lut[243] = 1;
        lut[245] = 1;
        lut[247] = -1;
        lut[249] = 3;
        lut[251] = 1;
        lut[253] = 1;
        lut[255] = -1;
        return lut;
    }

    private static enum Direction {
        NORTH,
        SOUTH,
        EAST,
        WEST,
        UP,
        DOWN;

    }

    static class AdjacencyTree {
        private static int[] lut = Thinning.createDeltaG_26();
        private final List<Octant> octants;
        private final Octant[][] leaves;
        private long requestCount = 0L;
        private long cachedCount = 0L;

        private AdjacencyTree() {
            Cube cube = new Cube();
            this.octants = Collections.unmodifiableList(cube.getOctants());
            this.leaves = new Octant[26][];
            for (int i = 0; i < 26; ++i) {
                int ind = i;
                this.leaves[i] = (Octant[])this.octants.stream().filter(o -> o.contains(ind)).toArray(Octant[]::new);
            }
        }

        public Octant getOctant(int ind) {
            return this.leaves[ind][0];
        }

        boolean isEulerInvariant(byte[] neighbors) {
            int euler = 0;
            for (Octant octant : this.octants) {
                euler += lut[octant.eulerChar(neighbors)];
            }
            return euler == 0;
        }

        void labelNeighbors(int ind, byte[] neighbors, byte label) {
            Octant octant = this.getOctant(ind);
            this.labelNeighbors(octant, neighbors, label);
        }

        void labelNeighbors(Octant octant, byte[] neighbors, byte label) {
            for (int i : octant.inds) {
                if (neighbors[i] != 1) continue;
                neighbors[i] = label;
                for (Octant oct : this.leaves[i]) {
                    if (oct == octant) continue;
                    this.labelNeighbors(oct, neighbors, label);
                }
            }
        }
    }

    static class Octant {
        private int[] inds;

        private Octant(int ... inds) {
            this.inds = inds;
            assert (this.inds.length == 7);
        }

        private boolean contains(int ind) {
            for (int i : this.inds) {
                if (i != ind) continue;
                return true;
            }
            return false;
        }

        int eulerChar(byte[] neighbors) {
            int n = 1;
            for (int i = 0; i < 7; ++i) {
                if (neighbors[this.inds[i]] == 0) continue;
                n |= 1 << 7 - i;
            }
            return n;
        }

        public String toString() {
            return "Octant: (Indices: " + Arrays.stream(this.inds).mapToObj(i -> Integer.toString(i)).collect(Collectors.joining(", ")) + ")";
        }
    }

    static class Cube {
        private final int[][][] cube = new int[3][3][3];

        private Cube() {
            int ind = 0;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        this.cube[i][j][k] = i == 1 && j == 1 && k == 1 ? -1 : ind++;
                    }
                }
            }
        }

        List<Octant> getOctants() {
            ArrayList<Octant> octants = new ArrayList<Octant>();
            octants.add(new Octant(23, 24, 14, 15, 20, 21, 12));
            octants.add(new Octant(25, 22, 16, 13, 24, 21, 15));
            octants.add(new Octant(17, 20, 9, 12, 18, 21, 10));
            octants.add(new Octant(19, 22, 18, 21, 11, 13, 10));
            octants.add(new Octant(6, 14, 7, 15, 3, 12, 4));
            octants.add(new Octant(8, 7, 16, 15, 5, 4, 13));
            octants.add(new Octant(0, 9, 3, 12, 1, 10, 4));
            octants.add(new Octant(2, 1, 11, 10, 5, 4, 13));
            return octants;
        }
    }
}

