/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.tools;

import java.nio.FloatBuffer;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import qupath.lib.analysis.algorithms.MorphologicalReconstruction;
import qupath.lib.analysis.algorithms.Watershed;
import qupath.lib.analysis.images.SimpleImage;
import qupath.lib.analysis.images.SimpleModifiableImage;
import qupath.opencv.tools.OpenCVTools;

public class ProcessingCV {
    public static boolean morphologicalReconstruction(Mat matMarker, Mat matMask) {
        PixelImageCV imMarker = new PixelImageCV(matMarker);
        PixelImageCV imMask = new PixelImageCV(matMask);
        boolean success = MorphologicalReconstruction.morphologicalReconstruction(imMarker, (SimpleImage)imMask);
        if (!success) {
            return false;
        }
        imMarker.put(matMarker);
        return true;
    }

    public static void doWatershed(Mat mat, Mat matLabels, boolean conn8) {
        ProcessingCV.doWatershed(mat, matLabels, Double.NEGATIVE_INFINITY, conn8);
    }

    public static void doWatershed(Mat mat, Mat matLabels, double minThreshold, boolean conn8) {
        PixelImageCV ip = new PixelImageCV(mat);
        PixelImageCV ipLabels = new PixelImageCV(matLabels);
        Watershed.doWatershed((SimpleImage)ip, ipLabels, minThreshold, conn8);
        ipLabels.put(matLabels);
    }

    static class PixelImageCV
    implements SimpleModifiableImage {
        private float[] pixels;
        private int width;
        private int height;

        public PixelImageCV(Mat mat) {
            this.width = mat.cols();
            this.height = mat.rows();
            this.pixels = OpenCVTools.extractPixels(mat, null);
        }

        public void put(Mat mat) {
            if (mat.depth() != 5) {
                Mat mat2 = new Mat(this.height, this.width, 5, Scalar.ZERO);
                mat2.convertTo(mat, mat.depth());
                FloatBuffer buffer = (FloatBuffer)mat2.createBuffer();
                buffer.put(this.pixels);
                mat2.convertTo(mat, mat.depth());
                mat2.close();
            } else {
                FloatBuffer buffer = (FloatBuffer)mat.createBuffer();
                buffer.put(this.pixels);
            }
        }

        public float getValue(int x, int y) {
            return this.pixels[y * this.width + x];
        }

        public void setValue(int x, int y, float val) {
            this.pixels[y * this.width + x] = val;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public float[] getArray(boolean direct) {
            if (direct) {
                return this.pixels;
            }
            return (float[])this.pixels.clone();
        }
    }
}

