/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.tools;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.MatExpr;
import org.bytedeco.opencv.opencv_core.Rect;
import qupath.lib.images.servers.PixelCalibration;
import qupath.opencv.tools.OpenCVTools;

public class MultiscaleFeatures {
    private static final FilterBorderType BORDER_DEFAULT = FilterBorderType.REPLICATE;

    static Mat calculateCoherence(Mat stMax, Mat stMin) {
        int w = stMax.cols();
        int h = stMax.rows();
        Mat coherence = new Mat(h, w, opencv_core.CV_32FC1);
        FloatIndexer idxCoherence = (FloatIndexer)coherence.createIndexer();
        Indexer idxMax = stMax.createIndexer();
        Indexer idxMin = stMin.createIndexer();
        long[] inds = new long[2];
        for (int r = 0; r < h; ++r) {
            for (int c = 0; c < w; ++c) {
                inds[0] = r;
                inds[1] = c;
                double max = idxMax.getDouble(inds);
                double min = idxMin.getDouble(inds);
                double difference = max - min;
                double sum = max + min;
                double co = sum == 0.0 ? 0.0 : difference / sum * (difference / sum);
                idxCoherence.put((long)r, (long)c, (float)co);
            }
        }
        idxCoherence.release();
        idxMax.release();
        idxMin.release();
        return coherence;
    }

    static Mat toColumns(Mat m) {
        return m.reshape(m.channels(), m.rows() * m.cols());
    }

    static List<Mat> toColumns(List<Mat> mats) {
        return mats.stream().map(m -> MultiscaleFeatures.toColumns(m)).toList();
    }

    static Mat sortedIndsByAbsoluteValue(List<Mat> mats) {
        Mat mat = OpenCVTools.hConcat(MultiscaleFeatures.toColumns(mats), null);
        Mat matAbs = opencv_core.abs((Mat)mat).asMat();
        opencv_core.sortIdx((Mat)matAbs, (Mat)matAbs, (int)16);
        mat.close();
        return matAbs;
    }

    static List<Mat> applySortedIndsToElements(List<Mat> mats, Mat sortedInds) {
        int nChannels = mats.get(0).channels();
        int nRows = mats.get(0).rows();
        int nCols = mats.get(0).cols();
        int nImages = mats.size();
        assert (sortedInds.cols() == nImages);
        assert (sortedInds.rows() == nRows * nCols);
        IntIndexer idx = (IntIndexer)sortedInds.createIndexer();
        ArrayList<Mat> outputMats = new ArrayList<Mat>();
        ArrayList<FloatIndexer> outputIndexers = new ArrayList<FloatIndexer>();
        ArrayList<FloatIndexer> indexers = new ArrayList<FloatIndexer>();
        for (int i = 0; i < nImages; ++i) {
            Mat temp = new Mat(nRows, nCols, opencv_core.CV_32FC((int)nChannels));
            outputMats.add(temp);
            outputIndexers.add((FloatIndexer)temp.createIndexer());
            indexers.add((FloatIndexer)mats.get(i).createIndexer());
        }
        long[] inds = new long[3];
        for (int i = 0; i < nImages; ++i) {
            FloatIndexer outputIdx = (FloatIndexer)outputIndexers.get(i);
            for (int r = 0; r < nRows; ++r) {
                inds[0] = r;
                for (int c = 0; c < nCols; ++c) {
                    inds[1] = c;
                    int ind = idx.get((long)(r * nCols + c), (long)i);
                    FloatIndexer tempIdx = (FloatIndexer)indexers.get(ind);
                    for (int channel = 0; channel < nChannels; ++channel) {
                        inds[2] = channel;
                        outputIdx.put(inds, tempIdx.get(inds));
                    }
                }
            }
        }
        outputIndexers.forEach(Indexer::close);
        indexers.forEach(Indexer::close);
        return outputMats;
    }

    static enum FilterBorderType {
        REPLICATE,
        REFLECT,
        WRAP;


        public String toString() {
            switch (this.ordinal()) {
                case 1: {
                    return "Reflect border";
                }
                case 0: {
                    return "Replicate border";
                }
                case 2: {
                    return "Wrap border";
                }
            }
            return super.toString();
        }

        int getOpenCVCode() {
            switch (this.ordinal()) {
                case 1: {
                    return 2;
                }
                case 0: {
                    return 1;
                }
                case 2: {
                    return 3;
                }
            }
            throw new IllegalArgumentException("Unknown border type " + String.valueOf((Object)this));
        }
    }

    private static class EigenSymm3
    implements AutoCloseable {
        private Mat eigvalMin;
        private Mat eigvalMiddle;
        private Mat eigvalMax;
        private Mat eigvecMin;
        private Mat eigvecMiddle;
        private Mat eigvecMax;

        EigenSymm3(Mat dxx, Mat dxy, Mat dxz, Mat dyy, Mat dyz, Mat dzz, boolean doEigenvectors) {
            int height = dxx.rows();
            int width = dxx.cols();
            Mat matInput = new Mat(3, 3, opencv_core.CV_32FC1);
            Mat matEigenvalues = new Mat(3, 1, opencv_core.CV_32FC1);
            Mat matEigenvectors = new Mat(3, 3, opencv_core.CV_32FC1);
            float[] pxDxx = OpenCVTools.extractFloats(dxx);
            float[] pxDxy = OpenCVTools.extractFloats(dxy);
            float[] pxDxz = OpenCVTools.extractFloats(dxz);
            float[] pxDyy = OpenCVTools.extractFloats(dyy);
            float[] pxDyz = OpenCVTools.extractFloats(dyz);
            float[] pxDzz = OpenCVTools.extractFloats(dzz);
            float[] bufMin = new float[width * height];
            float[] bufMiddle = new float[width * height];
            float[] bufMax = new float[width * height];
            float[] bufMinVec = doEigenvectors ? new float[width * height * 3] : null;
            float[] bufMiddleVec = doEigenvectors ? new float[width * height * 3] : null;
            float[] bufMaxVec = doEigenvectors ? new float[width * height * 3] : null;
            FloatIndexer idxInput = (FloatIndexer)matInput.createIndexer();
            FloatIndexer idxEigenvalues = (FloatIndexer)matEigenvalues.createIndexer();
            FloatIndexer idxEigenvectors = (FloatIndexer)matEigenvectors.createIndexer();
            float[] input = new float[9];
            float[] eigenvalues = new float[3];
            float[] eigenvectors = new float[9];
            int ind = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    input[0] = pxDxx[ind];
                    input[1] = pxDxy[ind];
                    input[2] = pxDxz[ind];
                    input[3] = pxDxy[ind];
                    input[4] = pxDyy[ind];
                    input[5] = pxDyz[ind];
                    input[6] = pxDxz[ind];
                    input[7] = pxDyz[ind];
                    input[8] = pxDzz[ind];
                    idxInput.put(0L, input);
                    if (doEigenvectors) {
                        opencv_core.eigen((Mat)matInput, (Mat)matEigenvalues, (Mat)matEigenvectors);
                    } else {
                        opencv_core.eigen((Mat)matInput, (Mat)matEigenvalues);
                    }
                    idxEigenvalues.get(0L, eigenvalues);
                    bufMax[ind] = eigenvalues[0];
                    bufMiddle[ind] = eigenvalues[1];
                    bufMin[ind] = eigenvalues[2];
                    if (doEigenvectors) {
                        idxEigenvectors.get(0L, eigenvectors);
                        bufMaxVec[ind * 3] = eigenvectors[0];
                        bufMaxVec[ind * 3 + 1] = eigenvectors[1];
                        bufMaxVec[ind * 3 + 2] = eigenvectors[2];
                        bufMiddleVec[ind * 3] = eigenvectors[3];
                        bufMiddleVec[ind * 3 + 1] = eigenvectors[4];
                        bufMiddleVec[ind * 3 + 2] = eigenvectors[5];
                        bufMinVec[ind * 3] = eigenvectors[6];
                        bufMinVec[ind * 3 + 1] = eigenvectors[7];
                        bufMinVec[ind * 3 + 2] = eigenvectors[8];
                    }
                    ++ind;
                }
            }
            idxInput.release();
            idxEigenvalues.release();
            idxEigenvectors.release();
            matInput.close();
            matEigenvalues.close();
            matEigenvectors.close();
            this.eigvalMin = new Mat(height, width, opencv_core.CV_32FC1, (Pointer)new FloatPointer(bufMin));
            this.eigvalMiddle = new Mat(height, width, opencv_core.CV_32FC1, (Pointer)new FloatPointer(bufMiddle));
            this.eigvalMax = new Mat(height, width, opencv_core.CV_32FC1, (Pointer)new FloatPointer(bufMax));
            if (doEigenvectors) {
                this.eigvecMin = new Mat(height, width, opencv_core.CV_32FC3, (Pointer)new FloatPointer(bufMinVec));
                this.eigvecMiddle = new Mat(height, width, opencv_core.CV_32FC3, (Pointer)new FloatPointer(bufMiddleVec));
                this.eigvecMax = new Mat(height, width, opencv_core.CV_32FC3, (Pointer)new FloatPointer(bufMaxVec));
            }
        }

        @Override
        public void close() {
            this.eigvalMin.close();
            this.eigvalMiddle.close();
            this.eigvalMax.close();
            if (this.eigvecMax != null) {
                this.eigvecMax.close();
            }
            if (this.eigvecMiddle != null) {
                this.eigvecMiddle.close();
            }
            if (this.eigvecMin != null) {
                this.eigvecMin.close();
            }
        }
    }

    private static class EigenSymm2
    implements AutoCloseable {
        private Mat eigvalMin;
        private Mat eigvalMax;
        private Mat eigvecMin;
        private Mat eigvecMax;

        EigenSymm2(Mat dxx, Mat dxy, Mat dyy, boolean doEigenvectors) {
            MatExpr trace = opencv_core.add((Mat)dxx, (Mat)dyy);
            MatExpr det = EigenSymm2.getDeterminantExpr2x2(dxx, dxy, dyy);
            MatExpr t1 = opencv_core.divide((MatExpr)trace, (double)2.0);
            Mat t2 = opencv_core.subtract((MatExpr)trace.mul(trace, 0.25), (MatExpr)det).asMat();
            opencv_core.sqrt((Mat)t2, (Mat)t2);
            this.eigvalMin = opencv_core.subtract((MatExpr)t1, (Mat)t2).asMat();
            this.eigvalMax = opencv_core.add((MatExpr)t1, (Mat)t2).asMat();
            this.eigvalMin.convertTo(this.eigvalMin, 5);
            this.eigvalMax.convertTo(this.eigvalMax, 5);
            opencv_core.patchNaNs((Mat)this.eigvalMin, (double)0.0);
            opencv_core.patchNaNs((Mat)this.eigvalMax, (double)0.0);
            if (doEigenvectors) {
                int width = dxx.cols();
                int height = dxx.rows();
                int n = width * height;
                float[] bufMinVec = new float[n * 2];
                float[] bufMaxVec = new float[n * 2];
                float[] c = OpenCVTools.extractFloats(dxy);
                float[] d = OpenCVTools.extractFloats(dyy);
                float[] l1 = OpenCVTools.extractFloats(this.eigvalMax);
                float[] l2 = OpenCVTools.extractFloats(this.eigvalMin);
                for (int i = 0; i < n; ++i) {
                    float offDiag = c[i];
                    if (offDiag == 0.0f) {
                        bufMaxVec[i * 2] = 1.0f;
                        bufMaxVec[i * 2 + 1] = 0.0f;
                        bufMinVec[i * 2] = 0.0f;
                        bufMinVec[i * 2 + 1] = 1.0f;
                        continue;
                    }
                    double temp1 = l1[i] - d[i];
                    double temp2 = c[i];
                    double len = Math.sqrt(temp1 * temp1 + temp2 * temp2);
                    bufMaxVec[i * 2] = (float)(temp1 / len);
                    bufMaxVec[i * 2 + 1] = (float)(temp2 / len);
                    temp1 = l2[i] - d[i];
                    len = Math.sqrt(temp1 * temp1 + temp2 * temp2);
                    bufMinVec[i * 2] = (float)(temp1 / len);
                    bufMinVec[i * 2 + 1] = (float)(temp2 / len);
                }
                this.eigvecMin = new Mat(height, width, opencv_core.CV_32FC2, (Pointer)new FloatPointer(bufMinVec));
                this.eigvecMax = new Mat(height, width, opencv_core.CV_32FC2, (Pointer)new FloatPointer(bufMaxVec));
            }
            t1.close();
            t2.close();
            trace.close();
            det.close();
        }

        static MatExpr getDeterminantExpr2x2(Mat dxx, Mat dxy, Mat dyy) {
            return opencv_core.subtract((MatExpr)dxx.mul(dyy), (MatExpr)dxy.mul(dxy));
        }

        @Override
        public void close() {
            this.eigvalMin.close();
            this.eigvalMax.close();
            if (this.eigvecMax != null) {
                this.eigvecMax.close();
            }
            if (this.eigvecMin != null) {
                this.eigvecMin.close();
            }
        }
    }

    public static class Hessian3D
    implements Hessian {
        private boolean doEigenvectors;
        private Mat dxx;
        private Mat dxy;
        private Mat dxz;
        private Mat dyy;
        private Mat dyz;
        private Mat dzz;
        private EigenSymm3 eigen;
        private Mat sortedByAbs;

        Hessian3D(Mat dxx, Mat dxy, Mat dxz, Mat dyy, Mat dyz, Mat dzz, boolean doEigenvectors) {
            this.dxx = dxx;
            this.dxy = dxy;
            this.dxz = dxz;
            this.dyy = dyy;
            this.dyz = dyz;
            this.dzz = dzz;
            this.doEigenvectors = doEigenvectors;
        }

        @Override
        public Mat getLaplacian() {
            return opencv_core.add((MatExpr)opencv_core.add((Mat)this.dxx, (Mat)this.dyy), (Mat)this.dzz).asMat();
        }

        private void ensureEigenvalues() {
            if (this.eigen == null) {
                this.eigen = new EigenSymm3(this.dxx, this.dxy, this.dxz, this.dyy, this.dyz, this.dzz, this.doEigenvectors);
            }
        }

        private Mat getSortedByAbsInds() {
            if (this.sortedByAbs == null) {
                this.sortedByAbs = MultiscaleFeatures.sortedIndsByAbsoluteValue(this.getEigenvalues(false));
            }
            return this.sortedByAbs;
        }

        @Override
        public List<Mat> getEigenvectors(boolean sortByAbs) {
            this.ensureEigenvalues();
            if (this.eigen.eigvecMax == null) {
                throw new UnsupportedOperationException("Eigenvectors were not calculated!");
            }
            List<Mat> list = Arrays.asList(this.eigen.eigvecMax, this.eigen.eigvecMiddle, this.eigen.eigvecMin);
            if (sortByAbs) {
                return MultiscaleFeatures.applySortedIndsToElements(list, this.getSortedByAbsInds());
            }
            return list;
        }

        @Override
        public List<Mat> getEigenvalues(boolean sortByAbs) {
            this.ensureEigenvalues();
            List<Mat> list = Arrays.asList(this.eigen.eigvalMax, this.eigen.eigvalMiddle, this.eigen.eigvalMin);
            if (sortByAbs) {
                return MultiscaleFeatures.applySortedIndsToElements(list, this.getSortedByAbsInds());
            }
            return list;
        }

        @Override
        public Mat getDeterminant() {
            this.ensureEigenvalues();
            return this.eigen.eigvalMin.mul(this.eigen.eigvalMiddle).mul(this.eigen.eigvalMax).asMat();
        }

        @Override
        public void close() {
            this.dxx.close();
            this.dxy.close();
            this.dxz.close();
            this.dyy.close();
            this.dyz.close();
            this.dzz.close();
            if (this.eigen != null) {
                this.eigen.close();
            }
        }
    }

    public static class Hessian2D
    implements Hessian {
        private boolean doEigenvectors;
        private Mat dxx;
        private Mat dxy;
        private Mat dyy;
        private EigenSymm2 eigen;
        private Mat sortedByAbs;

        Hessian2D(Mat dxx, Mat dxy, Mat dyy, boolean doEigenvectors) {
            this.dxx = dxx;
            this.dxy = dxy;
            this.dyy = dyy;
            this.doEigenvectors = doEigenvectors;
        }

        @Override
        public Mat getLaplacian() {
            return opencv_core.add((Mat)this.dxx, (Mat)this.dyy).asMat();
        }

        private void ensureEigenvalues() {
            if (this.eigen == null) {
                this.eigen = new EigenSymm2(this.dxx, this.dxy, this.dyy, this.doEigenvectors);
            }
        }

        private Mat getSortedByAbsInds() {
            if (this.sortedByAbs == null) {
                this.sortedByAbs = MultiscaleFeatures.sortedIndsByAbsoluteValue(this.getEigenvalues(false));
            }
            return this.sortedByAbs;
        }

        @Override
        public List<Mat> getEigenvectors(boolean sortByAbs) {
            this.ensureEigenvalues();
            if (this.eigen.eigvecMax == null) {
                throw new UnsupportedOperationException("Eigenvectors were not calculated!");
            }
            List<Mat> list = Arrays.asList(this.eigen.eigvecMax, this.eigen.eigvecMin);
            if (sortByAbs) {
                return MultiscaleFeatures.applySortedIndsToElements(list, this.getSortedByAbsInds());
            }
            return list;
        }

        @Override
        public List<Mat> getEigenvalues(boolean sortByAbs) {
            this.ensureEigenvalues();
            List<Mat> list = Arrays.asList(this.eigen.eigvalMax, this.eigen.eigvalMin);
            if (sortByAbs) {
                return MultiscaleFeatures.applySortedIndsToElements(list, this.getSortedByAbsInds());
            }
            return list;
        }

        @Override
        public Mat getDeterminant() {
            return EigenSymm2.getDeterminantExpr2x2(this.dxx, this.dxy, this.dyy).asMat();
        }

        @Override
        public void close() {
            this.dxx.close();
            this.dxy.close();
            this.dyy.close();
            if (this.eigen != null) {
                this.eigen.close();
            }
        }
    }

    public static interface Hessian
    extends AutoCloseable {
        public Mat getLaplacian();

        public Mat getDeterminant();

        public List<Mat> getEigenvalues(boolean var1);

        public List<Mat> getEigenvectors(boolean var1);
    }

    public static class MultiscaleResultsBuilder {
        private PixelCalibration pixelCalibration = PixelCalibration.getDefaultInstance();
        private double downsampleXY = 1.0;
        private double sigmaX = 1.0;
        private double sigmaY = 1.0;
        private double sigmaZ = 0.0;
        private boolean gaussianSmoothed = false;
        private boolean weightedStdDev = false;
        private boolean gradientMagnitude = false;
        private boolean structureTensorEigenvalues = false;
        private boolean laplacianOfGaussian = false;
        private boolean hessianEigenvalues = false;
        private boolean hessianDeterminant = false;
        private boolean retainHessian = false;
        private int paddingXY = 0;
        private int border = BORDER_DEFAULT.getOpenCVCode();

        public MultiscaleResultsBuilder() {
        }

        public MultiscaleResultsBuilder(Collection<MultiscaleFeature> features) {
            for (MultiscaleFeature feature : features) {
                switch (feature.ordinal()) {
                    case 0: {
                        this.gaussianSmoothed(true);
                        break;
                    }
                    case 3: {
                        this.gradientMagnitude(true);
                        break;
                    }
                    case 8: {
                        this.hessianDeterminant(true);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        this.hessianEigenvalues(true);
                        break;
                    }
                    case 1: {
                        this.laplacianOfGaussian(true);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.structureTensorEigenvalues(true);
                        break;
                    }
                    case 2: {
                        this.weightedStdDev(true);
                        break;
                    }
                }
            }
        }

        MultiscaleResultsBuilder(MultiscaleResultsBuilder builder) {
            this.pixelCalibration = builder.pixelCalibration;
            this.downsampleXY = builder.downsampleXY;
            this.sigmaX = builder.sigmaX;
            this.sigmaY = builder.sigmaY;
            this.sigmaZ = builder.sigmaZ;
            this.paddingXY = builder.paddingXY;
            this.gaussianSmoothed = builder.gaussianSmoothed;
            this.gradientMagnitude = builder.gradientMagnitude;
            this.structureTensorEigenvalues = builder.structureTensorEigenvalues;
            this.laplacianOfGaussian = builder.laplacianOfGaussian;
            this.hessianEigenvalues = builder.hessianEigenvalues;
            this.hessianDeterminant = builder.hessianDeterminant;
            this.border = builder.border;
        }

        public MultiscaleResultsBuilder gaussianSmoothed(boolean calculate) {
            this.gaussianSmoothed = calculate;
            return this;
        }

        public MultiscaleResultsBuilder paddingXY(int padding) {
            this.paddingXY = padding;
            return this;
        }

        public MultiscaleResultsBuilder weightedStdDev(boolean calculate) {
            this.weightedStdDev = calculate;
            return this;
        }

        public MultiscaleResultsBuilder gradientMagnitude(boolean calculate) {
            this.gradientMagnitude = calculate;
            return this;
        }

        public MultiscaleResultsBuilder structureTensorEigenvalues(boolean calculate) {
            this.structureTensorEigenvalues = calculate;
            return this;
        }

        public MultiscaleResultsBuilder laplacianOfGaussian(boolean calculate) {
            this.laplacianOfGaussian = calculate;
            return this;
        }

        public MultiscaleResultsBuilder hessianEigenvalues(boolean calculate) {
            this.hessianEigenvalues = calculate;
            return this;
        }

        public MultiscaleResultsBuilder retainHessian(boolean retain) {
            this.retainHessian = retain;
            return this;
        }

        public MultiscaleResultsBuilder hessianDeterminant(boolean calculate) {
            this.hessianDeterminant = calculate;
            return this;
        }

        public MultiscaleResultsBuilder pixelCalibration(PixelCalibration cal, double downsampleXY) {
            this.pixelCalibration = cal;
            this.downsampleXY = downsampleXY;
            return this;
        }

        public MultiscaleResultsBuilder sigmaXY(double sigma) {
            this.sigmaX = sigma;
            this.sigmaY = sigma;
            return this;
        }

        public MultiscaleResultsBuilder sigmaX(double sigma) {
            this.sigmaX = sigma;
            return this;
        }

        public MultiscaleResultsBuilder sigmaY(double sigma) {
            this.sigmaY = sigma;
            return this;
        }

        public MultiscaleResultsBuilder sigmaZ(double sigma) {
            this.sigmaZ = sigma;
            return this;
        }

        public FeatureMap build(Mat mat) {
            if (this.sigmaZ > 0.0) {
                return this.build3D(Collections.singletonList(mat), 0).get(0);
            }
            return this.build2D(Arrays.asList(mat)).get(0);
        }

        public FeatureMap build(List<Mat> mats, int ind) {
            if (this.sigmaZ > 0.0) {
                return this.build3D(mats, ind).getFirst();
            }
            return this.build2D(Collections.singletonList(mats.get(ind))).getFirst();
        }

        public List<FeatureMap> build(List<Mat> mats) {
            if (this.sigmaZ > 0.0) {
                return this.build3D(mats, -1);
            }
            return this.build2D(mats);
        }

        private Mat stripPadding(Mat mat) {
            if (this.paddingXY == 0) {
                return mat;
            }
            Mat mat2 = mat.apply(new Rect(this.paddingXY, this.paddingXY, mat.cols() - this.paddingXY * 2, mat.rows() - this.paddingXY * 2)).clone();
            mat.put(mat2);
            mat2.close();
            return mat;
        }

        private List<FeatureMap> build2D(List<Mat> mats) {
            ArrayList<FeatureMap> results = new ArrayList<FeatureMap>();
            double sigmaX = this.sigmaX;
            double sigmaY = this.sigmaY;
            if (this.pixelCalibration.hasPixelSizeMicrons()) {
                sigmaX /= this.pixelCalibration.getPixelWidthMicrons() * this.downsampleXY;
                sigmaY /= this.pixelCalibration.getPixelHeightMicrons() * this.downsampleXY;
            }
            Mat kx0 = OpenCVTools.getGaussianDerivKernel(sigmaX, 0, false);
            Mat kx1 = OpenCVTools.getGaussianDerivKernel(sigmaX, 1, false);
            Mat kx2 = OpenCVTools.getGaussianDerivKernel(sigmaX, 2, false);
            Mat ky0 = OpenCVTools.getGaussianDerivKernel(sigmaY, 0, true);
            Mat ky1 = OpenCVTools.getGaussianDerivKernel(sigmaY, 1, true);
            Mat ky2 = OpenCVTools.getGaussianDerivKernel(sigmaY, 2, true);
            Mat dxx = new Mat();
            Mat dxy = new Mat();
            Mat dyy = new Mat();
            boolean doSmoothed = this.weightedStdDev || this.gaussianSmoothed;
            boolean doHessian = this.hessianDeterminant || this.hessianEigenvalues || this.laplacianOfGaussian;
            Hessian2D hessian = null;
            int depth = mats.stream().allMatch(m -> m.depth() == 6) ? 6 : 5;
            for (Mat mat : mats) {
                Object temp;
                LinkedHashMap<MultiscaleFeature, Mat> features = new LinkedHashMap<MultiscaleFeature, Mat>();
                Mat matSmooth = null;
                if (doSmoothed) {
                    if (sigmaX > 0.0 || sigmaY > 0.0) {
                        matSmooth = new Mat();
                        opencv_imgproc.sepFilter2D((Mat)mat, (Mat)matSmooth, (int)depth, (Mat)kx0, (Mat)ky0, null, (double)0.0, (int)this.border);
                    } else {
                        matSmooth = mat.clone();
                    }
                    this.stripPadding(matSmooth);
                    if (this.gaussianSmoothed) {
                        features.put(MultiscaleFeature.GAUSSIAN, matSmooth);
                    }
                    if (this.weightedStdDev) {
                        Mat matSquaredSmoothed = mat.mul(mat).asMat();
                        opencv_imgproc.sepFilter2D((Mat)matSquaredSmoothed, (Mat)matSquaredSmoothed, (int)depth, (Mat)kx0, (Mat)ky0, null, (double)0.0, (int)this.border);
                        this.stripPadding(matSquaredSmoothed);
                        matSquaredSmoothed.put(opencv_core.subtract((Mat)matSquaredSmoothed, (MatExpr)matSmooth.mul(matSmooth)));
                        opencv_core.sqrt((Mat)matSquaredSmoothed, (Mat)matSquaredSmoothed);
                        features.put(MultiscaleFeature.WEIGHTED_STD_DEV, matSquaredSmoothed);
                    }
                }
                if (this.structureTensorEigenvalues) {
                    opencv_imgproc.Sobel((Mat)mat, (Mat)dxx, (int)depth, (int)1, (int)0);
                    opencv_imgproc.Sobel((Mat)mat, (Mat)dyy, (int)depth, (int)0, (int)1);
                    dxy.put(dxx.mul(dyy));
                    dxx.put(dxx.mul(dxx));
                    dyy.put(dyy.mul(dyy));
                    opencv_imgproc.sepFilter2D((Mat)dxx, (Mat)dxx, (int)depth, (Mat)kx0, (Mat)ky0, null, (double)0.0, (int)this.border);
                    opencv_imgproc.sepFilter2D((Mat)dyy, (Mat)dyy, (int)depth, (Mat)kx0, (Mat)ky0, null, (double)0.0, (int)this.border);
                    opencv_imgproc.sepFilter2D((Mat)dxy, (Mat)dxy, (int)depth, (Mat)kx0, (Mat)ky0, null, (double)0.0, (int)this.border);
                    temp = new EigenSymm2(dxx, dxy, dyy, false);
                    Mat stMax = this.stripPadding(temp.eigvalMax);
                    Mat stMin = this.stripPadding(temp.eigvalMin);
                    Mat coherence = MultiscaleFeatures.calculateCoherence(stMax, stMin);
                    features.put(MultiscaleFeature.STRUCTURE_TENSOR_EIGENVALUE_MAX, stMax);
                    features.put(MultiscaleFeature.STRUCTURE_TENSOR_EIGENVALUE_MIN, stMin);
                    features.put(MultiscaleFeature.STRUCTURE_TENSOR_COHERENCE, coherence);
                }
                if (this.gradientMagnitude) {
                    opencv_imgproc.sepFilter2D((Mat)mat, (Mat)dxx, (int)depth, (Mat)kx1, (Mat)ky0, null, (double)0.0, (int)this.border);
                    opencv_imgproc.sepFilter2D((Mat)mat, (Mat)dyy, (int)depth, (Mat)kx0, (Mat)ky1, null, (double)0.0, (int)this.border);
                    Mat magnitude = new Mat();
                    opencv_core.magnitude((Mat)dxx, (Mat)dyy, (Mat)magnitude);
                    features.put(MultiscaleFeature.GRADIENT_MAGNITUDE, this.stripPadding(magnitude));
                }
                if (doHessian) {
                    opencv_imgproc.sepFilter2D((Mat)mat, (Mat)dxx, (int)depth, (Mat)kx2, (Mat)ky0, null, (double)0.0, (int)this.border);
                    opencv_imgproc.sepFilter2D((Mat)mat, (Mat)dyy, (int)depth, (Mat)kx0, (Mat)ky2, null, (double)0.0, (int)this.border);
                    opencv_imgproc.sepFilter2D((Mat)mat, (Mat)dxy, (int)depth, (Mat)kx1, (Mat)ky1, null, (double)0.0, (int)this.border);
                    this.stripPadding(dxx);
                    this.stripPadding(dxy);
                    this.stripPadding(dyy);
                    hessian = new Hessian2D(dxx, dxy, dyy, this.retainHessian);
                    if (this.laplacianOfGaussian) {
                        temp = hessian.getLaplacian();
                        features.put(MultiscaleFeature.LAPLACIAN, (Mat)temp);
                    }
                    if (this.hessianDeterminant) {
                        temp = hessian.getDeterminant();
                        features.put(MultiscaleFeature.HESSIAN_DETERMINANT, (Mat)temp);
                    }
                    if (this.hessianEigenvalues) {
                        List<Mat> eigenvalues = hessian.getEigenvalues(false);
                        assert (eigenvalues.size() == 2);
                        features.put(MultiscaleFeature.HESSIAN_EIGENVALUE_MAX, eigenvalues.get(0));
                        features.put(MultiscaleFeature.HESSIAN_EIGENVALUE_MIN, eigenvalues.get(1));
                    }
                }
                if (depth != 5) {
                    for (Mat matFeature : features.values()) {
                        matFeature.convertTo(matFeature, 5);
                    }
                }
                results.add(new FeatureMap(features, this.retainHessian ? hessian : null));
            }
            if (dxx != null) {
                dxx.close();
            }
            if (dxy != null) {
                dxy.close();
            }
            if (dyy != null) {
                dyy.close();
            }
            kx0.close();
            kx1.close();
            kx2.close();
            ky0.close();
            ky1.close();
            ky2.close();
            return results;
        }

        static Mat ensureDepth(Mat mat, int requestedDepth) {
            int depth = mat.depth();
            if (depth == requestedDepth) {
                return mat;
            }
            Mat out = new Mat();
            mat.convertTo(out, requestedDepth);
            return out;
        }

        private List<FeatureMap> build3D(List<Mat> mats, int ind3D) {
            if (mats.size() == 0) {
                return Collections.emptyList();
            }
            int depth = mats.stream().allMatch(m -> m.depth() == 6) ? 6 : 5;
            mats = mats.stream().map(m -> MultiscaleResultsBuilder.ensureDepth(m, depth)).toList();
            double sigmaX = this.sigmaX;
            double sigmaY = this.sigmaY;
            double sigmaZ = this.sigmaZ;
            if (this.pixelCalibration.hasPixelSizeMicrons()) {
                sigmaX /= this.pixelCalibration.getPixelWidthMicrons() * this.downsampleXY;
                sigmaY /= this.pixelCalibration.getPixelHeightMicrons() * this.downsampleXY;
            }
            if (this.pixelCalibration.hasZSpacingMicrons()) {
                sigmaZ /= this.pixelCalibration.getZSpacingMicrons();
            }
            boolean doSmoothed = this.weightedStdDev || this.gaussianSmoothed;
            boolean doHessian = this.hessianDeterminant || this.hessianEigenvalues || this.laplacianOfGaussian;
            Mat kx0 = OpenCVTools.getGaussianDerivKernel(sigmaX, 0, false);
            Mat kx1 = OpenCVTools.getGaussianDerivKernel(sigmaX, 1, false);
            Mat kx2 = OpenCVTools.getGaussianDerivKernel(sigmaX, 2, false);
            Mat ky0 = OpenCVTools.getGaussianDerivKernel(sigmaY, 0, true);
            Mat ky1 = OpenCVTools.getGaussianDerivKernel(sigmaY, 1, true);
            Mat ky2 = OpenCVTools.getGaussianDerivKernel(sigmaY, 2, true);
            Mat kz0 = OpenCVTools.getGaussianDerivKernel(sigmaZ, 0, true);
            Mat kz1 = OpenCVTools.getGaussianDerivKernel(sigmaZ, 1, true);
            Mat kz2 = OpenCVTools.getGaussianDerivKernel(sigmaZ, 2, true);
            List<Mat> matsZ0 = null;
            if (doSmoothed || this.gradientMagnitude || doHessian) {
                matsZ0 = OpenCVTools.filterZ(mats, kz0, ind3D, this.border);
            }
            List<Mat> matsZ1 = null;
            if (doHessian || this.gradientMagnitude) {
                matsZ1 = OpenCVTools.filterZ(mats, kz1, ind3D, this.border);
            }
            List<Mat> matsZ2 = null;
            if (doHessian) {
                matsZ2 = OpenCVTools.filterZ(mats, kz2, ind3D, this.border);
            }
            List<Mat> matSTxx = null;
            List<Mat> matSTxy = null;
            List<Mat> matSTxz = null;
            List<Mat> matSTyy = null;
            List<Mat> matSTyz = null;
            List<Mat> matSTzz = null;
            if (this.structureTensorEigenvalues) {
                matSTxx = new ArrayList<Mat>();
                matSTxy = new ArrayList<Mat>();
                matSTxz = new ArrayList<Mat>();
                matSTyy = new ArrayList<Mat>();
                matSTyz = new ArrayList<Mat>();
                matSTzz = new ArrayList<Mat>();
                for (int i = 0; i < mats.size(); ++i) {
                    Mat tempX = new Mat();
                    Mat tempY = new Mat();
                    Mat tempZ = new Mat();
                    Mat mat = mats.get(i);
                    opencv_imgproc.Sobel((Mat)mat, (Mat)tempX, (int)depth, (int)1, (int)0);
                    opencv_imgproc.Sobel((Mat)mat, (Mat)tempY, (int)depth, (int)0, (int)1);
                    int iNext = Math.min(i + 1, mats.size() - 1);
                    int iPrev = Math.max(i - 1, 0);
                    opencv_core.subtract((Mat)mats.get(iNext), (Mat)mats.get(iPrev), (Mat)tempZ);
                    matSTxy.add(tempX.mul(tempY).asMat());
                    matSTxz.add(tempX.mul(tempZ).asMat());
                    matSTyz.add(tempY.mul(tempZ).asMat());
                    tempX.put(tempX.mul(tempX));
                    matSTxx.add(tempX);
                    tempY.put(tempY.mul(tempY));
                    matSTyy.add(tempY);
                    tempZ.put(tempZ.mul(tempZ));
                    matSTzz.add(tempZ);
                }
                matSTxx = OpenCVTools.filterZ(matSTxx, kz0, ind3D, this.border);
                matSTxy = OpenCVTools.filterZ(matSTxy, kz0, ind3D, this.border);
                matSTxz = OpenCVTools.filterZ(matSTxz, kz0, ind3D, this.border);
                matSTyy = OpenCVTools.filterZ(matSTyy, kz0, ind3D, this.border);
                matSTyz = OpenCVTools.filterZ(matSTyz, kz0, ind3D, this.border);
                matSTzz = OpenCVTools.filterZ(matSTzz, kz0, ind3D, this.border);
                for (List list : Arrays.asList(matSTxx, matSTxy, matSTxz, matSTyy, matSTyz, matSTzz)) {
                    for (Mat temp : list) {
                        opencv_imgproc.sepFilter2D((Mat)temp, (Mat)temp, (int)depth, (Mat)kx0, (Mat)ky0, null, (double)0.0, (int)this.border);
                    }
                }
            }
            int nSlices = ind3D >= 0 ? 1 : mats.size();
            List<Mat> matsSquaredZ0 = null;
            if (this.weightedStdDev) {
                matsSquaredZ0 = new ArrayList<Mat>();
                for (Mat mat : mats) {
                    matsSquaredZ0.add(mat.mul(mat).asMat());
                }
                matsSquaredZ0 = OpenCVTools.filterZ(matsSquaredZ0, kz0, ind3D, this.border);
            }
            Mat dxx = new Mat();
            Mat dxy = new Mat();
            Mat dxz = new Mat();
            Mat dyy = new Mat();
            Mat dyz = new Mat();
            Mat dzz = new Mat();
            Hessian3D hessian = null;
            ArrayList<FeatureMap> output = new ArrayList<FeatureMap>();
            for (int i = 0; i < nSlices; ++i) {
                Mat z1;
                Mat z0;
                LinkedHashMap<MultiscaleFeature, Mat> features = new LinkedHashMap<MultiscaleFeature, Mat>();
                if (doSmoothed) {
                    z0 = matsZ0.get(i);
                    Mat matSmooth = new Mat();
                    opencv_imgproc.sepFilter2D((Mat)z0, (Mat)matSmooth, (int)depth, (Mat)kx0, (Mat)ky0, null, (double)0.0, (int)this.border);
                    this.stripPadding(matSmooth);
                    if (this.gaussianSmoothed) {
                        features.put(MultiscaleFeature.GAUSSIAN, matSmooth);
                    }
                    if (this.weightedStdDev) {
                        Mat matSquaredSmoothed = matsSquaredZ0.get(i);
                        opencv_imgproc.sepFilter2D((Mat)matSquaredSmoothed, (Mat)matSquaredSmoothed, (int)depth, (Mat)kx0, (Mat)ky0, null, (double)0.0, (int)this.border);
                        this.stripPadding(matSquaredSmoothed);
                        matSquaredSmoothed.put(opencv_core.subtract((Mat)matSquaredSmoothed, (MatExpr)matSmooth.mul(matSmooth)));
                        opencv_core.sqrt((Mat)matSquaredSmoothed, (Mat)matSquaredSmoothed);
                        features.put(MultiscaleFeature.WEIGHTED_STD_DEV, matSquaredSmoothed);
                    }
                }
                if (this.structureTensorEigenvalues) {
                    EigenSymm3 temp = new EigenSymm3(matSTxx.get(i), matSTxy.get(i), matSTxz.get(i), matSTyy.get(i), matSTyz.get(i), matSTzz.get(i), false);
                    Mat stMax = this.stripPadding(temp.eigvalMax);
                    Mat stMiddle = this.stripPadding(temp.eigvalMiddle);
                    Mat stMin = this.stripPadding(temp.eigvalMin);
                    Mat coherence = MultiscaleFeatures.calculateCoherence(stMax, stMiddle);
                    features.put(MultiscaleFeature.STRUCTURE_TENSOR_EIGENVALUE_MAX, stMax);
                    features.put(MultiscaleFeature.STRUCTURE_TENSOR_EIGENVALUE_MIDDLE, stMiddle);
                    features.put(MultiscaleFeature.STRUCTURE_TENSOR_EIGENVALUE_MIN, stMin);
                    features.put(MultiscaleFeature.STRUCTURE_TENSOR_COHERENCE, coherence);
                }
                if (this.gradientMagnitude) {
                    z0 = matsZ0.get(i);
                    z1 = matsZ1.get(i);
                    opencv_imgproc.sepFilter2D((Mat)z0, (Mat)dxx, (int)depth, (Mat)kx1, (Mat)ky0, null, (double)0.0, (int)this.border);
                    opencv_imgproc.sepFilter2D((Mat)z0, (Mat)dyy, (int)depth, (Mat)kx0, (Mat)ky1, null, (double)0.0, (int)this.border);
                    opencv_imgproc.sepFilter2D((Mat)z1, (Mat)dzz, (int)depth, (Mat)kx0, (Mat)ky0, null, (double)0.0, (int)this.border);
                    Mat magnitude = opencv_core.add((MatExpr)opencv_core.add((MatExpr)dxx.mul(dxx), (MatExpr)dyy.mul(dyy)), (MatExpr)dzz.mul(dzz)).asMat();
                    features.put(MultiscaleFeature.GRADIENT_MAGNITUDE, this.stripPadding(magnitude));
                }
                if (doHessian) {
                    z0 = matsZ0.get(i);
                    z1 = matsZ1.get(i);
                    Mat z2 = matsZ2.get(i);
                    opencv_imgproc.sepFilter2D((Mat)z0, (Mat)dxx, (int)depth, (Mat)kx2, (Mat)ky0, null, (double)0.0, (int)this.border);
                    opencv_imgproc.sepFilter2D((Mat)z0, (Mat)dxy, (int)depth, (Mat)kx1, (Mat)ky1, null, (double)0.0, (int)this.border);
                    opencv_imgproc.sepFilter2D((Mat)z1, (Mat)dxz, (int)depth, (Mat)kx1, (Mat)ky0, null, (double)0.0, (int)this.border);
                    opencv_imgproc.sepFilter2D((Mat)z0, (Mat)dyy, (int)depth, (Mat)kx0, (Mat)ky2, null, (double)0.0, (int)this.border);
                    opencv_imgproc.sepFilter2D((Mat)z1, (Mat)dyz, (int)depth, (Mat)kx0, (Mat)ky1, null, (double)0.0, (int)this.border);
                    opencv_imgproc.sepFilter2D((Mat)z2, (Mat)dzz, (int)depth, (Mat)kx0, (Mat)ky0, null, (double)0.0, (int)this.border);
                    this.stripPadding(dxx);
                    this.stripPadding(dxy);
                    this.stripPadding(dxz);
                    this.stripPadding(dyy);
                    this.stripPadding(dyz);
                    this.stripPadding(dzz);
                    hessian = this.retainHessian ? new Hessian3D(dxx.clone(), dxy.clone(), dxz.clone(), dyy.clone(), dyz.clone(), dzz.clone(), true) : new Hessian3D(dxx, dxy, dxz, dyy, dyz, dzz, false);
                    if (this.laplacianOfGaussian) {
                        features.put(MultiscaleFeature.LAPLACIAN, hessian.getLaplacian());
                    }
                    if (this.hessianDeterminant) {
                        features.put(MultiscaleFeature.HESSIAN_DETERMINANT, hessian.getDeterminant());
                    }
                    if (this.hessianEigenvalues) {
                        List<Mat> eigenvalues = hessian.getEigenvalues(false);
                        assert (eigenvalues.size() == 3);
                        features.put(MultiscaleFeature.HESSIAN_EIGENVALUE_MAX, eigenvalues.get(0));
                        features.put(MultiscaleFeature.HESSIAN_EIGENVALUE_MIDDLE, eigenvalues.get(1));
                        features.put(MultiscaleFeature.HESSIAN_EIGENVALUE_MIN, eigenvalues.get(2));
                    }
                }
                output.add(new FeatureMap(features, this.retainHessian ? hessian : null));
            }
            dxx.close();
            dxy.close();
            dxz.close();
            dyz.close();
            dyy.close();
            dzz.close();
            return output;
        }

        public static class FeatureMap
        extends AbstractMap<MultiscaleFeature, Mat>
        implements Map<MultiscaleFeature, Mat> {
            private Hessian hessian;
            private Map<MultiscaleFeature, Mat> features;

            private FeatureMap(Map<MultiscaleFeature, Mat> features, Hessian hessian) {
                this.features = features;
                this.hessian = hessian;
            }

            public Hessian getHessian() {
                return this.hessian;
            }

            @Override
            public Set<Map.Entry<MultiscaleFeature, Mat>> entrySet() {
                return this.features.entrySet();
            }
        }
    }

    public static enum MultiscaleFeature {
        GAUSSIAN,
        LAPLACIAN,
        WEIGHTED_STD_DEV,
        GRADIENT_MAGNITUDE,
        STRUCTURE_TENSOR_EIGENVALUE_MAX,
        STRUCTURE_TENSOR_EIGENVALUE_MIDDLE,
        STRUCTURE_TENSOR_EIGENVALUE_MIN,
        STRUCTURE_TENSOR_COHERENCE,
        HESSIAN_DETERMINANT,
        HESSIAN_EIGENVALUE_MAX,
        HESSIAN_EIGENVALUE_MIDDLE,
        HESSIAN_EIGENVALUE_MIN;


        public boolean supports2D() {
            return this != HESSIAN_EIGENVALUE_MIDDLE && this != STRUCTURE_TENSOR_EIGENVALUE_MIDDLE;
        }

        public boolean supports3D() {
            return true;
        }

        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "Gaussian";
                }
                case 3: {
                    return "Gradient magnitude";
                }
                case 8: {
                    return "Hessian determinant";
                }
                case 9: {
                    return "Hessian max eigenvalue";
                }
                case 10: {
                    return "Hessian middle eigenvalue";
                }
                case 11: {
                    return "Hessian min eigenvalue";
                }
                case 1: {
                    return "Laplacian of Gaussian";
                }
                case 2: {
                    return "Weighted deviation";
                }
                case 7: {
                    return "Structure tensor coherence";
                }
                case 4: {
                    return "Structure tensor max eigenvalue";
                }
                case 5: {
                    return "Structure tensor middle eigenvalue";
                }
                case 6: {
                    return "Structure tensor min eigenvalue";
                }
            }
            return super.toString();
        }
    }
}

