/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.PixelCalibration;
import qupath.opencv.tools.OpenCVTools;

public class LocalNormalization {
    public static void gaussianNormalize(List<Mat> stack, LocalNormalizationType type, PixelCalibration cal, int border) {
        double sigmaX = type.scale.getSigma();
        double sigmaY = type.scale.getSigma();
        double sigmaZ = type.scale.getSigmaZ(cal);
        double sigmaVarianceX = 0.0;
        double sigmaVarianceY = 0.0;
        double sigmaVarianceZ = 0.0;
        if (type.scaleVariance != null) {
            sigmaVarianceX = type.scaleVariance.getSigma();
            sigmaVarianceY = type.scaleVariance.getSigma();
            sigmaVarianceZ = type.scaleVariance.getSigmaZ(cal);
        }
        LocalNormalization.gaussianNormalize3D(stack, sigmaX, sigmaY, sigmaZ, sigmaVarianceX, sigmaVarianceY, sigmaVarianceZ, border);
    }

    public static void gaussianNormalize2D(Mat mat, double sigma, double sigmaVariance, int border) {
        LocalNormalizationType type = LocalNormalizationType.getInstance(SmoothingScale.get2D(sigma), sigmaVariance > 0.0 ? SmoothingScale.get2D(sigmaVariance) : null);
        LocalNormalization.gaussianNormalize(Collections.singletonList(mat), type, PixelCalibration.getDefaultInstance(), border);
    }

    public static void gaussianNormalize3D(List<Mat> stack, double sigmaX, double sigmaY, double sigmaZ, double varianceSigmaX, double varianceSigmaY, double varianceSigmaZ, int border) {
        List<Mat> stackSmoothed;
        int inputDepth = stack.get(0).depth();
        int depth = 6;
        Mat kx = OpenCVTools.getGaussianDerivKernel(sigmaX, 0, false);
        Mat ky = OpenCVTools.getGaussianDerivKernel(sigmaY, 0, true);
        Mat kz = OpenCVTools.getGaussianDerivKernel(sigmaZ, 0, false);
        boolean doVariance = varianceSigmaX > 0.0 || varianceSigmaY > 0.0 || varianceSigmaZ > 0.0;
        Mat kx2 = kx;
        Mat ky2 = ky;
        Mat kz2 = kz;
        if (doVariance) {
            kx2 = OpenCVTools.getGaussianDerivKernel(varianceSigmaX, 0, false);
            ky2 = OpenCVTools.getGaussianDerivKernel(varianceSigmaY, 0, true);
            kz2 = OpenCVTools.getGaussianDerivKernel(varianceSigmaZ, 0, false);
        }
        List<Mat> stackSquared = new ArrayList<Mat>();
        for (Mat mat : stack) {
            mat.convertTo(mat, depth);
            if (!doVariance) continue;
            stackSquared.add(mat.mul(mat).asMat());
        }
        if (sigmaZ > 0.0) {
            stackSmoothed = OpenCVTools.filterZ(stack, kz, -1, border);
            if (doVariance) {
                stackSquared = OpenCVTools.filterZ(stackSquared, kz2, -1, border);
            }
        } else {
            stackSmoothed = stack.stream().map(m -> m.clone()).toList();
        }
        for (int i = 0; i < stack.size(); ++i) {
            Mat mat = stack.get(i);
            Mat matSmooth = stackSmoothed.get(i);
            opencv_imgproc.sepFilter2D((Mat)matSmooth, (Mat)matSmooth, (int)depth, (Mat)kx, (Mat)ky, null, (double)0.0, (int)border);
            opencv_core.subtract((Mat)mat, (Mat)matSmooth, (Mat)mat);
            if (doVariance) {
                matSmooth.put(matSmooth.mul(matSmooth));
                Mat matSquaredSmooth = stackSquared.get(i);
                opencv_imgproc.sepFilter2D((Mat)matSquaredSmooth, (Mat)matSquaredSmooth, (int)depth, (Mat)kx2, (Mat)ky2, null, (double)0.0, (int)border);
                opencv_core.subtract((Mat)matSquaredSmooth, (Mat)matSmooth, (Mat)matSmooth);
                opencv_core.sqrt((Mat)matSmooth, (Mat)matSmooth);
                opencv_core.divide((Mat)mat, (Mat)matSmooth, (Mat)mat);
                matSquaredSmooth.close();
            }
            matSmooth.close();
        }
        if (inputDepth != 6 && depth != 5) {
            for (Mat mat : stack) {
                mat.convertTo(mat, 5);
            }
        }
    }

    public static class LocalNormalizationType {
        public final SmoothingScale scale;
        public final SmoothingScale scaleVariance;

        private LocalNormalizationType(SmoothingScale scale, SmoothingScale scaleVariance) {
            this.scale = scale;
            this.scaleVariance = scaleVariance;
        }

        public static LocalNormalizationType getInstance(SmoothingScale scale, SmoothingScale scaleVariance) {
            Objects.requireNonNull(scale);
            return new LocalNormalizationType(scale, scaleVariance);
        }

        public static LocalNormalizationType getInstance(SmoothingScale scale, double varianceScaleRatio) {
            Objects.requireNonNull(scale);
            if (varianceScaleRatio <= 0.0) {
                return LocalNormalizationType.getInstance(scale, null);
            }
            return LocalNormalizationType.getInstance(scale, SmoothingScale.getInstance(scale.scaleType, scale.getSigma() * varianceScaleRatio));
        }
    }

    public static class SmoothingScale {
        private final double sigma;
        private final ScaleType scaleType;

        private SmoothingScale(ScaleType scaleType, double sigma) {
            this.sigma = sigma;
            this.scaleType = scaleType;
        }

        public static SmoothingScale get2D(double sigma) {
            return SmoothingScale.getInstance(ScaleType.SCALE_2D, sigma);
        }

        public static SmoothingScale get3DAnisotropic(double sigma) {
            return SmoothingScale.getInstance(ScaleType.SCALE_3D, sigma);
        }

        public static SmoothingScale get3DIsotropic(double sigma) {
            return SmoothingScale.getInstance(ScaleType.SCALE_3D_ISOTROPIC, sigma);
        }

        static SmoothingScale getInstance(ScaleType scaleType, double sigma) {
            return new SmoothingScale(scaleType, sigma);
        }

        public double getSigma() {
            return this.sigma;
        }

        public double getSigmaZ(PixelCalibration cal) {
            switch (this.scaleType.ordinal()) {
                case 0: {
                    return 0.0;
                }
                case 1: {
                    return this.sigma;
                }
                case 2: {
                    double pixelSize = cal.getAveragedPixelSize().doubleValue();
                    double zSpacing = cal.getZSpacing().doubleValue();
                    if (!Double.isFinite(zSpacing)) {
                        zSpacing = 1.0;
                    }
                    return this.sigma / zSpacing * pixelSize;
                }
            }
            throw new IllegalArgumentException("Unknown smoothing scale " + this.sigma);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.scaleType == null ? 0 : this.scaleType.hashCode());
            long temp = Double.doubleToLongBits(this.sigma);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SmoothingScale other = (SmoothingScale)obj;
            if (this.scaleType != other.scaleType) {
                return false;
            }
            return Double.doubleToLongBits(this.sigma) == Double.doubleToLongBits(other.sigma);
        }

        public String toString() {
            String sigmaString = String.format("\u03c3: %s", GeneralTools.formatNumber((double)this.sigma, (int)2));
            switch (this.scaleType.ordinal()) {
                case 1: {
                    return sigmaString + " (3D)";
                }
                case 2: {
                    return sigmaString + " (3D isotropic)";
                }
            }
            return sigmaString;
        }
    }

    static enum ScaleType {
        SCALE_2D,
        SCALE_3D,
        SCALE_3D_ISOTROPIC;

    }

    public static enum NormalizationType {
        NONE,
        GAUSSIAN_MEAN_ONLY,
        GAUSSIAN_MEAN_VARIANCE;

    }
}

