/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.tools;

import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;

public class Interpolation {
    private static ThreadLocal<long[]> indsLocal = new ThreadLocal();

    public static double interp2D(Indexer indexer, double i, double j) {
        long yi = (long)Math.floor(i);
        long xi = (long)Math.floor(j);
        double fx0y0 = Interpolation.get(indexer, yi, xi);
        double fx0y1 = Interpolation.get(indexer, yi + 1L, xi);
        double fx1y1 = Interpolation.get(indexer, yi + 1L, xi + 1L);
        double fx1y0 = Interpolation.get(indexer, yi, xi + 1L);
        return Interpolation.linearInterp2D(fx0y0, fx1y0, fx0y1, fx1y1, j - (double)xi, i - (double)yi);
    }

    public static double interp3D(Indexer indexer, double i, double j, double k) {
        long xi = (long)Math.floor(j);
        long yi = (long)Math.floor(i);
        long zi = (long)Math.floor(k);
        return Interpolation.linearInterp3D(Interpolation.get(indexer, yi, xi, zi), Interpolation.get(indexer, yi, xi + 1L, zi), Interpolation.get(indexer, yi + 1L, xi, zi), Interpolation.get(indexer, yi + 1L, xi + 1L, zi), Interpolation.get(indexer, yi, xi, zi + 1L), Interpolation.get(indexer, yi, xi + 1L, zi + 1L), Interpolation.get(indexer, yi + 1L, xi, zi + 1L), Interpolation.get(indexer, yi + 1L, xi + 1L, zi + 1L), j - (double)xi, i - (double)yi, k - (double)zi);
    }

    private static double get(Indexer indexer, long i, long j, long k) {
        if (indexer instanceof FloatIndexer) {
            return Interpolation.get((FloatIndexer)indexer, i, j, k);
        }
        if (indexer instanceof UByteIndexer) {
            return Interpolation.get((UByteIndexer)indexer, i, j, k);
        }
        if (indexer instanceof UShortIndexer) {
            return Interpolation.get((UShortIndexer)indexer, i, j, k);
        }
        if (indexer instanceof DoubleIndexer) {
            return Interpolation.get((DoubleIndexer)indexer, i, j, k);
        }
        long[] inds = indsLocal.get();
        if (inds == null || inds.length != 3) {
            inds = new long[3];
            indsLocal.set(inds);
        }
        inds[0] = Interpolation.clipIndex(i, indexer.size(0));
        inds[1] = Interpolation.clipIndex(j, indexer.size(1));
        inds[2] = Interpolation.clipIndex(k, indexer.size(2));
        return indexer.getDouble(inds);
    }

    private static double get(Indexer indexer, long i, long j) {
        if (indexer instanceof FloatIndexer) {
            return Interpolation.get((FloatIndexer)indexer, i, j);
        }
        if (indexer instanceof UByteIndexer) {
            return Interpolation.get((UByteIndexer)indexer, i, j);
        }
        if (indexer instanceof UShortIndexer) {
            return Interpolation.get((UShortIndexer)indexer, i, j);
        }
        if (indexer instanceof DoubleIndexer) {
            return Interpolation.get((DoubleIndexer)indexer, i, j);
        }
        long[] inds = indsLocal.get();
        if (inds == null || inds.length != 2) {
            inds = new long[2];
            indsLocal.set(inds);
        }
        inds[0] = Interpolation.clipIndex(i, indexer.size(0));
        inds[1] = Interpolation.clipIndex(j, indexer.size(1));
        return indexer.getDouble(inds);
    }

    private static double get(UShortIndexer indexer, long i, long j, long k) {
        return indexer.get(Interpolation.clipIndex(i, indexer.size(0)), Interpolation.clipIndex(j, indexer.size(1)), Interpolation.clipIndex(k, indexer.size(2)));
    }

    private static double get(UShortIndexer indexer, long i, long j) {
        return indexer.get(Interpolation.clipIndex(i, indexer.size(0)), Interpolation.clipIndex(j, indexer.size(1)));
    }

    private static double get(DoubleIndexer indexer, long i, long j, long k) {
        return indexer.get(Interpolation.clipIndex(i, indexer.size(0)), Interpolation.clipIndex(j, indexer.size(1)), Interpolation.clipIndex(k, indexer.size(2)));
    }

    private static double get(DoubleIndexer indexer, long i, long j) {
        return indexer.get(Interpolation.clipIndex(i, indexer.size(0)), Interpolation.clipIndex(j, indexer.size(1)));
    }

    private static double get(UByteIndexer indexer, long i, long j, long k) {
        return indexer.get(Interpolation.clipIndex(i, indexer.size(0)), Interpolation.clipIndex(j, indexer.size(1)), Interpolation.clipIndex(k, indexer.size(2)));
    }

    private static double get(UByteIndexer indexer, long i, long j) {
        return indexer.get(Interpolation.clipIndex(i, indexer.size(0)), Interpolation.clipIndex(j, indexer.size(1)));
    }

    private static double get(FloatIndexer indexer, long i, long j, long k) {
        return indexer.get(Interpolation.clipIndex(i, indexer.size(0)), Interpolation.clipIndex(j, indexer.size(1)), Interpolation.clipIndex(k, indexer.size(2)));
    }

    private static double get(FloatIndexer indexer, long i, long j) {
        return indexer.get(Interpolation.clipIndex(i, indexer.size(0)), Interpolation.clipIndex(j, indexer.size(1)));
    }

    private static long clipIndex(long ind, long max) {
        if (ind < 0L) {
            return 0L;
        }
        if (ind >= max) {
            return max - 1L;
        }
        return ind;
    }

    private static double linearInterp1D(double fx0, double fx1, double x) {
        assert (x >= 0.0 && x <= 1.0);
        return fx0 * (1.0 - x) + x * fx1;
    }

    private static double linearInterp2D(double fx0y0, double fx1y0, double fx0y1, double fx1y1, double x, double y) {
        double y0 = Interpolation.linearInterp1D(fx0y0, fx1y0, x);
        double y1 = Interpolation.linearInterp1D(fx0y1, fx1y1, x);
        return Interpolation.linearInterp1D(y0, y1, y);
    }

    private static double linearInterp3D(double fx0y0z0, double fx1y0z0, double fx0y1z0, double fx1y1z0, double fx0y0z1, double fx1y0z1, double fx0y1z1, double fx1y1z1, double x, double y, double z) {
        double z0 = Interpolation.linearInterp2D(fx0y0z0, fx1y0z0, fx0y1z0, fx1y1z0, x, y);
        double z1 = Interpolation.linearInterp2D(fx0y0z1, fx1y0z1, fx0y1z1, fx1y1z1, x, y);
        return Interpolation.linearInterp1D(z0, z1, z);
    }
}

