/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.tools;

import ij.CompositeImage;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.List;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import qupath.imagej.tools.IJTools;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.opencv.ops.ImageOps;
import qupath.opencv.tools.OpenCVTools;

public class GroovyCV {
    public static double mean(Mat mat) {
        return OpenCVTools.mean(mat);
    }

    public static double sum(Mat mat) {
        return OpenCVTools.sum(mat);
    }

    public static double std(Mat mat) {
        return OpenCVTools.stdDev(mat);
    }

    public static double max(Mat mat) {
        return OpenCVTools.maximum(mat);
    }

    public static double min(Mat mat) {
        return OpenCVTools.minimum(mat);
    }

    public static Mat flatten(Mat mat) {
        return mat.reshape(1, mat.rows() * mat.cols() * mat.channels());
    }

    public static long[] shape(Mat mat) {
        try (Indexer indexer = mat.createIndexer();){
            long[] lArray = indexer.sizes();
            return lArray;
        }
    }

    public static Mat clip(Mat mat, double min, double max) {
        return GroovyCV.maximum(GroovyCV.minimum(mat, max), min);
    }

    public static Mat maximum(Mat m1, Mat m2) {
        return opencv_core.max((Mat)m1, (Mat)m2).asMat();
    }

    public static Mat maximum(Mat m1, double d) {
        return opencv_core.max((Mat)m1, (double)d).asMat();
    }

    public static Mat minimum(Mat m1, double d) {
        return opencv_core.min((Mat)m1, (double)d).asMat();
    }

    public static Mat minimum(Mat m1, Mat m2) {
        return opencv_core.min((Mat)m1, (Mat)m2).asMat();
    }

    public static Mat plus(Mat m1, Mat m2) {
        return opencv_core.add((Mat)m1, (Mat)m2).asMat();
    }

    public static Mat plus(Mat m1, Number s) {
        int c = OpenCVTools.typeToChannels(m1.type());
        return GroovyCV.plus(m1, OpenCVTools.scalarMatWithType(s.doubleValue(), opencv_core.CV_64FC((int)c)));
    }

    public static Mat plus(Mat m1, Scalar s) {
        return opencv_core.add((Mat)m1, (Scalar)s).asMat();
    }

    public static Mat minus(Mat m1, Mat m2) {
        return opencv_core.subtract((Mat)m1, (Mat)m2).asMat();
    }

    public static Mat minus(Mat m1, Number s) {
        int c = OpenCVTools.typeToChannels(m1.type());
        return GroovyCV.minus(m1, OpenCVTools.scalarMatWithType(s.doubleValue(), opencv_core.CV_64FC((int)c)));
    }

    public static Mat minus(Mat m1, Scalar s) {
        return opencv_core.subtract((Mat)m1, (Scalar)s).asMat();
    }

    public static Mat multiply(Mat m1, Mat m2) {
        return m1.mul(m2).asMat();
    }

    public static Mat multiply(Mat m1, double s) {
        int c = m1.channels();
        if (c == 1) {
            return opencv_core.multiply((Mat)m1, (double)s).asMat();
        }
        Mat m2 = new Mat();
        m1.convertTo(m2, m1.type(), s, 0.0);
        return m2;
    }

    public static Mat div(Mat m1, Mat m2) {
        return opencv_core.divide((Mat)m1, (Mat)m2).asMat();
    }

    public static Mat div(Mat m1, double s) {
        return GroovyCV.multiply(m1, 1.0 / s);
    }

    public static Mat abs(Mat mat) {
        if (mat.channels() <= 4) {
            return opencv_core.abs((Mat)mat).asMat();
        }
        Mat m2 = mat.clone();
        OpenCVTools.applyToChannels(m2, m -> m.put(opencv_core.abs((Mat)m)));
        return m2;
    }

    public static Mat negative(Mat m1) {
        return GroovyCV.multiply(m1, -1.0);
    }

    public static Mat or(Mat m1, Mat m2) {
        Mat dest = new Mat();
        opencv_core.bitwise_or((Mat)m1, (Mat)m2, (Mat)dest);
        return dest;
    }

    public static Mat and(Mat m1, Mat m2) {
        Mat dest = new Mat();
        opencv_core.bitwise_and((Mat)m1, (Mat)m2, (Mat)dest);
        return dest;
    }

    public static Mat xor(Mat m1, Mat m2) {
        Mat dest = new Mat();
        opencv_core.bitwise_xor((Mat)m1, (Mat)m2, (Mat)dest);
        return dest;
    }

    public static Mat bitwiseNegate(Mat m1) {
        Mat dest = new Mat();
        opencv_core.bitwise_not((Mat)m1, (Mat)dest);
        return dest;
    }

    public static Mat power(Mat m1, double power) {
        if (!Double.isFinite(power)) {
            throw new IllegalArgumentException("power does not support non-finite values!");
        }
        return ImageOps.Core.power(power).apply(m1.clone());
    }

    public static List<Mat> splitChannels(Mat mat) {
        return OpenCVTools.splitChannels(mat);
    }

    public static Mat gt(Mat m1, double threshold) {
        return opencv_core.greaterThan((Mat)m1, (double)threshold).asMat();
    }

    public static Mat gt(Mat m1, Mat m2) {
        return opencv_core.greaterThan((Mat)m1, (Mat)m2).asMat();
    }

    public static Mat eq(Mat m1, double value) {
        return opencv_core.equals((Mat)m1, (double)value).asMat();
    }

    public static Mat eq(Mat m1, Mat m2) {
        return opencv_core.equals((Mat)m1, (Mat)m2).asMat();
    }

    public static Mat geq(Mat m1, double threshold) {
        return opencv_core.greaterThanEquals((Mat)m1, (double)threshold).asMat();
    }

    public static Mat geq(Mat m1, Mat m2) {
        return opencv_core.greaterThanEquals((Mat)m1, (Mat)m2).asMat();
    }

    public static Mat lt(Mat m1, double threshold) {
        return opencv_core.lessThan((Mat)m1, (double)threshold).asMat();
    }

    public static Mat leq(Mat m1, Mat m2) {
        return opencv_core.lessThanEquals((Mat)m1, (Mat)m2).asMat();
    }

    public static Mat leq(Mat m1, double threshold) {
        return opencv_core.lessThanEquals((Mat)m1, (double)threshold).asMat();
    }

    public static Mat lt(Mat m1, Mat m2) {
        return opencv_core.lessThan((Mat)m1, (Mat)m2).asMat();
    }

    public static <T> T asType(Mat mat, Class<T> cls) {
        if (Mat.class.isAssignableFrom(cls)) {
            return (T)mat;
        }
        if (BufferedImage.class.isAssignableFrom(cls)) {
            return (T)OpenCVTools.matToBufferedImage(mat);
        }
        if (ImageProcessor.class.isAssignableFrom(cls)) {
            if (mat.channels() == 3 && mat.depth() == 0) {
                return (T)new ColorProcessor((Image)OpenCVTools.matToBufferedImage(mat));
            }
            return (T)OpenCVTools.matToImageProcessor(mat);
        }
        if (ImagePlus.class.isAssignableFrom(cls)) {
            ImagePlus imp = OpenCVTools.matToImagePlus(mat, null);
            if (CompositeImage.class.isAssignableFrom(cls)) {
                return (T)GroovyCV.ensureComposite(imp);
            }
            return (T)imp;
        }
        if (double[].class.isAssignableFrom(cls)) {
            return (T)OpenCVTools.extractDoubles(mat);
        }
        if (float[].class.isAssignableFrom(cls)) {
            return (T)OpenCVTools.extractFloats(mat);
        }
        return null;
    }

    private static CompositeImage ensureComposite(ImagePlus imp) {
        return imp instanceof CompositeImage ? (CompositeImage)imp : new CompositeImage(imp);
    }

    public static <T> T asType(ImageProcessor ip, Class<T> cls) {
        Mat mat = null;
        if (Mat.class.isAssignableFrom(cls)) {
            if (ip instanceof ByteProcessor) {
                mat = new Mat(ip.getHeight(), ip.getWidth(), opencv_core.CV_8UC1);
                ByteBuffer buf = (ByteBuffer)mat.createBuffer();
                buf.put((byte[])ip.getPixels());
            } else if (ip instanceof ShortProcessor) {
                mat = new Mat(ip.getHeight(), ip.getWidth(), opencv_core.CV_16UC1);
                ShortBuffer buf = (ShortBuffer)mat.createBuffer();
                buf.put((short[])ip.getPixels());
            } else if (ip instanceof FloatProcessor) {
                mat = new Mat(ip.getHeight(), ip.getWidth(), opencv_core.CV_32FC1);
                FloatBuffer buf = (FloatBuffer)mat.createBuffer();
                buf.put((float[])ip.getPixels());
            } else if (ip instanceof ColorProcessor) {
                ColorProcessor cp = (ColorProcessor)ip;
                byte[] r = new byte[cp.getWidth() * cp.getHeight()];
                byte[] g = new byte[cp.getWidth() * cp.getHeight()];
                byte[] b = new byte[cp.getWidth() * cp.getHeight()];
                cp.getRGB(r, g, b);
                mat = new Mat(ip.getHeight(), ip.getWidth(), opencv_core.CV_8UC3);
                ByteBuffer buf = (ByteBuffer)mat.createBuffer();
                for (int i = 0; i < r.length; ++i) {
                    buf.put(r[i]);
                    buf.put(g[i]);
                    buf.put(b[i]);
                }
            } else {
                throw new IllegalArgumentException("Unknown ImageProcessor class " + String.valueOf(ip.getClass()));
            }
            return (T)mat;
        }
        if (Roi.class.isAssignableFrom(cls)) {
            if (ip.getMinThreshold() == -808080.0) {
                ip.setBinaryThreshold();
            }
            return (T)new ThresholdToSelection().convert(ip);
        }
        return null;
    }

    public static <T> T asType(ImagePlus imp, Class<T> cls) {
        if (ImageProcessor.class.isAssignableFrom(cls)) {
            return (T)imp.getProcessor();
        }
        if (Roi.class.isAssignableFrom(cls)) {
            return (T)GroovyCV.asType(imp.getProcessor(), Roi.class);
        }
        if (Mat.class.isAssignableFrom(cls)) {
            return (T)GroovyCV.asType(imp.getProcessor(), Mat.class);
        }
        return null;
    }

    public static <T> T asType(BufferedImage img, Class<T> cls) {
        if (Mat.class.isAssignableFrom(cls)) {
            return (T)OpenCVTools.imageToMat(img);
        }
        if (ImageProcessor.class.isAssignableFrom(cls)) {
            if (BufferedImageTools.is8bitColorType((int)img.getType())) {
                return (T)new ColorProcessor((Image)img);
            }
            return (T)IJTools.convertToImageProcessor(img, 0);
        }
        if (ImagePlus.class.isAssignableFrom(cls)) {
            ImagePlus imp = IJTools.convertToUncalibratedImagePlus("", img);
            if (CompositeImage.class.isAssignableFrom(cls)) {
                return (T)GroovyCV.ensureComposite(imp);
            }
            return (T)imp;
        }
        return null;
    }

    public static <T> T asType(Number n, Class<T> cls) {
        if (Scalar.class.isAssignableFrom(cls)) {
            return (T)Scalar.all((double)n.doubleValue());
        }
        if (Mat.class.isAssignableFrom(cls)) {
            return (T)OpenCVTools.scalarMat(n.doubleValue(), 6);
        }
        return null;
    }
}

