/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.ops;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bytedeco.opencv.opencv_core.Mat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.io.GsonTools;
import qupath.opencv.ops.ImageDataOp;
import qupath.opencv.ops.ImageDataServer;
import qupath.opencv.tools.OpenCVTools;

class ImageOpServer
extends AbstractTileableImageServer
implements ImageDataServer<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(ImageOpServer.class);
    private ImageData<BufferedImage> imageData;
    private ImageDataOp dataOp;
    private ImageServerMetadata metadata;

    ImageOpServer(ImageData<BufferedImage> imageData, double downsample, int tileWidth, int tileHeight, ImageDataOp dataOp) {
        this.imageData = imageData;
        this.dataOp = dataOp;
        PixelType pixelType = dataOp.getOutputType(imageData.getServer().getPixelType());
        List<ImageChannel> channels = dataOp.getChannels(imageData);
        this.metadata = new ImageServerMetadata.Builder(imageData.getServerMetadata()).levelsFromDownsamples(new double[]{downsample}).preferredTileSize(tileWidth, tileHeight).pixelType(pixelType).channels(channels).rgb(false).build();
    }

    @Override
    public ImageData<BufferedImage> getImageData() {
        return this.imageData;
    }

    public Collection<URI> getURIs() {
        return this.imageData.getServer().getURIs();
    }

    public String getServerType() {
        return "ImageOp server";
    }

    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    protected BufferedImage readTile(TileRequest tileRequest) throws IOException {
        Mat mat = this.dataOp.apply(this.imageData, tileRequest.getRegionRequest());
        return OpenCVTools.matToBufferedImage(mat);
    }

    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        logger.warn("Server builder not supported!");
        return null;
    }

    protected String createID() {
        try {
            return this.getServerType() + ": " + String.valueOf(this.imageData) + " " + GsonTools.getInstance().toJson((Object)this.dataOp);
        }
        catch (Exception e) {
            logger.debug("Unable to create ID from JSON");
            return UUID.randomUUID().toString();
        }
    }
}

