/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.ml.pixel;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bytedeco.javacpp.PointerScope;
import org.bytedeco.opencv.opencv_core.Mat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.classifiers.pixel.PixelClassifier;
import qupath.lib.classifiers.pixel.PixelClassifierMetadata;
import qupath.lib.color.ColorModelFactory;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.io.UriResource;
import qupath.lib.regions.RegionRequest;
import qupath.opencv.ops.ImageDataOp;
import qupath.opencv.tools.OpenCVTools;

class OpenCVPixelClassifier
implements PixelClassifier,
UriResource {
    private static final Logger logger = LoggerFactory.getLogger(OpenCVPixelClassifier.class);
    private transient ColorModel colorModelProbabilities;
    private transient ColorModel colorModelClassifications;
    private PixelClassifierMetadata metadata;
    private ImageDataOp op;

    private OpenCVPixelClassifier() {
    }

    OpenCVPixelClassifier(ImageDataOp op, PixelClassifierMetadata metadata) {
        this();
        this.op = op;
        this.metadata = metadata;
        logger.debug("Creating OpenCV pixel classifier");
    }

    public boolean supportsImage(ImageData<BufferedImage> imageData) {
        return this.op.supportsImage(imageData);
    }

    protected synchronized ColorModel getClassificationsColorModel() {
        if (this.colorModelClassifications == null) {
            this.colorModelClassifications = ColorModelFactory.getIndexedClassificationColorModel((Map)this.metadata.getClassificationLabels());
        }
        return this.colorModelClassifications;
    }

    protected synchronized ColorModel getProbabilityColorModel(boolean do8Bit) {
        if (this.colorModelProbabilities == null) {
            this.colorModelProbabilities = do8Bit ? ColorModelFactory.getProbabilityColorModel8Bit((List)this.metadata.getOutputChannels()) : ColorModelFactory.getProbabilityColorModel32Bit((List)this.metadata.getOutputChannels());
        }
        return this.colorModelProbabilities;
    }

    protected ImageDataOp getOp() {
        return this.op;
    }

    public PixelClassifierMetadata getMetadata() {
        return this.metadata;
    }

    public BufferedImage applyClassification(ImageData<BufferedImage> imageData, RegionRequest request) throws IOException {
        try (PointerScope scope = new PointerScope();){
            BufferedImage imgResult;
            Mat matResult = this.getOp().apply(imageData, request);
            ImageServerMetadata.ChannelType type = this.getMetadata().getOutputType();
            ColorModel colorModelLocal = null;
            if (type == null) {
                type = ImageServerMetadata.ChannelType.DEFAULT;
            }
            switch (type) {
                case CLASSIFICATION: {
                    colorModelLocal = this.getClassificationsColorModel();
                    break;
                }
                default: {
                    colorModelLocal = this.getProbabilityColorModel(matResult.depth() == 0);
                }
            }
            BufferedImage bufferedImage = imgResult = OpenCVTools.matToBufferedImage(matResult, colorModelLocal);
            return bufferedImage;
        }
    }

    public Collection<URI> getURIs() throws IOException {
        return this.op.getURIs();
    }

    public boolean updateURIs(Map<URI, URI> replacements) throws IOException {
        return this.op.updateURIs(replacements);
    }
}

