/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.ml.objects.features;

import com.google.gson.annotations.JsonAdapter;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.stats.RunningStatistics;
import qupath.lib.classifiers.Normalization;
import qupath.opencv.io.OpenCVTypeAdapters;
import qupath.opencv.ml.objects.features.Normalizer;

public class Preprocessing {
    public static PCAProjector createPCAProjector(Mat data, double retainedVariance, boolean normalize) {
        return new PCAProjector(data, retainedVariance, normalize);
    }

    public static Normalizer createNormalizer(Normalization normalization, Mat samples, double missingValue) {
        Mat features = samples.channels() == 1 ? samples : samples.reshape(1, samples.rows() * samples.cols());
        int nSamples = features.rows();
        int nFeatures = features.cols();
        double[] offsets = new double[nFeatures];
        double[] scales = new double[nFeatures];
        Arrays.fill(scales, 1.0);
        if (normalization == Normalization.NONE) {
            return Normalizer.createNormalizer(offsets, scales, missingValue);
        }
        Indexer indexer = samples.createIndexer();
        long[] inds = new long[2];
        for (int c = 0; c < nFeatures; ++c) {
            RunningStatistics stats = new RunningStatistics();
            inds[1] = c;
            for (int r = 0; r < nSamples; ++r) {
                inds[0] = r;
                double val = indexer.getDouble(inds);
                if (!Double.isFinite(val)) continue;
                stats.addValue(val);
            }
            offsets[c] = 0.0;
            scales[c] = 1.0;
            if (stats.size() <= 0L) continue;
            if (normalization == Normalization.MEAN_VARIANCE) {
                offsets[c] = -stats.getMean();
                scales[c] = 1.0 / stats.getStdDev();
                continue;
            }
            if (normalization != Normalization.MIN_MAX) continue;
            offsets[c] = -stats.getMin();
            scales[c] = 1.0 / (stats.getMax() - stats.getMin());
        }
        indexer.release();
        if (features != samples) {
            features.close();
        }
        return Normalizer.createNormalizer(offsets, scales, missingValue);
    }

    public static void normalize(Mat samples, Normalizer normalizer) {
        if (normalizer == null || normalizer.isIdentity()) {
            if (Double.isFinite(normalizer.getMissingValue())) {
                opencv_core.patchNaNs((Mat)samples, (double)normalizer.getMissingValue());
            }
            return;
        }
        boolean doChannels = samples.channels() > 1 && samples.channels() == normalizer.nFeatures();
        int nChannels = samples.channels();
        int nRows = samples.rows();
        int nCols = samples.cols();
        Indexer indexer = samples.createIndexer();
        long[] inds = new long[3];
        for (int channel = 0; channel < nChannels; ++channel) {
            inds[2] = channel;
            for (int row = 0; row < nRows; ++row) {
                inds[0] = row;
                for (int col = 0; col < nCols; ++col) {
                    inds[1] = col;
                    int f = doChannels ? channel : col;
                    double val = indexer.getDouble(inds);
                    val = normalizer.normalizeFeature(f, val);
                    indexer.putDouble(inds, val);
                }
            }
        }
        indexer.release();
    }

    @JsonAdapter(value=OpenCVTypeAdapters.OpenCVTypeAdaptorFactory.class)
    public static class PCAProjector
    implements AutoCloseable {
        private static final Logger logger = LoggerFactory.getLogger(PCAProjector.class);
        private static final double DEFAULT_EPSILON = 1.0E-5;
        @JsonAdapter(value=OpenCVTypeAdapters.OpenCVTypeAdaptorFactory.class)
        private Mat mean = new Mat();
        @JsonAdapter(value=OpenCVTypeAdapters.OpenCVTypeAdaptorFactory.class)
        private Mat eigenvectors = new Mat();
        @JsonAdapter(value=OpenCVTypeAdapters.OpenCVTypeAdaptorFactory.class)
        private Mat eigenvalues = new Mat();
        @JsonAdapter(value=OpenCVTypeAdapters.OpenCVTypeAdaptorFactory.class)
        private transient Mat eigenvaluesSqrt;
        private boolean normalize = true;

        PCAProjector(Mat data, double retainedVariance, boolean normalize) {
            this.normalize = normalize;
            opencv_core.PCACompute2((Mat)data, (Mat)this.mean, (Mat)this.eigenvectors, (Mat)this.eigenvalues, (double)retainedVariance);
            logger.info("Reduced dimensions from {} to {}", (Object)data.cols(), (Object)this.eigenvectors.rows());
        }

        public int nComponents() {
            return this.eigenvectors == null ? 0 : this.eigenvectors.rows();
        }

        public void project(Mat data, Mat result) {
            opencv_core.PCAProject((Mat)data, (Mat)this.mean, (Mat)this.eigenvectors, (Mat)result);
            if (this.normalize) {
                this.doNormalize(result);
            }
        }

        void doNormalize(Mat result) {
            if (this.eigenvaluesSqrt == null) {
                this.eigenvaluesSqrt = new Mat();
                this.eigenvalues.copyTo(this.eigenvaluesSqrt);
                opencv_core.add((Mat)this.eigenvaluesSqrt, (Scalar)Scalar.all((double)1.0E-5));
                opencv_core.sqrt((Mat)this.eigenvaluesSqrt, (Mat)this.eigenvaluesSqrt);
                this.eigenvaluesSqrt.put(this.eigenvaluesSqrt.t());
            }
            if (result.rows() == 1) {
                opencv_core.dividePut((Mat)result, (Mat)this.eigenvaluesSqrt);
            } else {
                FloatBuffer buffer = (FloatBuffer)this.eigenvaluesSqrt.createBuffer();
                for (int c = 0; c < result.cols(); ++c) {
                    opencv_core.dividePut((Mat)result.col(c), (double)buffer.get(c));
                }
            }
        }

        @Override
        public void close() throws Exception {
            this.mean.close();
            this.eigenvectors.close();
            this.eigenvalues.close();
            if (this.eigenvaluesSqrt != null) {
                this.eigenvaluesSqrt.close();
            }
        }
    }
}

