/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.ml.objects.features;

import java.nio.FloatBuffer;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;
import qupath.opencv.ml.objects.features.FeatureExtractor;
import qupath.opencv.ml.objects.features.Preprocessing;

class PCAProjectFeatureExtractor<T>
implements FeatureExtractor<T> {
    private FeatureExtractor<T> featureExtractor;
    private Preprocessing.PCAProjector pca;

    PCAProjectFeatureExtractor(FeatureExtractor<T> featureExtractor, Preprocessing.PCAProjector pca) {
        this.featureExtractor = featureExtractor;
        this.pca = pca;
    }

    @Override
    public List<String> getFeatureNames() {
        return IntStream.rangeClosed(1, this.pca.nComponents() + 1).mapToObj(i -> "PCA " + i).toList();
    }

    @Override
    public int nFeatures() {
        return this.pca.nComponents();
    }

    @Override
    public void extractFeatures(ImageData<T> imageData, Collection<? extends PathObject> pathObjects, FloatBuffer buffer) {
        Mat mat = new Mat(pathObjects.size(), this.featureExtractor.nFeatures(), opencv_core.CV_32FC1);
        FloatBuffer temp = (FloatBuffer)mat.createBuffer();
        this.featureExtractor.extractFeatures(imageData, pathObjects, temp);
        this.pca.project(mat, mat);
        buffer.put((FloatBuffer)mat.createBuffer());
        mat.close();
    }

    @Override
    public Collection<String> getMissingFeatures(ImageData<T> imageData, PathObject pathObject) {
        return this.featureExtractor.getMissingFeatures(imageData, pathObject);
    }
}

