/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.ml.objects.features;

public class Normalizer {
    private double[] offsets;
    private double[] scales;
    private Double missingValue;
    private transient Boolean isIdentity;

    private Normalizer(double[] offsets, double[] scales, double missingValue) {
        if (offsets.length != scales.length) {
            throw new IllegalArgumentException("Length of offsets and scales arrays do not match!");
        }
        this.missingValue = Double.isNaN(missingValue) ? null : Double.valueOf(missingValue);
        this.offsets = (double[])offsets.clone();
        this.scales = (double[])scales.clone();
    }

    public static Normalizer createNormalizer(double[] offsets, double[] scales, double missingValue) {
        return new Normalizer(offsets, scales, missingValue);
    }

    public double normalizeFeature(int idx, double originalValue) {
        double val = originalValue;
        if (!this.isIdentity()) {
            val = (originalValue + this.offsets[idx]) * this.scales[idx];
        }
        if (Double.isFinite(val)) {
            return val;
        }
        return this.getMissingValue();
    }

    private static boolean allEqual(double[] array, double val) {
        for (double d : array) {
            if (d == val) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentity() {
        if (this.isIdentity == null) {
            this.isIdentity = Normalizer.allEqual(this.offsets, 0.0) && Normalizer.allEqual(this.scales, 1.0);
        }
        return this.isIdentity;
    }

    public double getMissingValue() {
        return this.missingValue == null ? Double.NaN : this.missingValue;
    }

    public int nFeatures() {
        return this.scales.length;
    }

    public double getOffset(int ind) {
        return this.offsets[ind];
    }

    public double getScale(int ind) {
        return this.scales[ind];
    }
}

