/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.ml.objects.features;

import java.nio.FloatBuffer;
import java.util.Collection;
import java.util.List;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;
import qupath.opencv.ml.objects.features.FeatureExtractor;
import qupath.opencv.ml.objects.features.Normalizer;

class NormalizedFeatureExtractor<T>
implements FeatureExtractor<T> {
    private FeatureExtractor<T> featureExtractor;
    private Normalizer normalizer;

    NormalizedFeatureExtractor(FeatureExtractor<T> featureExtractor, Normalizer normalizer) {
        this.featureExtractor = featureExtractor;
        this.normalizer = normalizer;
    }

    @Override
    public List<String> getFeatureNames() {
        return this.featureExtractor.getFeatureNames();
    }

    @Override
    public int nFeatures() {
        return this.featureExtractor.nFeatures();
    }

    @Override
    public void extractFeatures(ImageData<T> imageData, Collection<? extends PathObject> pathObjects, FloatBuffer buffer) {
        int pos = buffer.position();
        this.featureExtractor.extractFeatures(imageData, pathObjects, buffer);
        int n = this.nFeatures();
        assert (buffer.position() - pos == pathObjects.size() * n);
        int ind = pos;
        for (int i = 0; i < pathObjects.size(); ++i) {
            for (int j = 0; j < n; ++j) {
                double val = buffer.get(ind);
                val = this.normalizer.normalizeFeature(j, val);
                buffer.put(ind, (float)val);
                ++ind;
            }
        }
    }

    @Override
    public Collection<String> getMissingFeatures(ImageData<T> imageData, PathObject pathObject) {
        return this.featureExtractor.getMissingFeatures(imageData, pathObject);
    }
}

