/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.ml.objects.features;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import qupath.lib.io.GsonTools;
import qupath.opencv.ml.objects.features.DefaultFeatureExtractor;
import qupath.opencv.ml.objects.features.FeatureExtractor;
import qupath.opencv.ml.objects.features.NormalizedFeatureExtractor;
import qupath.opencv.ml.objects.features.Normalizer;
import qupath.opencv.ml.objects.features.PCAProjectFeatureExtractor;
import qupath.opencv.ml.objects.features.Preprocessing;

public class FeatureExtractors {
    private static final TypeAdapterFactory factory = new FeatureExtractorTypeAdapterFactory();

    public static TypeAdapterFactory getTypeAdapterFactory() {
        return factory;
    }

    public static <T> FeatureExtractor<T> createMeasurementListFeatureExtractor(List<String> measurements) {
        return new DefaultFeatureExtractor(measurements);
    }

    public static <T> FeatureExtractor<T> createNormalizingFeatureExtractor(FeatureExtractor<T> extractor, Normalizer normalizer) {
        return new NormalizedFeatureExtractor<T>(extractor, normalizer);
    }

    public static <T> FeatureExtractor<T> createPCAProjectFeatureExtractor(FeatureExtractor<T> extractor, Preprocessing.PCAProjector pca) {
        return new PCAProjectFeatureExtractor<T>(extractor, pca);
    }

    static class FeatureExtractorTypeAdapterFactory
    implements TypeAdapterFactory {
        private static String typeName = "feature_extractor_type";
        private static final GsonTools.SubTypeAdapterFactory<FeatureExtractor> featureCalculatorTypeAdapter = GsonTools.createSubTypeAdapterFactory(FeatureExtractor.class, (String)typeName).registerSubtype(DefaultFeatureExtractor.class).registerSubtype(NormalizedFeatureExtractor.class).registerSubtype(PCAProjectFeatureExtractor.class);

        private static void registerSubtype(Class<? extends FeatureExtractor> cls) {
            featureCalculatorTypeAdapter.registerSubtype(cls);
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            return featureCalculatorTypeAdapter.create(gson, type);
        }
    }
}

