/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.ml.objects.features;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import qupath.lib.images.ImageData;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathObject;
import qupath.opencv.ml.objects.features.FeatureExtractor;

class DefaultFeatureExtractor<T>
implements FeatureExtractor<T> {
    private List<String> measurements = new ArrayList<String>();

    DefaultFeatureExtractor(Collection<String> measurements) {
        this.measurements.addAll(measurements);
    }

    @Override
    public void extractFeatures(ImageData<T> imageData, Collection<? extends PathObject> pathObjects, FloatBuffer buffer) {
        for (PathObject pathObject : pathObjects) {
            this.extractFeatures(pathObject, buffer);
        }
    }

    @Override
    public List<String> getFeatureNames() {
        return Collections.unmodifiableList(this.measurements);
    }

    @Override
    public int nFeatures() {
        return this.measurements.size();
    }

    private void extractFeatures(PathObject pathObject, FloatBuffer buffer) {
        MeasurementList measurementList = pathObject.getMeasurementList();
        for (String m : this.measurements) {
            double value = measurementList.get(m);
            buffer.put((float)value);
        }
    }

    @Override
    public Collection<String> getMissingFeatures(ImageData<T> imageData, PathObject pathObject) {
        ArrayList<String> missing = null;
        MeasurementList ml = pathObject.getMeasurementList();
        for (String name : this.measurements) {
            if (ml.containsKey(name)) continue;
            if (missing == null) {
                missing = new ArrayList<String>();
            }
            missing.add(name);
        }
        return missing == null ? Collections.emptyList() : missing;
    }
}

