/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.ml;

import org.bytedeco.opencv.opencv_core.Mat;
import qupath.lib.classifiers.Normalization;
import qupath.opencv.ml.objects.features.Normalizer;
import qupath.opencv.ml.objects.features.Preprocessing;

public class FeaturePreprocessor {
    private Normalizer normalizer;
    private Preprocessing.PCAProjector pca;
    private int inputLength;
    private int outputLength;

    public void apply(Mat mat, boolean channelFeatures) {
        int rows = mat.rows();
        int cols = mat.cols();
        if (channelFeatures) {
            mat.put(mat.reshape(1, rows * cols));
        }
        if (this.normalizer != null) {
            Preprocessing.normalize(mat, this.normalizer);
        }
        if (this.pca != null) {
            this.pca.project(mat, mat);
        }
        if (channelFeatures) {
            mat.put(mat.reshape((int)(mat.total() / (long)(rows * cols)), rows));
        }
    }

    public void apply(Mat mat) {
        this.apply(mat, mat.channels() > 1);
    }

    public boolean doesFeatureTransform() {
        return this.pca != null;
    }

    public boolean doesSomething() {
        return this.normalizer != null || this.pca != null;
    }

    public int getInputLength() {
        return this.inputLength;
    }

    public int getOutputLength() {
        return this.outputLength;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        String name = "FeaturePreprocessor";
        if (!this.doesSomething()) {
            return name + " (null)";
        }
        if (this.normalizer != null) {
            if (this.pca != null) {
                return name + " (" + String.valueOf(this.normalizer) + ", " + String.valueOf(this.pca) + ")";
            }
            return name + " (" + String.valueOf(this.normalizer) + ")";
        }
        return name + " (" + String.valueOf(this.pca) + ")";
    }

    public static class Builder {
        private Normalization normalization = Normalization.NONE;
        private double missingValue = Double.NaN;
        private double pcaRetainedVariance = -1.0;
        private boolean pcaNormalize = true;
        private Normalizer normalizer;
        private Preprocessing.PCAProjector pca;

        private Builder() {
        }

        public Builder normalize(Normalization normalization) {
            this.normalization = normalization;
            return this;
        }

        public Builder missingValue(double missingValue) {
            this.missingValue = missingValue;
            return this;
        }

        public Builder pca(double retainedVariance, boolean pcaNormalize) {
            this.pcaRetainedVariance = retainedVariance;
            this.pcaNormalize = pcaNormalize;
            return this;
        }

        public FeaturePreprocessor build(Mat trainingData, boolean applyToTraining) {
            FeaturePreprocessor features = new FeaturePreprocessor();
            features.inputLength = trainingData.cols();
            features.outputLength = trainingData.cols();
            if (this.normalization != Normalization.NONE || !Double.isNaN(this.missingValue)) {
                this.normalizer = Preprocessing.createNormalizer(this.normalization, trainingData, this.missingValue);
                if (applyToTraining) {
                    Preprocessing.normalize(trainingData, this.normalizer);
                }
            }
            if (this.pcaRetainedVariance > 0.0) {
                this.pca = Preprocessing.createPCAProjector(trainingData, this.pcaRetainedVariance, this.pcaNormalize);
                features.outputLength = this.pca.nComponents();
                if (applyToTraining) {
                    this.pca.project(trainingData, trainingData);
                }
            }
            features.normalizer = this.normalizer;
            features.pca = this.pca;
            return features;
        }
    }
}

