/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.FileNode;
import org.bytedeco.opencv.opencv_core.FileStorage;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.SparseMat;
import org.bytedeco.opencv.opencv_ml.ANN_MLP;
import org.bytedeco.opencv.opencv_ml.Boost;
import org.bytedeco.opencv.opencv_ml.DTrees;
import org.bytedeco.opencv.opencv_ml.EM;
import org.bytedeco.opencv.opencv_ml.KNearest;
import org.bytedeco.opencv.opencv_ml.LogisticRegression;
import org.bytedeco.opencv.opencv_ml.NormalBayesClassifier;
import org.bytedeco.opencv.opencv_ml.RTrees;
import org.bytedeco.opencv.opencv_ml.SVM;
import org.bytedeco.opencv.opencv_ml.SVMSGD;
import org.bytedeco.opencv.opencv_ml.StatModel;

public class OpenCVTypeAdapters {
    public static TypeAdapterFactory getOpenCVTypeAdaptorFactory() {
        return new OpenCVTypeAdaptorFactory();
    }

    public static <T> TypeAdapter<T> getTypeAdaptor(Class<T> cls) {
        if (Mat.class == cls) {
            return new MatTypeAdapter();
        }
        if (SparseMat.class == cls) {
            return new SparseMatTypeAdapter();
        }
        if (StatModel.class.isAssignableFrom(cls)) {
            return new StatModelTypeAdapter();
        }
        if (Scalar.class == cls) {
            return new ScalarTypeAdapter();
        }
        if (Size.class == cls) {
            return new SizeTypeAdapter();
        }
        return null;
    }

    public static class OpenCVTypeAdaptorFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            return OpenCVTypeAdapters.getTypeAdaptor(type.getRawType());
        }
    }

    private static class MatTypeAdapter
    extends OpenCVTypeAdapter<Mat> {
        private MatTypeAdapter() {
        }

        @Override
        void write(FileStorage fs, Mat value) {
            opencv_core.write((FileStorage)fs, (String)"mat", (Mat)value);
        }

        @Override
        Mat read(FileStorage fs) {
            return fs.getFirstTopLevelNode().mat();
        }
    }

    private static class SparseMatTypeAdapter
    extends OpenCVTypeAdapter<SparseMat> {
        private SparseMatTypeAdapter() {
        }

        @Override
        void write(FileStorage fs, SparseMat value) {
            opencv_core.write((FileStorage)fs, (String)"sparsemat", (SparseMat)value);
        }

        @Override
        SparseMat read(FileStorage fs) {
            SparseMat mat = new SparseMat();
            opencv_core.read((FileNode)fs.getFirstTopLevelNode(), (SparseMat)mat);
            return mat;
        }
    }

    private static class StatModelTypeAdapter
    extends TypeAdapter<StatModel> {
        Gson gson = new GsonBuilder().setLenient().create();

        private StatModelTypeAdapter() {
        }

        public void write(JsonWriter out, StatModel value) throws IOException {
            try (FileStorage fs = new FileStorage();){
                fs.open("anything.json", 29);
                value.write(fs, value.getDefaultName());
                String json = fs.releaseAndGetString().getString();
                out.beginObject();
                out.name("class");
                out.value(value.getClass().getSimpleName());
                out.name("statmodel");
                JsonObject element = (JsonObject)this.gson.fromJson(json.trim(), JsonObject.class);
                this.gson.toJson((JsonElement)element, out);
                out.endObject();
            }
        }

        public StatModel read(JsonReader in) throws IOException {
            boolean lenient = in.isLenient();
            try {
                RTrees rTrees;
                JsonElement element = JsonParser.parseReader((JsonReader)in);
                JsonObject obj = element.getAsJsonObject();
                String className = obj.get("class").getAsString();
                JsonElement objStatModel = obj.get("statmodel");
                String modelString = new GsonBuilder().setPrettyPrinting().create().toJson(objStatModel);
                boolean useRoot = objStatModel.isJsonObject() && objStatModel.getAsJsonObject().has("format");
                RTrees model = null;
                if (RTrees.class.getSimpleName().equals(className)) {
                    model = RTrees.create();
                } else if (DTrees.class.getSimpleName().equals(className)) {
                    model = DTrees.create();
                } else if (Boost.class.getSimpleName().equals(className)) {
                    model = Boost.create();
                } else if (EM.class.getSimpleName().equals(className)) {
                    model = EM.create();
                } else if (LogisticRegression.class.getSimpleName().equals(className)) {
                    model = LogisticRegression.create();
                } else if (SVM.class.getSimpleName().equals(className)) {
                    model = SVM.create();
                } else if (SVMSGD.class.getSimpleName().equals(className)) {
                    model = SVMSGD.create();
                } else if (NormalBayesClassifier.class.getSimpleName().equals(className)) {
                    model = NormalBayesClassifier.create();
                } else if (KNearest.class.getSimpleName().equals(className)) {
                    model = KNearest.create();
                } else if (ANN_MLP.class.getSimpleName().equals(className)) {
                    model = ANN_MLP.create();
                } else {
                    throw new IOException("Unknown StatModel class name " + className);
                }
                try (FileStorage fs = new FileStorage();){
                    fs.open(modelString, 28);
                    FileNode fn = useRoot ? fs.root() : fs.getFirstTopLevelNode();
                    model.read(fn);
                    rTrees = model;
                }
                return rTrees;
            }
            finally {
                in.setLenient(lenient);
            }
        }
    }

    private static class ScalarTypeAdapter
    extends TypeAdapter<Scalar> {
        private ScalarTypeAdapter() {
        }

        public void write(JsonWriter out, Scalar value) throws IOException {
            if (value == null || value.isNull()) {
                out.nullValue();
            } else {
                out.beginArray();
                for (int i = 0; i < 4; ++i) {
                    out.value(value.get((long)i));
                }
                out.endArray();
            }
        }

        public Scalar read(JsonReader in) throws IOException {
            int n;
            in.beginArray();
            double[] values = new double[4];
            for (n = 0; in.hasNext() && n < values.length; ++n) {
                values[n] = in.nextDouble();
            }
            in.endArray();
            if (n == 0) {
                return new Scalar();
            }
            if (n == 1) {
                return new Scalar(values[0]);
            }
            if (n == 2) {
                return new Scalar(values[0], values[1]);
            }
            return new Scalar(values[0], values[1], values[2], values[3]);
        }
    }

    private static class SizeTypeAdapter
    extends TypeAdapter<Size> {
        private SizeTypeAdapter() {
        }

        public void write(JsonWriter out, Size value) throws IOException {
            if (value == null || value.isNull()) {
                out.nullValue();
            } else {
                out.beginObject();
                out.name("width");
                out.value((long)value.width());
                out.name("height");
                out.value((long)value.height());
                out.endObject();
            }
        }

        public Size read(JsonReader in) throws IOException {
            in.beginObject();
            Map<String, Integer> map = Map.of(in.nextName().toLowerCase(), in.nextInt(), in.nextName().toLowerCase(), in.nextInt());
            in.endObject();
            return new Size(map.get("width").intValue(), map.get("height").intValue());
        }
    }

    public static abstract class OpenCVTypeAdapter<T>
    extends TypeAdapter<T> {
        Gson gson = new GsonBuilder().setLenient().create();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(JsonWriter out, T value) throws IOException {
            boolean lenient = out.isLenient();
            String json = null;
            try (FileStorage fs = new FileStorage();){
                fs.open("anything.json", 29);
                this.write(fs, value);
                json = fs.releaseAndGetString().getString().trim();
                JsonObject element = (JsonObject)this.gson.fromJson(json.trim(), JsonObject.class);
                this.gson.toJson((JsonElement)element, out);
            }
            finally {
                out.setLenient(lenient);
            }
        }

        abstract void write(FileStorage var1, T var2);

        abstract T read(FileStorage var1);

        public T read(JsonReader in) throws IOException {
            boolean lenient = in.isLenient();
            try {
                T t;
                JsonElement element = JsonParser.parseReader((JsonReader)in);
                JsonObject obj = element.getAsJsonObject();
                String inputString = obj.toString();
                try (FileStorage fs = new FileStorage();){
                    fs.open(inputString, 28);
                    t = this.read(fs);
                }
                return t;
            }
            finally {
                in.setLenient(lenient);
            }
        }
    }
}

