/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.features;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bytedeco.opencv.opencv_core.Point2f;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_imgproc.Subdiv2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.stats.RunningStatistics;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectConnectionGroup;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.roi.interfaces.ROI;

@Deprecated
public class DelaunayTriangulation
implements PathObjectConnectionGroup {
    private static final Logger logger = LoggerFactory.getLogger(DelaunayTriangulation.class);
    private double distanceThreshold = Double.NaN;
    private boolean limitByClass = false;
    private Map<Integer, PathObject> vertexMap;
    private Map<PathObject, DelaunayNode> nodeMap;

    public DelaunayTriangulation(List<PathObject> pathObjects, double pixelWidth, double pixelHeight, double distanceThresholdPixels, boolean limitByClass) {
        this.distanceThreshold = distanceThresholdPixels;
        this.limitByClass = limitByClass;
        this.computeDelaunay(pathObjects, pixelWidth, pixelHeight);
        Set measurements = PathObjectTools.getAvailableFeatures(pathObjects);
        for (String name : measurements) {
            RunningStatistics stats = new RunningStatistics();
            pathObjects.stream().forEach(p -> stats.addValue(p.getMeasurementList().get(name)));
        }
    }

    void getConnectedNodesRecursive(PathObject pathObject, Set<PathObject> set) {
        if (set.add(pathObject)) {
            for (PathObject next : this.getConnectedNodes(pathObject, null)) {
                this.getConnectedNodesRecursive(next, set);
            }
        }
    }

    public List<PathObject> getConnectedObjects(PathObject pathObject) {
        DelaunayNode node = this.nodeMap.get(pathObject);
        if (node == null) {
            return Collections.emptyList();
        }
        return node.getNodeList().stream().map(n -> n.getPathObject()).toList();
    }

    public Collection<PathObject> getPathObjects() {
        return this.nodeMap.keySet();
    }

    static ROI getROI(PathObject pathObject) {
        ROI roi;
        if (pathObject instanceof PathCellObject && (roi = ((PathCellObject)pathObject).getNucleusROI()) != null && !Double.isNaN(roi.getCentroidX())) {
            return roi;
        }
        return pathObject.getROI();
    }

    void computeDelaunay(List<PathObject> pathObjectList, double pixelWidth, double pixelHeight) {
        if (pathObjectList.size() <= 2) {
            return;
        }
        this.vertexMap = new HashMap<Integer, PathObject>(pathObjectList.size(), 1.0f);
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        ArrayList<Point2f> centroids = new ArrayList<Point2f>(pathObjectList.size());
        for (PathObject pathObject : pathObjectList) {
            ROI pathROI = null;
            pathROI = DelaunayTriangulation.getROI(pathObject);
            if (pathROI == null) {
                centroids.add(null);
                continue;
            }
            double x = pathROI.getCentroidX();
            double y = pathROI.getCentroidY();
            if (Double.isNaN(x) || Double.isNaN(y)) {
                centroids.add(null);
                continue;
            }
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y > maxY) {
                maxY = y;
            }
            centroids.add(new Point2f((float)x, (float)y));
        }
        Subdiv2D subdiv = new Subdiv2D();
        Rect bounds = new Rect((int)minX - 1, (int)minY - 1, (int)(maxX - minX) + 100, (int)(maxY - minY) + 100);
        subdiv.initDelaunay(bounds);
        for (int i = 0; i < centroids.size(); ++i) {
            Point2f p = (Point2f)centroids.get(i);
            if (p == null) continue;
            int v = subdiv.insert(p);
            this.vertexMap.put(v, pathObjectList.get(i));
        }
        this.updateNodeMap(subdiv, pixelWidth, pixelHeight);
    }

    void updateNodeMap(Subdiv2D subdiv, double pixelWidth, double pixelHeight) {
        if (subdiv == null) {
            return;
        }
        int[] firstEdgeArray = new int[1];
        boolean ignoreDistance = Double.isNaN(this.distanceThreshold) || Double.isInfinite(this.distanceThreshold) || this.distanceThreshold <= 0.0;
        DelaunayNodeFactory factory = new DelaunayNodeFactory(pixelWidth, pixelHeight);
        this.nodeMap = new HashMap<PathObject, DelaunayNode>(this.vertexMap.size(), 1.0f);
        for (Map.Entry<Integer, PathObject> entry : this.vertexMap.entrySet()) {
            int edgeDest;
            PathObject destination;
            int firstEdge;
            int v = entry.getKey();
            PathObject pathObject = entry.getValue();
            PathClass pathClass = pathObject.getPathClass() == null ? null : pathObject.getPathClass().getBaseClass();
            subdiv.getVertex(v, firstEdgeArray);
            int edge = firstEdge = firstEdgeArray[0];
            DelaunayNode node = factory.getNode(pathObject);
            while ((destination = this.vertexMap.get(edgeDest = subdiv.edgeDst(edge))) != null) {
                boolean classOK;
                boolean distanceOK = ignoreDistance || DelaunayTriangulation.distance(DelaunayTriangulation.getROI(pathObject), DelaunayTriangulation.getROI(destination)) < this.distanceThreshold;
                boolean bl = classOK = !this.limitByClass || pathClass == destination.getPathClass() || destination.getPathClass() != null && destination.getPathClass().getBaseClass() == pathClass;
                if (distanceOK && classOK) {
                    DelaunayNode destinationNode = factory.getNode(destination);
                    node.addEdge(destinationNode);
                    destinationNode.addEdge(node);
                }
                if ((edge = subdiv.getEdge(edge, 0)) != firstEdge) continue;
                break;
            }
            DelaunayNode previous = this.nodeMap.put(pathObject, node);
            assert (previous == null);
        }
    }

    @Deprecated
    public Collection<double[]> getConnectedNodes(Collection<PathObject> pathObjects, Collection<double[]> connections) {
        if (connections == null) {
            connections = new HashSet<double[]>();
        }
        if (this.nodeMap == null || pathObjects.isEmpty()) {
            return connections;
        }
        for (PathObject temp : pathObjects) {
            DelaunayNode node = this.nodeMap.get(temp);
            if (node == null) continue;
            ROI roi = DelaunayTriangulation.getROI(temp);
            double x1 = roi.getCentroidX();
            double y1 = roi.getCentroidY();
            for (DelaunayNode node2 : node.nodeList) {
                ROI roi2 = DelaunayTriangulation.getROI(node2.getPathObject());
                double x2 = roi2.getCentroidX();
                double y2 = roi2.getCentroidY();
                if (x1 < x2 || x1 == x2 && y1 <= y2) {
                    connections.add(new double[]{x1, y1, x2, y2});
                    continue;
                }
                connections.add(new double[]{x2, y2, x1, y1});
            }
        }
        return connections;
    }

    public Collection<PathObject> getConnectedNodes(PathObject pathObject, Collection<PathObject> list) {
        DelaunayNode node;
        if (list == null) {
            list = new ArrayList<PathObject>();
        }
        DelaunayNode delaunayNode = node = this.nodeMap == null ? null : this.nodeMap.get(pathObject);
        if (node == null) {
            return list;
        }
        for (DelaunayNode temp : node.nodeList) {
            list.add(temp.getPathObject());
        }
        return list;
    }

    public List<Set<PathObject>> getConnectedClusters() {
        if (this.nodeMap == null || this.nodeMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PathObject> toProcess = new ArrayList<PathObject>(this.nodeMap.keySet());
        ArrayList<Set<PathObject>> clusters = new ArrayList<Set<PathObject>>();
        while (!toProcess.isEmpty()) {
            HashSet<PathObject> inCluster = new HashSet<PathObject>();
            ArrayDeque<PathObject> toCheck = new ArrayDeque<PathObject>();
            PathObject next = (PathObject)toProcess.remove(toProcess.size() - 1);
            toCheck.add(next);
            while (!toCheck.isEmpty()) {
                next = (PathObject)toCheck.pop();
                if (!inCluster.add(next)) continue;
                toCheck.addAll(this.getConnectedObjects(next));
            }
            toProcess.removeAll(inCluster);
            clusters.add(inCluster);
        }
        return clusters;
    }

    public void addClusterMeasurements() {
        if (this.nodeMap == null || this.nodeMap.isEmpty()) {
            return;
        }
        List<Set<PathObject>> clusters = this.getConnectedClusters();
        String key = "Cluster ";
        ArrayList<String> measurementNames = new ArrayList<String>();
        for (String s : PathObjectTools.getAvailableFeatures(this.nodeMap.keySet())) {
            if (s.startsWith(key)) continue;
            measurementNames.add(s);
        }
        RunningStatistics[] averagedMeasurements = new RunningStatistics[measurementNames.size()];
        LinkedHashSet<String> missing = new LinkedHashSet<String>();
        for (Set<PathObject> cluster : clusters) {
            int i;
            MeasurementList ml;
            for (int i2 = 0; i2 < averagedMeasurements.length; ++i2) {
                averagedMeasurements[i2] = new RunningStatistics();
            }
            int n = cluster.size();
            for (PathObject pathObject : cluster) {
                ml = pathObject.getMeasurementList();
                for (i = 0; i < measurementNames.size(); ++i) {
                    String name = (String)measurementNames.get(i);
                    double val = ml.get(name);
                    if (Double.isFinite(val)) {
                        averagedMeasurements[i].addValue(val);
                        continue;
                    }
                    missing.add(name);
                }
            }
            for (PathObject pathObject : cluster) {
                ml = pathObject.getMeasurementList();
                for (i = 0; i < measurementNames.size(); ++i) {
                    ml.put(key + "mean: " + (String)measurementNames.get(i), averagedMeasurements[i].getMean());
                }
                ml.put(key + "size", (double)n);
                ml.close();
            }
        }
        if (!missing.isEmpty()) {
            logger.warn("Some objects have missing measurements! Statistics will calculated only for objects with measurements available.");
            logger.warn("Missing measurements: {}", missing);
        }
    }

    public void addNodeMeasurements() {
        if (this.nodeMap == null) {
            return;
        }
        int averagingSeparation = 0;
        String[] measurementNames = new String[]{};
        double[] averagedMeasurements = new double[]{};
        HashSet<PathObject> neighborSet = new HashSet<PathObject>();
        for (Map.Entry<PathObject, DelaunayNode> entry : this.nodeMap.entrySet()) {
            String name;
            int i;
            MeasurementList measurementList = entry.getKey().getMeasurementList();
            DelaunayNode node = entry.getValue();
            if (averagingSeparation > 0) {
                neighborSet.clear();
                node.addNeighborsToSet(neighborSet, averagingSeparation);
                measurementNames = measurementList.getNames().toArray(measurementNames);
                if (averagedMeasurements.length < measurementNames.length) {
                    averagedMeasurements = new double[measurementNames.length];
                }
                for (i = 0; i < measurementNames.length; ++i) {
                    name = measurementNames[i];
                    if (name == null || name.startsWith("Delaunay")) continue;
                    double sum = 0.0;
                    int n = 0;
                    for (PathObject tempObject : neighborSet) {
                        double value = tempObject.getMeasurementList().get(name);
                        if (Double.isNaN(value)) continue;
                        sum += value;
                        ++n;
                    }
                    averagedMeasurements[i] = n > 0 ? sum / (double)n : Double.NaN;
                }
            }
            measurementList.put("Delaunay: Num neighbors", (double)node.nNeighbors());
            measurementList.put("Delaunay: Mean distance", node.meanDistance());
            measurementList.put("Delaunay: Median distance", node.medianDistance());
            measurementList.put("Delaunay: Max distance", node.maxDistance());
            measurementList.put("Delaunay: Min distance", node.minDistance());
            measurementList.put("Delaunay: Mean triangle area", node.getMeanTriangleArea());
            measurementList.put("Delaunay: Max triangle area", node.getMaxTriangleArea());
            if (averagingSeparation > 0) {
                for (i = 0; i < measurementNames.length; ++i) {
                    name = measurementNames[i];
                    if (name == null || name.startsWith("Delaunay")) continue;
                    measurementList.put("Delaunay averaged (" + averagingSeparation + "): " + name, averagedMeasurements[i]);
                }
            }
            measurementList.close();
        }
    }

    static double distance(ROI r1, ROI r2) {
        double dx = r1.getCentroidX() - r2.getCentroidX();
        double dy = r1.getCentroidY() - r2.getCentroidY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    static double distance(DelaunayNode node1, DelaunayNode node2) {
        double dx = node1.x - node2.x;
        double dy = node1.y - node2.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public boolean containsObject(PathObject pathObject) {
        return this.nodeMap.containsKey(pathObject);
    }

    static class DelaunayNode {
        private PathObject pathObject;
        private double x;
        private double y;
        private List<DelaunayNode> nodeList = new ArrayList<DelaunayNode>(6);
        private List<DelaunayTriangle> triangleList = new ArrayList<DelaunayTriangle>();
        private double[] distances = null;

        private DelaunayNode(PathObject pathObject, double pixelWidth, double pixelHeight) {
            this.pathObject = pathObject;
            ROI roi = DelaunayTriangulation.getROI(pathObject);
            this.x = roi.getCentroidX() * pixelWidth;
            this.y = roi.getCentroidY() * pixelHeight;
        }

        public void addEdge(DelaunayNode destination) {
            if (destination == null) {
                return;
            }
            if (!this.nodeList.contains(destination)) {
                this.nodeList.add(destination);
                this.distances = null;
                this.triangleList.clear();
            }
        }

        public List<DelaunayNode> getNodeList() {
            return this.nodeList;
        }

        public PathObject getPathObject() {
            return this.pathObject;
        }

        public int nNeighbors() {
            return this.nodeList.size();
        }

        void ensureDistancesUpdated() {
            if (this.distances != null && this.distances.length == this.nodeList.size()) {
                return;
            }
            this.distances = new double[this.nNeighbors()];
            for (int i = 0; i < this.nodeList.size(); ++i) {
                DelaunayNode node = this.nodeList.get(i);
                this.distances[i] = DelaunayTriangulation.distance(this, node);
            }
            Arrays.sort(this.distances);
        }

        public double meanDistance() {
            this.ensureDistancesUpdated();
            if (this.distances.length == 0) {
                return Double.NaN;
            }
            double mean = 0.0;
            double n = this.nNeighbors();
            for (double d : this.distances) {
                mean += d / n;
            }
            return mean;
        }

        public double medianDistance() {
            this.ensureDistancesUpdated();
            if (this.distances.length == 0) {
                return Double.NaN;
            }
            if (this.distances.length % 2 == 1) {
                return this.distances[this.distances.length / 2];
            }
            return this.distances[this.distances.length / 2 - 1] / 2.0 + this.distances[this.distances.length / 2] / 2.0;
        }

        public double minDistance() {
            this.ensureDistancesUpdated();
            if (this.distances.length == 0) {
                return Double.NaN;
            }
            return this.distances[0];
        }

        public double maxDistance() {
            this.ensureDistancesUpdated();
            if (this.distances.length == 0) {
                return Double.NaN;
            }
            return this.distances[this.distances.length - 1];
        }

        private double getMeasurementValue(String measurement) {
            return this.pathObject.getMeasurementList().get(measurement);
        }

        private void addNeighborsToSet(Set<PathObject> set, int maxSeparation) {
            if (set.add(this.pathObject) && maxSeparation > 0) {
                for (DelaunayNode node : this.nodeList) {
                    node.addNeighborsToSet(set, maxSeparation - 1);
                }
            }
        }

        private double getMeanMeasurement(String measurement) {
            double sum = this.getMeasurementValue(measurement);
            int n = 1;
            if (Double.isNaN(sum)) {
                sum = 0.0;
                n = 0;
            }
            for (int i = 0; i < this.nodeList.size(); ++i) {
                DelaunayNode node = this.nodeList.get(i);
                double value = node.getMeasurementValue(measurement);
                if (Double.isNaN(value)) continue;
                sum += value;
                ++n;
            }
            if (n == 0) {
                return Double.NaN;
            }
            return sum / (double)n;
        }

        private void ensureTrianglesCalculated() {
            if (!this.triangleList.isEmpty()) {
                return;
            }
            this.triangleList.clear();
            for (int i = 0; i < this.nodeList.size(); ++i) {
                DelaunayNode node = this.nodeList.get(i);
                for (int j = i + 1; j < this.nodeList.size(); ++j) {
                    DelaunayNode node2 = this.nodeList.get(j);
                    if (!node.nodeList.contains(node2)) continue;
                    this.triangleList.add(new DelaunayTriangle(this, node, node2));
                }
            }
        }

        public double getMeanTriangleArea() {
            this.ensureTrianglesCalculated();
            double d = 0.0;
            for (DelaunayTriangle t : this.triangleList) {
                d += t.getArea();
            }
            return d / (double)this.triangleList.size();
        }

        public double getMaxTriangleArea() {
            this.ensureTrianglesCalculated();
            if (this.triangleList.isEmpty()) {
                return Double.NaN;
            }
            double maxArea = Double.NEGATIVE_INFINITY;
            for (DelaunayTriangle t : this.triangleList) {
                double area = t.getArea();
                if (!(area > maxArea)) continue;
                maxArea = area;
            }
            return Double.isFinite(maxArea) ? maxArea : Double.NaN;
        }
    }

    static class DelaunayNodeFactory {
        private Map<PathObject, DelaunayNode> nodeMap = new HashMap<PathObject, DelaunayNode>();
        private double pixelWidth;
        private double pixelHeight;

        DelaunayNodeFactory(double pixelWidth, double pixelHeight) {
            this.pixelWidth = pixelWidth;
            this.pixelHeight = pixelHeight;
        }

        public DelaunayNode getNode(PathObject pathObject) {
            DelaunayNode node = this.nodeMap.get(pathObject);
            if (node == null) {
                node = new DelaunayNode(pathObject, this.pixelWidth, this.pixelHeight);
                this.nodeMap.put(pathObject, node);
            }
            return node;
        }
    }

    static class DelaunayTriangle {
        private DelaunayNode node1;
        private DelaunayNode node2;
        private DelaunayNode node3;

        public DelaunayTriangle(DelaunayNode node1, DelaunayNode node2, DelaunayNode node3) {
            this.node1 = node1;
            this.node2 = node2;
            this.node3 = node3;
        }

        public double getArea() {
            double ax = this.node1.x - this.node3.x;
            double ay = this.node1.y - this.node3.y;
            double bx = this.node2.x - this.node3.x;
            double by = this.node2.y - this.node3.y;
            return Math.abs(ax * by - ay * bx) / 2.0;
        }
    }
}

