/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.features;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.DefaultPathObjectConnectionGroup;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectConnectionGroup;
import qupath.lib.objects.PathObjectConnections;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.AbstractInteractivePlugin;
import qupath.lib.plugins.PathTask;
import qupath.lib.plugins.TaskRunner;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.opencv.features.DelaunayTriangulation;

@Deprecated
public class DelaunayClusteringPlugin<T>
extends AbstractInteractivePlugin<T> {
    private static final Logger logger = LoggerFactory.getLogger(DelaunayClusteringPlugin.class);

    protected void preprocess(TaskRunner taskRunner, ImageData<T> imageData) {
        super.preprocess(taskRunner, imageData);
        imageData.removeProperty("OBJECT_CONNECTIONS");
    }

    protected void postprocess(TaskRunner taskRunner, ImageData<T> imageData) {
        super.postprocess(taskRunner, imageData);
        imageData.getHierarchy().fireHierarchyChangedEvent((Object)this);
    }

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        return Arrays.asList(TMACoreObject.class, PathAnnotationObject.class, PathRootObject.class);
    }

    public String getName() {
        return "Delaunay clustering";
    }

    public String getDescription() {
        return "Cluster neighboring objects, optionally limited by classification and/or distance";
    }

    public String getLastResultsDescription() {
        return null;
    }

    public ParameterList getDefaultParameterList(ImageData<T> imageData) {
        ParameterList params = new ParameterList().addDoubleParameter("distanceThreshold", "Distance threshold", 0.0, "pixels", "Distance threshold - edges longer than this will be omitted").addDoubleParameter("distanceThresholdMicrons", "Distance threshold", 0.0, GeneralTools.micrometerSymbol(), "Distance threshold - edges longer than this will be omitted").addBooleanParameter("limitByClass", "Limit edges to same class", false, "Prevent edges linking objects with different base classifications").addBooleanParameter("addClusterMeasurements", "Add cluster measurements", false, "Add measurements derived from clustering connected objects");
        ImageServer server = imageData.getServer();
        boolean hasMicrons = server != null && server.getPixelCalibration().hasPixelSizeMicrons();
        params.setHiddenParameters(hasMicrons, new String[]{"distanceThreshold"});
        params.setHiddenParameters(!hasMicrons, new String[]{"distanceThresholdMicrons"});
        return params;
    }

    protected Collection<? extends PathObject> getParentObjects(ImageData<T> imageData) {
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        if (hierarchy == null) {
            return Collections.emptyList();
        }
        ArrayList selected = new ArrayList(hierarchy.getSelectionModel().getSelectedObjects());
        if (selected.isEmpty()) {
            logger.trace("Creating task for the root object");
            return Collections.singletonList(hierarchy.getRootObject());
        }
        logger.trace("Creating tasks for {} parent objects", (Object)selected.size());
        return selected;
    }

    protected void addRunnableTasks(ImageData<T> imageData, PathObject parentObject, List<Runnable> tasks) {
        boolean hasMicrons;
        ImageServer server = imageData.getServer();
        double pixelWidth = 1.0;
        double pixelHeight = 1.0;
        PixelCalibration cal = server.getPixelCalibration();
        boolean bl = hasMicrons = server != null && cal.hasPixelSizeMicrons();
        if (hasMicrons) {
            pixelWidth = cal.getPixelWidthMicrons();
            pixelHeight = cal.getPixelHeightMicrons();
        }
        double distanceThresholdPixels = cal.hasPixelSizeMicrons() ? this.params.getDoubleParameterValue("distanceThresholdMicrons") / cal.getAveragedPixelSizeMicrons() : this.params.getDoubleParameterValue("distanceThreshold");
        tasks.add((Runnable)((Object)new DelaunayRunnable(imageData, parentObject, this.params.getBooleanParameterValue("addClusterMeasurements"), pixelWidth, pixelHeight, distanceThresholdPixels, this.params.getBooleanParameterValue("limitByClass"))));
    }

    private static class DelaunayRunnable
    implements PathTask {
        private ImageData<?> imageData;
        private PathObject parentObject;
        private double pixelWidth;
        private double pixelHeight;
        private double distanceThresholdPixels;
        private boolean addClusterMeasurements;
        private boolean limitByClass;
        private PathObjectConnectionGroup result;
        private String lastResult = null;

        DelaunayRunnable(ImageData<?> imageData, PathObject parentObject, boolean addClusterMeasurements, double pixelWidth, double pixelHeight, double distanceThresholdPixels, boolean limitByClass) {
            this.imageData = imageData;
            this.parentObject = parentObject;
            this.pixelWidth = pixelWidth;
            this.pixelHeight = pixelHeight;
            this.addClusterMeasurements = addClusterMeasurements;
            this.distanceThresholdPixels = distanceThresholdPixels;
            this.limitByClass = limitByClass;
        }

        public void run() {
            List<PathObject> pathObjects = PathObjectTools.getFlattenedObjectList((PathObject)this.parentObject, null, (boolean)false);
            if ((pathObjects = pathObjects.stream().filter(p -> p.isDetection()).toList()).isEmpty()) {
                this.lastResult = "No detection descendant objects for " + String.valueOf(this.parentObject);
                return;
            }
            DelaunayTriangulation dt = new DelaunayTriangulation(pathObjects, this.pixelWidth, this.pixelHeight, this.distanceThresholdPixels, this.limitByClass);
            DefaultPathObjectConnectionGroup result = new DefaultPathObjectConnectionGroup((PathObjectConnectionGroup)dt);
            pathObjects = new ArrayList<PathObject>(result.getPathObjects());
            dt.addNodeMeasurements();
            if (this.addClusterMeasurements) {
                dt.addClusterMeasurements();
            }
            this.result = result;
            this.lastResult = "Delaunay triangulation calculated for " + String.valueOf(this.parentObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskComplete(boolean wasCancelled) {
            if (wasCancelled) {
                return;
            }
            if (this.result != null && this.imageData != null) {
                ImageData<?> imageData = this.imageData;
                synchronized (imageData) {
                    Object o = this.imageData.getProperty("OBJECT_CONNECTIONS");
                    PathObjectConnections connections = null;
                    if (o instanceof PathObjectConnections) {
                        connections = (PathObjectConnections)o;
                    } else {
                        connections = new PathObjectConnections();
                        this.imageData.setProperty("OBJECT_CONNECTIONS", (Object)connections);
                    }
                    connections.addGroup(this.result);
                }
            }
        }

        public String getLastResultsDescription() {
            return this.lastResult;
        }
    }
}

