/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.dnn;

import java.util.Collections;
import java.util.Map;
import qupath.opencv.dnn.DnnShape;

public interface PredictionFunction<T> {
    public static final String DEFAULT_INPUT_NAME = "input";
    public static final String DEFAULT_OUTPUT_NAME = "output";

    default public Map<String, T> predict(Map<String, T> input) {
        if (input.size() == 1) {
            T output = this.predict(input.values().iterator().next());
            if (output == null) {
                return Collections.emptyMap();
            }
            return Map.of(DEFAULT_OUTPUT_NAME, output);
        }
        throw new IllegalArgumentException("Default call implementation only supports single input and single output!");
    }

    public T predict(T var1);

    public Map<String, DnnShape> getInputs();

    public Map<String, DnnShape> getOutputs(DnnShape ... var1);
}

