/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.dnn;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.bytedeco.opencv.opencv_dnn.ClassificationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.classifiers.object.AbstractObjectClassifier;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.io.UriResource;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.classes.PathClass;
import qupath.opencv.dnn.DnnTools;
import qupath.opencv.dnn.OpenCVDnn;

public class OpenCVModelObjectClassifier
extends AbstractObjectClassifier<BufferedImage>
implements UriResource {
    private static final Logger logger = LoggerFactory.getLogger(OpenCVModelObjectClassifier.class);
    private OpenCVDnn model;
    private List<PathClass> pathClasses;
    private double requestedPixelSize = 1.0;
    private int width;
    private int height;
    private transient ClassificationModel classificationModel;

    public Collection<PathClass> getPathClasses() {
        return Collections.unmodifiableList(this.pathClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassificationModel getModel() {
        if (this.classificationModel == null) {
            OpenCVModelObjectClassifier openCVModelObjectClassifier = this;
            synchronized (openCVModelObjectClassifier) {
                if (this.classificationModel == null) {
                    this.classificationModel = (ClassificationModel)this.model.buildModel(OpenCVDnn.ModelType.CLASSIFICATION);
                }
            }
        }
        return this.classificationModel;
    }

    public OpenCVModelObjectClassifier(PathObjectFilter filter, OpenCVDnn model, List<PathClass> pathClasses, int width, int height, double requestedPixelSize) {
        super(filter);
        this.model = model;
        this.pathClasses = new ArrayList<PathClass>(pathClasses);
        this.width = width;
        this.height = height;
        this.requestedPixelSize = requestedPixelSize;
    }

    public int classifyObjects(ImageData<BufferedImage> imageData, Collection<? extends PathObject> pathObjects, boolean resetExistingClass) {
        ClassificationModel model = this.getModel();
        ImageServer server = imageData.getServer();
        double ds = Double.isFinite(this.requestedPixelSize) && this.requestedPixelSize > 0.0 ? this.requestedPixelSize / server.getPixelCalibration().getAveragedPixelSize().doubleValue() : 1.0;
        double downsample = ds;
        return (int)pathObjects.parallelStream().filter(p -> this.tryToClassify(model, (PathObject)p, (ImageServer<BufferedImage>)server, downsample, i -> this.pathClasses.get(i))).count();
    }

    protected boolean tryToClassify(ClassificationModel model, PathObject pathObject, ImageServer<BufferedImage> server, double downsample, IntFunction<PathClass> classifier) {
        PathClass previousClass = pathObject.getPathClass();
        try {
            return DnnTools.classify(model, pathObject, server, downsample, this.width, this.height, classifier, null);
        }
        catch (IOException e) {
            logger.warn("Error classifying object: " + e.getLocalizedMessage(), (Throwable)e);
            return pathObject.getPathClass() != previousClass;
        }
    }

    public Map<String, Integer> getMissingFeatures(ImageData<BufferedImage> imageData, Collection<? extends PathObject> pathObjects) {
        return Collections.emptyMap();
    }

    public Collection<URI> getURIs() throws IOException {
        return this.model.getURIs();
    }

    public boolean updateURIs(Map<URI, URI> replacements) throws IOException {
        return this.model.updateURIs(replacements);
    }
}

