/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.dnn;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import qupath.lib.common.GeneralTools;
import qupath.opencv.dnn.DnnModel;
import qupath.opencv.dnn.DnnModelBuilder;
import qupath.opencv.dnn.DnnModelParams;
import qupath.opencv.dnn.OpenCVDnn;

public class OpenCVDnnModelBuilder
implements DnnModelBuilder {
    private static Set<String> weightsExtensions = Set.of(".pb", ".onnx", ".caffemodel", ".t7", ".net", ".weights", ".bin");
    private static Set<String> configExtensions = Set.of(".prototxt", ".pbtxt", ".cfg", ".xml");

    private boolean canBuild(DnnModelParams params) {
        List<URI> uris = params.getURIs();
        if (uris.isEmpty() || uris.size() > 2) {
            return false;
        }
        String framework = params.getFramework();
        if (framework != null) {
            return "OpenCV DNN".equalsIgnoreCase(framework);
        }
        for (URI uri : params.getURIs()) {
            Path path = GeneralTools.toPath((URI)uri);
            if (path == null) {
                return false;
            }
            String ext = GeneralTools.getExtension((String)path.getFileName().toString()).orElse("").toLowerCase();
            if (weightsExtensions.contains(ext) || configExtensions.contains(ext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DnnModel buildModel(DnnModelParams params) {
        if (!this.canBuild(params)) {
            return null;
        }
        List<URI> uris = params.getURIs();
        OpenCVDnn.Builder builder = OpenCVDnn.builder(Paths.get(uris.get(0)).toAbsolutePath().toString());
        if (uris.size() > 1) {
            builder = builder.config(uris.get(1));
        }
        return builder.build();
    }
}

