/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.dnn;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DnnShape {
    private static final Logger logger = LoggerFactory.getLogger(DnnShape.class);
    public static DnnShape UNKNOWN_SHAPE = new DnnShape("");
    public static long UNKNOWN_LENGTH = -1L;
    public static long UNKNOWN_SIZE = -1L;
    private final long[] shape;

    private DnnShape(String id) {
        if (UNKNOWN_SHAPE != null) {
            throw new UnsupportedOperationException("Unknown shape cannot be constructed more than once!");
        }
        this.shape = null;
    }

    private DnnShape(long ... shape) {
        this.shape = (long[])shape.clone();
        if (this.shape.length > 4) {
            logger.warn("Number of dimensions is {} (expected 3 or 4)", (Object)this.shape.length);
        }
        logger.trace("Creating shape: {}", (Object)Arrays.toString(shape));
    }

    private DnnShape(int nDims) {
        if (nDims > 4) {
            logger.warn("Number of dimensions is {} (expected 3 or 4)", (Object)nDims);
        }
        this.shape = new long[nDims];
        Arrays.fill(this.shape, -1L);
        logger.trace("Creating shape: {}", (Object)Arrays.toString(this.shape));
    }

    public final long[] getShape() {
        return this.shape == null ? null : (long[])this.shape.clone();
    }

    public final long get(int i) {
        return this.shape == null ? -1L : this.shape[i];
    }

    public static DnnShape of(long ... shape) {
        return new DnnShape(shape);
    }

    public final int numDimensions() {
        return this.shape == null ? 0 : this.shape.length;
    }

    public final boolean isUnknown() {
        return this.shape == null;
    }

    public final long size() {
        if (this.shape == null) {
            return UNKNOWN_SIZE;
        }
        long total = 1L;
        for (long s : this.shape) {
            if (s == UNKNOWN_LENGTH) {
                return UNKNOWN_SIZE;
            }
            total *= s;
        }
        return total;
    }

    public String toString() {
        return this.isUnknown() ? "Unknown shape" : Arrays.toString(this.shape);
    }
}

