/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.dnn;

import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.classifiers.object.ObjectClassifiers;
import qupath.lib.io.GsonTools;
import qupath.opencv.dnn.BlobFunction;
import qupath.opencv.dnn.DefaultBlobFunction;
import qupath.opencv.dnn.DefaultDnnModel;
import qupath.opencv.dnn.DnnModel;
import qupath.opencv.dnn.DnnModelBuilder;
import qupath.opencv.dnn.DnnModelParams;
import qupath.opencv.dnn.DnnObjectClassifier;
import qupath.opencv.dnn.OpenCVDnn;
import qupath.opencv.dnn.OpenCVModelObjectClassifier;
import qupath.opencv.dnn.PredictionFunction;

public class DnnModels {
    private static final Logger logger = LoggerFactory.getLogger(DnnModels.class);
    private static final GsonTools.SubTypeAdapterFactory<DnnModel> dnnAdapter;
    private static final GsonTools.SubTypeAdapterFactory<BlobFunction> blobAdapter;
    private static final GsonTools.SubTypeAdapterFactory<PredictionFunction> predictionAdapter;
    private static Set<DnnModelBuilder> builders;

    public static <T extends DnnModel> void registerDnnModel(Class<T> subtype, String name) {
        if (name == null || name.isBlank()) {
            dnnAdapter.registerSubtype(subtype);
        } else {
            dnnAdapter.registerSubtype(subtype, name);
        }
    }

    public static boolean registerBuilder(DnnModelBuilder builder) {
        if (builder != null) {
            return DnnModels.getBuilders().add(builder);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Set<DnnModelBuilder> getBuilders() {
        if (builders != null) return builders;
        Class<DnnModels> clazz = DnnModels.class;
        synchronized (DnnModels.class) {
            if (builders != null) return builders;
            builders = new LinkedHashSet<DnnModelBuilder>();
            for (DnnModelBuilder builder : ServiceLoader.load(DnnModelBuilder.class)) {
                builders.add(builder);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return builders;
        }
    }

    public static DnnModel buildModel(DnnModelParams params) {
        Set<DnnModelBuilder> allBuilders = DnnModels.getBuilders();
        for (DnnModelBuilder builder : allBuilders) {
            try {
                DnnModel model = builder.buildModel(params);
                if (model != null) {
                    return model;
                }
                logger.debug("Cannot build model with {}", (Object)builder);
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        logger.warn("Cannot build model with any of the available builders: {}", allBuilders);
        return null;
    }

    static {
        blobAdapter = GsonTools.createSubTypeAdapterFactory(BlobFunction.class, (String)"blob_fun").registerSubtype(DefaultBlobFunction.class);
        predictionAdapter = GsonTools.createSubTypeAdapterFactory(PredictionFunction.class, (String)"prediction_fun");
        dnnAdapter = GsonTools.createSubTypeAdapterFactory(DnnModel.class, (String)"dnn_model").registerSubtype(DefaultDnnModel.class).registerSubtype(OpenCVDnn.class);
        ObjectClassifiers.ObjectClassifierTypeAdapterFactory.registerSubtype(OpenCVModelObjectClassifier.class);
        ObjectClassifiers.ObjectClassifierTypeAdapterFactory.registerSubtype(DnnObjectClassifier.class);
        GsonTools.getDefaultBuilder().registerTypeAdapterFactory(blobAdapter).registerTypeAdapterFactory(predictionAdapter).registerTypeAdapterFactory(dnnAdapter);
    }
}

