/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.dnn;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.opencv.dnn.DnnShape;

public class DnnModelParams {
    public static final String FRAMEWORK_TENSORFLOW = "TensorFlow";
    public static final String FRAMEWORK_TF_LITE = "TFLite";
    public static final String FRAMEWORK_ONNX_RUNTIME = "OnnxRuntime";
    public static final String FRAMEWORK_OPENCV_DNN = "OpenCV DNN";
    public static final String FRAMEWORK_PYTORCH = "PyTorch";
    public static final String FRAMEWORK_MXNET = "MxNet";
    private static final Logger logger = LoggerFactory.getLogger(DnnModelParams.class);
    private String framework;
    private String layout;
    private List<URI> uris;
    private boolean lazyInitialize = false;
    private Map<String, DnnShape> inputs;
    private Map<String, DnnShape> outputs;

    private DnnModelParams(DnnModelParams params) {
        if (params == null) {
            logger.debug("Creating default model params");
            return;
        }
        logger.debug("Creating model params from {}", (Object)params);
        this.framework = params.getFramework();
        this.layout = params.getLayout();
        this.uris = Collections.unmodifiableList(new ArrayList<URI>(params.getURIs()));
        this.inputs = params.inputs == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, DnnShape>(params.getInputs()));
        this.outputs = params.outputs == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, DnnShape>(params.getOutputs()));
        this.lazyInitialize = params.lazyInitialize;
    }

    public String getFramework() {
        return this.framework;
    }

    public List<URI> getURIs() {
        return this.uris == null ? Collections.emptyList() : Collections.unmodifiableList(this.uris);
    }

    public Map<String, DnnShape> getInputs() {
        if (this.inputs == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.inputs);
    }

    public Map<String, DnnShape> getOutputs() {
        if (this.outputs == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.outputs);
    }

    public String getLayout() {
        return this.layout;
    }

    public boolean requestLazyInitialize() {
        return this.lazyInitialize;
    }

    public static Builder builder(DnnModelParams params) {
        return new Builder(params);
    }

    public static Builder builder() {
        return DnnModelParams.builder(null);
    }

    public static class Builder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        private DnnModelParams params;

        private Builder(DnnModelParams params) {
            this.params = new DnnModelParams(params);
        }

        public Builder files(File ... files) {
            return this.URIs(Arrays.stream(files).map(f -> f.toPath().toUri()).toList());
        }

        public Builder paths(Path ... paths) {
            return this.URIs(Arrays.stream(paths).map(p -> p.toUri()).toList());
        }

        public Builder URIs(URI ... uris) {
            return this.URIs(Arrays.asList(uris));
        }

        public Builder URIs(Collection<URI> uris) {
            if (this.params.uris == null) {
                this.params.uris = new ArrayList<URI>(uris);
            } else {
                this.params.uris.addAll(uris);
            }
            return this;
        }

        public Builder lazyInitialize(boolean lazyInitialize) {
            this.params.lazyInitialize = lazyInitialize;
            return this;
        }

        public Builder framework(String framework) {
            this.params.framework = framework;
            return this;
        }

        public Builder layout(String layout) {
            this.params.layout = layout;
            return this;
        }

        public Builder inputShape(long ... shape) {
            return this.input("input", DnnShape.of(shape));
        }

        public Builder input(String name, long ... shape) {
            return this.input(name, DnnShape.of(shape));
        }

        public Builder input(String name, DnnShape shape) {
            if (name == null) {
                name = "input";
            }
            return this.inputs(Collections.singletonMap(name, shape));
        }

        public Builder inputs(Map<String, DnnShape> inputs) {
            if (inputs == null) {
                logger.warn("Provided inputs were null");
                return this;
            }
            if (inputs.isEmpty()) {
                logger.warn("Provided inputs were empty");
                return this;
            }
            if (this.params.inputs == null) {
                this.params.inputs = new LinkedHashMap<String, DnnShape>(inputs);
            } else {
                this.params.inputs.putAll(inputs);
            }
            return this;
        }

        public Builder outputShape(long ... shape) {
            return this.output("output", DnnShape.of(shape));
        }

        public Builder output(String name, long ... shape) {
            return this.output(name, DnnShape.of(shape));
        }

        public Builder output(String name, DnnShape shape) {
            if (name == null) {
                name = "output";
            }
            return this.outputs(Collections.singletonMap(name, shape));
        }

        public Builder outputs(Map<String, DnnShape> outputs) {
            if (outputs == null) {
                logger.warn("Provided outputs were null");
                return this;
            }
            if (outputs.isEmpty()) {
                logger.warn("Provided outputs were empty");
                return this;
            }
            if (this.params.outputs == null) {
                this.params.outputs = new LinkedHashMap<String, DnnShape>(outputs);
            } else {
                this.params.outputs.putAll(outputs);
            }
            return this;
        }

        public DnnModelParams build() {
            return new DnnModelParams(this.params);
        }
    }
}

