/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.dnn;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bytedeco.opencv.opencv_core.Mat;

public interface DnnModel
extends AutoCloseable {
    public static final String DEFAULT_INPUT_NAME = "input";
    public static final String DEFAULT_OUTPUT_NAME = "output";

    public Map<String, Mat> predict(Map<String, Mat> var1);

    default public Mat predict(Mat mat) {
        return this.predict(Map.of(DEFAULT_INPUT_NAME, mat)).get(DEFAULT_OUTPUT_NAME);
    }

    default public List<Mat> batchPredict(List<? extends Mat> mats) {
        ArrayList<Mat> output = new ArrayList<Mat>();
        for (Mat mat : mats) {
            output.add(this.predict(mat));
        }
        return output;
    }

    @Override
    default public void close() throws Exception {
    }
}

