/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.dnn;

import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.opencv.dnn.AbstractDnnModel;
import qupath.opencv.dnn.BlobFunction;
import qupath.opencv.dnn.PredictionFunction;

class DefaultDnnModel<T>
extends AbstractDnnModel<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDnnModel.class);
    private static final Set<String> DEFAULT_NAMES = Set.of("input", "output");
    private Map<String, BlobFunction<T>> blobFun;
    private PredictionFunction<T> predictFun;

    public DefaultDnnModel(BlobFunction<T> blobFun, PredictionFunction<T> predictFun) {
        this(Map.of("default", blobFun), predictFun);
    }

    public DefaultDnnModel(Map<String, BlobFunction<T>> blobFun, PredictionFunction<T> predictFun) {
        this.blobFun = new LinkedHashMap<String, BlobFunction<T>>(blobFun);
        this.predictFun = predictFun;
    }

    @Override
    public BlobFunction<T> getBlobFunction() {
        return this.blobFun.values().iterator().next();
    }

    @Override
    public BlobFunction<T> getBlobFunction(String name) {
        if (name == null) {
            return this.getBlobFunction();
        }
        return this.blobFun.getOrDefault(name, null);
    }

    @Override
    public PredictionFunction<T> getPredictionFunction() {
        return this.predictFun;
    }

    @Override
    public void close() throws Exception {
        logger.debug("Closing {}", (Object)this);
        this.tryToClose(this.blobFun);
        this.tryToClose(this.predictFun);
    }

    private void tryToClose(Object o) throws Exception {
        if (o instanceof AutoCloseable) {
            ((AutoCloseable)o).close();
        } else if (o instanceof Closeable) {
            ((Closeable)o).close();
        }
    }
}

