/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.dnn;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;
import qupath.lib.io.UriResource;
import qupath.opencv.dnn.BlobFunction;
import qupath.opencv.dnn.DnnTools;
import qupath.opencv.ops.ImageOp;
import qupath.opencv.tools.OpenCVTools;

class DefaultBlobFunction
implements BlobFunction<Mat>,
UriResource {
    private final ImageOp preprocessing;
    private final Size inputSize;
    private final boolean crop;

    DefaultBlobFunction(ImageOp preprocessing, Size inputSize, boolean crop) {
        this.preprocessing = preprocessing;
        this.inputSize = inputSize;
        this.crop = crop;
    }

    @Override
    public Mat toBlob(Mat ... mats) {
        Mat[] preprocessed = new Mat[mats.length];
        int ind = 0;
        for (Mat mat : mats) {
            Mat temp = mat.clone();
            if (this.preprocessing != null) {
                temp = this.preprocessing.apply(temp);
            }
            if (this.inputSize != null) {
                if (this.crop) {
                    int w = this.inputSize.width();
                    int h = this.inputSize.height();
                    double factor = Math.max((double)w / (double)temp.cols(), (double)h / (double)temp.rows());
                    opencv_imgproc.resize((Mat)temp, (Mat)temp, (Size)new Size(), (double)factor, (double)factor, (int)1);
                    int x = (temp.cols() - w) / 2;
                    int y = (temp.rows() - h) / 2;
                    temp.put(OpenCVTools.crop(temp, x, y, w, h));
                } else {
                    opencv_imgproc.resize((Mat)temp, (Mat)temp, (Size)this.inputSize, (double)0.0, (double)0.0, (int)1);
                }
            }
            preprocessed[ind] = temp;
            ++ind;
        }
        return DnnTools.blobFromImages(preprocessed);
    }

    @Override
    public List<Mat> fromBlob(Mat blob) {
        if (blob.dims() == 4) {
            return DnnTools.imagesFromBlob(blob);
        }
        int nRows = blob.rows();
        if (nRows == 1) {
            return Collections.singletonList(blob);
        }
        return IntStream.range(0, nRows).mapToObj(r -> blob.row(r)).toList();
    }

    public Collection<URI> getURIs() throws IOException {
        if (this.preprocessing == null) {
            return Collections.emptyList();
        }
        return this.preprocessing.getURIs();
    }

    public boolean updateURIs(Map<URI, URI> replacements) throws IOException {
        if (this.preprocessing == null) {
            return false;
        }
        return this.preprocessing.updateURIs(replacements);
    }
}

