/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv.dnn;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bytedeco.opencv.opencv_core.Mat;
import org.slf4j.LoggerFactory;
import qupath.opencv.dnn.BlobFunction;
import qupath.opencv.dnn.DnnModel;
import qupath.opencv.dnn.PredictionFunction;

public abstract class AbstractDnnModel<T>
implements DnnModel {
    public abstract BlobFunction<T> getBlobFunction();

    public abstract BlobFunction<T> getBlobFunction(String var1);

    public abstract PredictionFunction<T> getPredictionFunction();

    @Override
    public Map<String, Mat> predict(Map<String, Mat> blobs) {
        Map<String, Object> input = blobs.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> this.getBlobFunction((String)e.getKey()).toBlob((Mat)e.getValue())));
        Map<String, Object> prediction = this.getPredictionFunction().predict(input);
        Map<String, Mat> output = prediction.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> this.getBlobFunction((String)e.getKey()).fromBlob(e.getValue()).get(0)));
        return output;
    }

    @Override
    public Mat predict(Mat mat) {
        T blob = this.getBlobFunction().toBlob(mat);
        T prediction = this.getPredictionFunction().predict(blob);
        List<Mat> output = this.getBlobFunction().fromBlob(prediction);
        if (output.size() > 1) {
            LoggerFactory.getLogger(DnnModel.class).warn("Expected single output but got {} outputs - I will return the first only", (Object)output.size());
        }
        return output.get(0);
    }

    @Override
    public List<Mat> batchPredict(List<? extends Mat> mats) {
        T blob = this.getBlobFunction().toBlob((Mat[])mats.toArray(Mat[]::new));
        T prediction = this.getPredictionFunction().predict(blob);
        List<Mat> output = this.getBlobFunction().fromBlob(prediction);
        return output;
    }
}

