/*
 * Decompiled with CFR 0.152.
 */
package qupath.opencv;

import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.MatVector;
import org.bytedeco.opencv.opencv_core.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.ColorTransformer;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.geom.Point2;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.plugins.AbstractTileableDetectionPlugin;
import qupath.lib.plugins.ObjectDetector;
import qupath.lib.plugins.parameters.Parameter;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.PolygonROI;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class CellCountsCV
extends AbstractTileableDetectionPlugin<BufferedImage> {
    private static Logger logger = LoggerFactory.getLogger(CellCountsCV.class);
    private static String HEMATOXYLIN = "Hematoxylin";
    private static String DAB = "DAB";
    private static String HEMATOXYLIN_PLUS_DAB = "Hematoxylin + DAB";
    private static List<String> STAIN_CHANNELS = Arrays.asList(HEMATOXYLIN, DAB, HEMATOXYLIN_PLUS_DAB);

    private static void putFloatPixels(Mat mat, float[] pixels) {
        FloatBuffer buffer = (FloatBuffer)mat.createBuffer();
        buffer.put(pixels);
    }

    protected boolean parseArgument(ImageData<BufferedImage> imageData, String arg) {
        ColorDeconvolutionStains stains = imageData.getColorDeconvolutionStains();
        if (!imageData.isBrightfield() || stains == null || !stains.isH_E() && !stains.isH_DAB()) {
            throw new IllegalArgumentException("This command only supports brightfield images with H&E or H-DAB staining, sorry!");
        }
        return super.parseArgument(imageData, arg);
    }

    public ParameterList getDefaultParameterList(ImageData<BufferedImage> imageData) {
        ParameterList params = new ParameterList().addTitleParameter("Detection image").addChoiceParameter("stainChannel", "Cell detection channel", (Object)HEMATOXYLIN, STAIN_CHANNELS, "Choose channel that will be thresholded to detect the cells").addDoubleParameter("magnification", "Requested magnification", Double.NaN, null, "Magnification at which the detection should be run").addDoubleParameter("gaussianSigmaPixels", "Gaussian sigma", 1.0, "px", "Smoothing filter used to reduce spurious peaks").addDoubleParameter("gaussianSigmaMicrons", "Gaussian sigma", 1.5, GeneralTools.micrometerSymbol(), "Smoothing filter used to reduce spurious peaks").addDoubleParameter("backgroundRadiusPixels", "Background radius", 20.0, "px", "Filter size to estimate background; should be > the largest nucleus radius").addDoubleParameter("backgroundRadiusMicrons", "Background radius", 15.0, GeneralTools.micrometerSymbol(), "Filter size to estimate background; should be > the largest nucleus radius").addBooleanParameter("doDoG", "Use Difference of Gaussians", true, "Apply Difference of Gaussians filter prior to detection - this tends to detect more nuclei, but may detect too many").addTitleParameter("Thresholding").addDoubleParameter("threshold", "Cell detection threshold", 0.1, null, "Hematoxylin intensity threshold").addDoubleParameter("thresholdDAB", "DAB threshold", 0.2, null, "DAB OD threshold for positive percentage counts").addBooleanParameter("ensureMainStain", "Hematoxylin predominant", false, "Accept detection only if haematoxylin value is higher than that of the second deconvolved stain").addTitleParameter("Display").addDoubleParameter("detectionDiameter", "Detection object diameter", 25.0, "pixels", "Adjust the size of detection object that is created around each peak (note, this does not influence which cells are detected");
        params.setHiddenParameters(true, new String[]{"magnification"});
        boolean isHDAB = imageData.isBrightfield() && imageData.getColorDeconvolutionStains().isH_DAB();
        params.setHiddenParameters(!isHDAB, new String[]{"stainChannel"});
        params.setHiddenParameters(isHDAB, new String[]{"ensureMainStain"});
        params.setHiddenParameters(!isHDAB, new String[]{"thresholdDAB"});
        boolean hasMicrons = imageData != null && imageData.getServer() != null && imageData.getServer().getPixelCalibration().hasPixelSizeMicrons();
        ((Parameter)params.getParameters().get("gaussianSigmaPixels")).setHidden(hasMicrons);
        ((Parameter)params.getParameters().get("gaussianSigmaMicrons")).setHidden(!hasMicrons);
        ((Parameter)params.getParameters().get("backgroundRadiusPixels")).setHidden(hasMicrons);
        ((Parameter)params.getParameters().get("backgroundRadiusMicrons")).setHidden(!hasMicrons);
        return params;
    }

    public String getName() {
        return "Fast cell counts";
    }

    public String getDescription() {
        return "Perform a fast, low-resolution count of nuclei in a whole slide image stained with H&E or hematoxylin and DAB using a peak-finding approach";
    }

    public String getLastResultsDescription() {
        return null;
    }

    protected double getPreferredPixelSizeMicrons(ImageData<BufferedImage> imageData, ParameterList params) {
        return 2.0;
    }

    protected ObjectDetector<BufferedImage> createDetector(ImageData<BufferedImage> imageData, ParameterList params) {
        return new FastCellCounter();
    }

    protected int getTileOverlap(ImageData<BufferedImage> imageData, ParameterList params) {
        return 0;
    }

    static class FastCellCounter
    implements ObjectDetector<BufferedImage> {
        private String lastResult = null;

        FastCellCounter() {
        }

        public Collection<PathObject> runDetection(ImageData<BufferedImage> imageData, ParameterList params, ROI pathROI) throws IOException {
            double stain2Threshold;
            double backgroundRadius;
            double gaussianSigma;
            double downsample;
            ArrayList<PathObject> pathObjects = new ArrayList<PathObject>();
            String stainChannel = (String)params.getChoiceParameterValue("stainChannel");
            if (stainChannel == null) {
                logger.debug("Stain channel not set - will default to 'Hematoxylin'");
                stainChannel = "Hematoxylin";
            }
            double magnification = params.getDoubleParameterValue("magnification");
            PixelCalibration cal = imageData.getServer().getPixelCalibration();
            boolean hasMicrons = imageData != null && imageData.getServer() != null && cal.hasPixelSizeMicrons();
            double threshold = params.getDoubleParameterValue("threshold");
            boolean doDoG = params.getBooleanParameterValue("doDoG");
            boolean ensureMainStain = params.getBooleanParameterValue("ensureMainStain");
            double radius = params.getDoubleParameterValue("detectionDiameter") / 2.0;
            if (!Double.isFinite(radius) || radius < 0.0) {
                radius = 10.0;
            }
            if ((downsample = imageData.getServerMetadata().getMagnification() / magnification) < 1.0) {
                downsample = 1.0;
            }
            if (hasMicrons) {
                gaussianSigma = params.getDoubleParameterValue("gaussianSigmaMicrons") / cal.getAveragedPixelSizeMicrons();
                backgroundRadius = params.getDoubleParameterValue("backgroundRadiusMicrons") / cal.getAveragedPixelSizeMicrons();
                if (!Double.isFinite(downsample)) {
                    downsample = Math.max(1L, Math.round(gaussianSigma / 1.25));
                }
                gaussianSigma /= downsample;
                backgroundRadius /= downsample;
            } else {
                if (!Double.isFinite(downsample)) {
                    downsample = 1.0;
                }
                gaussianSigma = params.getDoubleParameterValue("gaussianSigmaPixels") / downsample;
                backgroundRadius = params.getDoubleParameterValue("backgroundRadiusPixels") / downsample;
            }
            logger.debug("Fast cell counting with Gaussian sigma {} pixels, downsample {}", (Object)gaussianSigma, (Object)downsample);
            ImageServer server = imageData.getServer();
            RegionRequest request = RegionRequest.createInstance((String)server.getPath(), (double)downsample, (ROI)pathROI);
            BufferedImage img = (BufferedImage)server.readRegion(request);
            double x = request.getX();
            double y = request.getY();
            double scaleX = (double)request.getWidth() / (double)img.getWidth();
            double scaleY = (double)request.getHeight() / (double)img.getHeight();
            ColorDeconvolutionStains stains = imageData.getColorDeconvolutionStains();
            int[] rgb = img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth());
            float[] pxNucleusStain = ColorTransformer.getTransformedPixels((int[])rgb, (ColorTransformer.ColorTransformMethod)ColorTransformer.ColorTransformMethod.Stain_1, null, (ColorDeconvolutionStains)stains);
            float[] pxStain2 = ColorTransformer.getTransformedPixels((int[])rgb, (ColorTransformer.ColorTransformMethod)ColorTransformer.ColorTransformMethod.Stain_2, null, (ColorDeconvolutionStains)stains);
            double d = stain2Threshold = imageData.isBrightfield() && imageData.getColorDeconvolutionStains().isH_DAB() ? params.getDoubleParameterValue("thresholdDAB") : -1.0;
            if (stainChannel.equals(DAB)) {
                for (i = 0; i < pxNucleusStain.length; ++i) {
                    pxNucleusStain[i] = pxStain2[i];
                }
            } else if (stainChannel.equals(HEMATOXYLIN_PLUS_DAB)) {
                for (i = 0; i < pxNucleusStain.length; ++i) {
                    int n = i;
                    pxNucleusStain[n] = pxNucleusStain[n] + pxStain2[i];
                }
            }
            int width = img.getWidth();
            int height = img.getHeight();
            Mat matOrig = new Mat(height, width, opencv_core.CV_32FC1);
            CellCountsCV.putFloatPixels(matOrig, pxNucleusStain);
            if (backgroundRadius > 0.0) {
                Mat matBG = new Mat();
                int size = (int)Math.round(backgroundRadius) * 2 + 1;
                Mat kernel = opencv_imgproc.getStructuringElement((int)2, (Size)new Size(size, size));
                opencv_imgproc.morphologyEx((Mat)matOrig, (Mat)matBG, (int)2, (Mat)kernel);
                opencv_core.subtract((Mat)matOrig, (Mat)matBG, (Mat)matOrig);
            }
            int gaussianWidth = (int)(Math.ceil(gaussianSigma * 3.0) * 2.0 + 1.0);
            Mat mat = new Mat();
            opencv_imgproc.GaussianBlur((Mat)matOrig, (Mat)mat, (Size)new Size(gaussianWidth, gaussianWidth), (double)gaussianSigma);
            Mat matStain2 = new Mat(height, width, opencv_core.CV_32FC1);
            CellCountsCV.putFloatPixels(matStain2, pxStain2);
            opencv_imgproc.GaussianBlur((Mat)matStain2, (Mat)matStain2, (Size)new Size(gaussianWidth, gaussianWidth), (double)gaussianSigma);
            Mat matThresh = new Mat();
            opencv_imgproc.threshold((Mat)mat, (Mat)matThresh, (double)threshold, (double)255.0, (int)0);
            matThresh.convertTo(matThresh, opencv_core.CV_8UC1);
            if (ensureMainStain) {
                Mat matValid = new Mat();
                opencv_core.compare((Mat)mat, (Mat)matStain2, (Mat)matValid, (int)2);
                opencv_core.min((Mat)matThresh, (Mat)matValid, (Mat)matThresh);
                matValid.close();
            }
            if (doDoG) {
                double sigma2 = gaussianSigma * 1.6;
                int gaussianWidth2 = (int)(Math.ceil(sigma2 * 3.0) * 2.0 + 1.0);
                Mat mat2 = new Mat();
                opencv_imgproc.GaussianBlur((Mat)matOrig, (Mat)mat2, (Size)new Size(gaussianWidth2, gaussianWidth2), (double)sigma2);
                opencv_core.subtract((Mat)mat, (Mat)mat2, (Mat)mat);
            }
            Mat matMax = new Mat(mat.size(), mat.type());
            opencv_imgproc.dilate((Mat)mat, (Mat)matMax, (Mat)new Mat());
            Mat matMaxima = new Mat();
            opencv_core.compare((Mat)mat, (Mat)matMax, (Mat)matMaxima, (int)0);
            opencv_core.min((Mat)matThresh, (Mat)matMaxima, (Mat)matMaxima);
            MatVector contours = new MatVector();
            Mat temp = new Mat();
            opencv_imgproc.findContours((Mat)matMaxima, (MatVector)contours, (Mat)temp, (int)0, (int)2);
            temp.close();
            ArrayList<Point2> points = new ArrayList<Point2>();
            Shape shape = pathROI != null && pathROI.isArea() ? RoiTools.getShape((ROI)pathROI) : null;
            Integer color = ColorTools.packRGB((int)0, (int)255, (int)0);
            String stain2Name = stains.getStain(2).getName();
            ROI area = pathROI != null && pathROI.isArea() ? pathROI : null;
            boolean detectInPositiveChannel = stainChannel.equals(DAB);
            FloatIndexer indexerStain2 = (FloatIndexer)matStain2.createIndexer();
            for (long c = 0L; c < contours.size(); ++c) {
                Mat contour = contours.get(c);
                points.clear();
                IntIndexer indexerContour = (IntIndexer)contour.createIndexer();
                int r = 0;
                while ((long)r < indexerContour.size(0)) {
                    int px = indexerContour.get((long)r, 0L, 0L);
                    int py = indexerContour.get((long)r, 0L, 1L);
                    points.add(new Point2(((double)px + 0.5) * scaleX + x, ((double)py + 0.5) * scaleY + y));
                    ++r;
                }
                PolygonROI tempROI = null;
                if (points.size() == 1) {
                    Point2 p = (Point2)points.get(0);
                    if (shape != null && !shape.contains(p.getX(), p.getY()) || area != null && !area.contains(p.getX(), p.getY())) continue;
                    tempROI = ROIs.createEllipseROI((double)(p.getX() - radius), (double)(p.getY() - radius), (double)(radius * 2.0), (double)(radius * 2.0), (ImagePlane)ImagePlane.getPlane((ROI)pathROI));
                } else {
                    tempROI = ROIs.createPolygonROI(points, (ImagePlane)ImagePlane.getPlane((ROI)pathROI));
                    if (area != null && !area.contains(tempROI.getCentroidX(), tempROI.getCentroidY())) continue;
                    tempROI = ROIs.createEllipseROI((double)(tempROI.getCentroidX() - radius), (double)(tempROI.getCentroidY() - radius), (double)(radius * 2.0), (double)(radius * 2.0), (ImagePlane)ImagePlane.getPlane((ROI)pathROI));
                }
                PathObject pathObject = PathObjects.createDetectionObject((ROI)tempROI);
                if (stain2Threshold >= 0.0) {
                    int cx = (int)((tempROI.getCentroidX() - x) / scaleX);
                    int cy = (int)((tempROI.getCentroidY() - y) / scaleY);
                    float stain2Value = indexerStain2.get((long)cy, (long)cx);
                    if (detectInPositiveChannel || (double)stain2Value >= stain2Threshold) {
                        pathObject.setPathClass(PathClass.getPositive(null));
                    } else {
                        pathObject.setPathClass(PathClass.getNegative(null));
                    }
                    pathObject.getMeasurementList().put(stain2Name + " OD", (double)stain2Value);
                    pathObject.getMeasurementList().close();
                } else {
                    pathObject.setColor(color);
                }
                contour.release();
                pathObjects.add(pathObject);
            }
            logger.info("Found " + pathObjects.size() + " contours");
            matThresh.release();
            matMax.release();
            matMaxima.release();
            matOrig.release();
            matStain2.release();
            this.lastResult = "Detected " + pathObjects.size() + " cells";
            return pathObjects;
        }

        public String getLastResultsDescription() {
            return this.lastResult;
        }
    }
}

