/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.scripting.languages;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import qupath.lib.scripting.languages.ScriptAutoCompletor;

public abstract class ScriptLanguage {
    private String name;
    private Set<String> exts;

    protected ScriptLanguage(String name, Collection<String> exts) {
        this.name = name;
        this.exts = exts != null && !exts.isEmpty() ? Collections.unmodifiableSet(new LinkedHashSet<String>(exts)) : Collections.emptySet();
    }

    protected ScriptLanguage(String name, String ext) {
        this.name = name;
        this.exts = ext == null ? Collections.emptySet() : Collections.singleton(ext);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getExtensions() {
        return this.exts;
    }

    public ScriptAutoCompletor getAutoCompletor() {
        return null;
    }

    public String toString() {
        return this.name;
    }
}

