/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.scripting.languages;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;

public class AutoCompletions {
    private static final Comparator<Completion> COMPARATOR = Comparator.comparing(Completion::getCompletionText).thenComparing(Completion::getDisplayText);
    public static final CompletionTokenizer SUBSTRING_TOKENIZER = AutoCompletions::getSubstringToken;
    public static final CompletionTokenizer JAVA_TOKENIZER = AutoCompletions::getLastJavaToken;

    public static Comparator<Completion> getComparator() {
        return COMPARATOR;
    }

    private static String getSubstringToken(String text, int lastPos) {
        return text.substring(0, lastPos);
    }

    private static String getLastJavaToken(String text, int pos) {
        String[] split = text.substring(0, pos).split("(\\s+)|(\\()|(\\))|(\\{)|(\\})|(\\[)|(\\])");
        String start = split.length == 0 ? "" : split[split.length - 1].trim();
        return start;
    }

    public static Completion createJavaCompletion(Class<?> declaringClass, String displayText, String completionText) {
        return new JavaCompletion(declaringClass, displayText, completionText);
    }

    public static Completion createJavaCompletion(Class<?> cls) {
        return new JavaCompletion(cls, cls.getSimpleName(), cls.getSimpleName() + ".");
    }

    public static Completion createJavaCompletion(Class<?> declaringClass, Field field) {
        return AutoCompletions.createJavaCompletion(declaringClass, field.getType().getSimpleName() + " " + field.getName(), field.getName());
    }

    public static Completion createJavaCompletion(Class<?> declaringClass, Method method) {
        return AutoCompletions.createJavaCompletion(declaringClass, AutoCompletions.getMethodString(method), AutoCompletions.getMethodName(method));
    }

    private static String getMethodName(Method method) {
        return method.getName() + "()";
    }

    private static String getMethodString(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType().getSimpleName());
        sb.append(" ");
        sb.append(method.getName());
        sb.append("(");
        sb.append(Arrays.stream(method.getParameters()).map(p -> AutoCompletions.getParameterString(p)).collect(Collectors.joining(", ")));
        sb.append(")");
        return sb.toString();
    }

    private static String getParameterString(Parameter parameter) {
        if (parameter.isNamePresent()) {
            return parameter.getType().getSimpleName() + " " + parameter.getName();
        }
        return parameter.getType().getSimpleName();
    }

    static class JavaCompletion
    implements Completion {
        private Class<?> parentClass;
        private String displayText;
        private String completionText;

        private JavaCompletion(Class<?> parentClass, String displayText, String completionText) {
            this.parentClass = parentClass;
            this.displayText = displayText;
            this.completionText = completionText;
        }

        @Override
        public String getDisplayText() {
            return this.displayText;
        }

        @Override
        public String getCompletionText() {
            return this.completionText;
        }

        @Override
        public String getInsertion(String fullText, int pos, String token) {
            int lastDot;
            if (token == null) {
                token = this.getTokenizer().getToken(fullText, pos);
            }
            String completionText = this.getCompletionText();
            if (this.parentClass != null && !completionText.contains(".") && (lastDot = token.lastIndexOf(".")) >= 0 && lastDot != token.length() - 1) {
                token = token.substring(lastDot + 1);
            }
            String insertion = completionText.startsWith(token) ? completionText.substring(token.length()) : completionText;
            return insertion;
        }

        @Override
        public boolean isCompatible(String fullText, int pos, String token) {
            if (token == null) {
                token = this.getTokenizer().getToken(fullText, pos);
            }
            if (this.parentClass != null) {
                int ind = token.lastIndexOf(".");
                if (ind <= 0) {
                    return (this.parentClass.getName().startsWith(token) || this.parentClass.getSimpleName().startsWith(token)) && this.completionText.startsWith(token);
                }
                String first = token.substring(0, ind);
                String second = token.substring(ind + 1);
                if (this.parentClass.getName().equals(first) || this.parentClass.getSimpleName().equals(first)) {
                    return this.completionText.startsWith(second);
                }
                return false;
            }
            return this.completionText.startsWith(token);
        }

        @Override
        public CompletionTokenizer getTokenizer() {
            return JAVA_TOKENIZER;
        }

        public int hashCode() {
            return Objects.hash(this.completionText, this.displayText, this.parentClass);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JavaCompletion other = (JavaCompletion)obj;
            return Objects.equals(this.completionText, other.completionText) && Objects.equals(this.displayText, other.displayText) && Objects.equals(this.parentClass, other.parentClass);
        }
    }

    public static interface Completion {
        public String getCompletionText();

        public String getDisplayText();

        public String getInsertion(String var1, int var2, String var3);

        public boolean isCompatible(String var1, int var2, String var3);

        default public CompletionTokenizer getTokenizer() {
            return SUBSTRING_TOKENIZER;
        }
    }

    public static interface CompletionTokenizer {
        public String getToken(String var1, int var2);
    }
}

