/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.scripting;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.projects.Project;
import qupath.lib.scripting.LoggingTools;

public class ScriptParameters {
    private List<Class<?>> defaultImports;
    private List<Class<?>> defaultStaticImports;
    private File file;
    private String script;
    private Project<?> project;
    private ImageData<?> imageData;
    private boolean requestHierarchyUpdate = true;
    private boolean useCompiled = false;
    private Writer writer;
    private Writer errorWriter;
    private String[] args;
    private int batchSize = 1;
    private int batchIndex = 0;
    private boolean batchSaveResult;

    private ScriptParameters() {
    }

    public File getFile() {
        return this.file;
    }

    public String getScript() {
        if (this.script == null) {
            if (this.file != null && this.file.exists()) {
                try {
                    return GeneralTools.readFileAsString((String)this.file.getAbsolutePath());
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read script from " + String.valueOf(this.file), e);
                }
            }
            throw new RuntimeException("No file or script found!");
        }
        return this.script;
    }

    public Project<?> getProject() {
        return this.project;
    }

    public ImageData<?> getImageData() {
        return this.imageData;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getBatchIndex() {
        return this.batchIndex;
    }

    public Boolean getBatchSaveResult() {
        return this.batchSaveResult;
    }

    public String[] getArgs() {
        return this.args == null ? new String[]{} : (String[])this.args.clone();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    public List<Class<?>> getDefaultImports() {
        return this.defaultImports;
    }

    public boolean useCompiled() {
        return this.useCompiled;
    }

    public boolean doUpdateHierarchy() {
        return this.requestHierarchyUpdate;
    }

    public List<Class<?>> getDefaultStaticImports() {
        return this.defaultStaticImports;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<Class<?>> defaultImports = Collections.emptyList();
        private List<Class<?>> defaultStaticImports = Collections.emptyList();
        private File file;
        private String script;
        private Project<?> project;
        private ImageData<?> imageData;
        private boolean useCompiled = false;
        private Writer writer;
        private Writer errorWriter;
        private String[] args;
        private boolean requestHierarchyUpdate = true;
        private int batchSize = 1;
        private int batchIndex = 0;
        private boolean batchSaveResult = false;

        private Builder() {
        }

        public Builder setDefaultImports(Collection<Class<?>> imports) {
            this.defaultImports = imports == null ? Collections.emptyList() : new ArrayList(imports);
            return this;
        }

        public Builder setDefaultStaticImports(Collection<Class<?>> imports) {
            this.defaultStaticImports = imports == null ? Collections.emptyList() : new ArrayList(imports);
            return this;
        }

        public Builder setFile(File file) {
            this.file = file;
            return this;
        }

        public Builder setScript(String script) {
            this.script = script;
            return this;
        }

        public Builder setSystemWriters() {
            this.writer = new PrintWriter(System.out);
            this.errorWriter = new PrintWriter(System.err);
            return this;
        }

        public Builder useLogWriters(Logger logger) {
            this.writer = LoggingTools.createLogWriter(logger, Level.INFO);
            this.errorWriter = LoggingTools.createLogWriter(logger, Level.ERROR);
            return this;
        }

        public Builder useLogWriters() {
            return this.useLogWriters(null);
        }

        public Builder setWriter(Writer writer) {
            this.writer = writer;
            return this;
        }

        public Builder setErrorWriter(Writer writer) {
            this.errorWriter = writer;
            return this;
        }

        public Builder setBatchSize(int batch) {
            this.batchSize = batch;
            return this;
        }

        public Builder setBatchIndex(int ind) {
            this.batchIndex = ind;
            return this;
        }

        public Builder setBatchSaveResult(boolean doSave) {
            this.batchSaveResult = doSave;
            return this;
        }

        public Builder setArgs(String[] args) {
            this.args = (String[])args.clone();
            return this;
        }

        public Builder setProject(Project<?> project) {
            this.project = project;
            return this;
        }

        public Builder setImageData(ImageData<?> imageData) {
            this.imageData = imageData;
            return this;
        }

        public Builder doUpdateHierarchy(boolean requestUpdate) {
            this.requestHierarchyUpdate = requestUpdate;
            return this;
        }

        public Builder useCompiled(boolean useCompiled) {
            this.useCompiled = useCompiled;
            return this;
        }

        public ScriptParameters build() throws IllegalArgumentException {
            ScriptParameters params = new ScriptParameters();
            params.defaultImports = this.defaultImports;
            params.defaultStaticImports = this.defaultStaticImports;
            params.file = this.file;
            if (this.script == null && this.file == null) {
                throw new IllegalArgumentException("Either 'script' or 'file' must not be null!");
            }
            params.script = this.script;
            params.project = this.project;
            params.imageData = this.imageData;
            params.writer = this.writer == null ? new PrintWriter(System.out) : this.writer;
            params.errorWriter = this.errorWriter == null ? new PrintWriter(System.err) : this.errorWriter;
            params.requestHierarchyUpdate = this.requestHierarchyUpdate;
            params.useCompiled = this.useCompiled;
            params.args = this.args;
            params.batchSize = this.batchSize;
            params.batchIndex = this.batchIndex;
            params.batchSaveResult = this.batchSaveResult;
            return params;
        }
    }
}

