/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.scripting;

import com.google.common.collect.ObjectArrays;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.imagej.processing.IJFilters;
import qupath.imagej.tools.IJProperties;
import qupath.imagej.tools.IJTools;
import qupath.lib.analysis.DelaunayTools;
import qupath.lib.analysis.DistanceTools;
import qupath.lib.analysis.features.ObjectMeasurements;
import qupath.lib.analysis.heatmaps.ColorModels;
import qupath.lib.analysis.heatmaps.DensityMaps;
import qupath.lib.analysis.images.ContourTracing;
import qupath.lib.awt.common.AffineTransforms;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.classifiers.object.ObjectClassifier;
import qupath.lib.classifiers.object.ObjectClassifiers;
import qupath.lib.classifiers.pixel.PixelClassifier;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.LogTools;
import qupath.lib.common.Timeit;
import qupath.lib.common.Version;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ColorTransforms;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServerProvider;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.LabeledImageServer;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.images.servers.TransformedServerBuilder;
import qupath.lib.images.writers.ImageWriterTools;
import qupath.lib.images.writers.TileExporter;
import qupath.lib.io.GsonTools;
import qupath.lib.io.PathIO;
import qupath.lib.io.PointIO;
import qupath.lib.io.UriResource;
import qupath.lib.io.UriUpdater;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.CellTools;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.PathObjectPredicates;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;
import qupath.lib.objects.hierarchy.DefaultTMAGrid;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.objects.utils.ObjectMerger;
import qupath.lib.objects.utils.Tiler;
import qupath.lib.plugins.CommandLineTaskRunner;
import qupath.lib.plugins.PathPlugin;
import qupath.lib.plugins.TaskRunner;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectIO;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.projects.Projects;
import qupath.lib.projects.ResourceManager;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.Padding;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.GeometryTools;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.ShapeSimplifier;
import qupath.lib.roi.interfaces.ROI;
import qupath.lib.scripting.ScriptAttributes;
import qupath.opencv.dnn.DnnModelParams;
import qupath.opencv.dnn.DnnModels;
import qupath.opencv.dnn.DnnTools;
import qupath.opencv.io.OpenCVTypeAdapters;
import qupath.opencv.ml.BioimageIoTools;
import qupath.opencv.ml.objects.OpenCVMLClassifier;
import qupath.opencv.ml.objects.features.FeatureExtractors;
import qupath.opencv.ml.pixel.PixelClassifierTools;
import qupath.opencv.ml.pixel.PixelClassifiers;
import qupath.opencv.ops.ImageOps;
import qupath.opencv.tools.GroovyCV;
import qupath.opencv.tools.NumpyTools;
import qupath.opencv.tools.OpenCVTools;

public class QP {
    private static final Logger logger = LoggerFactory.getLogger(QP.class);
    public static final ImageData.ImageType BRIGHTFIELD_H_DAB = ImageData.ImageType.BRIGHTFIELD_H_DAB;
    public static final ImageData.ImageType BRIGHTFIELD_H_E = ImageData.ImageType.BRIGHTFIELD_H_E;
    public static final ImageData.ImageType BRIGHTFIELD_OTHER = ImageData.ImageType.BRIGHTFIELD_OTHER;
    public static final ImageData.ImageType FLUORESCENCE = ImageData.ImageType.FLUORESCENCE;
    public static final ImageData.ImageType OTHER = ImageData.ImageType.OTHER;
    private static Map<Thread, ImageData<BufferedImage>> batchImageData = new WeakHashMap<Thread, ImageData<BufferedImage>>();
    private static Map<Thread, Project<BufferedImage>> batchProject = new WeakHashMap<Thread, Project<BufferedImage>>();
    public static final String PROJECT_BASE_DIR = "{%PROJECT}";
    public static final String USER_HOME = System.getProperty("user.home");
    public static final Version VERSION = GeneralTools.getSemanticVersion();
    private static final Set<Class<?>> CORE_CLASSES;
    private static Project<BufferedImage> defaultProject;
    private static ImageData<BufferedImage> defaultImageData;

    public static String describe(Object o) {
        return QP.describe(o instanceof Class ? (Class<?>)o : o.getClass());
    }

    public static String describe(Class<?> cls) {
        List<Method> methods;
        StringBuilder sb = new StringBuilder(cls.getName());
        List<Field> fields = QP.getPublicFields(cls);
        if (!fields.isEmpty()) {
            sb.append("\n").append("  Fields:");
            for (Field f : fields) {
                sb.append("\n").append("    ").append(QP.getString(f));
            }
        }
        if (!(methods = QP.getPublicMethods(cls)).isEmpty()) {
            sb.append("\n").append("  Methods:");
            for (Method m : methods) {
                sb.append("\n").append("    ").append(QP.getString(m));
            }
        }
        return sb.toString();
    }

    private static List<Method> getPublicMethods(Object o) {
        Class<?> cls = o instanceof Class ? (Class<?>)o : o.getClass();
        return Arrays.stream(cls.getMethods()).filter(m -> !Object.class.equals(m.getDeclaringClass()) && QP.isPublic(m) && m.getAnnotation(Deprecated.class) == null).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).toList();
    }

    private static List<Field> getPublicFields(Object o) {
        Class<?> cls = o instanceof Class ? (Class<?>)o : o.getClass();
        return Arrays.stream(cls.getFields()).filter(f -> !Object.class.equals(f.getDeclaringClass()) && QP.isPublic(f) && f.getAnnotation(Deprecated.class) == null).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).toList();
    }

    private static boolean isPublic(Member m) {
        return Modifier.isPublic(m.getModifiers());
    }

    private static String getString(Method m) {
        StringBuilder sb = new StringBuilder();
        if (Modifier.isStatic(m.getModifiers())) {
            sb.append("static ");
        }
        sb.append(m.getReturnType().getSimpleName());
        sb.append(" ");
        sb.append(m.getName());
        sb.append('(');
        sb.append(Stream.of(m.getParameterTypes()).map(t -> t.getSimpleName()).collect(Collectors.joining(", ")));
        sb.append(')');
        Class<?>[] exceptions = m.getExceptionTypes();
        if (exceptions.length > 0) {
            sb.append(Stream.of(exceptions).map(t -> t.getSimpleName()).collect(Collectors.joining(", ", " throws ", "")));
        }
        return sb.toString();
    }

    private static String getString(Field f) {
        return f.toString();
    }

    public static Collection<Class<?>> getCoreClasses() {
        return CORE_CLASSES;
    }

    public static void setDefaultProject(Project<BufferedImage> project) {
        defaultProject = project;
        logger.debug("Default project set to {}", project);
    }

    public static void setDefaultImageData(ImageData<BufferedImage> imageData) {
        defaultImageData = imageData;
        logger.debug("Default image data set to {}", defaultImageData);
    }

    public static void setBatchProjectAndImage(Project<BufferedImage> project, ImageData<BufferedImage> imageData) {
        QP.setBatchProject(project);
        QP.setBatchImageData(imageData);
    }

    public static void resetBatchProjectAndImage() {
        QP.setBatchProject(null);
        QP.setBatchImageData(null);
    }

    static ImageData<BufferedImage> setBatchImageData(ImageData<BufferedImage> imageData) {
        Thread thread = Thread.currentThread();
        logger.trace("Setting image data for {} to {}", (Object)thread, imageData);
        if (imageData == null) {
            return batchImageData.remove(thread);
        }
        return batchImageData.put(thread, imageData);
    }

    static ImageData<BufferedImage> getBatchImageData() {
        return batchImageData.get(Thread.currentThread());
    }

    static Project<BufferedImage> setBatchProject(Project<BufferedImage> project) {
        Thread thread = Thread.currentThread();
        logger.trace("Setting project for {} to {}", (Object)thread, project);
        if (project == null) {
            return batchProject.remove(thread);
        }
        return batchProject.put(thread, project);
    }

    static Project<BufferedImage> getBatchProject() {
        return batchProject.get(Thread.currentThread());
    }

    @Deprecated
    public static ImageData<BufferedImage> loadImageData(String path, boolean setBatchData) throws IOException {
        ImageData imageData = PathIO.readImageData((File)new File(QP.resolvePath(path)));
        if (setBatchData && imageData != null) {
            QP.setBatchImageData((ImageData<BufferedImage>)imageData);
        }
        return imageData;
    }

    public static void fireHierarchyUpdate() {
        QP.fireHierarchyUpdate(QP.getCurrentHierarchy());
    }

    public static void fireHierarchyUpdate(PathObjectHierarchy hierarchy) {
        if (hierarchy != null) {
            hierarchy.fireHierarchyChangedEvent(QP.class);
        }
    }

    @Deprecated
    public static Integer getColorRGB(int ... v) {
        if (v.length == 1) {
            return ColorTools.packRGB((int)v[0], (int)v[0], (int)v[0]);
        }
        if (v.length == 3) {
            return ColorTools.packRGB((int)v[0], (int)v[1], (int)v[2]);
        }
        if (v.length == 4) {
            return ColorTools.packARGB((int)v[3], (int)v[0], (int)v[1], (int)v[2]);
        }
        throw new IllegalArgumentException("Input to getColorRGB must be either 1, 3 or 4 integer values, between 0 and 255!");
    }

    public static Integer makeRGB(int r, int g, int b) {
        return ColorTools.packClippedRGB((int)r, (int)g, (int)b);
    }

    public static Integer makeARGB(int a, int r, int g, int b) {
        return ColorTools.packClippedARGB((int)a, (int)r, (int)g, (int)b);
    }

    public static String getCurrentServerPath() {
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        if (imageData == null) {
            return null;
        }
        return imageData.getServerPath();
    }

    public static ImageData<BufferedImage> getCurrentImageData() {
        ImageData<BufferedImage> defaultTemp = defaultImageData;
        ImageData<BufferedImage> imageData = QP.getBatchImageData();
        if (imageData != null || defaultTemp == null) {
            return imageData;
        }
        Collection<ImageData<BufferedImage>> batchImages = batchImageData.values();
        if (batchImages.isEmpty() || batchImages.size() == 1 && batchImages.contains(defaultTemp)) {
            logger.debug("Returning the default ImageData: {}", defaultTemp);
            return defaultTemp;
        }
        logger.warn("No batch image data for the current thread, returning the default image data instead: {}", defaultTemp);
        return defaultTemp;
    }

    public static Project<BufferedImage> getProject() {
        Project<BufferedImage> defaultTemp = defaultProject;
        Project<BufferedImage> project = QP.getBatchProject();
        if (project != null || defaultTemp == null) {
            return project;
        }
        Collection<Project<BufferedImage>> batchProjects = batchProject.values();
        if (batchProjects.isEmpty() || batchProjects.size() == 1 && batchProjects.contains(defaultTemp)) {
            logger.debug("Returning the default project: {}", defaultTemp);
            return defaultTemp;
        }
        logger.warn("No batch project for the current thread, returning the default project instead {}", defaultTemp);
        return defaultTemp;
    }

    public static String resolvePath(String path) throws IllegalArgumentException {
        String base = QP.getProjectBaseDirectory();
        if (base != null) {
            return path.replace(PROJECT_BASE_DIR, base);
        }
        if (path.contains(PROJECT_BASE_DIR)) {
            throw new IllegalArgumentException("No project base directory available - '" + path + "' cannot be resolved");
        }
        return path;
    }

    public static String buildFilePath(String first, String ... more) throws IllegalArgumentException {
        File file = new File(QP.resolvePath(first));
        for (String part : more) {
            if (part == null) {
                throw new IllegalArgumentException("Part of the file path given to buildFilePath() is null!");
            }
            if (PROJECT_BASE_DIR.equals(part)) {
                throw new IllegalArgumentException("PROJECT_BASE_DIR must be the first element given to buildFilePath()");
            }
            file = new File(file, part);
        }
        String path = file.getAbsolutePath();
        return path;
    }

    public static String buildPathInProject(String ... parts) throws IllegalArgumentException {
        return QP.buildFilePath(PROJECT_BASE_DIR, parts);
    }

    public static String createDirectory(String first, String ... more) {
        Object path = QP.buildFilePath(first, more);
        if (!((String)path).endsWith(File.separator) && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        QP.mkdirs((String)path);
        return path;
    }

    public static String createDirectoryInProject(String ... parts) {
        return QP.createDirectory(PROJECT_BASE_DIR, parts);
    }

    @Deprecated
    public static String makePathInProject(String ... more) throws IllegalArgumentException {
        String path = QP.buildPathInProject(more);
        QP.mkdirs(path);
        return path;
    }

    public static File makeFileInProject(String ... more) throws IllegalArgumentException {
        if (more.length == 0) {
            return new File(QP.createDirectoryInProject(new String[0]));
        }
        String basePath = QP.createDirectoryInProject(Arrays.copyOfRange(more, 0, more.length - 1));
        return new File(basePath, more[more.length - 1]);
    }

    public static boolean mkdirs(String path) {
        File file = new File(QP.resolvePath(path));
        if (!file.exists()) {
            return file.mkdirs();
        }
        return false;
    }

    public static boolean fileExists(String path) {
        return new File(QP.resolvePath(path)).exists();
    }

    public static boolean isDirectory(String path) {
        return new File(QP.resolvePath(path)).isDirectory();
    }

    private static String getProjectBaseDirectory() {
        File dir = Projects.getBaseDirectory(QP.getProject());
        return dir == null ? null : dir.getAbsolutePath();
    }

    public static ProjectImageEntry<BufferedImage> getProjectEntry() {
        Project<BufferedImage> project = QP.getProject();
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        if (project == null || imageData == null) {
            return null;
        }
        return project.getEntry(imageData);
    }

    public static String getProjectEntryMetadataValue(String key) {
        ProjectImageEntry<BufferedImage> entry = QP.getProjectEntry();
        if (entry == null) {
            return null;
        }
        return entry.getMetadataValue(key);
    }

    public static PathObjectHierarchy getCurrentHierarchy() {
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        if (imageData == null) {
            return null;
        }
        return imageData.getHierarchy();
    }

    public static ImageServer<?> getCurrentServer() {
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        if (imageData == null) {
            return null;
        }
        return imageData.getServer();
    }

    public static String getCurrentImageName() {
        ProjectImageEntry<BufferedImage> entry = QP.getProjectEntry();
        if (entry != null && !entry.getImageName().isBlank()) {
            return entry.getImageName();
        }
        ImageServer<?> server = QP.getCurrentServer();
        if (server != null) {
            return server.getMetadata().getName();
        }
        return null;
    }

    public static String getCurrentImageNameWithoutExtension() {
        String name = QP.getCurrentImageName();
        return name == null ? null : GeneralTools.stripExtension((String)name);
    }

    public static Collection<PathObject> getSelectedObjects() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return null;
        }
        return hierarchy.getSelectionModel().getSelectedObjects();
    }

    public static PathObject getSelectedObject() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return null;
        }
        PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
        if (selected == null && !hierarchy.getSelectionModel().noSelection()) {
            logger.debug("getSelectedObject() is null because there is no primary selected object, you might want getSelectedObjects() instead");
        }
        return selected;
    }

    public static ROI getSelectedROI() {
        PathObject pathObject = QP.getSelectedObject();
        if (pathObject != null) {
            return pathObject.getROI();
        }
        return null;
    }

    public static void resetSelection() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return;
        }
        hierarchy.getSelectionModel().clearSelection();
    }

    public static boolean setSelectedObject(PathObject pathObject) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return false;
        }
        hierarchy.getSelectionModel().setSelectedObject(pathObject);
        return true;
    }

    public static void addObject(PathObject pathObject) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return;
        }
        hierarchy.addObject(pathObject);
    }

    public static void addObjects(PathObject ... pathObjects) {
        QP.addObjects(Arrays.asList(pathObjects));
    }

    public static void addObjects(Collection<PathObject> pathObjects) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return;
        }
        hierarchy.addObjects(pathObjects);
    }

    @Deprecated(since="0.6.0")
    public static void removeObject(PathObject pathObject, boolean keepChildren) {
        LogTools.warnOnce((Logger)logger, (String)"removeObject(PathObject, boolean) is deprecated - use removeObject(PathObject) or removeObjectAndDescendants(PathObject) instead");
        if (keepChildren) {
            QP.removeObject(pathObject);
        } else {
            QP.removeObjectAndDescendants(pathObject);
        }
    }

    public static void removeObject(PathObject pathObject) {
        QP.removeObjectsImpl(Collections.singleton(pathObject), true);
    }

    public static void removeObjectAndDescendants(PathObject pathObject) {
        QP.removeObjectsImpl(Collections.singleton(pathObject), false);
    }

    @Deprecated(since="0.6.0")
    public static void removeObjects(PathObject[] pathObjects, boolean keepChildren) {
        LogTools.warnOnce((Logger)logger, (String)"removeObjects(PathObject[], boolean) is deprecated - use removeObjects(PathObject[]) or removeObjectsAndDescendants(PathObject[]) instead");
        if (keepChildren) {
            QP.removeObjects(pathObjects);
        } else {
            QP.removeObjectsAndDescendants(pathObjects);
        }
    }

    public static int nObjects() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return 0;
        }
        return hierarchy.nObjects();
    }

    @Deprecated(since="0.6.0")
    public static void removeObjects(Collection<? extends PathObject> pathObjects, boolean keepChildren) {
        QP.removeObjectsImpl(pathObjects, keepChildren);
    }

    private static void removeObjectsImpl(Collection<? extends PathObject> pathObjects, boolean keepChildren) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return;
        }
        hierarchy.removeObjects(pathObjects, keepChildren);
    }

    public static void removeObjects(PathObject ... pathObjects) {
        QP.removeObjects(Arrays.asList(pathObjects));
    }

    public static void removeObjectsAndDescendants(PathObject ... pathObjects) {
        QP.removeObjectsAndDescendants(Arrays.asList(pathObjects));
    }

    public static void removeObjects(Collection<? extends PathObject> pathObjects) {
        QP.removeObjectsImpl(pathObjects, true);
    }

    public static void removeObjectsAndDescendants(Collection<? extends PathObject> pathObjects) {
        QP.removeObjectsImpl(pathObjects, false);
    }

    public static boolean isTMADearrayed() {
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        if (imageData == null) {
            return false;
        }
        return imageData.getHierarchy().getTMAGrid() != null && imageData.getHierarchy().getTMAGrid().nCores() > 0;
    }

    @Deprecated(since="0.6.0")
    public static void clearAllObjects() {
        LogTools.warnOnce((Logger)logger, (String)"clearAllObjects() has been deprecated - use removeAllObjects() instead");
        QP.removeAllObjects();
    }

    public static void removeAllObjects() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return;
        }
        hierarchy.clearAll();
        hierarchy.getSelectionModel().clearSelection();
    }

    @Deprecated(since="0.6.0")
    public static void clearAllObjects(Class<? extends PathObject> cls) {
        LogTools.warnOnce((Logger)logger, (String)"clearAllObjects(Class) has been deprecated - use removeAllObjects(Class) instead");
        QP.removeAllObjects(cls);
    }

    public static void removeAllObjects(Class<? extends PathObject> cls) {
        if (cls == null) {
            QP.clearAllObjects();
            return;
        }
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return;
        }
        Collection pathObjects = hierarchy.getObjects(null, cls);
        hierarchy.removeObjects(pathObjects, true);
        PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
        if (selected != null && selected.getClass().isAssignableFrom(cls)) {
            hierarchy.getSelectionModel().setSelectedObject(null);
        }
    }

    @Deprecated(since="0.6.0")
    public static void clearAnnotations() {
        LogTools.warnOnce((Logger)logger, (String)"clearAnnotations() has been deprecated - use removeAnnotations() instead");
        QP.removeAnnotations();
    }

    public static void removeAnnotations() {
        QP.removeAllObjects(PathAnnotationObject.class);
    }

    @Deprecated(since="0.6.0")
    public static void clearDetections() {
        LogTools.warnOnce((Logger)logger, (String)"clearDetections() has been deprecated - use removeDetections() instead");
        QP.removeDetections();
    }

    public static void removeDetections() {
        QP.removeAllObjects(PathDetectionObject.class);
    }

    @Deprecated(since="0.6.0")
    public static void clearTMAGrid() {
        LogTools.warnOnce((Logger)logger, (String)"clearTMAGrid() has been deprecated - use removeTMAGrid() instead");
        QP.removeTMAGrid();
    }

    public static void removeTMAGrid() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return;
        }
        hierarchy.setTMAGrid(null);
        PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
        if (selected instanceof TMACoreObject) {
            hierarchy.getSelectionModel().setSelectedObject(null);
        }
    }

    public static void addShapeMeasurements(String ... features) {
        List selected;
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        Collection<Object> collection = selected = imageData == null ? Collections.emptyList() : imageData.getHierarchy().getSelectionModel().getSelectedObjects();
        if (selected.isEmpty()) {
            logger.debug("Cannot add shape measurements (no objects selected)");
            return;
        }
        if (features.length == 0) {
            QP.addShapeMeasurements(imageData, new ArrayList(selected), new ObjectMeasurements.ShapeFeatures[0]);
        } else if (features.length == 1) {
            QP.addShapeMeasurements(imageData, new ArrayList(selected), features[0], new String[0]);
        } else {
            QP.addShapeMeasurements(imageData, new ArrayList(selected), features[0], Arrays.copyOfRange(features, 1, features.length));
        }
    }

    public static void addShapeMeasurements(ImageData<?> imageData, Collection<? extends PathObject> pathObjects, String feature, String ... additionalFeatures) {
        QP.addShapeMeasurements(imageData, pathObjects, (ObjectMeasurements.ShapeFeatures[])QP.parseEnumOptions(ObjectMeasurements.ShapeFeatures.class, (String)feature, (String[])additionalFeatures));
    }

    public static void addShapeMeasurements(ImageData<?> imageData, Collection<? extends PathObject> pathObjects, ObjectMeasurements.ShapeFeatures ... features) {
        if (pathObjects.isEmpty()) {
            return;
        }
        if (imageData == null) {
            ObjectMeasurements.addShapeMeasurements(pathObjects, null, features);
        } else {
            PathObjectHierarchy hierarchy = imageData.getHierarchy();
            ObjectMeasurements.addShapeMeasurements(pathObjects, imageData.getServer().getPixelCalibration(), features);
            hierarchy.fireObjectMeasurementsChangedEvent((Object)hierarchy, pathObjects);
        }
    }

    static <T extends Enum<T>> T[] parseEnumOptions(Class<T> classEnum, String option, String ... additionalOptions) {
        String[] allOptions;
        if (option == null && additionalOptions.length == 0) {
            return (Enum[])Array.newInstance(classEnum, 0);
        }
        LinkedHashSet<T> objectOptions = new LinkedHashSet<T>();
        for (String optionName : allOptions = option == null ? additionalOptions : (String[])ObjectArrays.concat((Object)option, (Object[])additionalOptions)) {
            if (optionName == null) continue;
            try {
                T temp = Enum.valueOf(classEnum, optionName);
                objectOptions.add(temp);
            }
            catch (Exception e) {
                logger.warn("Could not parse option {}", (Object)optionName);
            }
        }
        Enum[] array = (Enum[])Array.newInstance(classEnum, objectOptions.size());
        return objectOptions.toArray(array);
    }

    public static void setChannelNames(String ... names) {
        QP.setChannelNames(QP.getCurrentImageData(), names);
    }

    public static void setChannelNames(ImageData<?> imageData, String ... names) {
        List oldChannels = imageData.getServerMetadata().getChannels();
        ArrayList<ImageChannel> newChannels = new ArrayList<ImageChannel>(oldChannels);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name == null) continue;
            newChannels.set(i, ImageChannel.getInstance((String)name, (Integer)((ImageChannel)newChannels.get(i)).getColor()));
            if (i < newChannels.size()) continue;
            logger.warn("Too many channel names specified, only {} of {} will be used", (Object)newChannels.size(), (Object)names.length);
            break;
        }
        QP.setChannels(imageData, (ImageChannel[])newChannels.toArray(ImageChannel[]::new));
    }

    public static void setChannelColors(Integer ... colors) {
        QP.setChannelColors(QP.getCurrentImageData(), colors);
    }

    public static void setChannelColors(ImageData<?> imageData, Integer ... colors) {
        List oldChannels = imageData.getServerMetadata().getChannels();
        ArrayList<ImageChannel> newChannels = new ArrayList<ImageChannel>(oldChannels);
        for (int i = 0; i < colors.length; ++i) {
            Integer color = colors[i];
            if (color == null) continue;
            newChannels.set(i, ImageChannel.getInstance((String)((ImageChannel)newChannels.get(i)).getName(), (Integer)color));
            if (i < newChannels.size()) continue;
            logger.warn("Too many channel colors specified, only {} of {} will be used", (Object)newChannels.size(), (Object)colors.length);
            break;
        }
        QP.setChannels(imageData, (ImageChannel[])newChannels.toArray(ImageChannel[]::new));
    }

    public static void setChannels(ImageChannel ... channels) {
        QP.setChannels(QP.getCurrentImageData(), channels);
    }

    public static void setChannels(ImageData<?> imageData, ImageChannel ... channels) {
        List<ImageChannel> newChannels;
        ImageServerMetadata metadata = imageData.getServerMetadata();
        List oldChannels = metadata.getChannels();
        if (oldChannels.equals(newChannels = Arrays.asList(channels))) {
            logger.trace("Setting channels to the same values (no changes)");
            return;
        }
        if (oldChannels.size() != newChannels.size()) {
            throw new IllegalArgumentException("Cannot set channels - require " + oldChannels.size() + " channels but you provided " + channels.length);
        }
        ImageServerMetadata metadata2 = new ImageServerMetadata.Builder(metadata).channels(newChannels).build();
        imageData.updateServerMetadata(metadata2);
    }

    public static boolean runPlugin(String className, String args) throws InterruptedException {
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        if (imageData == null) {
            return false;
        }
        return QP.runPlugin(className, imageData, args);
    }

    public static boolean runPlugin(String className, ImageData<?> imageData, String args) throws InterruptedException {
        if (imageData == null) {
            return false;
        }
        try {
            Class<?> cPlugin = QP.class.getClassLoader().loadClass(className);
            Constructor<?> cons = cPlugin.getConstructor(new Class[0]);
            PathPlugin plugin = (PathPlugin)cons.newInstance(new Object[0]);
            return plugin.runPlugin((TaskRunner)new CommandLineTaskRunner(), imageData, args);
        }
        catch (Exception e) {
            logger.error("Unable to run plugin " + className, (Throwable)e);
            return false;
        }
    }

    public static boolean runPlugin(String className, Map<String, ?> args) throws InterruptedException {
        String json = args == null ? "" : GsonTools.getInstance().toJson(args);
        return QP.runPlugin(className, json);
    }

    public static boolean runPlugin(String className, ImageData<?> imageData, Map<String, ?> args) throws InterruptedException {
        String json = args == null ? "" : GsonTools.getInstance().toJson(args);
        return QP.runPlugin(className, imageData, json);
    }

    public static boolean runPlugin(Map<String, ?> args, String className) throws InterruptedException {
        return QP.runPlugin(className, args);
    }

    public static boolean runPlugin(Map<String, ?> args, String className, ImageData<?> imageData) throws InterruptedException {
        return QP.runPlugin(className, imageData, args);
    }

    public static List<TMACoreObject> getTMACoreList() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null || hierarchy.getTMAGrid() == null) {
            return Collections.emptyList();
        }
        return hierarchy.getTMAGrid().getTMACoreList();
    }

    public static Collection<PathObject> getAnnotationObjects() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return Collections.emptyList();
        }
        return hierarchy.getAnnotationObjects();
    }

    public static Collection<PathObject> getDetectionObjects() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return Collections.emptyList();
        }
        return hierarchy.getDetectionObjects();
    }

    public static Collection<PathObject> getTileObjects() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return Collections.emptyList();
        }
        return hierarchy.getTileObjects();
    }

    public static Collection<PathObject> getCellObjects() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return Collections.emptyList();
        }
        return hierarchy.getCellObjects();
    }

    public static Collection<PathObject> getAllObjects(boolean includeRootObject) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return Collections.emptyList();
        }
        List objList = hierarchy.getFlattenedObjectList(null);
        if (includeRootObject) {
            return objList;
        }
        return objList.stream().filter(e -> !e.isRootObject()).toList();
    }

    public static Collection<PathObject> getAllObjectsWithoutRoot() {
        return QP.getAllObjects(false);
    }

    public static Collection<PathObject> getAllObjects() {
        return QP.getAllObjects(true);
    }

    public static boolean setImageType(String typeName) {
        if (typeName == null) {
            return QP.setImageType(ImageData.ImageType.UNSET);
        }
        for (ImageData.ImageType typeTemp : ImageData.ImageType.values()) {
            if (!typeTemp.toString().equalsIgnoreCase(typeName) && !typeTemp.name().equalsIgnoreCase(typeName)) continue;
            return QP.setImageType(typeTemp);
        }
        logger.error("Image type could not be parsed from {}", (Object)typeName);
        return false;
    }

    public static boolean setImageType(ImageData.ImageType type) {
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        if (imageData == null) {
            return false;
        }
        if (type == null) {
            imageData.setImageType(ImageData.ImageType.UNSET);
        } else {
            imageData.setImageType(type);
        }
        return true;
    }

    public static boolean setColorDeconvolutionStains(String arg) {
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        if (imageData == null) {
            return false;
        }
        ColorDeconvolutionStains stains = ColorDeconvolutionStains.parseColorDeconvolutionStainsArg((String)arg);
        imageData.setColorDeconvolutionStains(stains);
        return true;
    }

    public static void setColorDeconvolutionStains(Map<String, List<Number>> stains, String name) {
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        if (imageData == null) {
            throw new IllegalStateException("No current image data. Cannot set color deconvolution stains");
        }
        imageData.setColorDeconvolutionStains(ColorDeconvolutionStains.parseColorDeconvolutionStains((String)name, stains));
    }

    @Deprecated
    public static void createSelectAllObject(boolean setSelected) {
        LogTools.warnOnce((Logger)logger, (String)"createSelectAllObject(boolean) is deprecated, use createFullImageAnnotation(boolean) instead");
        QP.createSelectAllObject(setSelected, 0, 0);
    }

    @Deprecated
    public static void createSelectAllObject(boolean setSelected, int z, int t) {
        LogTools.warnOnce((Logger)logger, (String)"createSelectAllObject(boolean, int, int) is deprecated, use createFullImageAnnotation(boolean, int, int) instead");
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        if (imageData == null) {
            return;
        }
        ImageServer server = imageData.getServer();
        PathObject pathObject = PathObjects.createAnnotationObject((ROI)ROIs.createRectangleROI((double)0.0, (double)0.0, (double)server.getWidth(), (double)server.getHeight(), (ImagePlane)ImagePlane.getPlane((int)z, (int)t)));
        imageData.getHierarchy().addObject(pathObject);
        if (setSelected) {
            imageData.getHierarchy().getSelectionModel().setSelectedObject(pathObject);
        }
    }

    public static List<PathObject> createAllFullImageAnnotations(boolean setSelected) {
        return QP.createAllFullImageAnnotations(QP.getCurrentImageData(), setSelected);
    }

    public static List<PathObject> createAllFullImageAnnotations(ImageData<?> imageData, boolean setSelected) {
        if (imageData == null) {
            return Collections.emptyList();
        }
        ImageServer server = imageData.getServer();
        ArrayList<PathObject> annotations = new ArrayList<PathObject>();
        for (int t = 0; t < server.nTimepoints(); ++t) {
            for (int z = 0; z < server.nZSlices(); ++z) {
                PathObject pathObject = PathObjects.createAnnotationObject((ROI)ROIs.createRectangleROI((double)0.0, (double)0.0, (double)server.getWidth(), (double)server.getHeight(), (ImagePlane)ImagePlane.getPlane((int)z, (int)t)));
                annotations.add(pathObject);
            }
        }
        imageData.getHierarchy().addObjects(annotations);
        if (setSelected) {
            imageData.getHierarchy().getSelectionModel().setSelectedObjects(annotations, (PathObject)annotations.get(0));
        }
        return annotations;
    }

    public static PathObject createFullImageAnnotation(boolean setSelected) {
        return QP.createFullImageAnnotation(QP.getCurrentImageData(), setSelected);
    }

    public static PathObject createFullImageAnnotation(boolean setSelected, int z, int t) {
        return QP.createFullImageAnnotation(QP.getCurrentImageData(), setSelected, z, t);
    }

    public static PathObject createFullImageAnnotation(ImageData<?> imageData, boolean setSelected) {
        return QP.createFullImageAnnotation(imageData, setSelected, 0, 0);
    }

    public static PathObject createFullImageAnnotation(ImageData<?> imageData, boolean setSelected, int z, int t) {
        if (imageData == null) {
            return null;
        }
        ImageServer server = imageData.getServer();
        PathObject pathObject = PathObjects.createAnnotationObject((ROI)ROIs.createRectangleROI((double)0.0, (double)0.0, (double)server.getWidth(), (double)server.getHeight(), (ImagePlane)ImagePlane.getPlane((int)z, (int)t)));
        imageData.getHierarchy().addObject(pathObject);
        if (setSelected) {
            imageData.getHierarchy().getSelectionModel().setSelectedObject(pathObject);
        }
        return pathObject;
    }

    @Deprecated
    public static <T> ImageServer<T> buildServer(String path, Class<T> cls, String ... args) throws IOException {
        return ImageServerProvider.buildServer((String)path, cls, (String[])args);
    }

    public static ImageServer<BufferedImage> buildServer(String path, String ... args) throws IOException {
        return ImageServers.buildServer((String)path, (String[])args);
    }

    public static ImageServer<BufferedImage> buildServer(URI uri, String ... args) throws IOException {
        return ImageServers.buildServer((URI)uri, (String[])args);
    }

    public static void transformSelectedObjects(AffineTransform transform) {
        QP.transformSelectedObjects(QP.getCurrentHierarchy(), transform);
    }

    public static void transformSelectedObjects(PathObjectHierarchy hierarchy, AffineTransform transform) {
        Objects.requireNonNull(hierarchy, "Can't transform selected objects - hierarchy is null!");
        Set selected = hierarchy.getSelectionModel().getSelectedObjects();
        if (selected.isEmpty()) {
            logger.warn("Cannot transform selected objects - no objects are selected");
            return;
        }
        PathObject primary = hierarchy.getSelectionModel().getSelectedObject();
        ArrayList<PathObject> transformed = new ArrayList<PathObject>();
        for (PathObject pathObject : (PathObject[])selected.toArray(PathObject[]::new)) {
            transformed.add(PathObjectTools.transformObject((PathObject)pathObject, (AffineTransform)transform, (boolean)true, (boolean)false));
        }
        hierarchy.removeObjects((Collection)selected, true);
        hierarchy.addObjects(transformed);
        PathObject newPrimary = primary == null ? null : (PathObject)transformed.stream().filter(p -> p.getID().equals(primary.getID())).findFirst().orElse(null);
        hierarchy.getSelectionModel().setSelectedObjects(transformed, newPrimary);
    }

    public static void scaleAllObjects(double scaleFactor) {
        QP.scaleAllObjects(QP.getCurrentHierarchy(), scaleFactor);
    }

    public static void scaleAllObjects(PathObjectHierarchy hierarchy, double scaleFactor) {
        QP.transformAllObjects(hierarchy, AffineTransform.getScaleInstance(scaleFactor, scaleFactor));
    }

    public static void translateAllObjects(double dx, double dy) {
        QP.translateAllObjects(QP.getCurrentHierarchy(), dx, dy);
    }

    public static void translateAllObjects(PathObjectHierarchy hierarchy, double dx, double dy) {
        QP.transformAllObjects(hierarchy, AffineTransform.getTranslateInstance(dx, dy));
    }

    public static void transformAllObjects(AffineTransform transform) {
        QP.transformAllObjects(QP.getCurrentHierarchy(), transform);
    }

    public static void transformAllObjects(PathObjectHierarchy hierarchy, AffineTransform transform) {
        Objects.requireNonNull(hierarchy, "Can't transform all objects - hierarchy is null!");
        PathObject primary = hierarchy.getSelectionModel().getSelectedObject();
        Set selectedIDs = hierarchy.getSelectionModel().getSelectedObjects().stream().map(p -> p.getID()).collect(Collectors.toSet());
        PathObject transformed = PathObjectTools.transformObjectRecursive((PathObject)hierarchy.getRootObject(), (AffineTransform)transform, (boolean)true, (boolean)false);
        ArrayList newObjects = new ArrayList(transformed.getChildObjects());
        TMAGrid tmaGrid = hierarchy.getTMAGrid();
        TMAGrid newTmaGrid = null;
        if (tmaGrid != null && !tmaGrid.getTMACoreList().isEmpty()) {
            List originalCores = tmaGrid.getTMACoreList();
            List<PathObject> newCores = PathObjectTools.getFlattenedObjectList((PathObject)transformed, null, (boolean)true).stream().filter(p -> p.isTMACore()).toList();
            Map matches = PathObjectTools.matchByID((Collection)originalCores, newCores);
            ArrayList<TMACoreObject> newCoresOrdered = new ArrayList<TMACoreObject>();
            for (TMACoreObject oldCore : originalCores) {
                PathObject newCore = matches.getOrDefault(oldCore, null);
                if (newCore == null) continue;
                newCoresOrdered.add((TMACoreObject)newCore);
            }
            if (newCoresOrdered.size() == originalCores.size()) {
                newTmaGrid = DefaultTMAGrid.create(newCoresOrdered, (int)tmaGrid.getGridWidth());
                newObjects.removeAll(newCoresOrdered);
            } else {
                logger.warn("Unable to match old and new TMA cores!");
            }
        }
        hierarchy.clearAll();
        if (newTmaGrid != null) {
            hierarchy.setTMAGrid(newTmaGrid);
        }
        hierarchy.addObjects(newObjects);
        if (!selectedIDs.isEmpty()) {
            Collection toSelect = PathObjectTools.findByUUID(selectedIDs, (Collection)hierarchy.getFlattenedObjectList(null)).values();
            PathObject newPrimary = primary == null ? null : (PathObject)toSelect.stream().filter(p -> p.getID().equals(primary.getID())).findFirst().orElse(null);
            hierarchy.getSelectionModel().setSelectedObjects(toSelect, newPrimary);
        }
    }

    public static void resetTMAMetadata(boolean includeMeasurements) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        QP.resetTMAMetadata(hierarchy, includeMeasurements);
    }

    public static void resetTMAMetadata(PathObjectHierarchy hierarchy, boolean includeMeasurements) {
        if (hierarchy == null || hierarchy.getTMAGrid() == null) {
            return;
        }
        for (TMACoreObject core : hierarchy.getTMAGrid().getTMACoreList()) {
            core.clearMetadata();
            if (!includeMeasurements) continue;
            core.getMeasurementList().clear();
        }
        hierarchy.fireObjectsChangedEvent(QP.class, (Collection)hierarchy.getTMAGrid().getTMACoreList());
    }

    public static boolean relabelTMAGrid(PathObjectHierarchy hierarchy, String labelsHorizontal, String labelsVertical, boolean rowFirst) {
        if (hierarchy == null || hierarchy.getTMAGrid() == null) {
            logger.error("Cannot relabel TMA grid - no grid found!");
            return false;
        }
        TMAGrid grid = hierarchy.getTMAGrid();
        return PathObjectTools.relabelTMAGrid((TMAGrid)grid, (String)labelsHorizontal, (String)labelsVertical, (boolean)rowFirst);
    }

    public static boolean relabelTMAGrid(String labelsHorizontal, String labelsVertical, boolean rowFirst) {
        return QP.relabelTMAGrid(QP.getCurrentHierarchy(), labelsHorizontal, labelsVertical, rowFirst);
    }

    public static void createTMAGrid(ImageData<?> imageData, String hLabels, String vLabels, boolean rowFirst, double diameterCalibrated) {
        PathObjectTools.addTMAGrid(imageData, (String)hLabels, (String)vLabels, (boolean)rowFirst, (double)diameterCalibrated);
    }

    public static void createTMAGrid(String hLabels, String vLabels, boolean rowFirst, double diameterCalibrated) {
        QP.createTMAGrid(QP.getCurrentImageData(), hLabels, vLabels, rowFirst, diameterCalibrated);
    }

    public static void resetClassifications(Class<? extends PathObject> cls) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        QP.resetClassifications(hierarchy, cls);
    }

    public static void refreshIDs() {
        QP.refreshIDs(QP.getCurrentHierarchy(), false);
    }

    public static boolean refreshDuplicateIDs() {
        return QP.refreshIDs(QP.getCurrentHierarchy(), true);
    }

    public static void refreshIDs(PathObjectHierarchy hierarchy) {
        QP.refreshIDs(hierarchy, false);
    }

    public static boolean refreshDuplicateIDs(PathObjectHierarchy hierarchy) {
        return QP.refreshIDs(hierarchy, true);
    }

    private static boolean refreshIDs(PathObjectHierarchy hierarchy, boolean duplicatesOnly) {
        if (hierarchy == null) {
            return false;
        }
        Collection pathObjects = hierarchy.getAllObjects(true);
        if (duplicatesOnly) {
            HashSet<UUID> set = new HashSet<UUID>();
            ArrayList<PathObject> changed = new ArrayList<PathObject>();
            for (PathObject p2 : pathObjects) {
                while (!set.add(p2.getID())) {
                    p2.refreshID();
                    changed.add(p2);
                }
            }
            if (changed.isEmpty()) {
                return false;
            }
            assert (set.size() == pathObjects.size());
            hierarchy.fireObjectsChangedEvent((Object)hierarchy, changed);
            return true;
        }
        pathObjects.stream().forEach(p -> p.refreshID());
        hierarchy.fireObjectsChangedEvent((Object)hierarchy, pathObjects);
        return true;
    }

    public static void resetClassifications(PathObjectHierarchy hierarchy, Class<? extends PathObject> cls) {
        if (hierarchy == null) {
            return;
        }
        Collection objects = hierarchy.getObjects(null, cls);
        if (objects.isEmpty()) {
            logger.warn("No objects to reset classifications!");
            return;
        }
        for (PathObject pathObject : objects) {
            if (pathObject.getPathClass() == null) continue;
            pathObject.resetPathClass();
        }
        hierarchy.fireObjectClassificationsChangedEvent(QP.class, objects);
    }

    public static void resetDetectionClassifications() {
        QP.resetClassifications(PathDetectionObject.class);
    }

    public static boolean hasMeasurement(PathObject pathObject, String measurementName) {
        return pathObject != null && pathObject.getMeasurementList().containsKey(measurementName);
    }

    public static double measurement(PathObject pathObject, String measurementName) {
        return pathObject == null ? Double.NaN : pathObject.getMeasurementList().get(measurementName);
    }

    @Deprecated(since="0.6.0")
    public static void clearSelectedObjects() {
        LogTools.warnOnce((Logger)logger, (String)"clearSelectedObjects() has been deprecated - use removeSelectedObjects() instead");
        QP.removeSelectedObjects();
    }

    public static void removeSelectedObjects() {
        QP.removeSelectedObjects(true);
    }

    @Deprecated(since="0.6.0")
    public static void clearSelectedObjects(boolean keepChildren) {
        LogTools.warnOnce((Logger)logger, (String)"clearSelectedObjects(boolean) has been deprecated - use removeSelectedObjects() or removeSelectedObjectsAndDescendants() instead");
        QP.removeSelectedObjects(keepChildren);
    }

    public static void removeSelectedObjectsAndDescendants() {
        QP.removeSelectedObjects(false);
    }

    private static void removeSelectedObjects(boolean keepChildren) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy == null) {
            return;
        }
        Set selectedRaw = hierarchy.getSelectionModel().getSelectedObjects();
        List<PathObject> selected = selectedRaw.stream().filter(p -> !(p instanceof TMACoreObject)).toList();
        hierarchy.removeObjects(selected, keepChildren);
        hierarchy.getSelectionModel().clearSelection();
    }

    public static List<PathObject> getObjects(Predicate<PathObject> predicate) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            return hierarchy.getFlattenedObjectList(null).stream().filter(predicate).toList();
        }
        return Collections.emptyList();
    }

    public static void selectAllObjects(PathObjectHierarchy hierarchy, boolean includeRootObject) {
        List<PathObject> allObjs = hierarchy.getFlattenedObjectList(null);
        if (!includeRootObject) {
            allObjs = allObjs.stream().filter(e -> !e.isRootObject()).toList();
        }
        if (hierarchy != null) {
            hierarchy.getSelectionModel().setSelectedObjects(allObjs, null);
        }
    }

    public static void selectAllObjects(PathObjectHierarchy hierarchy) {
        QP.selectAllObjects(hierarchy, false);
    }

    public static void selectAllObjects() {
        QP.selectAllObjects(QP.getCurrentHierarchy());
    }

    public static void selectObjectsByPlane(int z, int t) {
        QP.selectObjectsByPlane(ImagePlane.getPlane((int)z, (int)t));
    }

    public static void selectObjectsByPlane(ImagePlane plane) {
        QP.selectObjectsByPlane(QP.getCurrentHierarchy(), plane);
    }

    public static void selectObjectsByPlane(PathObjectHierarchy hierarchy, ImagePlane plane) {
        QP.selectObjects((PathObject p) -> p.hasROI() && p.getROI().getZ() == plane.getZ() && p.getROI().getT() == plane.getT());
    }

    public static void selectObjects(Predicate<PathObject> predicate) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            hierarchy.getSelectionModel().setSelectedObjects(QP.getObjects(hierarchy, predicate), null);
        }
    }

    public static void selectObjects(Collection<? extends PathObject> pathObjects) {
        QP.selectObjects(pathObjects, null);
    }

    public static void selectObjects(Collection<? extends PathObject> pathObjects, PathObject mainSelection) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            hierarchy.getSelectionModel().setSelectedObjects(pathObjects, mainSelection);
        }
    }

    public static void selectObjects(PathObjectHierarchy hierarchy, PathObject ... pathObjects) {
        if (pathObjects.length == 0) {
            return;
        }
        if (pathObjects.length == 1) {
            hierarchy.getSelectionModel().setSelectedObject(pathObjects[0]);
        } else {
            hierarchy.getSelectionModel().setSelectedObjects(Arrays.asList(pathObjects), null);
        }
    }

    public static void selectObjects(PathObject ... pathObjects) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            QP.selectObjects(hierarchy, pathObjects);
        }
    }

    public static List<PathObject> getObjects(PathObjectHierarchy hierarchy, Predicate<PathObject> predicate) {
        return hierarchy.getFlattenedObjectList(null).stream().filter(predicate).toList();
    }

    public static void selectObjects(PathObjectHierarchy hierarchy, Predicate<PathObject> predicate) {
        hierarchy.getSelectionModel().setSelectedObjects(QP.getObjects(hierarchy, predicate), null);
    }

    public static void selectObjectsByClass(Class<? extends PathObject> cls) {
        QP.selectObjects((PathObject p) -> cls.isInstance(p));
    }

    public static void selectObjectsByClass(PathObjectHierarchy hierarchy, Class<? extends PathObject> cls) {
        QP.selectObjects(hierarchy, (PathObject p) -> cls.isInstance(p));
    }

    public static void selectAnnotations(PathObjectHierarchy hierarchy) {
        QP.selectObjectsByClass(hierarchy, PathAnnotationObject.class);
    }

    public static void selectTMACores(PathObjectHierarchy hierarchy) {
        QP.selectTMACores(hierarchy, false);
    }

    public static void selectTMACores(PathObjectHierarchy hierarchy, boolean includeMissing) {
        hierarchy.getSelectionModel().setSelectedObjects((Collection)PathObjectTools.getTMACoreObjects((PathObjectHierarchy)hierarchy, (boolean)includeMissing), null);
    }

    public static void selectDetections(PathObjectHierarchy hierarchy) {
        QP.selectObjectsByClass(hierarchy, PathDetectionObject.class);
    }

    public static void selectCells(PathObjectHierarchy hierarchy) {
        QP.selectObjectsByClass(hierarchy, PathCellObject.class);
    }

    public static void selectAnnotations() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            QP.selectAnnotations(hierarchy);
        }
    }

    public static void selectTMACores() {
        QP.selectTMACores(false);
    }

    public static void selectTMACores(boolean includeMissing) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            QP.selectTMACores(hierarchy, includeMissing);
        }
    }

    public static void selectDetections() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            QP.selectDetections(hierarchy);
        }
    }

    public static void selectCells() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            QP.selectCells(hierarchy);
        }
    }

    public static void selectTiles(PathObjectHierarchy hierarchy) {
        QP.selectObjectsByClass(hierarchy, PathTileObject.class);
    }

    public static void selectTiles() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            QP.selectTiles(hierarchy);
        }
    }

    public static void selectObjectsByClassification(String ... pathClassNames) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            QP.selectObjectsByClassification(hierarchy, pathClassNames);
        }
    }

    public static void selectObjectsByPathClass(PathClass ... pathClasses) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            QP.selectObjectsByPathClass(hierarchy, pathClasses);
        }
    }

    public static void selectObjectsByClassification(PathObjectHierarchy hierarchy, String ... pathClassNames) {
        PathClass[] pathClasses = pathClassNames == null ? new PathClass[1] : (PathClass[])Arrays.stream(pathClassNames).map(s -> QP.getPathClass(s)).toArray(PathClass[]::new);
        QP.selectObjectsByPathClass(hierarchy, pathClasses);
    }

    public static void selectObjectsByPathClass(PathObjectHierarchy hierarchy, PathClass ... pathClasses) {
        Set pathClassSet = pathClasses == null ? Set.of((PathClass)null) : (Set)Arrays.stream(pathClasses).map(p -> p == PathClass.NULL_CLASS ? null : p).collect(Collectors.toCollection(HashSet::new));
        QP.selectObjects(hierarchy, (PathObject p) -> pathClassSet.contains(p.getPathClass()));
    }

    @Deprecated
    private static Predicate<PathObject> parsePredicate(String command) throws NoSuchElementException {
        String s = command.trim();
        if (s.isEmpty()) {
            throw new NoSuchElementException("No command provided!");
        }
        try (Scanner scanner = new Scanner(s);){
            HashMap<String, Predicate<Integer>> mapComparison = new HashMap<String, Predicate<Integer>>();
            mapComparison.put(">=", v -> v >= 0);
            mapComparison.put("<=", v -> v <= 0);
            mapComparison.put(">", v -> v > 0);
            mapComparison.put("<", v -> v < 0);
            mapComparison.put("=", v -> v == 0);
            mapComparison.put("==", v -> v == 0);
            mapComparison.put("!=", v -> v != 0);
            mapComparison.put("~=", v -> v != 0);
            Predicate<PathObject> predicate = null;
            Pattern comparePattern = Pattern.compile(">=|<=|==|!=|~=|=|>|<");
            Pattern combinePattern = Pattern.compile("and|AND|or|OR");
            Pattern notPattern = Pattern.compile("not|NOT");
            while (scanner.hasNext()) {
                String combine = null;
                scanner.reset();
                if (predicate != null) {
                    if (scanner.hasNext(combinePattern)) {
                        combine = scanner.next(combinePattern).trim().toUpperCase();
                    } else {
                        throw new NoSuchElementException("Missing combiner (AND, OR) between comparisons!");
                    }
                }
                boolean negate = false;
                if (scanner.hasNext(notPattern)) {
                    negate = true;
                    scanner.next(notPattern);
                }
                scanner.useDelimiter(comparePattern);
                String measurement = scanner.next().trim();
                scanner.reset();
                if (!scanner.hasNext(comparePattern)) {
                    throw new NoSuchElementException("Missing comparison operator (<, >, <=, >=, ==) for measurement \"" + measurement + "\"");
                }
                String comparison = scanner.next(comparePattern).trim();
                if (!scanner.hasNextDouble()) {
                    throw new NoSuchElementException("Missing comparison value after \"" + measurement + " " + comparison + "\"");
                }
                double value = scanner.nextDouble();
                Predicate<PathObject> predicateNew = p -> {
                    double v = p.getMeasurementList().get(measurement);
                    return !Double.isNaN(v) && ((Predicate)mapComparison.get(comparison)).test(Double.compare(p.getMeasurementList().get(measurement), value));
                };
                if (negate) {
                    predicateNew = predicateNew.negate();
                }
                if (predicate == null) {
                    predicate = predicateNew;
                    continue;
                }
                if ("AND".equals(combine)) {
                    predicate = predicate.and(predicateNew);
                    continue;
                }
                if ("OR".equals(combine)) {
                    predicate = predicate.or(predicateNew);
                    continue;
                }
                throw new NoSuchElementException("Unrecognised combination of predicates: " + combine);
            }
            Predicate<PathObject> predicate2 = predicate;
            return predicate2;
        }
    }

    @Deprecated
    public static void selectObjectsByMeasurement(ImageData<?> imageData, String command) {
        QP.selectObjects(imageData.getHierarchy(), QP.parsePredicate(command));
    }

    @Deprecated
    private static void selectObjectsByMeasurement(String command) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            QP.selectObjects(hierarchy, QP.parsePredicate(command));
        }
    }

    public static void classifySelected(String pathClassName) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            QP.classifySelected(hierarchy, pathClassName);
        }
    }

    public static void classifySelected(PathObjectHierarchy hierarchy, String pathClassName) {
        PathClass pathClass = PathClass.fromString((String)pathClassName);
        Set selected = hierarchy.getSelectionModel().getSelectedObjects();
        if (selected.isEmpty()) {
            logger.info("No objects selected");
            return;
        }
        for (PathObject pathObject : selected) {
            pathObject.setPathClass(pathClass);
        }
        if (selected.size() == 1) {
            logger.info("{} object classified as {}", (Object)selected.size(), (Object)pathClassName);
        } else {
            logger.info("{} objects classified as {}", (Object)selected.size(), (Object)pathClassName);
        }
        hierarchy.fireObjectClassificationsChangedEvent(null, (Collection)selected);
    }

    public static void exportAllObjectsToGeoJson(String path, String option, String ... additionalOptions) throws IOException {
        QP.exportAllObjectsToGeoJson(path, (PathIO.GeoJsonExportOptions[])QP.parseEnumOptions(PathIO.GeoJsonExportOptions.class, (String)option, (String[])additionalOptions));
    }

    public static void exportAllObjectsToGeoJson(String path, PathIO.GeoJsonExportOptions ... options) throws IOException {
        QP.exportObjectsToGeoJson(QP.getAllObjects(false), path, options);
    }

    public static void exportSelectedObjectsToGeoJson(String path, String option, String ... additionalOptions) throws IOException {
        QP.exportSelectedObjectsToGeoJson(path, (PathIO.GeoJsonExportOptions[])QP.parseEnumOptions(PathIO.GeoJsonExportOptions.class, (String)option, (String[])additionalOptions));
    }

    public static void exportSelectedObjectsToGeoJson(String path, PathIO.GeoJsonExportOptions ... options) throws IOException {
        QP.exportObjectsToGeoJson(QP.getSelectedObjects(), path, options);
    }

    public static void exportObjectsToGeoJson(Collection<? extends PathObject> pathObjects, String path, String option, String ... additionalOptions) throws IOException {
        QP.exportObjectsToGeoJson(pathObjects, path, (PathIO.GeoJsonExportOptions[])QP.parseEnumOptions(PathIO.GeoJsonExportOptions.class, (String)option, (String[])additionalOptions));
    }

    public static void exportObjectsToGeoJson(Collection<? extends PathObject> pathObjects, String path, PathIO.GeoJsonExportOptions ... options) throws IOException {
        PathIO.exportObjectsAsGeoJSON((File)new File(path), pathObjects, (PathIO.GeoJsonExportOptions[])options);
    }

    public static boolean importObjectsFromFile(String path) throws FileNotFoundException, IllegalArgumentException, IOException, ClassNotFoundException {
        List objs = PathIO.readObjects((File)new File(path));
        return QP.getCurrentHierarchy().addObjects((Collection)objs);
    }

    public static void deselectAll() {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            QP.deselectAll(hierarchy);
        }
    }

    public static void deselectAll(PathObjectHierarchy hierarchy) {
        hierarchy.getSelectionModel().clearSelection();
    }

    public static PathClass getPathClass(String name) {
        return PathClass.fromString((String)name);
    }

    public static PathClass getPathClass(String name, Integer rgb) {
        return PathClass.fromString((String)name, (Integer)rgb);
    }

    public static PathClass getDerivedPathClass(PathClass baseClass, String name) {
        return QP.getDerivedPathClass(baseClass, name, null);
    }

    public static PathClass getDerivedPathClass(PathClass baseClass, String name, Integer rgb) {
        return PathClass.getInstance((PathClass)baseClass, (String)name, (Integer)rgb);
    }

    public static void removeMeasurements(Class<? extends PathObject> cls, String ... measurementNames) {
        QP.removeMeasurements(QP.getCurrentHierarchy(), cls, measurementNames);
    }

    public static void removeMeasurements(PathObjectHierarchy hierarchy, Class<? extends PathObject> cls, String ... measurementNames) {
        if (hierarchy == null) {
            return;
        }
        Collection pathObjects = hierarchy.getObjects(null, cls);
        for (PathObject pathObject : pathObjects) {
            if (pathObject.getClass() != cls) continue;
            MeasurementList ml = pathObject.getMeasurementList();
            try {
                ml.removeAll(measurementNames);
            }
            finally {
                if (ml == null) continue;
                ml.close();
            }
        }
        hierarchy.fireObjectMeasurementsChangedEvent(null, pathObjects);
    }

    @Deprecated(since="0.6.0")
    public static void clearMeasurements(PathObjectHierarchy hierarchy, PathObject ... pathObjects) {
        LogTools.warnOnce((Logger)logger, (String)"clearMeasurements(PathObjectHierarchy, PathObject...) has been deprecated - use removeMeasurements(PathObjectHierarchy, PathObject...) instead");
        QP.removeMeasurements(hierarchy, pathObjects);
    }

    public static void removeMeasurements(PathObjectHierarchy hierarchy, PathObject ... pathObjects) {
        QP.removeMeasurements(hierarchy, Arrays.asList(pathObjects));
    }

    @Deprecated(since="0.6.0")
    public static void clearMeasurements(PathObjectHierarchy hierarchy, Collection<? extends PathObject> pathObjects) {
        LogTools.warnOnce((Logger)logger, (String)"clearMeasurements(PathObjectHierarchy, Collection<PathObject>) has been deprecated - use removeMeasurements(PathObjectHierarchy, Collection<PathObject>) instead");
        QP.removeMeasurements(hierarchy, pathObjects);
    }

    public static void removeMeasurements(PathObjectHierarchy hierarchy, Collection<? extends PathObject> pathObjects) {
        for (PathObject pathObject : pathObjects) {
            pathObject.getMeasurementList().clear();
            pathObject.getMeasurementList().close();
        }
        if (hierarchy != null) {
            hierarchy.fireObjectMeasurementsChangedEvent(null, pathObjects);
        }
    }

    @Deprecated(since="0.6.0")
    public static void clearAnnotationMeasurements(PathObjectHierarchy hierarchy) {
        LogTools.warnOnce((Logger)logger, (String)"clearAnnotationMeasurements(PathObjectHierarchy) has been deprecated - use removeAnnotationMeasurements(PathObjectHierarchy) instead");
        QP.removeAnnotationMeasurements(hierarchy);
    }

    public static void removeAnnotationMeasurements(PathObjectHierarchy hierarchy) {
        if (hierarchy != null) {
            QP.removeMeasurements(hierarchy, hierarchy.getAnnotationObjects());
        }
    }

    @Deprecated(since="0.6.0")
    public static void clearAnnotationMeasurements() {
        LogTools.warnOnce((Logger)logger, (String)"clearAnnotationMeasurements() has been deprecated - use removeAnnotationMeasurements() instead");
        QP.removeAnnotationMeasurements();
    }

    public static void removeAnnotationMeasurements() {
        QP.removeAnnotationMeasurements(QP.getCurrentHierarchy());
    }

    @Deprecated(since="0.6.0")
    public static void clearDetectionMeasurements(PathObjectHierarchy hierarchy) {
        LogTools.warnOnce((Logger)logger, (String)"clearDetectionMeasurements(PathObjectHierarchy) has been deprecated - use removeDetectionMeasurements(PathObjectHierarchy) instead");
        QP.removeDetectionMeasurements(hierarchy);
    }

    public static void removeDetectionMeasurements(PathObjectHierarchy hierarchy) {
        if (hierarchy != null) {
            QP.removeMeasurements(hierarchy, hierarchy.getDetectionObjects());
        }
    }

    @Deprecated(since="0.6.0")
    public static void clearDetectionMeasurements() {
        LogTools.warnOnce((Logger)logger, (String)"clearDetectionMeasurements() has been deprecated - use removeDetectionMeasurements() instead");
        QP.removeDetectionMeasurements();
    }

    public static void removeDetectionMeasurements() {
        QP.removeDetectionMeasurements(QP.getCurrentHierarchy());
    }

    @Deprecated(since="0.6.0")
    public static void clearTMACoreMeasurements(PathObjectHierarchy hierarchy) {
        LogTools.warnOnce((Logger)logger, (String)"clearTMACoreMeasurements(PathObjectHierarchy) has been deprecated - use removeTMACoreMeasurements(PathObjectHierarchy) instead");
        QP.removeTMACoreMeasurements(hierarchy);
    }

    public static void removeTMACoreMeasurements(PathObjectHierarchy hierarchy) {
        if (hierarchy != null) {
            QP.removeMeasurements(hierarchy, TMACoreObject.class);
        }
    }

    @Deprecated(since="0.6.0")
    public static void clearTMACoreMeasurements() {
        LogTools.warnOnce((Logger)logger, (String)"clearTMACoreMeasurements() has been deprecated - use removeTMACoreMeasurements() instead");
        QP.removeTMACoreMeasurements();
    }

    public static void removeTMACoreMeasurements() {
        QP.removeTMACoreMeasurements(QP.getCurrentHierarchy());
    }

    @Deprecated(since="0.6.0")
    public static void clearMeasurements(PathObjectHierarchy hierarchy, Class<? extends PathObject> cls) {
        LogTools.warnOnce((Logger)logger, (String)"clearMeasurements(PathObjectHierarchy, Class) has been deprecated - use removeMeasurements(PathObjectHierarchy, Class) instead");
        QP.removeMeasurements(hierarchy, cls);
    }

    public static void removeMeasurements(PathObjectHierarchy hierarchy, Class<? extends PathObject> cls) {
        if (hierarchy != null) {
            QP.removeMeasurements(hierarchy, (PathObject[])hierarchy.getObjects(null, null).stream().filter(p -> p.getClass().equals(cls)).toArray(PathObject[]::new));
        }
    }

    @Deprecated(since="0.6.0")
    public static void clearMeasurements(Class<? extends PathObject> cls) {
        LogTools.warnOnce((Logger)logger, (String)"clearMeasurements(Class) has been deprecated - use removeMeasurements(Class) instead");
        QP.removeMeasurements(cls);
    }

    public static void removeMeasurements(Class<? extends PathObject> cls) {
        QP.removeMeasurements(QP.getCurrentHierarchy(), cls);
    }

    @Deprecated(since="0.6.0")
    public static void clearMeasurements() {
        LogTools.warnOnce((Logger)logger, (String)"clearMeasurements() has been deprecated - use removeMeasurements() instead");
        QP.removeMeasurements();
    }

    public static void removeMeasurements() {
        QP.removeDetectionMeasurements(QP.getCurrentHierarchy());
    }

    @Deprecated(since="0.6.0")
    public static void clearCellMeasurements(PathObjectHierarchy hierarchy) {
        LogTools.warnOnce((Logger)logger, (String)"clearCellMeasurements(PathObjectHierarchy) has been deprecated - use removeCellMeasurements(PathObjectHierarchy) instead");
        QP.removeCellMeasurements(hierarchy);
    }

    public static void removeCellMeasurements(PathObjectHierarchy hierarchy) {
        if (hierarchy != null) {
            QP.removeMeasurements(hierarchy, hierarchy.getCellObjects());
        }
    }

    @Deprecated(since="0.6.0")
    public static void clearCellMeasurements() {
        LogTools.warnOnce((Logger)logger, (String)"clearCellMeasurements() has been deprecated - use removeCellMeasurements() instead");
        QP.removeCellMeasurements();
    }

    public static void removeCellMeasurements() {
        QP.removeCellMeasurements(QP.getCurrentHierarchy());
    }

    public static void removeTileMeasurements(PathObjectHierarchy hierarchy) {
        if (hierarchy != null) {
            QP.removeMeasurements(hierarchy, hierarchy.getTileObjects());
        }
    }

    @Deprecated(since="0.6.0")
    public static void clearTileMeasurements(PathObjectHierarchy hierarchy) {
        LogTools.warnOnce((Logger)logger, (String)"clearTileMeasurements(PathObjectHierarchy) has been deprecated - use removeTileMeasurements(PathObjectHierarchy) instead");
        QP.removeTileMeasurements(hierarchy);
    }

    @Deprecated(since="0.6.0")
    public static void clearTileMeasurements() {
        LogTools.warnOnce((Logger)logger, (String)"clearTileMeasurements() has been deprecated - use removeTileMeasurements() instead");
        QP.removeTileMeasurements();
    }

    public static void removeTileMeasurements() {
        QP.removeTileMeasurements(QP.getCurrentHierarchy());
    }

    @Deprecated(since="0.6.0")
    public static void clearRootMeasurements(PathObjectHierarchy hierarchy) {
        LogTools.warnOnce((Logger)logger, (String)"clearRootMeasurements(PathObjectHierarchy) has been deprecated - use removeRootMeasurements(PathObjectHierarchy) instead");
        QP.removeRootMeasurements(hierarchy);
    }

    public static void removeRootMeasurements(PathObjectHierarchy hierarchy) {
        if (hierarchy != null) {
            QP.removeMeasurements(hierarchy, hierarchy.getRootObject());
        }
    }

    @Deprecated(since="0.6.0")
    public static void clearRootMeasurements() {
        LogTools.warnOnce((Logger)logger, (String)"clearRootMeasurements() has been deprecated - use removeRootMeasurements() instead");
        QP.removeRootMeasurements();
    }

    public static void removeRootMeasurements() {
        QP.removeRootMeasurements(QP.getCurrentHierarchy());
    }

    public static PathClass getBasePathClass(PathObject pathObject) {
        PathClass baseClass = pathObject.getPathClass();
        if (baseClass != null && (PathClassTools.isPositiveOrGradedIntensityClass((PathClass)(baseClass = baseClass.getBaseClass())) || PathClassTools.isNegativeClass((PathClass)baseClass))) {
            baseClass = null;
        }
        return baseClass;
    }

    public static PathClass getNonIntensityAncestorPathClass(PathObject pathObject) {
        return PathClassTools.getNonIntensityAncestorClass((PathClass)pathObject.getPathClass());
    }

    public static void setIntensityClassifications(Collection<? extends PathObject> pathObjects, String measurementName, double ... thresholds) {
        PathObjectTools.setIntensityClassifications(pathObjects, (String)measurementName, (double[])thresholds);
    }

    public static void setIntensityClassificationsForSelected(PathObjectHierarchy hierarchy, String measurementName, double ... thresholds) {
        List<PathObject> pathObjects = hierarchy.getSelectionModel().getSelectedObjects().stream().filter(p -> p.isDetection()).toList();
        QP.setIntensityClassifications(pathObjects, measurementName, thresholds);
        hierarchy.fireObjectClassificationsChangedEvent(QP.class, pathObjects);
    }

    public static void setIntensityClassifications(PathObjectHierarchy hierarchy, Class<? extends PathObject> cls, String measurementName, double ... thresholds) {
        Collection pathObjects = hierarchy.getObjects(null, cls);
        QP.setIntensityClassifications(pathObjects, measurementName, thresholds);
        hierarchy.fireObjectClassificationsChangedEvent(QP.class, pathObjects);
    }

    public static void setIntensityClassifications(Class<? extends PathObject> cls, String measurementName, double ... thresholds) {
        QP.setIntensityClassifications(QP.getCurrentHierarchy(), cls, measurementName, thresholds);
    }

    public static void setDetectionIntensityClassifications(PathObjectHierarchy hierarchy, String measurementName, double ... thresholds) {
        QP.setIntensityClassifications(hierarchy, PathDetectionObject.class, measurementName, thresholds);
    }

    public static void setDetectionIntensityClassifications(String measurementName, double ... thresholds) {
        QP.setDetectionIntensityClassifications(QP.getCurrentHierarchy(), measurementName, thresholds);
    }

    public static void setCellIntensityClassifications(String measurementName, double ... thresholds) {
        QP.setCellIntensityClassifications(QP.getCurrentHierarchy(), measurementName, thresholds);
    }

    public static void setCellIntensityClassifications(PathObjectHierarchy hierarchy, String measurementName, double ... thresholds) {
        QP.setIntensityClassifications(hierarchy, PathCellObject.class, measurementName, thresholds);
    }

    public static void resetIntensityClassifications(Collection<PathObject> pathObjects) {
        for (PathObject pathObject : pathObjects) {
            PathClass currentClass = pathObject.getPathClass();
            if (!PathClassTools.isPositiveOrGradedIntensityClass((PathClass)currentClass) && !PathClassTools.isNegativeClass((PathClass)currentClass)) continue;
            pathObject.setPathClass(QP.getNonIntensityAncestorPathClass(pathObject));
        }
    }

    public static void resetIntensityClassifications(PathObjectHierarchy hierarchy) {
        Collection pathObjects = hierarchy.getObjects(null, PathDetectionObject.class);
        QP.resetIntensityClassifications(pathObjects);
        hierarchy.fireObjectClassificationsChangedEvent(QP.class, pathObjects);
    }

    public static void resetIntensityClassifications() {
        QP.resetIntensityClassifications(QP.getCurrentHierarchy());
    }

    public static void writeImageRegion(ImageServer<BufferedImage> server, RegionRequest request, String path) throws IOException {
        ImageWriterTools.writeImageRegion(server, (RegionRequest)request, (String)path);
    }

    public static void writePredictionImage(ImageData<BufferedImage> imageData, PixelClassifier classifier, String path) throws IOException {
        if (imageData == null) {
            imageData = QP.getCurrentImageData();
        }
        ImageServer<BufferedImage> server = PixelClassifierTools.createPixelClassificationServer(imageData, classifier);
        ImageWriterTools.writeImage(server, (String)path);
    }

    public static void writePredictionImage(String classifierName, String path) throws IOException {
        QP.writePredictionImage(QP.getCurrentImageData(), QP.loadPixelClassifier(classifierName), path);
    }

    public static void writeDensityMapImage(ImageData<BufferedImage> imageData, DensityMaps.DensityMapBuilder densityMap, String path) throws IOException {
        if (imageData == null) {
            imageData = QP.getCurrentImageData();
        }
        ImageServer<BufferedImage> server = densityMap.buildServer(imageData);
        ImageWriterTools.writeImage(server, (String)path);
    }

    public static void writeDensityMapImage(String densityMapName, String path) throws IOException {
        QP.writeDensityMapImage(QP.getCurrentImageData(), QP.loadDensityMap(densityMapName), path);
    }

    public static void writeImage(ImageServer<BufferedImage> server, String path) throws IOException {
        ImageWriterTools.writeImage(server, (String)path);
    }

    public static void writeImage(BufferedImage img, String path) throws IOException {
        ImageWriterTools.writeImage((BufferedImage)img, (String)path);
    }

    public static void detectionCentroidDistances(ImageData<?> imageData, boolean splitClassNames) {
        DistanceTools.detectionCentroidDistances(imageData, (boolean)splitClassNames);
    }

    @Deprecated
    public static void detectionCentroidDistances() {
        QP.detectionCentroidDistances(false);
    }

    public static void detectionCentroidDistances(boolean splitClassNames) {
        QP.detectionCentroidDistances(QP.getCurrentImageData(), splitClassNames);
    }

    public static void detectionToAnnotationDistances(ImageData<?> imageData, boolean splitClassNames) {
        DistanceTools.detectionToAnnotationDistances(imageData, (boolean)splitClassNames);
    }

    @Deprecated
    public static void detectionToAnnotationDistances() {
        QP.detectionToAnnotationDistances(false);
    }

    public static void detectionToAnnotationDistances(boolean splitClassNames) {
        QP.detectionToAnnotationDistances(QP.getCurrentImageData(), splitClassNames);
    }

    public static void detectionToAnnotationDistancesSigned(ImageData<?> imageData, boolean splitClassNames) {
        DistanceTools.detectionToAnnotationDistancesSigned(imageData, (boolean)splitClassNames);
    }

    public static void detectionToAnnotationDistancesSigned(boolean splitClassNames) {
        QP.detectionToAnnotationDistancesSigned(QP.getCurrentImageData(), splitClassNames);
    }

    public static boolean setPixelSizeMicrons(ImageData<?> imageData, Number pixelWidthMicrons, Number pixelHeightMicrons, Number zSpacingMicrons) {
        if (QP.isFinite(pixelWidthMicrons) && !QP.isFinite(pixelHeightMicrons)) {
            pixelHeightMicrons = pixelWidthMicrons;
        } else if (QP.isFinite(pixelHeightMicrons) && !QP.isFinite(pixelWidthMicrons)) {
            pixelWidthMicrons = pixelHeightMicrons;
        }
        ImageServerMetadata serverMetadata = imageData.getServerMetadata();
        ImageServerMetadata metadataNew = new ImageServerMetadata.Builder(serverMetadata).pixelSizeMicrons(pixelWidthMicrons, pixelHeightMicrons).zSpacingMicrons(zSpacingMicrons).build();
        if (serverMetadata.equals((Object)metadataNew)) {
            return false;
        }
        imageData.updateServerMetadata(metadataNew);
        return true;
    }

    public static boolean setPixelSizeMicrons(Number pixelWidthMicrons, Number pixelHeightMicrons, Number zSpacingMicrons) {
        return QP.setPixelSizeMicrons(QP.getCurrentImageData(), pixelWidthMicrons, pixelHeightMicrons, zSpacingMicrons);
    }

    public static boolean setPixelSizeMicrons(Number pixelWidthMicrons, Number pixelHeightMicrons) {
        return QP.setPixelSizeMicrons(pixelWidthMicrons, pixelHeightMicrons, null);
    }

    public static void replaceClassification(String originalClassName, String newClassName) {
        QP.replaceClassification(QP.getCurrentHierarchy(), QP.getPathClass(originalClassName), QP.getPathClass(newClassName));
    }

    public static void replaceClassification(PathClass originalClass, PathClass newClass) {
        QP.replaceClassification(QP.getCurrentHierarchy(), originalClass, newClass);
    }

    public static void replaceClassification(PathObjectHierarchy hierarchy, PathClass originalClass, PathClass newClass) {
        if (hierarchy == null) {
            return;
        }
        Collection pathObjects = hierarchy.getObjects(null, null);
        if (pathObjects.isEmpty()) {
            return;
        }
        QP.replaceClassification(pathObjects, originalClass, newClass);
        hierarchy.fireObjectClassificationsChangedEvent(QP.class, pathObjects);
    }

    public static void replaceClassification(Collection<PathObject> pathObjects, PathClass originalClass, PathClass newClass) {
        if (PathClass.NULL_CLASS == originalClass) {
            originalClass = null;
        }
        if (PathClass.NULL_CLASS == newClass) {
            newClass = null;
        }
        for (PathObject pathObject : pathObjects) {
            if (pathObject.getPathClass() != originalClass) continue;
            pathObject.setPathClass(newClass);
        }
    }

    public static void resolveHierarchy() {
        QP.resolveHierarchy(QP.getCurrentHierarchy());
    }

    public static void resolveHierarchy(PathObjectHierarchy hierarchy) {
        if (hierarchy == null) {
            return;
        }
        hierarchy.resolveHierarchy();
    }

    public static void insertObjects(Collection<? extends PathObject> pathObjects) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            hierarchy.insertPathObjects(pathObjects);
        }
    }

    public static void insertObjects(PathObject pathObject) {
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        if (hierarchy != null) {
            hierarchy.insertPathObject(pathObject, true);
        }
    }

    private static boolean isFinite(Number val) {
        return val != null && Double.isFinite(val.doubleValue());
    }

    public static boolean mergePointsForAllClasses() {
        return PathObjectTools.mergePointsForAllClasses((PathObjectHierarchy)QP.getCurrentHierarchy());
    }

    public static boolean mergePointsForSelectedObjectClasses() {
        return PathObjectTools.mergePointsForSelectedObjectClasses((PathObjectHierarchy)QP.getCurrentHierarchy());
    }

    public static boolean splitAllAnnotationAreasByLines() {
        return QP.splitAllAnnotationAreasByLines(QP.getCurrentHierarchy());
    }

    public static boolean splitAllAnnotationAreasByLines(double thickness, boolean removeLines) {
        return QP.splitAllAnnotationAreasByLines(QP.getCurrentHierarchy(), thickness, removeLines);
    }

    public static boolean splitAllAnnotationAreasByLines(PathObjectHierarchy hierarchy) {
        return QP.splitAllAnnotationAreasByLines(hierarchy, 0.0, true);
    }

    public static boolean splitAllAnnotationAreasByLines(PathObjectHierarchy hierarchy, double thickness, boolean removeLines) {
        return QP.splitSpecifiedAreasByLines(hierarchy, hierarchy.getAnnotationObjects(), thickness, removeLines);
    }

    public static boolean splitSelectedAnnotationAreasByLines() {
        return QP.splitSelectedAnnotationAreasByLines(QP.getCurrentHierarchy());
    }

    public static boolean splitSelectedAnnotationAreasByLines(double thickness, boolean removeLines) {
        return QP.splitSelectedAnnotationAreasByLines(QP.getCurrentHierarchy(), thickness, removeLines);
    }

    public static boolean splitSelectedAnnotationAreasByLines(PathObjectHierarchy hierarchy) {
        return QP.splitSelectedAnnotationAreasByLines(hierarchy, 0.0, true);
    }

    public static boolean splitSelectedAnnotationAreasByLines(PathObjectHierarchy hierarchy, double thickness, boolean removeLines) {
        return QP.splitSpecifiedAreasByLines(hierarchy, hierarchy.getSelectionModel().getSelectedObjects().stream().filter(PathObject::isAnnotation).toList(), thickness, removeLines);
    }

    public static boolean splitSpecifiedAreasByLines(PathObjectHierarchy hierarchy, Collection<? extends PathObject> pathObjects, double thickness, boolean removeLines) {
        List lines;
        if (hierarchy == null) {
            logger.warn("No hierarchy available for splitting annotations");
            return false;
        }
        List areas = PathObjectTools.getAreaObjects(pathObjects);
        Map map = PathObjectTools.splitAreasByBufferedLines((Collection)areas, (Collection)(lines = PathObjectTools.getLineObjects(pathObjects)), (double)(thickness / 2.0));
        if (map.isEmpty() && lines.isEmpty()) {
            return false;
        }
        HashSet removed = new HashSet(map.keySet());
        hierarchy.removeObjects(map.keySet(), true);
        hierarchy.addObjects(map.values().stream().flatMap(Collection::stream).toList());
        if (removeLines) {
            hierarchy.removeObjects((Collection)lines, true);
            removed.addAll(lines);
        }
        hierarchy.getSelectionModel().deselectObjects(removed);
        return true;
    }

    public static boolean duplicateSelectedAnnotations() {
        return QP.duplicateSelectedAnnotations(QP.getCurrentHierarchy());
    }

    public static boolean duplicateSelectedAnnotations(PathObjectHierarchy hierarchy) {
        return PathObjectTools.duplicateSelectedAnnotations((PathObjectHierarchy)hierarchy);
    }

    public static boolean copySelectedObjectsToPlane(int z, int t) {
        return QP.copySelectedObjectsToPlane(QP.getCurrentHierarchy(), ImagePlane.getPlane((int)z, (int)t));
    }

    public static boolean copySelectedObjectsToPlane(ImagePlane plane) {
        return QP.copySelectedObjectsToPlane(QP.getCurrentHierarchy(), plane);
    }

    public static boolean copySelectedObjectsToPlane(PathObjectHierarchy hierarchy, ImagePlane plane) {
        return QP.copySelectedObjectsToPlane(hierarchy, plane, p -> p.hasROI());
    }

    public static boolean copySelectedAnnotationsToPlane(int z, int t) {
        return QP.copySelectedAnnotationsToPlane(QP.getCurrentHierarchy(), ImagePlane.getPlane((int)z, (int)t));
    }

    public static boolean copySelectedAnnotationsToPlane(ImagePlane plane) {
        return QP.copySelectedAnnotationsToPlane(QP.getCurrentHierarchy(), plane);
    }

    public static boolean copySelectedAnnotationsToPlane(PathObjectHierarchy hierarchy, ImagePlane plane) {
        return QP.copySelectedObjectsToPlane(hierarchy, plane, p -> p.hasROI() && p.isAnnotation());
    }

    private static boolean copySelectedObjectsToPlane(PathObjectHierarchy hierarchy, ImagePlane plane, Predicate<PathObject> filter) {
        List<PathObject> transformed;
        if (hierarchy == null) {
            return false;
        }
        Collection selected = hierarchy.getSelectionModel().getSelectedObjects();
        if (selected.isEmpty()) {
            return false;
        }
        PathObject primary = hierarchy.getSelectionModel().getSelectedObject();
        if (primary != null) {
            selected = new ArrayList(selected);
            selected.remove(primary);
            ((List)selected).add(0, primary);
        }
        if ((transformed = selected.stream().filter(filter).map(p -> PathObjectTools.updatePlane((PathObject)p, (ImagePlane)plane, (boolean)false, (boolean)true)).toList()).isEmpty()) {
            return false;
        }
        hierarchy.addObjects(transformed);
        hierarchy.getSelectionModel().setSelectedObjects(transformed, primary == null ? null : transformed.get(0));
        return true;
    }

    public static boolean mergeAnnotations(Collection<PathObject> annotations) {
        return QP.mergeAnnotations(QP.getCurrentHierarchy(), annotations);
    }

    public static boolean mergeSelectedAnnotations() {
        return QP.mergeSelectedAnnotations(QP.getCurrentHierarchy());
    }

    public static boolean mergeAnnotations(PathObjectHierarchy hierarchy, Collection<PathObject> annotations) {
        if (hierarchy == null) {
            return false;
        }
        ROI shapeNew = null;
        ArrayList<PathObject> merged = new ArrayList<PathObject>();
        HashSet<PathClass> pathClasses = new HashSet<PathClass>();
        for (PathObject annotation : annotations) {
            if (!annotation.isAnnotation() || !annotation.hasROI() || !annotation.getROI().isArea() && !annotation.getROI().isPoint()) continue;
            if (shapeNew == null) {
                shapeNew = annotation.getROI();
            } else if (shapeNew.getImagePlane().equals((Object)annotation.getROI().getImagePlane())) {
                shapeNew = RoiTools.combineROIs((ROI)shapeNew, (ROI)annotation.getROI(), (RoiTools.CombineOp)RoiTools.CombineOp.ADD);
            } else {
                logger.warn("Cannot merge ROIs across different image planes!");
                return false;
            }
            if (annotation.getPathClass() != null) {
                pathClasses.add(annotation.getPathClass());
            }
            merged.add(annotation);
        }
        if (merged.isEmpty() || merged.size() == 1) {
            return false;
        }
        PathObject pathObjectNew = PathObjects.createAnnotationObject(shapeNew);
        if (pathClasses.size() == 1) {
            pathObjectNew.setPathClass((PathClass)pathClasses.iterator().next());
        } else {
            logger.warn("Cannot assign class unambiguously - " + pathClasses.size() + " classes represented in selection");
        }
        hierarchy.removeObjects(merged, true);
        hierarchy.addObject(pathObjectNew);
        hierarchy.getSelectionModel().setSelectedObject(pathObjectNew);
        return true;
    }

    public static boolean mergeSelectedAnnotations(PathObjectHierarchy hierarchy) {
        return hierarchy == null ? false : QP.mergeAnnotations(hierarchy, hierarchy.getSelectionModel().getSelectedObjects());
    }

    public static boolean makeInverseAnnotation(PathObject pathObject) {
        return QP.makeInverseAnnotation(QP.getCurrentImageData(), pathObject);
    }

    public static boolean makeInverseAnnotation(ImageData<?> imageData, PathObject pathObject) {
        if (imageData == null) {
            return false;
        }
        return QP.makeInverseAnnotation(imageData, Collections.singletonList(pathObject));
    }

    public static boolean makeInverseAnnotation() {
        return QP.makeInverseAnnotation(QP.getCurrentImageData());
    }

    public static boolean makeInverseAnnotation(ImageData<?> imageData) {
        return QP.makeInverseAnnotation(imageData, imageData.getHierarchy().getSelectionModel().getSelectedObjects());
    }

    public static boolean makeInverseAnnotation(ImageData<?> imageData, Collection<PathObject> pathObjects) {
        PathObject parent;
        if (imageData == null) {
            return false;
        }
        Map<ImagePlane, List<PathObject>> map = pathObjects.stream().filter(p -> p.hasROI() && p.getROI().isArea()).collect(Collectors.groupingBy(p -> p.getROI().getImagePlane()));
        if (map.isEmpty()) {
            logger.warn("No area annotations available - cannot created inverse ROI!");
            return false;
        }
        if (map.size() > 1) {
            logger.error("Cannot merge annotations from different image planes!");
            return false;
        }
        ImagePlane plane = map.keySet().iterator().next();
        List<PathObject> pathObjectList = map.get(plane);
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        Collection parentSet = pathObjectList.stream().map(p -> p.getParent()).collect(Collectors.toCollection(HashSet::new));
        if (parentSet.size() > 1) {
            parentSet.clear();
            boolean firstTime = true;
            for (PathObject temp : pathObjectList) {
                if (firstTime) {
                    parentSet.addAll(PathObjectTools.getAncestorList((PathObject)temp));
                } else {
                    parentSet.retainAll(PathObjectTools.getAncestorList((PathObject)temp));
                }
                firstTime = false;
            }
            ArrayList parents = new ArrayList(parentSet);
            Collections.sort(parents, Comparator.comparingInt(PathObject::getLevel).reversed().thenComparingDouble(p -> p.hasROI() ? p.getROI().getArea() : Double.MAX_VALUE));
            parent = (PathObject)parents.get(0);
        } else {
            parent = (PathObject)parentSet.iterator().next();
        }
        Object geometryParent = parent == null || parent.isRootObject() || !parent.hasROI() ? GeometryTools.createRectangle((double)0.0, (double)0.0, (double)imageData.getServer().getWidth(), (double)imageData.getServer().getHeight()) : parent.getROI().getGeometry();
        Geometry union = GeometryTools.union(pathObjectList.stream().map(p -> p.getROI().getGeometry()).toList());
        Geometry geometry = geometryParent.difference(union);
        ROI shapeNew = GeometryTools.geometryToROI((Geometry)geometry, (ImagePlane)plane);
        PathObject pathObjectNew = PathObjects.createAnnotationObject((ROI)shapeNew);
        parent.addChildObject(pathObjectNew);
        hierarchy.fireHierarchyChangedEvent((Object)parent);
        hierarchy.getSelectionModel().setSelectedObject(pathObjectNew);
        return true;
    }

    public static void runObjectClassifier(String ... names) throws IllegalArgumentException {
        QP.runObjectClassifier(QP.getCurrentImageData(), names);
    }

    public static void runObjectClassifier(ImageData imageData, String ... names) throws IllegalArgumentException {
        Collection pathObjects;
        if (names.length == 0) {
            logger.warn("Cannot run object classifier - no names provided!");
            return;
        }
        if (imageData == null) {
            logger.warn("Cannot run object classifier - no ImageData available!");
            return;
        }
        ObjectClassifier<BufferedImage> classifier = QP.loadObjectClassifier(names);
        if (classifier.classifyObjects(imageData, pathObjects = classifier.getCompatibleObjects(imageData), true) > 0) {
            imageData.getHierarchy().fireObjectClassificationsChangedEvent(classifier, pathObjects);
        }
    }

    public static ObjectClassifier<BufferedImage> loadObjectClassifier(String ... names) throws IllegalArgumentException {
        Project<BufferedImage> project = QP.getProject();
        ArrayList<ObjectClassifier> classifiers = new ArrayList<ObjectClassifier>();
        for (String name : names) {
            ObjectClassifier classifier = null;
            Exception exception = null;
            if (project != null) {
                try {
                    ResourceManager.Manager objectClassifiers = project.getObjectClassifiers();
                    if (objectClassifiers.contains(name)) {
                        classifier = (ObjectClassifier)objectClassifiers.get(name);
                    }
                }
                catch (Exception e) {
                    exception = e;
                    logger.debug("Object classifier '{}' not found in project", (Object)name);
                }
            }
            if (classifier == null) {
                try {
                    Path path = Paths.get(name, new String[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        classifier = ObjectClassifiers.readClassifier((Path)path);
                    }
                }
                catch (Exception e) {
                    exception = e;
                    logger.debug("Object classifier '{}' cannot be read from file", (Object)name);
                }
            }
            if (classifier == null) {
                throw new IllegalArgumentException("Unable to find object classifier " + name, exception);
            }
            if (classifier instanceof UriResource) {
                UriUpdater.fixUris((UriResource)((UriResource)classifier), project);
            }
            if (names.length == 1) {
                return classifier;
            }
            classifiers.add(classifier);
        }
        return ObjectClassifiers.createCompositeClassifier(classifiers);
    }

    public static DensityMaps.DensityMapBuilder loadDensityMap(String name) throws IllegalArgumentException {
        Project<BufferedImage> project = QP.getProject();
        Exception exception = null;
        if (project != null) {
            try {
                ResourceManager.Manager densityMaps = project.getResources("classifiers/density_maps", DensityMaps.DensityMapBuilder.class, "json");
                if (densityMaps.contains(name)) {
                    return (DensityMaps.DensityMapBuilder)densityMaps.get(name);
                }
            }
            catch (Exception e) {
                exception = e;
                logger.debug("Density map '{}' not found in project", (Object)name);
            }
        }
        try {
            Path path = Paths.get(name, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                return DensityMaps.loadDensityMap(path);
            }
        }
        catch (Exception e) {
            exception = e;
            logger.debug("Density map '{}' cannot be read from file", (Object)name);
        }
        throw new IllegalArgumentException("Unable to find density map " + name, exception);
    }

    public static String locateFile(String nameOrPath) throws IOException {
        return QP.locateFile(nameOrPath, 4);
    }

    public static String locateFile(String nameOrPath, int searchDepth) throws IOException {
        Path path;
        Project<BufferedImage> project = QP.getProject();
        Path path2 = path = project == null ? null : project.getPath();
        if (path != null) {
            return UriUpdater.locateFile((String)nameOrPath, (int)searchDepth, (Path[])new Path[]{path});
        }
        return nameOrPath;
    }

    public static void findDensityMapHotspots(String densityMapName, int channel, int numHotspots, double minCounts, boolean deleteExisting, boolean peaksOnly) throws IOException {
        QP.findDensityMapHotspots(QP.getCurrentImageData(), QP.loadDensityMap(densityMapName), channel, numHotspots, minCounts, deleteExisting, peaksOnly);
    }

    public static void findDensityMapHotspots(ImageData<BufferedImage> imageData, String densityMapName, int channel, int numHotspots, double minCounts, boolean deleteExisting, boolean peaksOnly) throws IOException {
        QP.findDensityMapHotspots(imageData, QP.loadDensityMap(densityMapName), channel, numHotspots, minCounts, deleteExisting, peaksOnly);
    }

    public static void findDensityMapHotspots(ImageData<BufferedImage> imageData, DensityMaps.DensityMapBuilder densityMap, int channel, int numHotspots, double minCounts, boolean deleteExisting, boolean peaksOnly) throws IOException {
        ImageServer<BufferedImage> densityServer = densityMap.buildServer(imageData);
        double radius = densityMap.buildParameters().getRadius();
        PathClass pathClass = PathClass.fromString((String)densityServer.getChannel(channel).getName());
        DensityMaps.findHotspots(imageData.getHierarchy(), densityServer, channel, numHotspots, radius, minCounts, pathClass, deleteExisting, peaksOnly);
    }

    public static void createAnnotationsFromDensityMap(String densityMapName, Map<Integer, ? extends Number> thresholds, String pathClassName, String ... options) throws IOException {
        QP.createAnnotationsFromDensityMap(QP.getCurrentImageData(), densityMapName, thresholds, pathClassName, options);
    }

    public static void createAnnotationsFromDensityMap(ImageData<BufferedImage> imageData, String densityMapName, Map<Integer, ? extends Number> thresholds, String pathClassName, String ... options) throws IOException {
        DensityMaps.DensityMapBuilder densityMap = QP.loadDensityMap(densityMapName);
        QP.createAnnotationsFromDensityMap(imageData, densityMap, thresholds, pathClassName, (PixelClassifierTools.CreateObjectOptions[])QP.parseEnumOptions(PixelClassifierTools.CreateObjectOptions.class, null, (String[])options));
    }

    public static void createAnnotationsFromDensityMap(ImageData<BufferedImage> imageData, DensityMaps.DensityMapBuilder densityMap, Map<Integer, ? extends Number> thresholds, String pathClassName, PixelClassifierTools.CreateObjectOptions ... options) throws IOException {
        ImageServer<BufferedImage> densityServer = densityMap.buildServer(imageData);
        DensityMaps.threshold(imageData.getHierarchy(), densityServer, thresholds, pathClassName, options);
    }

    public static Logger getLogger() {
        return logger;
    }

    public static Logger getLogger(String name) {
        return LoggerFactory.getLogger((String)name);
    }

    public static Logger getLogger(Class<?> cls) {
        return LoggerFactory.getLogger(cls);
    }

    public static PixelClassifier loadPixelClassifier(String name) throws IllegalArgumentException {
        Project<BufferedImage> project = QP.getProject();
        Exception exception = null;
        PixelClassifier pixelClassifier = null;
        if (project != null) {
            try {
                ResourceManager.Manager pixelClassifiers = project.getPixelClassifiers();
                if (pixelClassifiers.contains(name)) {
                    pixelClassifier = (PixelClassifier)pixelClassifiers.get(name);
                }
            }
            catch (Exception e) {
                exception = e;
                logger.debug("Pixel classifier '{}' not found in project", (Object)name);
            }
        }
        try {
            Path path = Paths.get(name, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                pixelClassifier = PixelClassifiers.readClassifier(path);
            }
        }
        catch (Exception e) {
            exception = e;
            logger.debug("Pixel classifier '{}' cannot be read from file", (Object)name);
        }
        if (pixelClassifier == null) {
            throw new IllegalArgumentException("Unable to find pixel classifier " + name, exception);
        }
        if (pixelClassifier instanceof UriResource) {
            UriUpdater.fixUris((UriResource)((UriResource)pixelClassifier), project);
        }
        return pixelClassifier;
    }

    public static void addPixelClassifierMeasurements(String classifierName, String measurementID) {
        QP.addPixelClassifierMeasurements(QP.loadPixelClassifier(classifierName), measurementID);
    }

    public static void addPixelClassifierMeasurements(PixelClassifier classifier, String measurementID) {
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        PixelClassifierTools.addMeasurementsToSelectedObjects(imageData, classifier, measurementID);
    }

    public static void createDetectionsFromPixelClassifier(String classifierName, double minArea, double minHoleArea, String ... options) throws IllegalArgumentException, IOException {
        QP.createDetectionsFromPixelClassifier(QP.loadPixelClassifier(classifierName), minArea, minHoleArea, options);
    }

    public static void createDetectionsFromPixelClassifier(PixelClassifier classifier, double minArea, double minHoleArea, String ... options) throws IOException {
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        PixelClassifierTools.createDetectionsFromPixelClassifier(imageData, classifier, minArea, minHoleArea, (PixelClassifierTools.CreateObjectOptions[])QP.parseEnumOptions(PixelClassifierTools.CreateObjectOptions.class, null, (String[])options));
    }

    public static void createAnnotationsFromPixelClassifier(String classifierName, double minArea, double minHoleArea, String ... options) throws IllegalArgumentException, IOException {
        QP.createAnnotationsFromPixelClassifier(QP.loadPixelClassifier(classifierName), minArea, minHoleArea, options);
    }

    public static void createAnnotationsFromPixelClassifier(PixelClassifier classifier, double minArea, double minHoleArea, String ... options) throws IOException {
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        PixelClassifierTools.createAnnotationsFromPixelClassifier(imageData, classifier, minArea, minHoleArea, (PixelClassifierTools.CreateObjectOptions[])QP.parseEnumOptions(PixelClassifierTools.CreateObjectOptions.class, null, (String[])options));
    }

    public static void classifyDetectionsByCentroid(PixelClassifier classifier) {
        ImageData<BufferedImage> imageData = QP.getCurrentImageData();
        PixelClassifierTools.classifyDetectionsByCentroid(imageData, classifier);
    }

    public static void classifyDetectionsByCentroid(String classifierName) {
        QP.classifyDetectionsByCentroid(QP.loadPixelClassifier(classifierName));
    }

    public static void checkMinVersion(String version) throws UnsupportedOperationException {
        if (VERSION == null) {
            throw new UnsupportedOperationException("Can't check version - QuPath version is unknown!");
        }
        Version versionToCompare = Version.parse((String)version);
        if (versionToCompare.compareTo(VERSION) > 0) {
            throw new UnsupportedOperationException("Mininum version " + String.valueOf(versionToCompare) + " exceeds current QuPath version " + String.valueOf(VERSION));
        }
    }

    public static void checkVersionRange(String minVersion, String maxVersion) throws UnsupportedOperationException {
        QP.checkMinVersion(minVersion);
        Version versionMax = Version.parse((String)maxVersion);
        if (versionMax.compareTo(VERSION) <= 0) {
            throw new UnsupportedOperationException("Current QuPath version " + String.valueOf(VERSION) + " is >= the specified (non-inclusive) maximum " + String.valueOf(versionMax));
        }
    }

    public static boolean removeObjectsOutsideImage() {
        return QP.removeObjectsOutsideImage(QP.getCurrentImageData());
    }

    public static boolean removeObjectsOutsideImage(boolean ignoreIntersecting) {
        return QP.removeObjectsOutsideImage(QP.getCurrentImageData(), ignoreIntersecting);
    }

    public static boolean removeObjectsOutsideImage(ImageData<?> imageData) {
        return QP.removeObjectsOutsideImage(imageData, true);
    }

    public static boolean removeObjectsOutsideImage(ImageData<?> imageData, boolean ignoreIntersecting) {
        Objects.requireNonNull(imageData, "Hierarchy must not be null!");
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        ImageServer server = imageData.getServer();
        List toRemoveOriginal = PathObjectTools.findObjectsOutsideImage((Collection)hierarchy.getAllObjects(false), (ImageServer)server, (boolean)ignoreIntersecting);
        List<PathObject> toRemove = toRemoveOriginal.stream().filter(p -> !p.isTMACore()).toList();
        if (toRemove.size() < toRemoveOriginal.size()) {
            logger.warn("TMA cores outside the image can't be removed");
        }
        if (toRemove.isEmpty()) {
            return false;
        }
        hierarchy.removeObjects(toRemove, true);
        hierarchy.getSelectionModel().deselectObjects(toRemove);
        return true;
    }

    public static boolean removeOrClipObjectsOutsideImage() {
        return QP.removeOrClipObjectsOutsideImage(QP.getCurrentImageData());
    }

    public static boolean removeOrClipObjectsOutsideImage(ImageData<?> imageData) {
        ImageServer server = imageData.getServer();
        PathObjectHierarchy hierarchy = QP.getCurrentHierarchy();
        boolean changes = QP.removeObjectsOutsideImage(imageData, true);
        List<PathObject> overlapping = PathObjectTools.findObjectsOutsideImage((Collection)hierarchy.getAllObjects(false), (ImageServer)server, (boolean)false).stream().filter(p -> !p.isTMACore()).toList();
        if (overlapping.isEmpty()) {
            return changes;
        }
        List<PathObject> overlappingDetections = overlapping.stream().filter(p -> p.isDetection()).toList();
        if (!overlappingDetections.isEmpty()) {
            hierarchy.removeObjects(overlappingDetections, true);
            changes = true;
            if (overlapping.size() == overlappingDetections.size()) {
                return changes;
            }
        }
        Polygon clipBounds = GeometryTools.createRectangle((double)0.0, (double)0.0, (double)server.getWidth(), (double)server.getHeight());
        for (PathObject pathObject : overlapping) {
            if (!pathObject.isAnnotation()) continue;
            ROI roi = pathObject.getROI();
            Geometry geom = roi.getGeometry();
            Geometry geom2 = clipBounds.intersection(geom);
            ROI roi2 = GeometryTools.geometryToROI((Geometry)geom2, (ImagePlane)roi.getImagePlane());
            ((PathAnnotationObject)pathObject).setROI(roi2);
            changes = true;
        }
        hierarchy.fireHierarchyChangedEvent(QP.class);
        return changes;
    }

    public static boolean removeObjectsTouchingImageBounds() {
        return QP.removeObjectsTouchingImageBounds(null);
    }

    public static boolean removeObjectsTouchingImageBounds(Predicate<PathObject> filter) {
        return QP.removeObjectsTouchingImageBounds(QP.getCurrentImageData(), filter);
    }

    public static boolean removeObjectsTouchingImageBounds(ImageData<?> imageData, Predicate<PathObject> filter) {
        if (imageData == null) {
            return false;
        }
        return PathObjectTools.removeTouchingImageBounds(imageData, filter);
    }

    public static boolean removeObjectsTouchingSelectedBounds() {
        return QP.removeObjectsTouchingSelectedBounds(null);
    }

    public static boolean removeObjectsTouchingSelectedBounds(Predicate<PathObject> filter) {
        return QP.removeObjectsTouchingSelectedBounds(QP.getCurrentHierarchy(), filter);
    }

    public static boolean removeObjectsTouchingSelectedBounds(PathObjectHierarchy hierarchy, Predicate<PathObject> filter) {
        if (hierarchy == null) {
            return false;
        }
        List<PathObject> selected = List.copyOf(hierarchy.getSelectionModel().getSelectedObjects());
        boolean changes = false;
        for (PathObject obj : selected) {
            changes |= PathObjectTools.removeTouchingBounds((PathObjectHierarchy)hierarchy, (PathObject)obj, filter);
        }
        return changes;
    }

    public static boolean removeChildObjectsTouchingSelectedBounds() {
        return QP.removeChildObjectsTouchingSelectedBounds(null);
    }

    public static boolean removeChildObjectsTouchingSelectedBounds(Predicate<PathObject> filter) {
        return QP.removeChildObjectsTouchingSelectedBounds(QP.getCurrentHierarchy(), filter);
    }

    public static boolean removeChildObjectsTouchingSelectedBounds(PathObjectHierarchy hierarchy, Predicate<PathObject> filter) {
        if (hierarchy == null) {
            return false;
        }
        List<PathObject> selected = List.copyOf(hierarchy.getSelectionModel().getSelectedObjects());
        boolean changes = false;
        for (PathObject obj : selected) {
            Predicate<PathObject> predicate = p -> Objects.equals(obj, p.getParent());
            if (filter != null) {
                predicate = filter.and(predicate);
            }
            changes |= PathObjectTools.removeTouchingBounds((PathObjectHierarchy)hierarchy, (PathObject)obj, predicate);
        }
        return changes;
    }

    private static void setTMACoreList(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("tMACoreList");
    }

    private static void setCellObjects(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("cellObjects");
    }

    private static void setTileObjects(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("tileObjects");
    }

    private static void setDetectionObjects(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("detectionObjects");
    }

    private static void setAnnotationObjects(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("annotationObjects");
    }

    private static void setAllObjects(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("allObjects");
    }

    private static void setCurrentHierarchy(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("currentHierarchy");
    }

    private static void setCurrentImageData(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("currentImageData");
    }

    private static void setCurrentServer(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("currentServer");
    }

    private static void setCurrentServerPath(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("currentServerPath");
    }

    private static void setProject(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("project");
    }

    private static void setProjectEntry(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("projectEntry");
    }

    private static void setCoreClasses(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("coreClasses");
    }

    private static void setCurrentImageName(Object o) throws UnsupportedOperationException {
        QP.warnAboutSetter("currentImageName");
    }

    private static void warnAboutSetter(String name) throws UnsupportedOperationException {
        logger.warn("Unsupported attempt to set {}. This can happen in a Groovy script if you use '{}' as a global variable name - please use a different name instead, or default a local variable with 'def {}'", new Object[]{name, name, name});
        throw new UnsupportedOperationException(name + " cannot be set!");
    }

    public static void simplifyAllAnnotations(double altitudeThreshold) {
        QP.simplifySpecifiedAnnotations(QP.getAnnotationObjects(), altitudeThreshold);
    }

    public static void simplifySelectedAnnotations(double altitudeThreshold) {
        QP.simplifySpecifiedAnnotations(Objects.requireNonNull(QP.getSelectedObjects()).stream().toList(), altitudeThreshold);
    }

    public static void simplifySpecifiedAnnotations(Collection<? extends PathObject> pathObjects, double altitudeThreshold) {
        int skipped = 0;
        for (PathObject pathObject : pathObjects) {
            if (!(pathObject instanceof PathAnnotationObject)) {
                ++skipped;
                continue;
            }
            PathAnnotationObject pao = (PathAnnotationObject)pathObject;
            pao.setROI(ShapeSimplifier.simplifyROI((ROI)pathObject.getROI(), (double)altitudeThreshold));
        }
        if (skipped > 0) {
            logger.warn("{} non-annotation objects supplied to simplifySpecifiedAnnotations (ignored)", (Object)skipped);
        }
    }

    public static void convertSelectedObjectsToPoints() {
        QP.convertSpecifiedObjectsToPoints(QP.getCurrentHierarchy(), QP.getSelectedObjects());
    }

    public static void convertDetectionsToPoints() {
        QP.convertSpecifiedObjectsToPoints(QP.getCurrentHierarchy(), QP.getDetectionObjects());
    }

    public static void convertSpecifiedObjectsToPoints(PathObjectHierarchy hierarchy, Collection<? extends PathObject> pathObjects) {
        PathObjectTools.convertToPoints((PathObjectHierarchy)hierarchy, pathObjects, (boolean)true, (boolean)false);
    }

    static {
        logger.info("Initializing type adapters");
        ObjectClassifiers.ObjectClassifierTypeAdapterFactory.registerSubtype(OpenCVMLClassifier.class);
        GsonTools.getDefaultBuilder().registerTypeAdapterFactory(PixelClassifiers.getTypeAdapterFactory()).registerTypeAdapterFactory(FeatureExtractors.getTypeAdapterFactory()).registerTypeAdapterFactory(ObjectClassifiers.getTypeAdapterFactory()).registerTypeAdapterFactory(OpenCVTypeAdapters.getOpenCVTypeAdaptorFactory()).registerTypeAdapter(ColorTransforms.ColorTransform.class, (Object)new ColorTransforms.ColorTransformTypeAdapter());
        ImageOps init = new ImageOps();
        ImageServers servers = new ImageServers();
        PathObjectPredicates predicates = new PathObjectPredicates();
        ColorModels colorModels = new ColorModels();
        DnnTools dnnTools = new DnnTools();
        CORE_CLASSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(QP.class, ImageData.class, ImageServer.class, PathObject.class, PathObjectHierarchy.class, PathClass.class, TransformedServerBuilder.class, ImageRegion.class, RegionRequest.class, ImagePlane.class, Padding.class, PixelType.class, PathObjects.class, ROIs.class, Projects.class, AffineTransforms.class, PathObjectTools.class, RoiTools.class, GsonTools.class, BufferedImageTools.class, ColorTools.class, GeneralTools.class, ObjectMerger.class, Tiler.class, Timeit.class, ScriptAttributes.class, Version.class, DistanceTools.class, ImageWriterTools.class, PathClassTools.class, GeometryTools.class, IJTools.class, IJProperties.class, IJFilters.class, OpenCVTools.class, NumpyTools.class, DnnTools.class, DnnModels.class, DnnModelParams.class, TileExporter.class, LabeledImageServer.class, ServerTools.class, PixelClassifierTools.class, BioimageIoTools.class, DensityMaps.class, ColorTransforms.class, ImageOps.class, DelaunayTools.class, CellTools.class, ContourTracing.class, GroovyCV.class, PathObjectFilter.class, PathObjectPredicates.class, PathIO.class, PointIO.class, ProjectIO.class, UriUpdater.class, BufferedImage.class)));
    }
}

