/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.scripting;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class LoggingTools {
    private static final Logger defaultLogger = LoggerFactory.getLogger(LoggingTools.class);

    public static Writer createLogWriter(Logger logger, Level level) {
        Logger localLogger;
        Objects.requireNonNull(level);
        Logger logger2 = localLogger = logger == null ? defaultLogger : logger;
        if (level == Level.INFO) {
            return new LoggerInfoWriter(localLogger);
        }
        if (level == Level.ERROR) {
            return new LoggerErrorWriter(localLogger);
        }
        return new LoggerWriter(localLogger, level);
    }

    private static class LoggerInfoWriter
    extends LoggerWriter {
        private LoggerInfoWriter(Logger logger) {
            super(logger, Level.INFO);
        }

        @Override
        protected void log(String s) {
            this.logger.info(s);
        }
    }

    private static class LoggerErrorWriter
    extends LoggerWriter {
        private LoggerErrorWriter(Logger logger) {
            super(logger, Level.ERROR);
        }

        @Override
        protected void log(String s) {
            this.logger.error(s);
        }
    }

    private static class LoggerWriter
    extends Writer {
        protected Logger logger;
        protected Level level;

        private LoggerWriter(Logger logger, Level level) {
            this.logger = logger;
            this.level = level;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (len == 1 && cbuf[off] == '\n') {
                return;
            }
            String s = String.valueOf(cbuf, off, len);
            if (s.equals(System.lineSeparator())) {
                return;
            }
            this.log(s);
        }

        protected void log(String s) {
            this.logger.atLevel(this.level).log(s);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }
}

