/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.AbstractDetectionPlugin;
import qupath.lib.plugins.PathTask;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class TileClassificationsToAnnotationsPlugin<T>
extends AbstractDetectionPlugin<T> {
    private static Logger logger = LoggerFactory.getLogger(TileClassificationsToAnnotationsPlugin.class);
    private ParameterList params;
    private boolean parametersInitialized = false;

    public String getName() {
        return "Tile classifications to annotations";
    }

    public String getDescription() {
        return "Create annotations from classified tiles";
    }

    public String getLastResultsDescription() {
        return "";
    }

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        ArrayList<Class<? extends PathObject>> parentClasses = new ArrayList<Class<? extends PathObject>>();
        parentClasses.add(TMACoreObject.class);
        parentClasses.add(PathAnnotationObject.class);
        parentClasses.add(PathRootObject.class);
        return parentClasses;
    }

    protected void addRunnableTasks(ImageData<T> imageData, PathObject parentObject, List<Runnable> tasks) {
        ParameterList params = this.getParameterList(imageData);
        if (params.getBooleanParameterValue("clearAnnotations").booleanValue()) {
            PathObjectHierarchy hierarchy = imageData.getHierarchy();
            Collection annotations = PathObjectTools.getDescendantObjects((PathObject)parentObject, null, PathAnnotationObject.class);
            hierarchy.removeObjects(annotations, true);
        }
        tasks.add((Runnable)((Object)new ClassificationToAnnotationRunnable(params, imageData, parentObject)));
    }

    public ParameterList getDefaultParameterList(ImageData<T> imageData) {
        if (!this.parametersInitialized) {
            PathClass allClasses;
            Set pathClasses = PathObjectTools.getRepresentedPathClasses((PathObjectHierarchy)imageData.getHierarchy(), PathTileObject.class);
            ArrayList<PathClass> choices = new ArrayList<PathClass>(pathClasses);
            Collections.sort(choices, new Comparator<PathClass>(this){

                @Override
                public int compare(PathClass pc1, PathClass pc2) {
                    return pc1.getName().compareTo(pc2.getName());
                }
            });
            PathClass defaultChoice = allClasses = PathClass.getInstance((String)"All classes");
            choices.add(0, allClasses);
            this.params = new ParameterList();
            this.params.addChoiceParameter("pathClass", "Choose class", (Object)defaultChoice, choices, "Choose PathClass to create annotations from").addBooleanParameter("deleteTiles", "Delete existing child objects", false, "Delete the tiles that were used for creating annotations - further training will not be possible after these are deleted").addBooleanParameter("clearAnnotations", "Remove existing annotations", true, "Remove all existing annotations (often a good idea if they were used to train a classifier, but are no longer needed)").addBooleanParameter("splitAnnotations", "Split new annotations", false, "Split newly-created annotations into distinct regions (rather than have one large, possibly-discontinuous object)");
        }
        return this.params;
    }

    protected Collection<PathObject> getParentObjects(ImageData<T> imageData) {
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        ArrayList<PathObject> parents = new ArrayList<PathObject>(hierarchy.getSelectionModel().getSelectedObjects());
        ArrayList tempList = new ArrayList(parents);
        for (PathObject temp : tempList) {
            Iterator iter = parents.iterator();
            while (iter.hasNext()) {
                if (!PathObjectTools.isAncestor((PathObject)((PathObject)iter.next()), (PathObject)temp)) continue;
                iter.remove();
            }
        }
        return parents;
    }

    static class ClassificationToAnnotationRunnable
    implements PathTask {
        private ParameterList params;
        private PathObject parentObject;
        private ImageData<?> imageData;
        private List<PathObject> pathAnnotations = new ArrayList<PathObject>();
        private String resultsString;

        public ClassificationToAnnotationRunnable(ParameterList params, ImageData<?> imageData, PathObject parentObject) {
            this.params = params;
            this.parentObject = parentObject;
            this.imageData = imageData;
        }

        public void run() {
            long startTime = System.currentTimeMillis();
            PathClass choice = (PathClass)this.params.getChoiceParameterValue("pathClass");
            List<PathClass> pathClasses = "All classes".equals(choice.getName()) ? (Collection)this.parentObject.getChildObjects().stream().map(p -> p.getPathClass()).collect(Collectors.toSet()) : Collections.singletonList(choice);
            boolean doSplit = this.params.getBooleanParameterValue("splitAnnotations");
            boolean deleteTiles = this.params.getBooleanParameterValue("deleteTiles");
            for (PathClass pathClass : pathClasses) {
                PathObject pathSingleAnnotation = null;
                ArrayList<PathObject> tiles = new ArrayList<PathObject>();
                if (pathClass != null && !PathClassTools.isIgnoredClass((PathClass)pathClass)) {
                    ArrayList<ROI> roisToMerge = new ArrayList<ROI>();
                    for (PathObject pathObject : this.parentObject.getChildObjectsAsArray()) {
                        if (!(pathObject instanceof PathTileObject) || !RoiTools.isShapeROI((ROI)pathObject.getROI()) || !pathClass.equals(pathObject.getPathClass())) continue;
                        roisToMerge.add(pathObject.getROI());
                        tiles.add(pathObject);
                    }
                    if (!tiles.isEmpty()) {
                        ROI pathROINew = RoiTools.union(roisToMerge);
                        pathSingleAnnotation = PathObjects.createAnnotationObject((ROI)pathROINew, (PathClass)pathClass);
                        if (!deleteTiles) {
                            pathSingleAnnotation.addChildObjects(tiles);
                        }
                    }
                }
                if (pathSingleAnnotation == null) continue;
                if (doSplit) {
                    RoiTools.splitROI((ROI)pathSingleAnnotation.getROI()).stream().map(p -> PathObjects.createAnnotationObject((ROI)p, (PathClass)pathClass)).forEach(this.pathAnnotations::add);
                    continue;
                }
                this.pathAnnotations.add(pathSingleAnnotation);
            }
            if (this.resultsString == null) {
                this.resultsString = this.pathAnnotations.isEmpty() ? "No annotation created!" : (this.pathAnnotations.size() == 1 ? "Created 1 annotation" : "Created " + this.pathAnnotations.size() + " annotations");
            }
            long endTime = System.currentTimeMillis();
            logger.info(String.valueOf(this.parentObject) + String.format(" processed in %.2f seconds", (double)(endTime - startTime) / 1000.0));
        }

        public void taskComplete(boolean wasCancelled) {
            if (!wasCancelled && !Thread.currentThread().isInterrupted()) {
                if (this.params.getBooleanParameterValue("deleteTiles").booleanValue()) {
                    this.parentObject.clearChildObjects();
                }
                if (this.pathAnnotations != null && !this.pathAnnotations.isEmpty()) {
                    this.parentObject.addChildObjects(this.pathAnnotations);
                }
                this.imageData.getHierarchy().fireHierarchyChangedEvent((Object)this.parentObject);
            }
            this.pathAnnotations = null;
        }

        public String getLastResultsDescription() {
            return this.resultsString;
        }
    }
}

