/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.AbstractInteractivePlugin;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class SplitAnnotationsPlugin<T>
extends AbstractInteractivePlugin<T> {
    private String resultString = null;

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        return Collections.singleton(PathAnnotationObject.class);
    }

    public String getName() {
        return "Split annotations";
    }

    public String getDescription() {
        return "Split annotations with multi-part ROIs into separate annotation objects";
    }

    public String getLastResultsDescription() {
        return this.resultString;
    }

    public ParameterList getDefaultParameterList(ImageData<T> imageData) {
        return new ParameterList();
    }

    protected Collection<? extends PathObject> getParentObjects(ImageData<T> imageData) {
        return imageData.getHierarchy().getSelectionModel().getSelectedObjects().stream().filter(p -> p.isAnnotation()).toList();
    }

    protected void addRunnableTasks(ImageData<T> imageData, PathObject parentObject, List<Runnable> tasks) {
    }

    protected Collection<Runnable> getTasks(ImageData<T> imageData) {
        Collection<PathObject> parentObjects = this.getParentObjects(imageData);
        if (parentObjects == null || parentObjects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(1);
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
        tasks.add(() -> {
            ArrayList toAdd = new ArrayList();
            ArrayList<PathObject> toRemove = new ArrayList<PathObject>();
            ArrayList<PathObject> localSplit = new ArrayList<PathObject>();
            HashSet<Object> toSelect = new HashSet<Object>();
            for (PathObject pathObject : parentObjects) {
                localSplit.clear();
                ROI roiOrig = pathObject.getROI();
                if (roiOrig == null) {
                    toSelect.add(pathObject);
                    continue;
                }
                List splitROIs = RoiTools.splitROI((ROI)roiOrig);
                if (splitROIs.size() == 1) continue;
                toRemove.add(pathObject);
                for (ROI r : splitROIs) {
                    PathObject annotation = PathObjects.createAnnotationObject((ROI)r, (PathClass)pathObject.getPathClass());
                    annotation.setLocked(pathObject.isLocked());
                    localSplit.add(annotation);
                }
                if (pathObject.hasChildObjects()) {
                    for (PathObject temp : localSplit) {
                        hierarchy.addObjectBelowParent(pathObject, temp, false);
                    }
                } else {
                    pathObject.addChildObjects(localSplit);
                }
                toAdd.addAll(localSplit);
            }
            if (toAdd.isEmpty() && toRemove.isEmpty()) {
                return;
            }
            hierarchy.getSelectionModel().clearSelection();
            toSelect.addAll(toAdd);
            hierarchy.removeObjects(toRemove, true);
            hierarchy.getSelectionModel().selectObjects(toSelect);
            if (toSelect.contains(selected)) {
                hierarchy.getSelectionModel().setSelectedObject(selected, true);
            }
        });
        return tasks;
    }
}

